/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.Constants.StoreLibConstants;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PIT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_REPOSITORY_SPACE;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class CreateViewDialog
extends VivaldiBaseDialog {
    public LogicalDriveHelper m_ldHelper = null;
    public LogicalDriveHelper m_Repository_ldHelper = null;
    private MR_LD_PIT_INFO m_pitInfo = null;
    private JButton m_okButton = new JButton();
    private JTextField m_tfViewName = new JTextField(15);
    private SpinnerNumberModel percentSpinnerModel = null;
    private JSpinner percentSpinner = null;
    private JLabel enterViewNameLabel = new JLabel();
    private long availableSize = 0L;
    private double requiredSize = 0.0;
    String title = null;
    double[] size = new double[2];
    private String[] unit = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};

    public CreateViewDialog(LogicalDriveHelper logicalDriveHelper, MR_LD_PIT_INFO mR_LD_PIT_INFO, LogicalDriveHelper logicalDriveHelper2) {
        this.m_ldHelper = logicalDriveHelper;
        this.m_pitInfo = mR_LD_PIT_INFO;
        this.m_Repository_ldHelper = logicalDriveHelper2;
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.title = Resource.getString("CREATE_VIEW_TITLE", "Create View");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("CREATEVIEW_DESC_TEXT_", "<html>Specify the capacity to allocate for writes to the view. The capacity for writes comes <br> from available capacity on the snapshot repository, " + this.getSnapshotText(this.m_Repository_ldHelper)));
        stringBuffer.append("</html>");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(stringBuffer.toString()), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIEW_NAME_LABEL", "(V)iew name:"));
        this.enterViewNameLabel.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.enterViewNameLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)this.enterViewNameLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        jPanel.add((Component)this.m_tfViewName, gridBagConstraints);
        this.m_tfViewName.setText(Resource.getString("VIEW_TEXT", "View"));
        this.enterViewNameLabel.setLabelFor(this.m_tfViewName);
        this.availableSize = this.getAvailableCapacity();
        this.size = KernelConstants.getSizeAndUnit(this.availableSize, this.m_ldHelper.getBlockSize());
        if (this.size[1] >= 4.0) {
            this.size[1] = 3.0;
            this.size[0] = KernelConstants.getSizeInSpecifiedUnit(this.size[0], 4, 3, this.m_ldHelper.getBlockSize());
        }
        this.percentSpinnerModel = new SpinnerNumberModel(this.size[0], 1.0, this.size[0], 1.0);
        this.percentSpinner = new JSpinner(this.percentSpinnerModel);
        this.percentSpinnerModel.setMinimum(Double.valueOf(1.0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        stringArray = Resource.getResourceMnemonic(Resource.getString("VIEW_WRITE_CAPACITY", "(W)rite capacity:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 10, 30, 0);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(this.percentSpinner);
        JLabel jLabel2 = new JLabel(this.unit[(int)this.size[1]]);
        jPanel2.add(jLabel2);
        JLabel jLabel3 = new JLabel(" (" + this.size[0] + " " + this.unit[(int)this.size[1]] + " " + Resource.getString("AVAILABLE_TEXT", "available") + ")");
        jPanel2.add(jLabel3);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jLabel.setLabelFor(this.percentSpinner);
        this.percentSpinnerModel.setValue(this.size[0]);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_okButton = new JButton(stringArray[0]);
        this.getRootPane().setDefaultButton(this.m_okButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
        JButton jButton = new JButton(stringArray[0]);
        jPanel3.add(this.m_okButton);
        jPanel3.add(jButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.requiredSize = (Double)this.percentSpinner.getValue();
        this.m_tfViewName.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (CreateViewDialog.this.m_tfViewName.getText().length() > 15) {
                    new CustomMsgBox("View Name cannot exceed more than 15 characters");
                    CreateViewDialog.this.m_tfViewName.setText(CreateViewDialog.this.m_tfViewName.getText().substring(0, 15));
                }
            }
        });
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        JComponent jComponent = this.percentSpinner.getEditor();
        if (jComponent instanceof JSpinner.NumberEditor) {
            jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
        }
        jFormattedTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                    keyEvent.consume();
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Double d;
                JFormattedTextField jFormattedTextField = ((JSpinner.NumberEditor)CreateViewDialog.this.percentSpinner.getEditor()).getTextField();
                if (jFormattedTextField.getText().length() == 0) {
                    return;
                }
                try {
                    d = new Double(jFormattedTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    CreateViewDialog.this.requiredSize = (Double)CreateViewDialog.this.percentSpinner.getValue();
                    jFormattedTextField.setText("" + CreateViewDialog.this.requiredSize);
                    CreateViewDialog.this.percentSpinner.setValue(CreateViewDialog.this.requiredSize);
                    return;
                }
                CreateViewDialog.this.requiredSize = d;
                if (d > CreateViewDialog.this.size[0]) {
                    CreateViewDialog.this.requiredSize = CreateViewDialog.this.size[0];
                    jFormattedTextField.setText("" + CreateViewDialog.this.requiredSize);
                    CreateViewDialog.this.percentSpinner.setValue(CreateViewDialog.this.requiredSize);
                } else if (d < 1.0) {
                    CreateViewDialog.this.requiredSize = 1.0;
                    jFormattedTextField.setText("" + CreateViewDialog.this.requiredSize);
                    CreateViewDialog.this.percentSpinner.setValue(CreateViewDialog.this.requiredSize);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateViewDialog.this.dispose();
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                byte[] byArray = new byte[16];
                byArray = CreateViewDialog.this.m_pitInfo.getParams().getPITName();
                byte[] byArray2 = new byte[16];
                byArray2 = CreateViewDialog.this.m_tfViewName.getText().getBytes();
                if (CreateViewDialog.this.m_tfViewName.getText().trim().length() == 0) {
                    JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("VIEW_NAME_MANDATORY_MESSAGE", "You cannot leave this field blank. Enter a view name to proceed."), Resource.getString("VIEW_NAME_MANDATORY_MESSAGE", "Enter View Name - Mandatory"), -1, 2);
                    CreateViewDialog.this.m_tfViewName.requestFocus();
                    return;
                }
                System.out.println("requiredSize " + CreateViewDialog.this.requiredSize);
                double d = CreateViewDialog.this.requiredSize;
                int n = (int)CreateViewDialog.this.size[1];
                long l = KernelConstants.getSizeInBlocks(d, n, CreateViewDialog.this.m_ldHelper.getBlockSize());
                byte by = 0;
                by = 0;
                boolean bl = ((SASLogicalDrive)CreateViewDialog.this.m_ldHelper.getDeviceObject()).createView(CreateViewDialog.this.m_pitInfo.getParams().getPITCreationTime(), byArray, byArray2, by, l);
                CreateViewDialog.this.dispose();
            }
        });
        this.add((Component)jPanel, "West");
        this.setTitle(this.title);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public long getAvailableCapacity() {
        long l = 0L;
        long l2 = 0L;
        if (((SASLogicalDrive)this.m_Repository_ldHelper.getDeviceObject()).getInformation().getsnapshotRepository() == 1) {
            MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = null;
            mR_LD_SNAPSHOT_REPOSITORY_SPACE = ((SASLogicalDrive)this.m_Repository_ldHelper.getDeviceObject()).getSnapshotRepositorySpace();
            byte by = mR_LD_SNAPSHOT_REPOSITORY_SPACE.getNumHoles();
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                l2 += mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[by2].getHoleSize();
            }
            l2 = KernelConstants.getSizeInBlocks(l2, 2, this.m_ldHelper.getBlockSize());
        }
        l = ((SASLogicalDrive)this.m_Repository_ldHelper.getDeviceObject()).getInformation().getsize();
        l = l - l2 - StoreLibConstants.OS_METADATA_SIZE_ON_REP;
        return l;
    }

    public String getSnapshotText(LogicalDriveHelper logicalDriveHelper) {
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("REPOSITORY_VIRTUAL_DRIVE_TEXT", "Snapshot Repository") + ": " + ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getID());
        if (((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getName() != null && ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getName().length() != 0) {
            stringBuffer.append(", ");
            stringBuffer.append(((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getName());
        }
        return stringBuffer.toString();
    }
}

