/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_SNAPSHOT_SCHEDULE_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.CustomComboBox;
import Utils.Resource;
import Wizard.ConfigWizard.GUIData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class EnableSchedulePanel
extends JPanel
implements ListSelectionListener,
TableModelListener {
    private LogicalDriveHelper m_ldHelper = null;
    private VDScheduleTabelModel scheduleTabelModel = null;
    private JTable scheduleTable = null;
    private JComboBox frequencyComboBox = null;
    private JPanel mainPanel = null;
    private byte lastSelectedIndex = 0;
    private MR_TIME_STAMP scheduleTime = new MR_TIME_STAMP();
    private int NextExecFreq = 0;
    private JFormattedTextField everyTextField = null;
    private NumberFormat everyTextFieldFormat;
    private JComboBox dayComboBox = null;
    private JComboBox timeComboBox = null;
    private JComboBox dayofMonthComboBox = null;
    private JComboBox dayOfWeekTextComboBox = null;
    private JComboBox dayOfWeekComboBox = null;
    private JRadioButton dayOfMonth = null;
    private JRadioButton dayOfWeek = null;
    private double requiredSize = 0.0;
    double[] size = new double[2];
    private JRadioButton addVdtoExistingSchedule = null;
    private JRadioButton createNewSchedule = null;
    private JRadioButton doNotSchedule = null;
    private boolean createNewSchedule_selected = false;

    public EnableSchedulePanel(LogicalDriveHelper logicalDriveHelper) {
        this.m_ldHelper = logicalDriveHelper;
        this.buildUI();
    }

    public void buildUI() {
        Serializable serializable;
        JLabel jLabel;
        Object object;
        Object object2;
        if (this.mainPanel != null && ((Component[])(object2 = this.mainPanel.getComponents())).length > 0) {
            this.mainPanel.removeAll();
            this.remove(this.mainPanel);
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        object2 = new GridBagConstraints();
        String[] stringArray = null;
        JLabel jLabel2 = new JLabel(Resource.getString("ENABLE_SCHEDULE_DESC", "Select an existing snapshot schedule or create a new one."));
        object2.gridx = 0;
        object2.gridy = 0;
        object2.gridwidth = 10;
        object2.insets = new Insets(10, 10, 0, 0);
        object2.anchor = 18;
        this.mainPanel.add((Component)jLabel2, object2);
        ButtonGroup buttonGroup = new ButtonGroup();
        stringArray = Resource.getResourceMnemonic(Resource.getString("ADD_TO_EXISTING_SCHEDULE", "(A)dd virtual drive to existing schedule."));
        this.addVdtoExistingSchedule = new JRadioButton(stringArray[0], true);
        if (stringArray.length == 2) {
            this.addVdtoExistingSchedule.setMnemonic(stringArray[1].charAt(0));
        }
        ++object2.gridy;
        object2.insets = new Insets(10, 20, 0, 0);
        this.mainPanel.add((Component)this.addVdtoExistingSchedule, object2);
        buttonGroup.add(this.addVdtoExistingSchedule);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SCHEDULE_TEXT", "(S)chedule:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++object2.gridy;
        object2.insets = new Insets(10, 30, 0, 0);
        this.mainPanel.add((Component)jLabel3, object2);
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.m_ldHelper.getParent()).getLogicalDrives();
        Vector<LogicalDriveHelper> vector = new Vector<LogicalDriveHelper>();
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            if (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((MR_SNAPSHOT_SCHEDULE_PROPERTIES)(object = ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getSnapshotInformation().getSchedProp())).getExecFreq() == 0) continue;
            vector.add(logicalDriveHelperArray[i]);
        }
        this.scheduleTabelModel = vector.size() != 0 ? new VDScheduleTabelModel(vector) : new VDScheduleTabelModel();
        this.scheduleTabelModel.addTableModelListener(this);
        this.scheduleTable = new JTable(this.scheduleTabelModel);
        this.scheduleTable.setCellSelectionEnabled(false);
        this.scheduleTable.setColumnSelectionAllowed(false);
        this.scheduleTable.setRowSelectionAllowed(true);
        this.scheduleTable.getSelectionModel().addListSelectionListener(this);
        this.scheduleTable.setSelectionMode(0);
        this.scheduleTable.getTableHeader().setReorderingAllowed(false);
        this.scheduleTable.getTableHeader().setResizingAllowed(true);
        this.scheduleTable.setAutoResizeMode(4);
        this.scheduleTable.setRowHeight(this.scheduleTable.getRowHeight() + 20);
        TableColumn tableColumn = this.scheduleTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(150);
        if (vector.size() != 0) {
            this.scheduleTable.setRowSelectionInterval(0, 0);
        }
        jLabel3.setLabelFor(this.scheduleTable);
        ++object2.gridy;
        ++object2.gridy;
        ++object2.gridy;
        object2.insets = new Insets(10, 30, 0, 15);
        object = new JScrollPane(this.scheduleTable);
        this.mainPanel.add((Component)object, object2);
        ((JComponent)object).setPreferredSize(new Dimension(((JComponent)object).getPreferredSize().width, this.scheduleTable.getRowHeight() * 5));
        stringArray = Resource.getResourceMnemonic(Resource.getString("CREATE_NEW_SCHEDULE", "(C)reate new schedule"));
        this.createNewSchedule = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.createNewSchedule.setMnemonic(stringArray[1].charAt(0));
        }
        ++object2.gridy;
        object2.insets = new Insets(10, 20, 0, 0);
        this.mainPanel.add((Component)this.createNewSchedule, object2);
        buttonGroup.add(this.createNewSchedule);
        if (vector.size() == 0 || this.createNewSchedule_selected) {
            this.createNewSchedule.setSelected(true);
            this.addVdtoExistingSchedule.setEnabled(false);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("FREQUENCY", "(F)requency:"));
        JLabel jLabel4 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++object2.gridy;
        object2.gridwidth = 1;
        object2.insets = new Insets(10, 30, 0, 0);
        this.mainPanel.add((Component)jLabel4, object2);
        this.frequencyComboBox = new CustomComboBox(new Object[]{new GUIData(Resource.getString("DAILY"), 24), new GUIData(Resource.getString("WEEKLY"), 168)});
        ++object2.gridx;
        object2.insets = new Insets(10, 5, 0, 0);
        this.mainPanel.add((Component)this.frequencyComboBox, object2);
        jLabel4.setLabelFor(this.frequencyComboBox);
        this.frequencyComboBox.setSelectedIndex(this.lastSelectedIndex);
        stringArray = Resource.getResourceMnemonic(Resource.getString("EVERY_TEXT", "(E)very"));
        JLabel jLabel5 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel5.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++object2.gridx;
        object2.insets = new Insets(10, 5, 0, 0);
        this.mainPanel.add((Component)jLabel5, object2);
        this.everyTextFieldFormat = NumberFormat.getInstance();
        this.everyTextFieldFormat.setMaximumIntegerDigits(3);
        this.everyTextField = new JFormattedTextField(this.everyTextFieldFormat);
        this.everyTextField.setValue(new Long(1L));
        ++object2.gridx;
        object2.insets = new Insets(10, 5, 0, 0);
        this.mainPanel.add((Component)this.everyTextField, object2);
        this.everyTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                    keyEvent.consume();
                    return;
                }
            }
        });
        if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 24) {
            jLabel = new JLabel(Resource.getString("DAYS_TEXT", "day(s)"));
            ++object2.gridx;
            object2.insets = new Insets(10, 5, 0, 0);
            this.mainPanel.add((Component)jLabel, object2);
        } else if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 168) {
            jLabel = new JLabel(Resource.getString("WEEKS_TEXT", "week(s)"));
            ++object2.gridx;
            object2.insets = new Insets(10, 5, 0, 0);
            this.mainPanel.add((Component)jLabel, object2);
            stringArray = Resource.getResourceMnemonic(Resource.getString("DAY_TEXT", "Da(y):"));
            serializable = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                ((JLabel)serializable).setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            ++object2.gridy;
            object2.gridx = 0;
            object2.insets = new Insets(10, 30, 0, 0);
            this.mainPanel.add((Component)serializable, object2);
            this.dayComboBox = new CustomComboBox(new Object[]{new GUIData("Sunday", 1), new GUIData("Monday", 2), new GUIData("Tuesday", 3), new GUIData("Wednesday", 4), new GUIData("Thursday", 5), new GUIData("Friday", 6), new GUIData("Saturday", 7)});
            ++object2.gridx;
            object2.insets = new Insets(10, 5, 0, 0);
            this.mainPanel.add((Component)this.dayComboBox, object2);
            ((JLabel)serializable).setLabelFor(this.dayComboBox);
        } else {
            jLabel = new JLabel(Resource.getString("MONTHS_TEXT", "month(s)"));
            ++object2.gridx;
            object2.insets = new Insets(10, 5, 0, 0);
            this.mainPanel.add((Component)jLabel, object2);
            serializable = new ButtonGroup();
            stringArray = Resource.getResourceMnemonic(Resource.getString("DAY_OF_MONTH", "Day of the (m)onth:"));
            this.dayOfMonth = new JRadioButton(stringArray[0], true);
            if (stringArray.length == 2) {
                this.dayOfMonth.setMnemonic(stringArray[1].charAt(0));
            }
            ++object2.gridy;
            object2.gridx = 1;
            object2.insets = new Insets(10, 15, 0, 0);
            this.mainPanel.add((Component)this.dayOfMonth, object2);
            ((ButtonGroup)serializable).add(this.dayOfMonth);
            this.dayofMonthComboBox = new CustomComboBox(new Object[]{new GUIData("1", 1), new GUIData("2", 2), new GUIData("3", 3), new GUIData("4", 4), new GUIData("5", 5), new GUIData("6", 6), new GUIData("7", 7), new GUIData("8", 8), new GUIData("9", 9), new GUIData("10", 10), new GUIData("11", 11), new GUIData("12", 12), new GUIData("13", 13), new GUIData("14", 14), new GUIData("15", 15), new GUIData("16", 16), new GUIData("17", 17), new GUIData("18", 18), new GUIData("19", 19), new GUIData("20", 20), new GUIData("21", 21), new GUIData("22", 22), new GUIData("23", 23), new GUIData("24", 24), new GUIData("25", 25), new GUIData("26", 26), new GUIData("27", 27), new GUIData("28", 28), new GUIData("29", 29), new GUIData("30", 30), new GUIData("31", 31)});
            ++object2.gridx;
            object2.insets = new Insets(10, 5, 0, 0);
            this.mainPanel.add((Component)this.dayofMonthComboBox, object2);
            stringArray = Resource.getResourceMnemonic(Resource.getString("DAY_OF_WEEK", "Day of the (w)eek:"));
            this.dayOfWeek = new JRadioButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.dayOfWeek.setMnemonic(stringArray[1].charAt(0));
            }
            ++object2.gridy;
            object2.gridx = 1;
            object2.insets = new Insets(10, 15, 0, 0);
            this.mainPanel.add((Component)this.dayOfWeek, object2);
            ((ButtonGroup)serializable).add(this.dayOfWeek);
            this.dayOfWeekTextComboBox = new CustomComboBox(new Object[]{new GUIData("First", 1), new GUIData("Second", 2), new GUIData("Third", 3), new GUIData("Fourth", 4), new GUIData("Last", 5)});
            ++object2.gridx;
            object2.insets = new Insets(10, 5, 0, 0);
            this.mainPanel.add((Component)this.dayOfWeekTextComboBox, object2);
            this.dayOfWeekComboBox = new CustomComboBox(new Object[]{new GUIData("Sunday", 1), new GUIData("Monday", 2), new GUIData("Tuesday", 3), new GUIData("Wednesday", 4), new GUIData("Thursday", 5), new GUIData("Friday", 6), new GUIData("Saturday", 7)});
            ++object2.gridx;
            object2.insets = new Insets(10, 5, 0, 0);
            this.mainPanel.add((Component)this.dayOfWeekComboBox, object2);
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("TIME_TEXT", "(T)ime:"));
        jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++object2.gridy;
        object2.gridx = 0;
        object2.insets = new Insets(10, 30, 0, 0);
        this.mainPanel.add((Component)jLabel, object2);
        this.timeComboBox = new CustomComboBox(new Object[]{new GUIData("12:00 AM", 1), new GUIData("12:30 AM", 2), new GUIData("01:00 AM", 3), new GUIData("01:30 AM", 4), new GUIData("02:00 AM", 5), new GUIData("02:30 AM", 6), new GUIData("03:00 AM", 7), new GUIData("03:30 AM", 8), new GUIData("04:00 AM", 9), new GUIData("04:30 AM", 10), new GUIData("05:00 AM", 11), new GUIData("05:30 AM", 12), new GUIData("06:00 AM", 13), new GUIData("06:30 AM", 14), new GUIData("07:00 AM", 15), new GUIData("07:30 AM", 16), new GUIData("08:00 AM", 17), new GUIData("08:30 AM", 18), new GUIData("09:00 AM", 19), new GUIData("09:30 AM", 20), new GUIData("10:00 AM", 21), new GUIData("10:30 AM", 22), new GUIData("11:00 AM", 23), new GUIData("11:30 AM", 24), new GUIData("12:00 PM", 25), new GUIData("12:30 PM", 26), new GUIData("01:00 PM", 27), new GUIData("01:30 PM", 28), new GUIData("02:00 PM", 29), new GUIData("02:30 PM", 30), new GUIData("03:00 PM", 31), new GUIData("03:30 PM", 32), new GUIData("04:00 PM", 33), new GUIData("04:30 PM", 34), new GUIData("05:00 PM", 35), new GUIData("05:30 PM", 36), new GUIData("06:00 PM", 37), new GUIData("06:30 PM", 38), new GUIData("07:00 PM", 39), new GUIData("07:30 PM", 40), new GUIData("08:00 PM", 41), new GUIData("08:30 PM", 42), new GUIData("09:00 PM", 43), new GUIData("09:30 PM", 44), new GUIData("10:00 PM", 45), new GUIData("10:30 PM", 46), new GUIData("11:00 PM", 47), new GUIData("11:30 PM", 48)});
        ++object2.gridx;
        object2.insets = new Insets(10, 5, 0, 0);
        this.mainPanel.add((Component)this.timeComboBox, object2);
        jLabel.setLabelFor(this.timeComboBox);
        stringArray = Resource.getResourceMnemonic(Resource.getString("DO_NOT_SCHEDULE", "(D)o not schedule any automatic snapshots"));
        this.doNotSchedule = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.doNotSchedule.setMnemonic(stringArray[1].charAt(0));
        }
        object2.gridx = 0;
        ++object2.gridy;
        object2.gridwidth = 5;
        object2.insets = new Insets(10, 20, 0, 0);
        this.mainPanel.add((Component)this.doNotSchedule, object2);
        buttonGroup.add(this.doNotSchedule);
        serializable = new JLabel("");
        ++object2.gridx;
        object2.insets = new Insets(30, 60, 30, 60);
        this.mainPanel.add((Component)serializable, object2);
        for (int i = 0; i < this.scheduleTable.getRowCount(); ++i) {
            this.scheduleTable.setRowHeight(i, ((Schedule)this.scheduleTabelModel.scheduleList.get(i)).getLdHelpers().size() * 40);
        }
        if (this.addVdtoExistingSchedule.isSelected()) {
            this.scheduleTable.setEnabled(true);
            this.everyTextField.setEnabled(false);
            this.frequencyComboBox.setEnabled(false);
            this.timeComboBox.setEnabled(false);
            if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 168) {
                this.dayComboBox.setEnabled(false);
            }
        } else if (this.createNewSchedule.isSelected()) {
            this.scheduleTable.setEnabled(false);
            this.everyTextField.setEnabled(true);
            this.frequencyComboBox.setEnabled(true);
            this.timeComboBox.setEnabled(true);
            if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 168) {
                this.dayComboBox.setEnabled(true);
            }
        } else if (this.doNotSchedule.isSelected()) {
            this.scheduleTable.setEnabled(false);
            this.everyTextField.setEnabled(false);
            this.frequencyComboBox.setEnabled(false);
            this.timeComboBox.setEnabled(false);
            if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 168) {
                this.dayComboBox.setEnabled(false);
            }
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
        this.add(this.mainPanel);
        this.frequencyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnableSchedulePanel.this.lastSelectedIndex = (byte)EnableSchedulePanel.this.frequencyComboBox.getSelectedIndex();
                EnableSchedulePanel.this.createNewSchedule_selected = true;
                EnableSchedulePanel.this.buildUI();
            }
        });
        this.addVdtoExistingSchedule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EnableSchedulePanel.this.addVdtoExistingSchedule.isSelected()) {
                    EnableSchedulePanel.this.scheduleTable.setEnabled(true);
                    EnableSchedulePanel.this.everyTextField.setEnabled(false);
                    EnableSchedulePanel.this.frequencyComboBox.setEnabled(false);
                    EnableSchedulePanel.this.timeComboBox.setEnabled(false);
                    if (((GUIData)((EnableSchedulePanel)EnableSchedulePanel.this).frequencyComboBox.getSelectedItem()).flag == 168) {
                        EnableSchedulePanel.this.dayComboBox.setEnabled(false);
                    }
                }
            }
        });
        this.createNewSchedule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EnableSchedulePanel.this.createNewSchedule.isSelected()) {
                    EnableSchedulePanel.this.scheduleTable.setEnabled(false);
                    EnableSchedulePanel.this.everyTextField.setEnabled(true);
                    EnableSchedulePanel.this.frequencyComboBox.setEnabled(true);
                    EnableSchedulePanel.this.timeComboBox.setEnabled(true);
                    if (((GUIData)((EnableSchedulePanel)EnableSchedulePanel.this).frequencyComboBox.getSelectedItem()).flag == 168) {
                        EnableSchedulePanel.this.dayComboBox.setEnabled(true);
                    }
                }
            }
        });
        this.doNotSchedule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EnableSchedulePanel.this.doNotSchedule.isSelected()) {
                    EnableSchedulePanel.this.scheduleTable.setEnabled(false);
                    EnableSchedulePanel.this.everyTextField.setEnabled(false);
                    EnableSchedulePanel.this.frequencyComboBox.setEnabled(false);
                    EnableSchedulePanel.this.timeComboBox.setEnabled(false);
                    if (((GUIData)((EnableSchedulePanel)EnableSchedulePanel.this).frequencyComboBox.getSelectedItem()).flag == 168) {
                        EnableSchedulePanel.this.dayComboBox.setEnabled(false);
                    }
                }
            }
        });
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    public MR_TIME_STAMP getCtrlTime() {
        MR_TIME_STAMP mR_TIME_STAMP = ((SASAdapter)((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).parent()).getCtrlTime();
        return mR_TIME_STAMP;
    }

    public MR_TIME_STAMP getCCMR_TIME_STAMP() {
        if (this.addVdtoExistingSchedule.isSelected()) {
            Vector vector = this.scheduleTabelModel.scheduleList;
            int n = this.scheduleTable.getSelectedRow();
            Vector vector2 = new Vector();
            for (int i = 0; i < ((Schedule)vector.get(n)).ldHelpers.size(); ++i) {
                vector2.add(((Schedule)vector.get(n)).ldHelpers.get(i));
            }
            return KernelConstants.getTimeStamp(((Schedule)vector.get(n)).getScheduleTime());
        }
        MR_TIME_STAMP mR_TIME_STAMP = ((SASAdapter)((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).parent()).getCtrlTime();
        if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 24) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(mR_TIME_STAMP.getyear(), mR_TIME_STAMP.getmonth() - 1, mR_TIME_STAMP.getday(), mR_TIME_STAMP.gethour(), mR_TIME_STAMP.getmin(), mR_TIME_STAMP.getsec());
            this.scheduleTime.setyear((short)gregorianCalendar.get(1));
            this.scheduleTime.setmonth((byte)gregorianCalendar.get(2));
            this.scheduleTime.setday((byte)gregorianCalendar.get(5));
            System.out.println("timeComboBox.getSelectedItem().toString() " + this.timeComboBox.getSelectedItem().toString());
            int n = new Integer(this.timeComboBox.getSelectedItem().toString().substring(0, 2));
            int n2 = new Integer(this.timeComboBox.getSelectedItem().toString().substring(3, 5));
            String string = this.timeComboBox.getSelectedItem().toString().substring(6, 8);
            boolean bl = false;
            bl = string.compareTo("AM") != 0;
            if (bl && n != 12) {
                n += 12;
            }
            if (!bl && n == 12) {
                n -= 12;
            }
            this.scheduleTime.sethour((byte)n);
            this.scheduleTime.setmin((byte)n2);
            this.scheduleTime.setsec((byte)0);
        } else if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 168) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(mR_TIME_STAMP.getyear(), mR_TIME_STAMP.getmonth() - 1, mR_TIME_STAMP.getday(), mR_TIME_STAMP.gethour(), mR_TIME_STAMP.getmin(), mR_TIME_STAMP.getsec());
            this.scheduleTime.setyear((short)gregorianCalendar.get(1));
            this.scheduleTime.setmonth((byte)gregorianCalendar.get(2));
            int n = ((GUIData)this.dayComboBox.getSelectedItem()).flag - gregorianCalendar.get(7);
            if (n < 0) {
                n += 7;
            }
            this.scheduleTime.setday((byte)(gregorianCalendar.get(5) + n));
            int n3 = new Integer(this.timeComboBox.getSelectedItem().toString().substring(0, 2));
            int n4 = new Integer(this.timeComboBox.getSelectedItem().toString().substring(3, 5));
            String string = this.timeComboBox.getSelectedItem().toString().substring(6, 8);
            boolean bl = false;
            bl = string.compareTo("AM") != 0;
            if (bl && n3 != 12) {
                n3 += 12;
            }
            if (!bl && n3 == 12) {
                n3 -= 12;
            }
            this.scheduleTime.sethour((byte)n3);
            this.scheduleTime.setmin((byte)n4);
            this.scheduleTime.setsec((byte)0);
        } else {
            int n;
            int n5;
            GregorianCalendar gregorianCalendar = new GregorianCalendar(mR_TIME_STAMP.getyear(), mR_TIME_STAMP.getmonth() - 1, mR_TIME_STAMP.getday(), mR_TIME_STAMP.gethour(), mR_TIME_STAMP.getmin(), mR_TIME_STAMP.getsec());
            this.scheduleTime.setyear((short)gregorianCalendar.get(1));
            this.scheduleTime.setmonth((byte)gregorianCalendar.get(2));
            this.scheduleTime.setday((byte)gregorianCalendar.get(5));
            if (this.dayOfMonth.isSelected()) {
                n5 = gregorianCalendar.get(5);
                n = ((GUIData)this.dayofMonthComboBox.getSelectedItem()).flag;
                if (n > ((Calendar)gregorianCalendar).getActualMaximum(5)) {
                    n = ((Calendar)gregorianCalendar).getActualMaximum(5);
                }
                if (n > n5) {
                    this.scheduleTime.setday((byte)n);
                } else if (n < n5) {
                    int n6 = gregorianCalendar.get(2);
                    if (++n6 > 12) {
                        this.scheduleTime.setmonth((byte)1);
                        this.scheduleTime.setyear((short)(gregorianCalendar.get(1) + 1));
                    }
                    this.scheduleTime.setmonth((byte)n6);
                }
            }
            n5 = new Integer(this.timeComboBox.getSelectedItem().toString().substring(0, 2));
            n = new Integer(this.timeComboBox.getSelectedItem().toString().substring(3, 5));
            String string = this.timeComboBox.getSelectedItem().toString().substring(6, 8);
            boolean bl = false;
            bl = string.compareTo("AM") != 0;
            if (bl && n5 != 12) {
                n5 += 12;
            }
            if (!bl && n5 == 12) {
                n5 -= 12;
            }
            this.scheduleTime.sethour((byte)n5);
            this.scheduleTime.setmin((byte)n);
            this.scheduleTime.setsec((byte)0);
        }
        return this.scheduleTime;
    }

    public int getNextExecFreq() {
        if (this.addVdtoExistingSchedule.isSelected()) {
            Vector vector = this.scheduleTabelModel.scheduleList;
            int n = this.scheduleTable.getSelectedRow();
            Vector vector2 = new Vector();
            for (int i = 0; i < ((Schedule)vector.get(n)).ldHelpers.size(); ++i) {
                vector2.add(((Schedule)vector.get(n)).ldHelpers.get(i));
            }
            return ((Schedule)vector.get(n)).getScheduleFrequency();
        }
        long l = (Long)this.everyTextField.getValue();
        this.NextExecFreq = ((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 24 ? 24 * (int)l : (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 168 ? 168 * (int)l : 720 * (int)l);
        return this.NextExecFreq;
    }

    public long getFieldVal() {
        long l = (Long)this.everyTextField.getValue();
        return l;
    }

    public int nextExeq() {
        if (((GUIData)this.frequencyComboBox.getSelectedItem()).flag == 24) {
            return 24;
        }
        return 168;
    }

    public boolean isNoScheduleSelected() {
        return this.doNotSchedule.isSelected();
    }

    public class VDScheduleTabelModel
    extends AbstractTableModel {
        private Vector<LogicalDriveHelper> m_ldHelpers = null;
        private Vector<Weekly> weeklyList = new Vector();
        private Vector<Daily> dailyList = new Vector();
        private Vector<Monthly> monthlyList = new Vector();
        private Vector<Schedule> enabledScheduleList = new Vector();
        private Vector<Schedule> disabledScheduleList = new Vector();
        private Vector<Schedule> scheduleList = new Vector();

        public VDScheduleTabelModel() {
        }

        public VDScheduleTabelModel(Vector<LogicalDriveHelper> vector) {
            this.m_ldHelpers = vector;
            this.AddLDsToAppropriateList();
            this.CreateEnabledandDisabledScheduleList();
            this.CreateScheduleList();
        }

        private void CreateScheduleList() {
            int n;
            for (n = 0; n < this.enabledScheduleList.size(); ++n) {
                this.scheduleList.add(this.enabledScheduleList.get(n));
            }
            for (n = 0; n < this.disabledScheduleList.size(); ++n) {
                this.scheduleList.add(this.disabledScheduleList.get(n));
            }
        }

        private void CreateEnabledandDisabledScheduleList() {
            int n;
            Schedule schedule;
            int n2;
            for (n2 = 0; n2 < this.dailyList.size(); ++n2) {
                schedule = new Schedule();
                if (this.dailyList.get(n2).getFrequency() != 24) {
                    n = this.dailyList.get(n2).getFrequency() / 24;
                    schedule.setType("Every " + n + " Days");
                } else {
                    schedule.setType(Resource.getString("DAILY", "Daily"));
                }
                schedule.setScheduleTime(this.dailyList.get(n2).getScheduleTime());
                schedule.setLdHelpers(this.dailyList.get(n2).getDaily_ldHelpers());
                schedule.setState(this.dailyList.get(n2).getState());
                schedule.setScheduleFrequency(this.dailyList.get(n2).getFrequency());
                if (this.dailyList.get(n2).getState() == 1) {
                    this.enabledScheduleList.add(schedule);
                    continue;
                }
                this.disabledScheduleList.add(schedule);
            }
            for (n2 = 0; n2 < this.weeklyList.size(); ++n2) {
                schedule = new Schedule();
                if (this.weeklyList.get(n2).getFrequency() != 168) {
                    n = this.weeklyList.get(n2).getFrequency() / 168;
                    schedule.setType("Every " + n + " Weeks");
                } else {
                    schedule.setType(Resource.getString("WEEKLY", "Weekly"));
                }
                schedule.setScheduleTime(this.weeklyList.get(n2).getScheduleTime());
                schedule.setLdHelpers(this.weeklyList.get(n2).getWeekly_ldHelpers());
                schedule.setState(this.weeklyList.get(n2).getState());
                schedule.setScheduleFrequency(this.weeklyList.get(n2).getFrequency());
                if (this.weeklyList.get(n2).getState() == 1) {
                    this.enabledScheduleList.add(schedule);
                    continue;
                }
                this.disabledScheduleList.add(schedule);
            }
            for (n2 = 0; n2 < this.monthlyList.size(); ++n2) {
                schedule = new Schedule();
                schedule.setType(Resource.getString("MONTHLY", "Monthly"));
                schedule.setScheduleTime(this.monthlyList.get(n2).getScheduleTime());
                schedule.setLdHelpers(this.monthlyList.get(n2).getMonthly_ldHelpers());
                schedule.setState(this.monthlyList.get(n2).getState());
                schedule.setScheduleFrequency(this.monthlyList.get(n2).getFrequency());
                if (this.monthlyList.get(n2).getState() == 1) {
                    this.enabledScheduleList.add(schedule);
                    continue;
                }
                this.disabledScheduleList.add(schedule);
            }
        }

        private void AddLDsToAppropriateList() {
            Vector<LogicalDriveHelper> vector;
            Vector<LogicalDriveHelper> vector2;
            int n;
            Vector<LogicalDriveHelper> vector3 = new Vector<LogicalDriveHelper>();
            Vector<LogicalDriveHelper> vector4 = new Vector<LogicalDriveHelper>();
            Vector vector5 = new Vector();
            MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = null;
            for (n = 0; n < this.m_ldHelpers.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)this.m_ldHelpers.get(n).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() < 168) {
                    vector3.add(this.m_ldHelpers.get(n));
                    continue;
                }
                vector4.add(this.m_ldHelpers.get(n));
            }
            for (n = 0; n < vector3.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)((LogicalDriveHelper)vector3.get(n)).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (this.dailyList.size() == 0) {
                    Daily daily = new Daily();
                    daily.setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                    Vector<LogicalDriveHelper> vector6 = new Vector<LogicalDriveHelper>();
                    vector6.add((LogicalDriveHelper)vector3.get(n));
                    daily.setDaily_ldHelpers(vector6);
                    daily.setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                    daily.setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                    this.dailyList.add(daily);
                    continue;
                }
                int n2 = 0;
                boolean bl = false;
                for (n2 = 0; n2 < this.dailyList.size(); ++n2) {
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec() != this.dailyList.get(n2).getScheduleTime() || mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() != this.dailyList.get(n2).getFrequency()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector2 = this.dailyList.get(n2).getDaily_ldHelpers();
                    vector2.add((LogicalDriveHelper)vector3.get(n));
                    this.dailyList.get(n2).setDaily_ldHelpers(vector2);
                    continue;
                }
                vector2 = new Daily();
                ((Daily)((Object)vector2)).setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                vector = new Vector<LogicalDriveHelper>();
                vector.add((LogicalDriveHelper)vector3.get(n));
                ((Daily)((Object)vector2)).setDaily_ldHelpers(vector);
                ((Daily)((Object)vector2)).setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                ((Daily)((Object)vector2)).setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                this.dailyList.add((Daily)((Object)vector2));
            }
            for (n = 0; n < vector4.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)((LogicalDriveHelper)vector4.get(n)).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (this.weeklyList.size() == 0) {
                    Weekly weekly = new Weekly();
                    weekly.setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                    Vector<LogicalDriveHelper> vector7 = new Vector<LogicalDriveHelper>();
                    vector7.add((LogicalDriveHelper)vector4.get(n));
                    weekly.setWeekly_ldHelpers(vector7);
                    weekly.setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                    weekly.setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                    this.weeklyList.add(weekly);
                    continue;
                }
                int n3 = 0;
                boolean bl = false;
                for (n3 = 0; n3 < this.weeklyList.size(); ++n3) {
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec() != this.weeklyList.get(n3).getScheduleTime() || mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() != this.weeklyList.get(n3).getFrequency()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector2 = this.weeklyList.get(n3).getWeekly_ldHelpers();
                    vector2.add((LogicalDriveHelper)vector4.get(n));
                    this.weeklyList.get(n3).setWeekly_ldHelpers(vector2);
                    continue;
                }
                vector2 = new Weekly();
                ((Weekly)((Object)vector2)).setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                vector = new Vector();
                vector.add((LogicalDriveHelper)vector4.get(n));
                ((Weekly)((Object)vector2)).setWeekly_ldHelpers(vector);
                ((Weekly)((Object)vector2)).setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                ((Weekly)((Object)vector2)).setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                this.weeklyList.add((Weekly)((Object)vector2));
            }
            for (n = 0; n < vector5.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)((LogicalDriveHelper)vector5.get(n)).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (this.monthlyList.size() == 0) {
                    Monthly monthly = new Monthly();
                    monthly.setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                    Vector<LogicalDriveHelper> vector8 = new Vector<LogicalDriveHelper>();
                    vector8.add((LogicalDriveHelper)vector5.get(n));
                    monthly.setMonthly_ldHelpers(vector8);
                    monthly.setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                    monthly.setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                    this.monthlyList.add(monthly);
                    continue;
                }
                int n4 = 0;
                boolean bl = false;
                for (n4 = 0; n4 < this.monthlyList.size(); ++n4) {
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec() != this.monthlyList.get(n4).getScheduleTime()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector2 = this.monthlyList.get(n4).getMonthly_ldHelpers();
                    vector2.add((LogicalDriveHelper)vector5.get(n));
                    this.monthlyList.get(n4).setMonthly_ldHelpers(vector2);
                    continue;
                }
                vector2 = new Monthly();
                ((Monthly)((Object)vector2)).setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                vector = new Vector();
                vector.add((LogicalDriveHelper)vector5.get(n));
                ((Monthly)((Object)vector2)).setMonthly_ldHelpers(vector);
                ((Monthly)((Object)vector2)).setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                ((Monthly)((Object)vector2)).setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                this.monthlyList.add((Monthly)((Object)vector2));
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (this.m_ldHelpers == null) {
                return 0;
            }
            return this.scheduleList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CharSequence charSequence = null;
            if (n2 == 0) {
                charSequence = this.scheduleList.get(n).getType();
            }
            if (n2 == 1) {
                MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(this.scheduleList.get(n).getScheduleTime());
                charSequence = KernelConstants.getTimeText(mR_TIME_STAMP);
            } else if (n2 == 2) {
                Vector<LogicalDriveHelper> vector = this.scheduleList.get(n).getLdHelpers();
                StringBuffer stringBuffer = new StringBuffer("<html>" + vector.get(0).getText() + "<br>");
                for (int i = 1; i < vector.size(); ++i) {
                    stringBuffer.append(vector.get(i).getText() + "<br>");
                }
                stringBuffer.append("</html>");
                charSequence = stringBuffer;
            }
            return charSequence;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return super.getColumnClass(n);
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                string = Resource.getString("TABLE_TEXT_FREQUENCY", "Frequency");
            } else if (n == 1) {
                string = Resource.getString("TABLE_TEXT_NEXT_SNAP", "Next Snapshot");
            } else if (n == 2) {
                string = Resource.getString("TABLE_TEXT_SCHEDULED_VDS", "Scheduled Virtual Drives");
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public int getSelectedRowCount() {
            return 1;
        }
    }

    public class Schedule {
        private String type = null;
        private int scheduleTime = 0;
        private byte state = 1;
        private int scheduleFrequency = 0;
        private Vector<LogicalDriveHelper> ldHelpers = null;

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getLdHelpers() {
            return this.ldHelpers;
        }

        public void setLdHelpers(Vector<LogicalDriveHelper> vector) {
            this.ldHelpers = vector;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }

        public int getScheduleFrequency() {
            return this.scheduleFrequency;
        }

        public void setScheduleFrequency(int n) {
            this.scheduleFrequency = n;
        }
    }

    public class Monthly {
        private int scheduleTime = 0;
        private byte state = 1;
        private Vector<LogicalDriveHelper> Monthly_ldHelpers = null;
        private int frequency = 0;

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int n) {
            this.frequency = n;
        }

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getMonthly_ldHelpers() {
            return this.Monthly_ldHelpers;
        }

        public void setMonthly_ldHelpers(Vector<LogicalDriveHelper> vector) {
            this.Monthly_ldHelpers = vector;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }
    }

    public class Daily {
        private int scheduleTime = 1;
        private byte state = 1;
        private Vector<LogicalDriveHelper> Daily_ldHelpers = null;
        private int frequency = 0;

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int n) {
            this.frequency = n;
        }

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getDaily_ldHelpers() {
            return this.Daily_ldHelpers;
        }

        public void setDaily_ldHelpers(Vector<LogicalDriveHelper> vector) {
            this.Daily_ldHelpers = vector;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }
    }

    public class Weekly {
        private int scheduleTime = 0;
        private byte state = 1;
        private Vector<LogicalDriveHelper> weekly_ldHelpers = null;
        private int frequency = 0;

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int n) {
            this.frequency = n;
        }

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getWeekly_ldHelpers() {
            return this.weekly_ldHelpers;
        }

        public void setWeekly_ldHelpers(Vector<LogicalDriveHelper> vector) {
            this.weekly_ldHelpers = vector;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }
    }
}

