/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.Constants.StoreLibConstants;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_REPOSITORY_SPACE;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EnableSnapshotDialog
extends VivaldiBaseDialog {
    private LogicalDriveHelper m_ldHelper = null;
    private JButton m_okButton = new JButton();
    private SpinnerNumberModel percentSpinnerModel = null;
    private JSpinner percentSpinner = null;
    private JComboBox snapRepository = null;
    private JLabel availableCapacity = null;
    private JLabel capacityIndicationIcon = null;
    private long availableSize = 0L;
    private double requiredSize = 0.0;
    private String title = null;
    private double[] size = new double[2];
    private String[] unit = new String[]{"B", "KB", "MB", "GB", "TB", "PB"};
    private JLabel unitLabel = new JLabel();
    private JCheckBox autoSnapshotCheckBox = null;

    public EnableSnapshotDialog(LogicalDriveHelper logicalDriveHelper) {
        this.m_ldHelper = logicalDriveHelper;
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.m_ldHelper.getText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("ENABLE_SNAPSHOT_DESC", "<html>This base virtual drive will have an associated snapshot repository virtual drive where the snapshot-related data will be<br>stored. Use the suggested snapshot repository or change it if needed. Then determine the capacity to set aside in the<br>snapshot repository for changes to the base virtual drive. The available capacity is the largest free block of capacity on the<br>snapshot repository virtual drive.</html>"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        jPanel.add((Component)new JLabel(stringBuffer.toString()), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SNAPSHOT_REPOSITORY_LABEL", "(S)napshot Repository:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.m_ldHelper.getParent()).getLogicalDrives();
        Vector<LogicalDriveHelper> vector = new Vector<LogicalDriveHelper>();
        boolean bl = false;
        bl = this.m_ldHelper.isEncrypted();
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            if (((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getID() == ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getID() || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() == 1 || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getNotReady() == 1 || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getisSSCD() != 0 || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') continue;
            if (bl) {
                if (!logicalDriveHelperArray[i].isEncrypted()) continue;
                vector.add(logicalDriveHelperArray[i]);
                continue;
            }
            vector.add(logicalDriveHelperArray[i]);
        }
        Collections.sort(vector, new RepositorySizeComparator());
        this.snapRepository = new JComboBox(vector);
        jLabel2.setLabelFor(this.snapRepository);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)this.snapRepository, gridBagConstraints);
        this.availableSize = this.getAvailableCapacity();
        this.availableCapacity = new JLabel("Available capacity:" + KernelConstants.getConvertedSize(this.availableSize, this.m_ldHelper.getBlockSize()));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)this.availableCapacity, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_CAPACITY", "S(e)lect Capacity"));
        JLabel jLabel3 = new JLabel(stringArray[0] + ":");
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.percentSpinnerModel = new SpinnerNumberModel(1.0, 1.0, 100.0, 1.0);
        this.percentSpinner = new JSpinner(this.percentSpinnerModel);
        this.percentSpinnerModel.setMinimum(Double.valueOf(1.0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)this.percentSpinner, gridBagConstraints);
        jLabel3.setLabelFor(this.percentSpinner);
        if (stringArray.length == 2) {
            this.unitLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 70, 0, 0);
        jPanel.add((Component)this.unitLabel, gridBagConstraints);
        this.size = KernelConstants.getSizeAndUnit(this.availableSize, this.m_ldHelper.getBlockSize());
        if (this.size[1] >= 4.0) {
            this.size[1] = 3.0;
            this.size[0] = KernelConstants.getSizeInSpecifiedUnit(this.size[0], 4, 3, this.m_ldHelper.getBlockSize());
        }
        this.percentSpinnerModel.setMaximum(Double.valueOf(this.size[0]));
        this.percentSpinnerModel.setValue(this.size[0]);
        this.unitLabel.setText(this.unit[(int)this.size[1]]);
        this.requiredSize = (Double)this.percentSpinner.getValue();
        this.snapRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnableSnapshotDialog.this.availableSize = EnableSnapshotDialog.this.getAvailableCapacity();
                EnableSnapshotDialog.this.availableCapacity.setText(Resource.getString("AVAILABLE_CAPACITY_TEXT", "Available capacity") + " : " + KernelConstants.getConvertedSize(EnableSnapshotDialog.this.availableSize, EnableSnapshotDialog.this.m_ldHelper.getBlockSize()));
                EnableSnapshotDialog.access$302(EnableSnapshotDialog.this, KernelConstants.getSizeAndUnit(EnableSnapshotDialog.this.availableSize, EnableSnapshotDialog.this.m_ldHelper.getBlockSize()));
                if (EnableSnapshotDialog.this.size[1] >= 4.0) {
                    ((EnableSnapshotDialog)EnableSnapshotDialog.this).size[1] = 3.0;
                    ((EnableSnapshotDialog)EnableSnapshotDialog.this).size[0] = KernelConstants.getSizeInSpecifiedUnit(EnableSnapshotDialog.this.size[0], 4, 3, EnableSnapshotDialog.this.m_ldHelper.getBlockSize());
                }
                EnableSnapshotDialog.this.percentSpinnerModel.setMaximum(Double.valueOf(EnableSnapshotDialog.this.size[0]));
                EnableSnapshotDialog.this.percentSpinnerModel.setValue(EnableSnapshotDialog.this.size[0]);
                EnableSnapshotDialog.this.unitLabel.setText(EnableSnapshotDialog.this.unit[(int)EnableSnapshotDialog.this.size[1]]);
            }
        });
        this.percentSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EnableSnapshotDialog.this.requiredSize = (Double)EnableSnapshotDialog.this.percentSpinner.getValue();
                EnableSnapshotDialog.this.availableSize = EnableSnapshotDialog.this.getAvailableCapacity();
                if ((double)EnableSnapshotDialog.this.availableSize > EnableSnapshotDialog.this.requiredSize) {
                    EnableSnapshotDialog.this.capacityIndicationIcon.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("Avail.png"))));
                } else {
                    EnableSnapshotDialog.this.capacityIndicationIcon.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("NotAvail.png"))));
                }
            }
        });
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        JComponent jComponent = this.percentSpinner.getEditor();
        if (jComponent instanceof JSpinner.NumberEditor) {
            jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
        }
        jFormattedTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                    keyEvent.consume();
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Double d;
                JFormattedTextField jFormattedTextField = ((JSpinner.NumberEditor)EnableSnapshotDialog.this.percentSpinner.getEditor()).getTextField();
                if (jFormattedTextField.getText().length() == 0) {
                    return;
                }
                try {
                    d = new Double(jFormattedTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    EnableSnapshotDialog.this.requiredSize = (Double)EnableSnapshotDialog.this.percentSpinner.getValue();
                    jFormattedTextField.setText("" + EnableSnapshotDialog.this.requiredSize);
                    EnableSnapshotDialog.this.percentSpinner.setValue(EnableSnapshotDialog.this.requiredSize);
                    return;
                }
                EnableSnapshotDialog.this.requiredSize = d;
                if (d > EnableSnapshotDialog.this.size[0]) {
                    EnableSnapshotDialog.this.requiredSize = EnableSnapshotDialog.this.size[0];
                    jFormattedTextField.setText("" + EnableSnapshotDialog.this.requiredSize);
                    EnableSnapshotDialog.this.percentSpinner.setValue(EnableSnapshotDialog.this.requiredSize);
                } else if (d < 1.0) {
                    EnableSnapshotDialog.this.requiredSize = 1.0;
                    jFormattedTextField.setText("" + EnableSnapshotDialog.this.requiredSize);
                    EnableSnapshotDialog.this.percentSpinner.setValue(EnableSnapshotDialog.this.requiredSize);
                }
            }
        });
        stringArray = Resource.getResourceMnemonic(Resource.getString("AUTO_SNAPSHOT", "(T)ake snapshot on reboot"));
        this.autoSnapshotCheckBox = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.autoSnapshotCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)this.autoSnapshotCheckBox, gridBagConstraints);
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(Resource.getString("AUTO_SNAPSHOT_DESC", "<html>Selecting this option will take a snapshot of the VD on boot after every successful shutdown. This feature is mainly intended to<br>take snapshot of boot VDs to allow restoring the OS on the VD in case of corruption. Before selecting take snapshot on reboot<br>on the VD, please ensure that you have copied all data to the VD</html>"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)new JLabel(stringBuffer2.toString()), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.capacityIndicationIcon = (double)this.availableSize > this.requiredSize ? new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("Avail.png"))), 0) : new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("NotAvail.png"))), 0);
        gridBagConstraints.insets = new Insets(10, 170, 0, 0);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_okButton = new JButton(stringArray[0]);
        this.getRootPane().setDefaultButton(this.m_okButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
        JButton jButton = new JButton(stringArray[0]);
        jPanel2.add(this.m_okButton);
        jPanel2.add(jButton);
        gridBagConstraints.gridy += 5;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (EnableSnapshotDialog.this.warningDialog()) {
                    EnableSnapshotDialog.this.dispose();
                }
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = EnableSnapshotDialog.this.requiredSize;
                int n = (int)EnableSnapshotDialog.this.size[1];
                long l = KernelConstants.getSizeInBlocks(d, n, EnableSnapshotDialog.this.m_ldHelper.getBlockSize());
                LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)EnableSnapshotDialog.this.snapRepository.getSelectedItem();
                SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)EnableSnapshotDialog.this.m_ldHelper.getDeviceObject();
                SASLogicalDrive sASLogicalDrive2 = (SASLogicalDrive)logicalDriveHelper.getDeviceObject();
                if (sASLogicalDrive2.getInformation().getsnapshotRepository() == 1) {
                    StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_REP", "<html>Once you enable snapshots on this virtual drive, you cannot change<br>the allocated capacity percentage or the snapshot repository without<br>first disabling snapshots and losing any snapshot data.<br><br>Are you sure you want to enable snapshots on Virtual Drive:"));
                    stringBuffer.append(sASLogicalDrive.getID() + " " + sASLogicalDrive.getName() + " ? </html>");
                    if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_ENABLE_SNAPSHOT_TITLE", "Confirm Enable Snapshots"), stringBuffer.toString())) {
                        EnableSnapshotDialog.this.dispose();
                        return;
                    }
                } else {
                    StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_NON_REP", "<html>Once you enable snapshots on this virtual drive, you cannot change<br>the allocated capacity percentage or the snapshot repository without<br>first disabling snapshots and losing any snapshot data.<br><br>"));
                    stringBuffer.append(Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive2.getID() + " " + sASLogicalDrive2.getName() + " ");
                    stringBuffer.append(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_NON_REP_CONT1", "will become a snapshot repository.<br>It should now only be used for storing snapshot-related data. If there<br>is any existing data on"));
                    stringBuffer.append(" " + Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive2.getID() + " " + sASLogicalDrive2.getName() + " ");
                    stringBuffer.append(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_NON_REP_CONT2", "it will be lost.<br><br> Are you sure you want to enable snapshots on"));
                    stringBuffer.append(" " + Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive.getID() + " " + sASLogicalDrive.getName() + " ? </html>");
                    if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_ENABLE_SNAPSHOT_TITLE", "Confirm Enable Snapshots"), stringBuffer.toString())) {
                        EnableSnapshotDialog.this.dispose();
                        return;
                    }
                }
                boolean bl = EnableSnapshotDialog.this.autoSnapshotCheckBox.isSelected();
                EnableSnapshotDialog.this.dispose();
            }
        });
        this.add(jPanel);
        this.title = Resource.getString("ENABLE_SNAPSHOT_TITLE", "Enable Snapshots");
        this.setTitle(this.title);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    protected boolean warningDialog() {
        String string = Resource.getString("ENABLE_SNAPSHOT_CONFIRMATION_TITLE", "Enable Snapshot - Confirmation");
        JOptionPane jOptionPane = new JOptionPane(Resource.getString("CONFIG_CANCEL_MSG"), 3, 0);
        this.createDialog(jOptionPane, string);
        Object object = jOptionPane.getValue();
        return object instanceof Integer && (Integer)object == 0;
    }

    private void createDialog(JOptionPane jOptionPane, String string) {
        JDialog jDialog = jOptionPane.createDialog(this, string);
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        jDialog.setIconImage(image);
        jDialog.setVisible(true);
    }

    public long getAvailableCapacity() {
        long l = 0L;
        long l2 = 0L;
        LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)this.snapRepository.getSelectedItem();
        if (((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsnapshotRepository() == 1) {
            MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = null;
            mR_LD_SNAPSHOT_REPOSITORY_SPACE = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getSnapshotRepositorySpace();
            byte by = mR_LD_SNAPSHOT_REPOSITORY_SPACE.getNumHoles();
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                l2 += mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[by2].getHoleSize();
            }
            l2 = KernelConstants.getSizeInBlocks(l2, 2, this.m_ldHelper.getBlockSize());
        }
        l = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsize();
        l = l - l2 - StoreLibConstants.OS_METADATA_SIZE_ON_REP;
        return l;
    }

    public long getAvailableCapacity(LogicalDriveHelper logicalDriveHelper) {
        long l = 0L;
        long l2 = 0L;
        if (((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsnapshotRepository() == 1) {
            MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = null;
            mR_LD_SNAPSHOT_REPOSITORY_SPACE = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getSnapshotRepositorySpace();
            byte by = mR_LD_SNAPSHOT_REPOSITORY_SPACE.getNumHoles();
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                l2 += mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[by2].getHoleSize();
            }
            l2 = KernelConstants.getSizeInBlocks(l2, 2, this.m_ldHelper.getBlockSize());
        }
        l = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsize();
        l = l - l2 - StoreLibConstants.OS_METADATA_SIZE_ON_REP;
        return l;
    }

    static /* synthetic */ double[] access$302(EnableSnapshotDialog enableSnapshotDialog, double[] dArray) {
        enableSnapshotDialog.size = dArray;
        return dArray;
    }

    class RepositorySizeComparator
    implements Comparator {
        RepositorySizeComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2 = EnableSnapshotDialog.this.getAvailableCapacity((LogicalDriveHelper)object);
            if (l2 < (l = EnableSnapshotDialog.this.getAvailableCapacity((LogicalDriveHelper)object2))) {
                return 1;
            }
            if (l2 > l) {
                return -1;
            }
            return 0;
        }
    }
}

