/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.venus.configuration.ConfigurationSummaryPage;
import GUI.venus.configuration.DriveGroupSelectionPage;
import GUI.venus.configuration.ModeSelectionPage;
import GUI.venus.configuration.advanced.AdvanceConfigEngine;
import GUI.venus.configuration.advanced.DriveGroupCreationPage;
import GUI.venus.configuration.advanced.VirtualDiskCreationPage;
import GUI.venus.configuration.simple.SimpleConfigEngine;
import GUI.venus.configuration.simple.VirtualDriveSettingsPage;
import GUI.venus.wizard.DefaultWizardPage;
import GUI.venus.wizard.WizardController;
import GUI.venus.wizard.WizardNavigationException;
import GUIHelper.AdapterHelper;
import GUIHelper.EnclosureHelper;
import GUIHelper.LogicalDriveHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.Constants.StoreLibConstants;
import SASKernel.LibraryAPI.StoreLib.MR_BIOS_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_REPOSITORY_SPACE;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import Wizard.UnitsComboBoxModel;
import Wizard.UnitsRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class EnableSnapshotPanel
extends JPanel
implements ListSelectionListener,
TableModelListener,
Observer {
    private LogicalDriveHelper m_ldHelper = null;
    private SpinnerNumberModel percentSpinnerModel = null;
    private JSpinner percentSpinner = null;
    private JComboBox unitComboBox = null;
    private UnitsComboBoxModel m_unitsComboModel = null;
    private int m_iCurrentUnit = 3;
    private long availableSize = 0L;
    private double[] size = new double[2];
    private long defaultavailableSize = 0L;
    private double[] defaultSize = new double[2];
    private JLabel notesLabel = new JLabel();
    private SnapRepositoryTabelModel snapRepositoryModel = null;
    private JTable snapRepositoryTable = null;
    private JButton createVdButton = null;
    private Vector<LogicalDriveHelper> ldHelpers = new Vector();
    private DefaultWizardPage m_wizardpage = null;

    public EnableSnapshotPanel(LogicalDriveHelper logicalDriveHelper, DefaultWizardPage defaultWizardPage) {
        this.m_wizardpage = defaultWizardPage;
        this.m_wizardpage.setNextButtonStatus(false);
        this.m_ldHelper = logicalDriveHelper;
        this.addObservers();
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.m_ldHelper.getText());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("ENABLE_SNAPSHOT_DESC", "<html>Select an existing virtual drive or create a new virtual drive to use as the snapshot repository,<br>which will hold the snapshot-related information for this virtual drive. The snapshot repository<br>should only be used for snapshot data.</html>"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)new JLabel(stringBuffer.toString()), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SNAPSHOT_REPOSITORY_LABEL", "(S)napshot Repository:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.setEligibleLds();
        this.snapRepositoryModel = new SnapRepositoryTabelModel(this.ldHelpers);
        this.snapRepositoryModel.addTableModelListener(this);
        this.snapRepositoryTable = new JTable(this.snapRepositoryModel);
        this.snapRepositoryTable.setCellSelectionEnabled(false);
        this.snapRepositoryTable.setColumnSelectionAllowed(false);
        this.snapRepositoryTable.setRowSelectionAllowed(true);
        this.snapRepositoryTable.getSelectionModel().addListSelectionListener(this);
        this.snapRepositoryTable.setSelectionMode(0);
        this.snapRepositoryTable.getTableHeader().setReorderingAllowed(false);
        this.snapRepositoryTable.getTableHeader().setResizingAllowed(true);
        jLabel2.setLabelFor(this.snapRepositoryTable);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 10);
        JScrollPane jScrollPane = new JScrollPane(this.snapRepositoryTable);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, this.snapRepositoryTable.getRowHeight() * 5));
        stringArray = Resource.getResourceMnemonic(Resource.getString("CREATE_VD_TEXT", "(C)reate New...."));
        this.createVdButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.createVdButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 350, 0, 0);
        jPanel.add((Component)this.createVdButton, gridBagConstraints);
        this.createVdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EnableSnapshotPanel.this.CreateVd();
                EnableSnapshotPanel.this.snapRepositoryModel.fireTableDataChanged();
            }
        });
        stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("ENABLE_SNAPSHOT_DESC_CONTINUED", "<html>Specify the amount of capacity to allocate from the snapshot repository. Be careful to allocate<br>sufficient capacity because you cannot change it later without losing snapshot data.<br><br>Tips for allocating capacity:<br>- When allocating capacity, consider the expected percentage of data that will change between<br>snapshots times the number of snapshots retained (up to <num>).<br>- You may want to leave some available capacity on the snapshot repository for a future snapshot view.<br>The capacity for writes to a view must come from available capacity on the snapshot repository.</html>"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)new JLabel(stringBuffer.toString()), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_SELECT_CAPACITY", "S(e)lect Capacity"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)jLabel3, gridBagConstraints);
        this.percentSpinnerModel = new SpinnerNumberModel(1.0, 1.0, 100.0, 1.0);
        this.percentSpinner = new JSpinner(this.percentSpinnerModel);
        this.percentSpinnerModel.setMinimum(Double.valueOf(1.0));
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)this.percentSpinner, gridBagConstraints);
        jLabel3.setLabelFor(this.percentSpinner);
        this.percentSpinnerModel.setValue(0);
        this.m_unitsComboModel = new UnitsComboBoxModel(-1);
        this.percentSpinner.setEnabled(false);
        this.percentSpinner.setPreferredSize(new Dimension(this.percentSpinner.getPreferredSize().width * 2, this.percentSpinner.getPreferredSize().height));
        this.percentSpinnerModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                EnableSnapshotPanel.this.availableSize = EnableSnapshotPanel.this.getAvailableCapacity();
                EnableSnapshotPanel.access$202(EnableSnapshotPanel.this, KernelConstants.getSizeAndUnit(EnableSnapshotPanel.this.availableSize, EnableSnapshotPanel.this.m_ldHelper.getBlockSize()));
                if (EnableSnapshotPanel.this.size[1] >= 4.0) {
                    ((EnableSnapshotPanel)EnableSnapshotPanel.this).size[1] = 3.0;
                    ((EnableSnapshotPanel)EnableSnapshotPanel.this).size[0] = KernelConstants.getSizeInSpecifiedUnit(EnableSnapshotPanel.this.size[0], 4, 3, EnableSnapshotPanel.this.m_ldHelper.getBlockSize());
                }
                double d = Double.parseDouble(EnableSnapshotPanel.this.percentSpinner.getValue() + "");
                if ((Integer)EnableSnapshotPanel.this.unitComboBox.getSelectedItem() == (int)EnableSnapshotPanel.this.size[1]) {
                    EnableSnapshotPanel.this.percentSpinnerModel.setMaximum(Double.valueOf(EnableSnapshotPanel.this.size[0]));
                } else {
                    EnableSnapshotPanel.this.percentSpinnerModel.setMaximum(Double.valueOf(KernelConstants.getSizeInSpecifiedUnit(d, (int)EnableSnapshotPanel.this.size[1], (Integer)EnableSnapshotPanel.this.unitComboBox.getSelectedItem(), EnableSnapshotPanel.this.m_ldHelper.getBlockSize())));
                }
                System.out.println("percentSpinnerModel. " + EnableSnapshotPanel.this.percentSpinnerModel.getMaximum());
                double d2 = KernelConstants.getSizeInBlocks(d, (Integer)EnableSnapshotPanel.this.unitComboBox.getSelectedItem(), EnableSnapshotPanel.this.m_ldHelper.getBlockSize());
                long l = (long)d2 / 8L;
                l *= 100L;
                StringBuffer stringBuffer = new StringBuffer("(Approximately " + (l /= ((SASLogicalDrive)EnableSnapshotPanel.this.m_ldHelper.getDeviceObject()).getSize()) + "% " + "of data may change for each of 8 snapshots)");
                EnableSnapshotPanel.this.notesLabel.setText(stringBuffer.toString());
            }
        });
        this.unitComboBox = new JComboBox(this.m_unitsComboModel);
        this.unitComboBox.setRenderer(new UnitsRenderer());
        this.unitComboBox.addItemListener(new UnitsChangeItemListener());
        this.unitComboBox.setEnabled(false);
        this.unitComboBox.setSelectedItem((int)this.defaultSize[1] - 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 120, 0, 0);
        jPanel.add((Component)this.unitComboBox, gridBagConstraints);
        long l = this.availableSize / 8L;
        l *= 100L;
        StringBuffer stringBuffer2 = new StringBuffer("(Approximately " + (l /= ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getSize()) + "% " + "of data may change for each of 8 snapshots)");
        this.notesLabel.setText(stringBuffer2.toString());
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 20, 0, 0);
        jPanel.add((Component)this.notesLabel, gridBagConstraints);
        JFormattedTextField jFormattedTextField = new JFormattedTextField();
        JComponent jComponent = this.percentSpinner.getEditor();
        if (jComponent instanceof JSpinner.NumberEditor) {
            jFormattedTextField = ((JSpinner.NumberEditor)jComponent).getTextField();
        }
        jFormattedTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (!Character.isDigit(keyEvent.getKeyChar()) && keyEvent.getKeyChar() != '.' && keyEvent.getKeyCode() != 8 && keyEvent.getKeyCode() != 127) {
                    keyEvent.consume();
                    return;
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Double d;
                EnableSnapshotPanel.this.availableSize = EnableSnapshotPanel.this.getAvailableCapacity();
                EnableSnapshotPanel.access$202(EnableSnapshotPanel.this, KernelConstants.getSizeAndUnit(EnableSnapshotPanel.this.availableSize, EnableSnapshotPanel.this.m_ldHelper.getBlockSize()));
                JFormattedTextField jFormattedTextField = ((JSpinner.NumberEditor)EnableSnapshotPanel.this.percentSpinner.getEditor()).getTextField();
                if (jFormattedTextField.getText().length() == 0) {
                    return;
                }
                System.out.println("(Integer) m_unitsComboModel.getSelectedItem() " + (Integer)EnableSnapshotPanel.this.unitComboBox.getSelectedItem());
                int n = (Integer)EnableSnapshotPanel.this.unitComboBox.getSelectedItem();
                ((EnableSnapshotPanel)EnableSnapshotPanel.this).size[0] = KernelConstants.getSizeInSpecifiedUnit(EnableSnapshotPanel.this.size[0], (int)EnableSnapshotPanel.this.size[1], n, EnableSnapshotPanel.this.m_ldHelper.getBlockSize());
                ((EnableSnapshotPanel)EnableSnapshotPanel.this).size[1] = n;
                try {
                    d = new Double(jFormattedTextField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    jFormattedTextField.setText("" + EnableSnapshotPanel.this.size[0]);
                    EnableSnapshotPanel.this.percentSpinner.setValue(EnableSnapshotPanel.this.size[0]);
                    return;
                }
                if (d > EnableSnapshotPanel.this.size[0]) {
                    jFormattedTextField.setText("" + EnableSnapshotPanel.this.size[0]);
                    EnableSnapshotPanel.this.percentSpinner.setValue(EnableSnapshotPanel.this.size[0]);
                } else if (d < 1.0) {
                    jFormattedTextField.setText("" + EnableSnapshotPanel.this.size[0]);
                    EnableSnapshotPanel.this.percentSpinner.setValue(EnableSnapshotPanel.this.size[0]);
                }
            }
        });
        this.add(jPanel);
        if ((this.isConfigAllowed() & 1) != 1) {
            this.createVdButton.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        long l = 0L;
        try {
            MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).parent()).getMFCDefaults();
            byte by = mR_MFC_DEFAULTS.getSnapVDSpace();
            l = ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getSize();
            l = l / 100L * (long)by * 5L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_wizardpage.setNextButtonStatus(true);
        this.percentSpinner.setEnabled(true);
        this.unitComboBox.setEnabled(true);
        this.availableSize = this.getAvailableCapacity();
        this.size = KernelConstants.getSizeAndUnit(this.availableSize, this.m_ldHelper.getBlockSize());
        if (this.size[1] >= 4.0) {
            this.size[1] = 3.0;
            this.size[0] = KernelConstants.getSizeInSpecifiedUnit(this.size[0], 4, 3, this.m_ldHelper.getBlockSize());
        }
        if ((n = this.snapRepositoryTable.getSelectedRow()) == -1) {
            n = 0;
        }
        this.defaultavailableSize = Math.min(this.availableSize, l);
        this.defaultSize = KernelConstants.getSizeAndUnit(this.defaultavailableSize, this.m_ldHelper.getBlockSize());
        if (this.defaultSize[1] >= 4.0) {
            this.defaultSize[1] = 3.0;
            this.defaultSize[0] = KernelConstants.getSizeInSpecifiedUnit(this.defaultSize[0], 4, 3, this.m_ldHelper.getBlockSize());
        }
        this.m_iCurrentUnit = (int)this.defaultSize[1];
        if (this.m_unitsComboModel == null) {
            this.m_unitsComboModel = new UnitsComboBoxModel((int)this.size[1]);
        } else {
            this.m_unitsComboModel.setUnit((int)this.size[1]);
        }
        this.m_unitsComboModel.setSelectedItem((int)this.defaultSize[1]);
        this.percentSpinnerModel.setValue(this.defaultSize[0]);
        long l2 = this.defaultavailableSize / 8L;
        l2 *= 100L;
        StringBuffer stringBuffer = new StringBuffer("(Approximately " + (l2 /= ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getSize()) + "% " + "of data may change for each of 8 snapshots)");
        this.notesLabel.setText(stringBuffer.toString());
    }

    public long getAvailableCapacity() {
        LogicalDriveHelper logicalDriveHelper;
        long l = 0L;
        long l2 = 0L;
        int n = this.snapRepositoryTable.getSelectedRow();
        if (n == -1) {
            n = 0;
        }
        if (((SASLogicalDrive)(logicalDriveHelper = this.ldHelpers.get(n)).getDeviceObject()).getInformation().getsnapshotRepository() == 1) {
            MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = null;
            mR_LD_SNAPSHOT_REPOSITORY_SPACE = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getSnapshotRepositorySpace();
            byte by = mR_LD_SNAPSHOT_REPOSITORY_SPACE.getNumHoles();
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                l2 += mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[by2].getHoleSize();
            }
            l2 = KernelConstants.getSizeInBlocks(l2, 2, this.m_ldHelper.getBlockSize());
        }
        l = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsize();
        l = l - l2 - StoreLibConstants.OS_METADATA_SIZE_ON_REP;
        return l;
    }

    public long getAvailableCapacity(LogicalDriveHelper logicalDriveHelper) {
        long l = 0L;
        long l2 = 0L;
        if (((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsnapshotRepository() == 1) {
            MR_LD_SNAPSHOT_REPOSITORY_SPACE mR_LD_SNAPSHOT_REPOSITORY_SPACE = null;
            mR_LD_SNAPSHOT_REPOSITORY_SPACE = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getSnapshotRepositorySpace();
            byte by = mR_LD_SNAPSHOT_REPOSITORY_SPACE.getNumHoles();
            for (byte by2 = 0; by2 < by; by2 = (byte)(by2 + 1)) {
                l2 += mR_LD_SNAPSHOT_REPOSITORY_SPACE.getRecoverableholeInfo()[by2].getHoleSize();
            }
            l2 = KernelConstants.getSizeInBlocks(l2, 2, this.m_ldHelper.getBlockSize());
        }
        l = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getInformation().getsize();
        l = l - l2 - StoreLibConstants.OS_METADATA_SIZE_ON_REP;
        return l;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setEligibleLds();
        this.snapRepositoryModel.updateModel();
    }

    public void setEligibleLds() {
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.m_ldHelper.getParent()).getLogicalDrives();
        MR_BIOS_DATA mR_BIOS_DATA = null;
        short s = 0;
        try {
            mR_BIOS_DATA = ((SASAdapter)((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).parent()).getBIOSData();
            s = mR_BIOS_DATA.getbootTargetId();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
        }
        boolean bl = false;
        bl = this.m_ldHelper.isEncrypted();
        this.ldHelpers.removeAllElements();
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            if (((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getID() == ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getID() || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() == 1 || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getisSSCD() != 0 || ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPIEnabled() == 1 && ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getPIEnabled() == 0 || ((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).getInformation().getldConfig().getparams().getPIEnabled() == 0 && ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getPIEnabled() == 1 || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000' || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getID() == s) continue;
            if (bl) {
                if (!logicalDriveHelperArray[i].isEncrypted()) continue;
                this.ldHelpers.add(logicalDriveHelperArray[i]);
                continue;
            }
            this.ldHelpers.add(logicalDriveHelperArray[i]);
        }
        Collections.sort(this.ldHelpers, new RepositorySizeComparator());
    }

    public void CreateVd() {
        try {
            SimpleConfigEngine simpleConfigEngine = new SimpleConfigEngine((AdapterHelper)this.m_ldHelper.getParent());
            AdvanceConfigEngine advanceConfigEngine = new AdvanceConfigEngine((AdapterHelper)this.m_ldHelper.getParent());
            WizardController wizardController = new WizardController();
            HashMap hashMap = wizardController.getWizardData();
            hashMap.put("isSimpleAllowed", true);
            hashMap.put("SimpleConfigEngine", simpleConfigEngine);
            hashMap.put("AdapterHelper", (AdapterHelper)this.m_ldHelper.getParent());
            hashMap.put("WarningDialogTitle", Resource.getString("CONFIG_CONFIRMATION_TITLE", "Create virtual Drive - Confirmation"));
            hashMap.put("AdvanceConfigEngine", advanceConfigEngine);
            wizardController.addPage(ModeSelectionPage.class.getName(), "ModeSelectionPage");
            wizardController.addPage(DriveGroupSelectionPage.class.getName(), "DriveGroupSelectionPage");
            wizardController.addPage(VirtualDriveSettingsPage.class.getName(), "VirtualDriveSettingsPage");
            wizardController.addPage(DriveGroupCreationPage.class.getName(), "AdvanceDGCreationPage");
            wizardController.addPage(VirtualDiskCreationPage.class.getName(), "AdvanceVDCreationPage");
            wizardController.addPage(ConfigurationSummaryPage.class.getName(), "ConfigurationSummaryPage");
            wizardController.setFirstPage("ModeSelectionPage");
            wizardController.addPageTransition("ModeSelectionPage", 0, "DriveGroupSelectionPage");
            wizardController.addPageTransition("ModeSelectionPage", 1, "VirtualDriveSettingsPage");
            wizardController.addPageTransition("DriveGroupSelectionPage", 0, "ConfigurationSummaryPage");
            wizardController.addPageTransition("DriveGroupSelectionPage", 1, "VirtualDriveSettingsPage");
            wizardController.addPageTransition("VirtualDriveSettingsPage", 0, "ConfigurationSummaryPage");
            wizardController.addPageTransition("ModeSelectionPage", 2, "AdvanceDGCreationPage");
            wizardController.addPageTransition("DriveGroupSelectionPage", 2, "AdvanceVDCreationPage");
            wizardController.addPageTransition("DriveGroupSelectionPage", 3, "AdvanceDGCreationPage");
            wizardController.addPageTransition("AdvanceDGCreationPage", 0, "AdvanceVDCreationPage");
            wizardController.addPageTransition("AdvanceVDCreationPage", 0, "ConfigurationSummaryPage");
            wizardController.launchWizard();
        }
        catch (WizardNavigationException wizardNavigationException) {
            wizardNavigationException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getRequiredSize() {
        double d = KernelConstants.getSizeInBlocks((Double)this.percentSpinner.getValue(), this.m_iCurrentUnit, this.m_ldHelper.getBlockSize());
        return d;
    }

    public LogicalDriveHelper getChosenRepository() {
        int n = this.snapRepositoryTable.getSelectedRow();
        if (n == -1) {
            n = 0;
        }
        LogicalDriveHelper logicalDriveHelper = this.ldHelpers.get(n);
        return logicalDriveHelper;
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        switch (n) {
            default: 
        }
        this.snapRepositoryModel.fireTableDataChanged();
    }

    private int isConfigAllowed() {
        OperationDetails operationDetails = new OperationDetails(9, null);
        int n = 0;
        try {
            ((SASAdapter)((SASLogicalDrive)this.m_ldHelper.getDeviceObject()).parent()).fireConfigOperation(operationDetails);
            n = (Integer)operationDetails.getParam();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private void addObservers() {
        ((AdapterHelper)this.m_ldHelper.getParent()).addObserver(this);
        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)this.m_ldHelper.getParent()).getPhysicalDrives();
        int n = physicalDriveHelperArray.length;
        for (int i = 0; i < n; ++i) {
            physicalDriveHelperArray[i].addObserver(this);
        }
        EnclosureHelper[] enclosureHelperArray = ((AdapterHelper)this.m_ldHelper.getParent()).getEnclosures();
        int n2 = enclosureHelperArray.length;
        for (int i = 0; i < n2; ++i) {
            enclosureHelperArray[i].addObserver(this);
        }
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.m_ldHelper.getParent()).getLogicalDrives();
        int n3 = logicalDriveHelperArray.length;
        for (int i = 0; i < n3; ++i) {
            logicalDriveHelperArray[i].addObserver(this);
        }
    }

    static /* synthetic */ double[] access$202(EnableSnapshotPanel enableSnapshotPanel, double[] dArray) {
        enableSnapshotPanel.size = dArray;
        return dArray;
    }

    public class SnapRepositoryTabelModel
    extends AbstractTableModel {
        private Vector<LogicalDriveHelper> m_ldHelpers = null;

        public SnapRepositoryTabelModel(Vector<LogicalDriveHelper> vector) {
            this.m_ldHelpers = vector;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.m_ldHelpers.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            LogicalDriveHelper logicalDriveHelper = this.m_ldHelpers.get(n);
            if (n2 == 0) {
                string = ((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getName();
            }
            if (n2 == 1) {
                string = logicalDriveHelper.getState();
            } else if (n2 == 2) {
                string = KernelConstants.getConvertedSize(EnableSnapshotPanel.this.getAvailableCapacity(logicalDriveHelper), logicalDriveHelper.getBlockSize());
            } else if (n2 == 3) {
                string = KernelConstants.getConvertedSize(((SASLogicalDrive)logicalDriveHelper.getDeviceObject()).getSize(), logicalDriveHelper.getBlockSize());
            }
            return string;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return super.getColumnClass(n);
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                string = Resource.getString("NAME", "Name");
            } else if (n == 1) {
                string = Resource.getString("STATUS", "Status");
            } else if (n == 2) {
                string = Resource.getString("AVAILABLE_CAPACITY_TEXT", "Available Capacity");
            } else if (n == 3) {
                string = Resource.getString("PROPERTY_TOTAL_CAPACITY_TEXT", "Total capacity");
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public int getSelectedRowCount() {
            return 1;
        }

        public void updateModel() {
            this.m_ldHelpers = EnableSnapshotPanel.this.ldHelpers;
            if ((EnableSnapshotPanel.this.isConfigAllowed() & 1) != 1) {
                EnableSnapshotPanel.this.createVdButton.setEnabled(false);
            }
        }
    }

    class RepositorySizeComparator
    implements Comparator {
        RepositorySizeComparator() {
        }

        public int compare(Object object, Object object2) {
            long l;
            long l2 = EnableSnapshotPanel.this.getAvailableCapacity((LogicalDriveHelper)object);
            if (l2 < (l = EnableSnapshotPanel.this.getAvailableCapacity((LogicalDriveHelper)object2))) {
                return 1;
            }
            if (l2 > l) {
                return -1;
            }
            return 0;
        }
    }

    class UnitsChangeItemListener
    implements ItemListener {
        UnitsChangeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            double d;
            int n;
            if (EnableSnapshotPanel.this.unitComboBox.getSelectedIndex() != -1 && (n = ((Integer)itemEvent.getItem()).intValue()) != EnableSnapshotPanel.this.m_iCurrentUnit && (d = Double.parseDouble(EnableSnapshotPanel.this.percentSpinner.getValue() + "")) > 0.0) {
                double d2 = KernelConstants.getSizeInSpecifiedUnit(d, EnableSnapshotPanel.this.m_iCurrentUnit, n, EnableSnapshotPanel.this.m_ldHelper.getBlockSize());
                EnableSnapshotPanel.this.percentSpinnerModel.setValue(d2);
                EnableSnapshotPanel.this.m_iCurrentUnit = n;
            }
        }
    }
}

