/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_SNAPSHOT_SCHEDULE_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Snapshot.CreateNewSchedule;
import Snapshot.EditSchedulePanel;
import Snapshot.PitDetailPanel;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ManageSnapshotSchedules
extends VivaldiBaseDialog
implements ListSelectionListener,
TableModelListener,
Observer {
    private AdapterHelper m_helper = null;
    private ArrayList<LogicalDriveHelper> m_ldHelper = null;
    PitDetailPanel pitDetailPanel = null;
    private JPanel mainPanel = new JPanel();
    GridBagConstraints gbc = new GridBagConstraints();
    private VDScheduleTabelModel scheduleTabelModel = null;
    private JTable scheduleTable = null;
    private JButton createSnapshotButton = new JButton();
    private JButton cancelButton = new JButton();
    private static final int SCHEDULE_FREQUENCY_WEEKLY = 168;
    private static final int SCHEDULE_FREQUENCY_NONE = 0;
    private static final byte STATE_ENABLED = 1;
    private static final byte STATE_DISABLED = 0;
    private JButton EditButton = null;
    private JButton pauseButton = null;
    private JButton deleteButton = null;
    private JButton AddToScheduleButton = null;
    private JButton NewScheduleButton = null;
    private VDNoScheduleTabelModel VdTabelModel = null;
    private JTable VdTabel = null;
    private String m_strHelpPage = "MR_MANAGE_SNAPSHOTS";
    private Vector<LogicalDriveHelper> ldHelpers = null;
    private Vector<LogicalDriveHelper> tempLdHelpers = null;

    public ManageSnapshotSchedules(ArrayList<LogicalDriveHelper> arrayList, AdapterHelper adapterHelper) {
        this.m_helper = adapterHelper;
        this.m_ldHelper = arrayList;
        this.buildUI();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpPage);
    }

    public void buildUI() {
        Object object;
        Object object2;
        int n;
        String[] stringArray = null;
        int n2 = this.m_ldHelper.size();
        for (int i = 0; i < n2; ++i) {
            this.m_ldHelper.get(i).addObserver(this);
        }
        this.mainPanel.setLayout(new GridBagLayout());
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.anchor = 18;
        this.gbc.insets = new Insets(10, 30, 0, 15);
        this.gbc.gridwidth = 10;
        String string = Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES_DESC", "Manage Snapshot Schedules");
        stringArray = Resource.getResourceMnemonic(Resource.getString("SCHEDULE_TEXT", "(S)chedule:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.mainPanel.add((Component)jLabel2, this.gbc);
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_helper.getLogicalDrives();
        this.ldHelpers = new Vector();
        for (n = 0; n < logicalDriveHelperArray.length; ++n) {
            if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((MR_SNAPSHOT_SCHEDULE_PROPERTIES)(object2 = ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getSnapshotInformation().getSchedProp())).getExecFreq() == 0) continue;
            this.ldHelpers.add(logicalDriveHelperArray[n]);
        }
        this.scheduleTabelModel = this.ldHelpers.size() != 0 ? new VDScheduleTabelModel(this.ldHelpers) : new VDScheduleTabelModel();
        this.scheduleTabelModel.addTableModelListener(this);
        this.scheduleTable = new JTable(this.scheduleTabelModel);
        this.scheduleTable.setCellSelectionEnabled(false);
        this.scheduleTable.setColumnSelectionAllowed(false);
        this.scheduleTable.setRowSelectionAllowed(true);
        this.scheduleTable.getSelectionModel().addListSelectionListener(this);
        this.scheduleTable.setSelectionMode(0);
        this.scheduleTable.getTableHeader().setReorderingAllowed(false);
        this.scheduleTable.getTableHeader().setResizingAllowed(true);
        this.scheduleTable.setAutoResizeMode(4);
        for (n = 0; n < this.scheduleTable.getRowCount(); ++n) {
            this.scheduleTable.setRowHeight(n, ((Schedule)this.scheduleTabelModel.scheduleList.get(n)).getLdHelpers().size() * 40);
        }
        TableColumn tableColumn = this.scheduleTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(150);
        jLabel.setLabelFor(this.scheduleTable);
        ++this.gbc.gridy;
        ++this.gbc.gridy;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(10, 30, 0, 15);
        object2 = new JScrollPane(this.scheduleTable);
        this.mainPanel.add((Component)object2, this.gbc);
        ((JComponent)object2).setPreferredSize(new Dimension(((JComponent)object2).getPreferredSize().width, this.scheduleTable.getRowHeight() * 10));
        jLabel2.setLabelFor((Component)object2);
        this.gbc.gridwidth = 1;
        stringArray = Resource.getResourceMnemonic(Resource.getString("EDIT_SCHEDULE", "(E)dit Schedule"));
        this.EditButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.EditButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(10, 30, 0, 15);
        this.mainPanel.add((Component)this.EditButton, this.gbc);
        Vector vector = this.scheduleTabelModel.scheduleList;
        if (vector == null || vector.size() == 0) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("PAUSE_BUTTON", "(P)ause"));
            this.pauseButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.pauseButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.pauseButton.setEnabled(false);
        } else if (((Schedule)vector.get(0)).getState() == 0) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("RESUME_TEXT", "Resu(m)e"));
            this.pauseButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.pauseButton.setMnemonic(stringArray[1].charAt(0));
            }
        } else if (((Schedule)vector.get(0)).getState() == 1) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("PAUSE_BUTTON", "(P)ause"));
            this.pauseButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.pauseButton.setMnemonic(stringArray[1].charAt(0));
            }
        }
        ++this.gbc.gridx;
        this.gbc.insets = new Insets(10, 30, 0, 15);
        this.mainPanel.add((Component)this.pauseButton, this.gbc);
        stringArray = Resource.getResourceMnemonic(Resource.getString("DELETE_BUTTON", "De(l)ete"));
        this.deleteButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.deleteButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++this.gbc.gridx;
        this.gbc.insets = new Insets(10, 30, 0, 15);
        this.mainPanel.add((Component)this.deleteButton, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 10;
        stringArray = Resource.getResourceMnemonic(Resource.getString("NO_SCHEDULE_TEXT", "(V)irtual drives with no snapshot schedule:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(10, 30, 0, 15);
        this.mainPanel.add((Component)jLabel3, this.gbc);
        this.tempLdHelpers = new Vector();
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            if (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((MR_SNAPSHOT_SCHEDULE_PROPERTIES)(object = ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getSnapshotInformation().getSchedProp())).getExecFreq() != 0) continue;
            this.tempLdHelpers.add(logicalDriveHelperArray[i]);
        }
        this.VdTabelModel = this.tempLdHelpers.size() != 0 ? new VDNoScheduleTabelModel(this.tempLdHelpers) : new VDNoScheduleTabelModel();
        this.VdTabelModel.addTableModelListener(this);
        this.VdTabel = new JTable(this.VdTabelModel);
        this.VdTabel.setCellSelectionEnabled(false);
        this.VdTabel.setColumnSelectionAllowed(false);
        this.VdTabel.setRowSelectionAllowed(true);
        this.VdTabel.getSelectionModel().addListSelectionListener(this);
        this.VdTabel.setSelectionMode(2);
        this.VdTabel.setTableHeader(null);
        this.VdTabel.setAutoResizeMode(4);
        this.VdTabel.setRowHeight(this.VdTabel.getRowHeight() + 20);
        TableColumn tableColumn2 = this.VdTabel.getColumnModel().getColumn(0);
        tableColumn2.setPreferredWidth(150);
        jLabel.setLabelFor(this.VdTabel);
        ++this.gbc.gridy;
        ++this.gbc.gridy;
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(10, 30, 0, 15);
        object = new JScrollPane(this.VdTabel);
        this.mainPanel.add((Component)object, this.gbc);
        ((JComponent)object).setPreferredSize(new Dimension(((JComponent)object).getPreferredSize().width, this.VdTabel.getRowHeight() * 3));
        jLabel3.setLabelFor((Component)object);
        this.gbc.gridwidth = 1;
        stringArray = Resource.getResourceMnemonic(Resource.getString("ADD_TO_SCHEDULE_BUTTON", "(A)dd to Schedule"));
        this.AddToScheduleButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.AddToScheduleButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++this.gbc.gridy;
        this.gbc.insets = new Insets(10, 30, 10, 15);
        this.mainPanel.add((Component)this.AddToScheduleButton, this.gbc);
        stringArray = Resource.getResourceMnemonic(Resource.getString("NEW_SCHEDULE_BUTTON", "(N)ew Schedule"));
        this.NewScheduleButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.NewScheduleButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++this.gbc.gridx;
        this.gbc.insets = new Insets(10, 15, 10, 0);
        this.mainPanel.add((Component)this.NewScheduleButton, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridwidth = 10;
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("CLOSE_BUTTON_TEXT", "(C)lose"));
        this.createSnapshotButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.createSnapshotButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.getRootPane().setDefaultButton(this.createSnapshotButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("HELP_BUTTON_TEXT", "(H)elp"));
        this.cancelButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.cancelButton.setMnemonic(stringArray[1].charAt(0));
        }
        jPanel.add(this.createSnapshotButton);
        jPanel.add(this.cancelButton);
        this.gbc.gridy += 5;
        this.gbc.insets = new Insets(0, 0, 10, 0);
        this.gbc.anchor = 10;
        this.mainPanel.add((Component)jPanel, this.gbc);
        if (this.tempLdHelpers.size() == 0) {
            this.AddToScheduleButton.setEnabled(false);
            this.NewScheduleButton.setEnabled(false);
        }
        if (this.ldHelpers.size() != 0) {
            this.scheduleTable.setRowSelectionInterval(0, 0);
        }
        if (vector == null || vector.size() == 0) {
            this.deleteButton.setEnabled(false);
            this.EditButton.setEnabled(false);
        }
        this.EditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Vector vector = ManageSnapshotSchedules.this.scheduleTabelModel.scheduleList;
                int n2 = ManageSnapshotSchedules.this.scheduleTable.getSelectedRow();
                if (n2 == -1) {
                    Icon icon = UIManager.getIcon("OptionPane.warningIcon");
                    JOptionPane.showMessageDialog(null, new String("Please select a Schedule from the Schedule Table."), Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES_DESC", "Manage Snapshot Schedules"), 0, icon);
                    return;
                }
                Vector<LogicalDriveHelper> vector2 = new Vector<LogicalDriveHelper>();
                for (n = 0; n < ((Schedule)vector.get(n2)).ldHelpers.size(); ++n) {
                    vector2.add((LogicalDriveHelper)((Schedule)vector.get(n2)).ldHelpers.get(n));
                }
                n = ((Schedule)vector.get(n2)).getScheduleTime();
                int n3 = ((Schedule)vector.get(n2)).getScheduleFrequency();
                new EditSchedulePanel(vector2, n, n3, (LogicalDriveHelper)((Schedule)vector.get(n2)).ldHelpers.get(0), 13);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpContext.executeHelpProcess(ManageSnapshotSchedules.this.getHelpPage());
            }
        });
        this.createSnapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ManageSnapshotSchedules.this.warningDialog()) {
                    ManageSnapshotSchedules.this.dispose();
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = ManageSnapshotSchedules.this.scheduleTabelModel.scheduleList;
                int n = ManageSnapshotSchedules.this.scheduleTable.getSelectedRow();
                if (n == -1) {
                    Icon icon = UIManager.getIcon("OptionPane.warningIcon");
                    JOptionPane.showMessageDialog(null, new String("Please select a Schedule from the Schedule Table."), Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES_DESC", "Manage Snapshot Schedules"), 0, icon);
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DELETE_SCHEDULE_TEXT", "Are you sure that you want to delete the selected schedule?"));
                stringBuffer.append("\n");
                if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_DELETE_SCHEDULE_TITLE", "Confirm Delete Schedule"), stringBuffer.toString())) {
                    return;
                }
                for (int i = 0; i < ((Schedule)vector.get(n)).ldHelpers.size(); ++i) {
                    MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
                    long l = 0L;
                    boolean bl = false;
                    mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec((int)l);
                    mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq((short)(bl ? 1 : 0));
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)((Schedule)vector.get(n)).ldHelpers.get(i)).getDeviceObject();
                    sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
                }
            }
        });
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = ManageSnapshotSchedules.this.scheduleTabelModel.scheduleList;
                int n = ManageSnapshotSchedules.this.scheduleTable.getSelectedRow();
                if (n == -1) {
                    Icon icon = UIManager.getIcon("OptionPane.warningIcon");
                    JOptionPane.showMessageDialog(null, new String("Please select a Schedule from the Schedule Table."), Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES_DESC", "Manage Snapshot Schedules"), 0, icon);
                    return;
                }
                if (((Schedule)vector.get(n)).getState() == 1) {
                    int n2;
                    StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT", "All scheduled snapshots for the following virtual drives will be"));
                    stringBuffer.append("\n");
                    stringBuffer.append(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT_CONT_1", " skipped until you choose to resume the schedule."));
                    stringBuffer.append("\n");
                    stringBuffer.append("\n");
                    stringBuffer.append(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT_CONT_2", "Virtual drives:"));
                    stringBuffer.append("\n");
                    for (n2 = 0; n2 < ((Schedule)vector.get(n)).ldHelpers.size(); ++n2) {
                        stringBuffer.append(" ");
                        stringBuffer.append(((Schedule)vector.get(n)).ldHelpers.get(n2) + "\n");
                    }
                    stringBuffer.append("\n");
                    stringBuffer.append(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT_CONT_3", "Are you sure that you want to pause the schedule?"));
                    if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_PAUSE_SCHEDULE_TITLE", "Confirm Pause Schedule"), stringBuffer.toString())) {
                        return;
                    }
                    for (n2 = 0; n2 < ((Schedule)vector.get(n)).ldHelpers.size(); ++n2) {
                        MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec(((Schedule)vector.get(n)).getScheduleTime());
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq((short)0);
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)((Schedule)vector.get(n)).ldHelpers.get(n2)).getDeviceObject();
                        sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
                    }
                } else {
                    MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(((Schedule)vector.get(n)).getScheduleTime());
                    for (int i = 0; i < ((Schedule)vector.get(n)).ldHelpers.size(); ++i) {
                        MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec(((Schedule)vector.get(n)).getScheduleTime());
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq((short)((Schedule)vector.get(n)).getScheduleFrequency());
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)((Schedule)vector.get(n)).ldHelpers.get(i)).getDeviceObject();
                        sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
                    }
                    StringBuffer stringBuffer = new StringBuffer(Resource.getString("RESUME_SCHEDULE_TEXT", "The snapshot schedule has been resumed. The next"));
                    stringBuffer.append("\n");
                    stringBuffer.append(Resource.getString("RESUME_SCHEDULE_TEXT_CONT", " scheduled snapshot will occur on"));
                    stringBuffer.append(" " + KernelConstants.getTimeText(mR_TIME_STAMP));
                    JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, stringBuffer.toString(), Resource.getString("SCHEDULE_RESUMED_TITLE", "Snapshot Schedule Resumed"), 1);
                }
            }
        });
        this.NewScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = ManageSnapshotSchedules.this.VdTabelModel.m_ldHelpers;
                int[] nArray = ManageSnapshotSchedules.this.VdTabel.getSelectedRows();
                if (nArray.length == 0) {
                    Icon icon = UIManager.getIcon("OptionPane.warningIcon");
                    JOptionPane.showMessageDialog(null, new String("Please select a Virtual Drive from the list of \nVirtual drives with no snapshot schedule"), Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES_DESC", "Manage Snapshot Schedules"), 0, icon);
                    return;
                }
                new CreateNewSchedule(vector, nArray);
            }
        });
        this.AddToScheduleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector vector = ManageSnapshotSchedules.this.scheduleTabelModel.scheduleList;
                int n = ManageSnapshotSchedules.this.scheduleTable.getSelectedRow();
                Vector vector2 = ManageSnapshotSchedules.this.VdTabelModel.m_ldHelpers;
                int[] nArray = ManageSnapshotSchedules.this.VdTabel.getSelectedRows();
                if (vector.size() == 0) {
                    JOptionPane.showMessageDialog(null, new String("There are no existing Schedules available"), Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES_DESC", "Manage Snapshot Schedules"), 0);
                    return;
                }
                if (n == -1 || nArray.length <= 0) {
                    Icon icon = UIManager.getIcon("OptionPane.warningIcon");
                    JOptionPane.showMessageDialog(null, new String("Please select a Schedule from the Schedule table and a Virtual Drive \nfrom the list of Virtual drives with no snapshot schedule to proceed"), Resource.getString("ADAPTER_OPERATION_MANAGE_SNAPSHOT_SCHEDULES_DESC", "Manage Snapshot Schedules"), 0, icon);
                    return;
                }
                MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
                mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec(((Schedule)vector.get(n)).getScheduleTime());
                mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq((short)((Schedule)vector.get(n)).getScheduleFrequency());
                for (int i = 0; i < nArray.length; ++i) {
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)vector2.get(nArray[i])).getDeviceObject();
                    sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
                }
            }
        });
        this.add((Component)this.mainPanel, "West");
        this.setTitle(string);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Vector vector = this.scheduleTabelModel.scheduleList;
        String[] stringArray = null;
        int n = this.scheduleTable.getSelectedRow();
        if (n == -1) {
            n = 0;
        }
        if (vector == null || vector.size() == 0) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("PAUSE_BUTTON", "(P)ause"));
            this.pauseButton.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.pauseButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.pauseButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.EditButton.setEnabled(false);
        } else if (((Schedule)vector.get(n)).getState() == 0) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("RESUME_TEXT", "Resu(m)e"));
            this.pauseButton.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.pauseButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.pauseButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.EditButton.setEnabled(true);
        } else {
            stringArray = Resource.getResourceMnemonic(Resource.getString("PAUSE_BUTTON", "(P)ause"));
            this.pauseButton.setText(stringArray[0]);
            if (stringArray.length == 2) {
                this.pauseButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.pauseButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.EditButton.setEnabled(true);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES;
        int n;
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_helper.getLogicalDrives();
        this.ldHelpers.removeAllElements();
        for (n = 0; n < logicalDriveHelperArray.length; ++n) {
            if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || (mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getSnapshotInformation().getSchedProp()).getExecFreq() == 0) continue;
            this.ldHelpers.add(logicalDriveHelperArray[n]);
        }
        if (this.ldHelpers.size() == 0) {
            this.pauseButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.EditButton.setEnabled(false);
        } else {
            this.pauseButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.EditButton.setEnabled(true);
        }
        this.tempLdHelpers = new Vector();
        this.tempLdHelpers.removeAllElements();
        for (n = 0; n < logicalDriveHelperArray.length; ++n) {
            if (((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || (mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getSnapshotInformation().getSchedProp()).getExecFreq() != 0) continue;
            this.tempLdHelpers.add(logicalDriveHelperArray[n]);
        }
        this.scheduleTabelModel.updateModel();
        this.VdTabelModel.updateModel();
        for (n = 0; n < this.scheduleTable.getRowCount(); ++n) {
            this.scheduleTable.setRowHeight(n, ((Schedule)this.scheduleTabelModel.scheduleList.get(n)).getLdHelpers().size() * 40);
        }
        if (this.tempLdHelpers == null || this.tempLdHelpers.size() == 0) {
            this.NewScheduleButton.setEnabled(false);
        } else {
            this.NewScheduleButton.setEnabled(true);
            this.AddToScheduleButton.setEnabled(true);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        switch (n) {
            default: 
        }
        this.scheduleTabelModel.fireTableDataChanged();
        this.VdTabelModel.fireTableDataChanged();
    }

    private class VDNoScheduleTabelModel
    extends AbstractTableModel {
        private Vector<LogicalDriveHelper> m_ldHelpers = new Vector();

        public VDNoScheduleTabelModel() {
        }

        public VDNoScheduleTabelModel(Vector<LogicalDriveHelper> vector) {
            this.m_ldHelpers = vector;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.m_ldHelpers.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n2 == 0) {
                string = this.m_ldHelpers.get(n).getText();
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void updateModel() {
            this.m_ldHelpers = ManageSnapshotSchedules.this.tempLdHelpers;
            if (ManageSnapshotSchedules.this.tempLdHelpers.size() == 0) {
                ManageSnapshotSchedules.this.AddToScheduleButton.setEnabled(false);
                ManageSnapshotSchedules.this.NewScheduleButton.setEnabled(false);
            }
        }
    }

    private class VDScheduleTabelModel
    extends AbstractTableModel {
        private Vector<LogicalDriveHelper> m_ldHelpers = null;
        private Vector<Weekly> weeklyList = new Vector();
        private Vector<Daily> dailyList = new Vector();
        private Vector<Monthly> monthlyList = new Vector();
        private Vector<Schedule> enabledScheduleList = new Vector();
        private Vector<Schedule> disabledScheduleList = new Vector();
        private Vector<Schedule> scheduleList = new Vector();

        public VDScheduleTabelModel() {
        }

        public VDScheduleTabelModel(Vector<LogicalDriveHelper> vector) {
            this.m_ldHelpers = vector;
            this.AddLDsToAppropriateList();
            this.CreateEnabledandDisabledScheduleList();
            this.CreateScheduleList();
        }

        private void CreateScheduleList() {
            int n;
            this.scheduleList.removeAllElements();
            for (n = 0; n < this.enabledScheduleList.size(); ++n) {
                this.scheduleList.add(this.enabledScheduleList.get(n));
            }
            for (n = 0; n < this.disabledScheduleList.size(); ++n) {
                this.scheduleList.add(this.disabledScheduleList.get(n));
            }
        }

        private void CreateEnabledandDisabledScheduleList() {
            int n;
            Schedule schedule;
            int n2;
            this.enabledScheduleList.removeAllElements();
            this.disabledScheduleList.removeAllElements();
            for (n2 = 0; n2 < this.dailyList.size(); ++n2) {
                schedule = new Schedule();
                if (this.dailyList.get(n2).getFrequency() != 24) {
                    n = this.dailyList.get(n2).getFrequency() / 24;
                    schedule.setType("Every " + n + " Days");
                } else {
                    schedule.setType(Resource.getString("DAILY", "Daily"));
                }
                schedule.setScheduleTime(this.dailyList.get(n2).getScheduleTime());
                schedule.setLdHelpers(this.dailyList.get(n2).getDaily_ldHelpers());
                schedule.setState(this.dailyList.get(n2).getState());
                schedule.setScheduleFrequency(this.dailyList.get(n2).getFrequency());
                if (this.dailyList.get(n2).getState() == 1) {
                    this.enabledScheduleList.add(schedule);
                    continue;
                }
                this.disabledScheduleList.add(schedule);
            }
            for (n2 = 0; n2 < this.weeklyList.size(); ++n2) {
                schedule = new Schedule();
                if (this.weeklyList.get(n2).getFrequency() != 168) {
                    n = this.weeklyList.get(n2).getFrequency() / 168;
                    schedule.setType("Every " + n + " Weeks");
                } else {
                    schedule.setType(Resource.getString("WEEKLY", "Weekly"));
                }
                schedule.setScheduleTime(this.weeklyList.get(n2).getScheduleTime());
                schedule.setLdHelpers(this.weeklyList.get(n2).getWeekly_ldHelpers());
                schedule.setState(this.weeklyList.get(n2).getState());
                schedule.setScheduleFrequency(this.weeklyList.get(n2).getFrequency());
                if (this.weeklyList.get(n2).getState() == 1) {
                    this.enabledScheduleList.add(schedule);
                    continue;
                }
                this.disabledScheduleList.add(schedule);
            }
            for (n2 = 0; n2 < this.monthlyList.size(); ++n2) {
                schedule = new Schedule();
                schedule.setType(Resource.getString("MONTHLY", "Monthly"));
                schedule.setScheduleTime(this.monthlyList.get(n2).getScheduleTime());
                schedule.setLdHelpers(this.monthlyList.get(n2).getMonthly_ldHelpers());
                schedule.setState(this.monthlyList.get(n2).getState());
                schedule.setScheduleFrequency(this.monthlyList.get(n2).getFrequency());
                if (this.monthlyList.get(n2).getState() == 1) {
                    this.enabledScheduleList.add(schedule);
                    continue;
                }
                this.disabledScheduleList.add(schedule);
            }
        }

        private void AddLDsToAppropriateList() {
            Vector<LogicalDriveHelper> vector;
            Vector<LogicalDriveHelper> vector2;
            int n;
            this.dailyList.removeAllElements();
            this.weeklyList.removeAllElements();
            this.monthlyList.removeAllElements();
            Vector<LogicalDriveHelper> vector3 = new Vector<LogicalDriveHelper>();
            Vector<LogicalDriveHelper> vector4 = new Vector<LogicalDriveHelper>();
            Vector vector5 = new Vector();
            MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = null;
            for (n = 0; n < this.m_ldHelpers.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)this.m_ldHelpers.get(n).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() < 168) {
                    vector3.add(this.m_ldHelpers.get(n));
                    continue;
                }
                vector4.add(this.m_ldHelpers.get(n));
            }
            for (n = 0; n < vector3.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)((LogicalDriveHelper)vector3.get(n)).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (this.dailyList.size() == 0) {
                    Daily daily = new Daily();
                    daily.setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                    Vector<LogicalDriveHelper> vector6 = new Vector<LogicalDriveHelper>();
                    vector6.add((LogicalDriveHelper)vector3.get(n));
                    daily.setDaily_ldHelpers(vector6);
                    daily.setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                    daily.setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                    this.dailyList.add(daily);
                    continue;
                }
                int n2 = 0;
                boolean bl = false;
                for (n2 = 0; n2 < this.dailyList.size(); ++n2) {
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec() != this.dailyList.get(n2).getScheduleTime() || mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() != this.dailyList.get(n2).getFrequency()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector2 = this.dailyList.get(n2).getDaily_ldHelpers();
                    vector2.add((LogicalDriveHelper)vector3.get(n));
                    this.dailyList.get(n2).setDaily_ldHelpers(vector2);
                    continue;
                }
                vector2 = new Daily();
                ((Daily)((Object)vector2)).setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                vector = new Vector<LogicalDriveHelper>();
                vector.add((LogicalDriveHelper)vector3.get(n));
                ((Daily)((Object)vector2)).setDaily_ldHelpers(vector);
                ((Daily)((Object)vector2)).setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                ((Daily)((Object)vector2)).setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                this.dailyList.add((Daily)((Object)vector2));
            }
            for (n = 0; n < vector4.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)((LogicalDriveHelper)vector4.get(n)).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (this.weeklyList.size() == 0) {
                    Weekly weekly = new Weekly();
                    weekly.setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                    Vector<LogicalDriveHelper> vector7 = new Vector<LogicalDriveHelper>();
                    vector7.add((LogicalDriveHelper)vector4.get(n));
                    weekly.setWeekly_ldHelpers(vector7);
                    weekly.setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                    weekly.setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                    this.weeklyList.add(weekly);
                    continue;
                }
                int n3 = 0;
                boolean bl = false;
                for (n3 = 0; n3 < this.weeklyList.size(); ++n3) {
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec() != this.weeklyList.get(n3).getScheduleTime() || mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() != this.weeklyList.get(n3).getFrequency()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector2 = this.weeklyList.get(n3).getWeekly_ldHelpers();
                    vector2.add((LogicalDriveHelper)vector4.get(n));
                    this.weeklyList.get(n3).setWeekly_ldHelpers(vector2);
                    continue;
                }
                vector2 = new Weekly();
                ((Weekly)((Object)vector2)).setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                vector = new Vector();
                vector.add((LogicalDriveHelper)vector4.get(n));
                ((Weekly)((Object)vector2)).setWeekly_ldHelpers(vector);
                ((Weekly)((Object)vector2)).setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                ((Weekly)((Object)vector2)).setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                this.weeklyList.add((Weekly)((Object)vector2));
            }
            for (n = 0; n < vector5.size(); ++n) {
                mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)((LogicalDriveHelper)vector5.get(n)).getDeviceObject()).getSnapshotInformation().getSchedProp();
                if (this.monthlyList.size() == 0) {
                    Monthly monthly = new Monthly();
                    monthly.setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                    Vector<LogicalDriveHelper> vector8 = new Vector<LogicalDriveHelper>();
                    vector8.add((LogicalDriveHelper)vector5.get(n));
                    monthly.setMonthly_ldHelpers(vector8);
                    monthly.setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                    monthly.setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                    this.monthlyList.add(monthly);
                    continue;
                }
                int n4 = 0;
                boolean bl = false;
                for (n4 = 0; n4 < this.monthlyList.size(); ++n4) {
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec() != this.monthlyList.get(n4).getScheduleTime()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    vector2 = this.monthlyList.get(n4).getMonthly_ldHelpers();
                    vector2.add((LogicalDriveHelper)vector5.get(n));
                    this.monthlyList.get(n4).setMonthly_ldHelpers(vector2);
                    continue;
                }
                vector2 = new Monthly();
                ((Monthly)((Object)vector2)).setScheduleTime(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec());
                vector = new Vector();
                vector.add((LogicalDriveHelper)vector5.get(n));
                ((Monthly)((Object)vector2)).setMonthly_ldHelpers(vector);
                ((Monthly)((Object)vector2)).setState(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState());
                ((Monthly)((Object)vector2)).setFrequency(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq());
                this.monthlyList.add((Monthly)((Object)vector2));
            }
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (this.m_ldHelpers == null) {
                return 0;
            }
            return this.scheduleList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CharSequence charSequence = null;
            if (n2 == 0 && this.scheduleList != null && this.scheduleList.size() != 0) {
                charSequence = this.scheduleList.get(n).getType();
            }
            if (n2 == 1) {
                if (this.scheduleList != null && this.scheduleList.size() != 0) {
                    MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(this.scheduleList.get(n).getScheduleTime());
                    charSequence = KernelConstants.getTimeText(mR_TIME_STAMP);
                }
            } else if (n2 == 2 && this.scheduleList != null && this.scheduleList.size() != 0) {
                Vector<LogicalDriveHelper> vector = this.scheduleList.get(n).getLdHelpers();
                StringBuffer stringBuffer = new StringBuffer("<html>" + vector.get(0).getText() + "<br>");
                for (int i = 1; i < vector.size(); ++i) {
                    stringBuffer.append(vector.get(i).getText() + "<br>");
                }
                stringBuffer.append("</html>");
                charSequence = stringBuffer;
            }
            return charSequence;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return super.getColumnClass(n);
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                string = Resource.getString("TABLE_TEXT_FREQUENCY", "Frequency");
            } else if (n == 1) {
                string = Resource.getString("TABLE_TEXT_NEXT_SNAP", "Next Snapshot");
            } else if (n == 2) {
                string = Resource.getString("TABLE_TEXT_SCHEDULED_VDS", "Scheduled Virtual Drives");
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public int getSelectedRowCount() {
            return 1;
        }

        public void updateModel() {
            this.m_ldHelpers = ManageSnapshotSchedules.this.ldHelpers;
            this.AddLDsToAppropriateList();
            this.CreateEnabledandDisabledScheduleList();
            this.CreateScheduleList();
            if (ManageSnapshotSchedules.this.ldHelpers.size() != 0) {
                ManageSnapshotSchedules.this.scheduleTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    public class Schedule {
        private String type = null;
        private int scheduleTime = 0;
        private byte state = 1;
        private int scheduleFrequency = 0;
        private Vector<LogicalDriveHelper> ldHelpers = null;

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getLdHelpers() {
            return this.ldHelpers;
        }

        public void setLdHelpers(Vector<LogicalDriveHelper> vector) {
            this.ldHelpers = vector;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }

        public int getScheduleFrequency() {
            return this.scheduleFrequency;
        }

        public void setScheduleFrequency(int n) {
            this.scheduleFrequency = n;
        }
    }

    public class Monthly {
        private int scheduleTime = 0;
        private byte state = 1;
        private Vector<LogicalDriveHelper> Monthly_ldHelpers = null;
        private int frequency = 0;

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int n) {
            this.frequency = n;
        }

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getMonthly_ldHelpers() {
            return this.Monthly_ldHelpers;
        }

        public void setMonthly_ldHelpers(Vector<LogicalDriveHelper> vector) {
            this.Monthly_ldHelpers = vector;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }
    }

    public class Daily {
        private int scheduleTime = 1;
        private byte state = 1;
        private Vector<LogicalDriveHelper> Daily_ldHelpers = null;
        private int frequency = 0;

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int n) {
            this.frequency = n;
        }

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getDaily_ldHelpers() {
            return this.Daily_ldHelpers;
        }

        public void setDaily_ldHelpers(Vector<LogicalDriveHelper> vector) {
            this.Daily_ldHelpers = vector;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }
    }

    public class Weekly {
        private int scheduleTime = 0;
        private byte state = 1;
        private Vector<LogicalDriveHelper> weekly_ldHelpers = null;
        private int frequency = 0;

        public int getFrequency() {
            return this.frequency;
        }

        public void setFrequency(int n) {
            this.frequency = n;
        }

        public int getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(int n) {
            this.scheduleTime = n;
        }

        public Vector<LogicalDriveHelper> getWeekly_ldHelpers() {
            return this.weekly_ldHelpers;
        }

        public void setWeekly_ldHelpers(Vector<LogicalDriveHelper> vector) {
            this.weekly_ldHelpers = vector;
        }

        public byte getState() {
            return this.state;
        }

        public void setState(byte by) {
            this.state = by;
        }
    }
}

