/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PIT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_ALL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_VIEW_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Snapshot.CreateViewDialog;
import Utils.CustomMsgBox;
import Utils.Resource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class PitDetailPanel
extends JPanel {
    private LogicalDriveHelper m_helper = null;
    private LogicalDriveHelper m_Repository_helper = null;
    private MR_LD_PIT_INFO m_PitInfo = null;
    private MR_LD_VIEW_INFO m_viewInfo = null;
    private MR_LD_SNAPSHOT_ALL_INFO m_allLDSPitInfo = null;
    private int m_oldestPit = 0;
    private JButton deleteSnapshotButton = new JButton();
    private JButton createViewButton = new JButton();
    private JButton deleteViewButton = new JButton();
    private JPanel mainPanel = new JPanel();
    GridBagConstraints gbc = new GridBagConstraints();
    private String[] m_month = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private boolean isViewOnly = false;

    public PitDetailPanel(LogicalDriveHelper logicalDriveHelper, MR_LD_PIT_INFO mR_LD_PIT_INFO, int n, LogicalDriveHelper logicalDriveHelper2) {
        this.m_helper = logicalDriveHelper;
        this.m_PitInfo = mR_LD_PIT_INFO;
        this.m_viewInfo = this.getViewInfo(this.m_PitInfo);
        this.m_oldestPit = n;
        this.isViewOnly = ((AdapterHelper)this.m_helper.getParent()).isViewOnlyMode();
        this.m_Repository_helper = logicalDriveHelper2;
        this.buildUI();
    }

    public void buildUI() {
        JLabel jLabel;
        JLabel jLabel2;
        String[] stringArray = null;
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.fill = 0;
        stringArray = Resource.getResourceMnemonic(Resource.getString("DELETE_SNAPSHOT", "Delete Snapshot"));
        this.deleteSnapshotButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.deleteSnapshotButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.mainPanel.add((Component)this.deleteSnapshotButton, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("CREATE_VIEW", "Create View"));
        this.createViewButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.createViewButton.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridx = 1;
        this.mainPanel.add((Component)this.createViewButton, gridBagConstraints);
        this.deleteViewButton.setText(Resource.getString("BUTTON_DELETE_VIEW", "Delete View"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_DELETE_VIEW", "Delete View"));
        this.deleteViewButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.deleteViewButton.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.gridx = 2;
        this.mainPanel.add((Component)this.deleteViewButton, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.insets = new Insets(5, 15, 5, 15);
        jPanel.setBorder(BorderFactory.createTitledBorder(new TitledBorder(Resource.getString("SNAPSHOT_DETAILS", "SnapShot Details"))));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        this.mainPanel.add((Component)jPanel, gridBagConstraints);
        JLabel jLabel3 = new JLabel(Resource.getString("DELETE_SNAPSHOT_NOTES", "<html><b>Note: </b>Only oldest snapshot <br> information can be deleted</html>"));
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 2;
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        JLabel jLabel4 = new JLabel();
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 1;
        jLabel4.setText(Resource.getString("NAME", "Name"));
        jPanel.add((Component)jLabel4, gridBagConstraints2);
        JLabel jLabel5 = new JLabel();
        gridBagConstraints2.gridx = 1;
        jLabel5.setText(new String(this.m_PitInfo.getParams().getPITName()).trim());
        jPanel.add((Component)jLabel5, gridBagConstraints2);
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jLabel6.setText(Resource.getString("PROPERTY_TIME_OF_CREATION", "Time of creation"));
        jPanel.add((Component)jLabel6, gridBagConstraints2);
        MR_TIME_STAMP mR_TIME_STAMP = this.m_PitInfo.getParams().getPITCreationTime();
        StringBuffer stringBuffer = new StringBuffer("<html>");
        if (mR_TIME_STAMP.gethour() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.gethour() + ":");
        } else {
            stringBuffer.append(mR_TIME_STAMP.gethour() + ":");
        }
        if (mR_TIME_STAMP.getmin() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getmin() + ":");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getmin() + ":");
        }
        if (mR_TIME_STAMP.getsec() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getsec() + "</html>");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getsec() + "</html>");
        }
        jLabel7.setText(stringBuffer.toString());
        gridBagConstraints2.gridx = 1;
        jPanel.add((Component)jLabel7, gridBagConstraints2);
        JLabel jLabel8 = new JLabel();
        JLabel jLabel9 = new JLabel();
        jLabel8.setText(Resource.getString("STATUS", "Status"));
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)jLabel8, gridBagConstraints2);
        jLabel9.setText(this.getStatus());
        gridBagConstraints2.gridx = 1;
        jPanel.add((Component)jLabel9, gridBagConstraints2);
        JLabel jLabel10 = new JLabel();
        JLabel jLabel11 = new JLabel();
        jLabel10.setText(Resource.getString("STATE", "State"));
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)jLabel10, gridBagConstraints2);
        jLabel11.setText(this.getState());
        gridBagConstraints2.gridx = 1;
        jPanel.add((Component)jLabel11, gridBagConstraints2);
        if (this.m_PitInfo.getState() == 1) {
            jLabel2 = new JLabel();
            jLabel = new JLabel();
            jLabel2.setText(Resource.getString("ROLLBACK_PROGRESS", "RollBack Progress"));
            gridBagConstraints2.gridx = 0;
            ++gridBagConstraints2.gridy;
            jPanel.add((Component)jLabel2, gridBagConstraints2);
            jLabel.setText(this.getProgress() + "");
            gridBagConstraints2.gridx = 2;
            jPanel.add((Component)jLabel, gridBagConstraints2);
        }
        jLabel2 = new JLabel();
        jLabel = new JLabel();
        jLabel2.setText(Resource.getString("CAPACITY_USED", "Capacity Used"));
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        double d = this.m_PitInfo.getCapacityUsed();
        d *= 100.0;
        long l = this.m_allLDSPitInfo.getSnapshotInfo()[0].getParams().getSize();
        l *= (long)(d /= 65535.0);
        jLabel.setText(KernelConstants.getConvertedSize(l /= 100L, this.m_helper.getBlockSize()) + "");
        gridBagConstraints2.gridx = 1;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        if (this.m_oldestPit != 0 || this.isViewOnly || ((SASLogicalDrive)this.m_helper.getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') {
            this.deleteSnapshotButton.setEnabled(false);
        }
        if (!this.isViewButtonEnabledForThisPIT(this.m_PitInfo) || this.isViewOnly || ((SASLogicalDrive)this.m_helper.getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') {
            this.createViewButton.setEnabled(false);
        }
        if (this.m_viewInfo == null || ((SASLogicalDrive)this.m_helper.getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') {
            this.deleteViewButton.setEnabled(false);
        }
        if (this.m_viewInfo != null) {
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.insets = new Insets(5, 15, 5, 15);
            jPanel2.setBorder(BorderFactory.createTitledBorder(new TitledBorder(Resource.getString("LABEL_VIEW_DETAILS", "View Details:"))));
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridwidth = 1;
            this.mainPanel.add((Component)jPanel2, gridBagConstraints);
            if (this.isViewOnly || ((SASLogicalDrive)this.m_helper.getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') {
                this.createViewButton.setEnabled(false);
            }
            JLabel jLabel12 = new JLabel();
            JLabel jLabel13 = new JLabel(Resource.getString("LABEL_VIEW_NAME", "View name"));
            jLabel12.setText(new String(this.m_viewInfo.getParams().getViewName()).trim());
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel13, gridBagConstraints3);
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel12, gridBagConstraints3);
            JLabel jLabel14 = new JLabel();
            JLabel jLabel15 = new JLabel();
            jLabel14.setText(Resource.getString("PROPERTY_TIME_OF_CREATION", "Time of creation"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel14, gridBagConstraints3);
            MR_TIME_STAMP mR_TIME_STAMP2 = this.m_viewInfo.getParams().getViewCreationTime();
            stringBuffer = new StringBuffer("<html>");
            if (mR_TIME_STAMP2.gethour() <= 9) {
                stringBuffer.append("0" + mR_TIME_STAMP2.gethour() + ":");
            } else {
                stringBuffer.append(mR_TIME_STAMP2.gethour() + ":");
            }
            if (mR_TIME_STAMP2.getmin() <= 9) {
                stringBuffer.append("0" + mR_TIME_STAMP2.getmin() + ":");
            } else {
                stringBuffer.append(mR_TIME_STAMP2.getmin() + ":");
            }
            if (mR_TIME_STAMP2.getsec() <= 9) {
                stringBuffer.append("0" + mR_TIME_STAMP2.getsec() + "</html>");
            } else {
                stringBuffer.append(mR_TIME_STAMP2.getsec() + "</html>");
            }
            jLabel15.setText(stringBuffer.toString());
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel15, gridBagConstraints3);
            JLabel jLabel16 = new JLabel();
            JLabel jLabel17 = new JLabel();
            jLabel16.setText(Resource.getString("STATUS", "Status"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel16, gridBagConstraints3);
            jLabel17.setText(this.getViewState());
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel17, gridBagConstraints3);
            JLabel jLabel18 = new JLabel();
            JLabel jLabel19 = new JLabel();
            jLabel18.setText(Resource.getString("SNAP_NAME", "Snapshot Name"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jLabel19.setText(jLabel5.getText());
            gridBagConstraints3.gridx = 1;
            JLabel jLabel20 = new JLabel();
            JLabel jLabel21 = new JLabel();
            jLabel20.setText(Resource.getString("SCD", "Snapshot Creation Date"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            gridBagConstraints3.gridx = 1;
            jLabel21.setText(jLabel7.getText());
            JLabel jLabel22 = new JLabel();
            JLabel jLabel23 = new JLabel();
            jLabel22.setText(Resource.getString("TARGET_ID", "Target ID"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel22, gridBagConstraints3);
            jLabel23.setText(this.m_viewInfo.getParams().getViewTargetId() + "");
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel23, gridBagConstraints3);
            JLabel jLabel24 = new JLabel();
            JLabel jLabel25 = new JLabel();
            jLabel24.setText(Resource.getString("PROPERTY_OS_DISK_NAME", "OS disk name"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel24, gridBagConstraints3);
            String string = " ";
            try {
                string = new String(this.m_helper.getOSDiskName(this.m_viewInfo.getParams().getViewTargetId())).trim() + "";
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null) {
                jLabel25.setText(string);
            } else {
                jLabel25.setText("");
            }
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel25, gridBagConstraints3);
            JLabel jLabel26 = new JLabel();
            JLabel jLabel27 = new JLabel();
            jLabel26.setText(Resource.getString("PROPERTY_ACCESSPOLICY_TEXT", "Access Policy"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel26, gridBagConstraints3);
            if (this.m_viewInfo.getParams().getAccessPolicy() == 0) {
                jLabel27.setText(Resource.getString("LD_ACCESS_RDWRITE", "Read Write"));
            }
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel27, gridBagConstraints3);
            JLabel jLabel28 = new JLabel();
            JLabel jLabel29 = new JLabel();
            jLabel28.setText(Resource.getString("PROPERTY_TOTAL_CAPACITY_TEXT", "Total Capacity"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel28, gridBagConstraints3);
            jLabel29.setText(KernelConstants.getConvertedSize(this.m_viewInfo.getParams().getViewSize()) + "");
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel29, gridBagConstraints3);
            JLabel jLabel30 = new JLabel();
            JLabel jLabel31 = new JLabel();
            jLabel30.setText(Resource.getString("CAPACITY_USED", "Capacity used"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel30, gridBagConstraints3);
            double d2 = this.m_viewInfo.getCapacityUsed();
            d2 *= 100.0;
            d2 /= 65535.0;
            d2 *= (double)this.m_viewInfo.getParams().getViewSize();
            jLabel31.setText(KernelConstants.getConvertedSize(d2 /= 100.0) + "");
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel31, gridBagConstraints3);
            JLabel jLabel32 = new JLabel();
            JLabel jLabel33 = new JLabel();
            jLabel32.setText(Resource.getString("CAPACITY_REMAINING", "Capacity remaining"));
            gridBagConstraints3.gridx = 0;
            ++gridBagConstraints3.gridy;
            jPanel2.add((Component)jLabel32, gridBagConstraints3);
            jLabel33.setText(KernelConstants.getConvertedSize((double)this.m_viewInfo.getParams().getViewSize() - d2) + "");
            gridBagConstraints3.gridx = 1;
            jPanel2.add((Component)jLabel33, gridBagConstraints3);
            if (this.isViewOnly) {
                this.deleteViewButton.setEnabled(false);
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "West");
        this.deleteSnapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer;
                String string = Resource.getString("DELETE_SNAPSHOT_TITLE", "Delete Snapshot");
                if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, (stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DELETE_SNAPSHOT", "<html>You have chosen to delete the Snasphot.All the data <br>related to this Snapshot will be lost.<br><br>Are you sure you want to delete the Snapshot?</html>"))).toString())) {
                    return;
                }
                ((SASLogicalDrive)PitDetailPanel.this.m_helper.getDeviceObject()).deleteSnapshot(PitDetailPanel.this.m_PitInfo.getParams().getPITCreationTime());
            }
        });
        this.createViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new CreateViewDialog(PitDetailPanel.this.m_helper, PitDetailPanel.this.m_PitInfo, PitDetailPanel.this.m_Repository_helper);
            }
        });
        this.deleteViewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringBuffer stringBuffer;
                String string = Resource.getString("DELETE_VIEW_TITLE", "Delete View");
                if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, (stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DELETE_VIEW", "<html>You have chosen to delete the View.All the data <br>related to this view will be lost.<br><br>Are you sure you want to delete the View?</html>"))).toString())) {
                    return;
                }
                ((SASLogicalDrive)PitDetailPanel.this.m_helper.getDeviceObject()).deleteView(PitDetailPanel.this.m_PitInfo.getParams().getPITCreationTime());
            }
        });
    }

    public String getStatus() {
        byte by = this.m_PitInfo.getStatus();
        if (by == 2) {
            return Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
        }
        if (by == 0) {
            return Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
        }
        if (by == 1) {
            return Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
        }
        if (by == 3) {
            return Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        return null;
    }

    public String getState() {
        byte by = this.m_PitInfo.getState();
        StringBuffer stringBuffer = new StringBuffer();
        if (by == 1) {
            stringBuffer.append("Rollback in Progress");
        } else {
            stringBuffer.append("Normal");
        }
        return stringBuffer.toString();
    }

    public float getProgress() {
        return this.m_PitInfo.getProgress().getprogress();
    }

    public MR_LD_VIEW_INFO getViewInfo(MR_LD_PIT_INFO mR_LD_PIT_INFO) {
        this.m_allLDSPitInfo = ((SASLogicalDrive)this.m_helper.getDeviceObject()).getSnapshotInfo((byte)((SASLogicalDrive)this.m_helper.getDeviceObject()).getID());
        MR_LD_VIEW_INFO[] mR_LD_VIEW_INFOArray = this.m_allLDSPitInfo.getSnapshotInfo()[0].getViewInfo();
        if (mR_LD_VIEW_INFOArray == null) {
            return null;
        }
        for (int i = 0; i < mR_LD_VIEW_INFOArray.length; ++i) {
            MR_TIME_STAMP mR_TIME_STAMP = mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime();
            if (!this.isEqual(mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime(), mR_LD_PIT_INFO.getParams().getPITCreationTime())) continue;
            return mR_LD_VIEW_INFOArray[i];
        }
        return null;
    }

    public boolean isViewButtonEnabledForThisPIT(MR_LD_PIT_INFO mR_LD_PIT_INFO) {
        MR_LD_SNAPSHOT_INFO mR_LD_SNAPSHOT_INFO = this.m_allLDSPitInfo.getSnapshotInfo()[0];
        return mR_LD_SNAPSHOT_INFO.getNumViews() == 0;
    }

    public String getViewState() {
        byte by = this.m_viewInfo.getStatus();
        if (by == 2) {
            return Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
        }
        if (by == 0) {
            return Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
        }
        if (by == 1) {
            return Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
        }
        if (by == 3) {
            return Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        return null;
    }

    public boolean isEqual(MR_TIME_STAMP mR_TIME_STAMP, MR_TIME_STAMP mR_TIME_STAMP2) {
        return mR_TIME_STAMP.getyear() == mR_TIME_STAMP2.getyear() && mR_TIME_STAMP.getmonth() == mR_TIME_STAMP2.getmonth() && mR_TIME_STAMP.getday() == mR_TIME_STAMP2.getday() && mR_TIME_STAMP.gethour() == mR_TIME_STAMP2.gethour() && mR_TIME_STAMP.getmin() == mR_TIME_STAMP2.getmin() && mR_TIME_STAMP.getsec() == mR_TIME_STAMP2.getsec();
    }

    public MR_LD_PIT_INFO[] Sort(MR_LD_PIT_INFO[] mR_LD_PIT_INFOArray) {
        for (int i = 1; i < mR_LD_PIT_INFOArray.length; ++i) {
            if (!this.isLesser(mR_LD_PIT_INFOArray[i].getParams().getPITCreationTime(), mR_LD_PIT_INFOArray[i - 1].getParams().getPITCreationTime())) continue;
            MR_LD_PIT_INFO mR_LD_PIT_INFO = mR_LD_PIT_INFOArray[i];
            int n = i;
            do {
                mR_LD_PIT_INFOArray[n] = mR_LD_PIT_INFOArray[n - 1];
            } while (--n > 0 && !this.isLesser(mR_LD_PIT_INFOArray[n - 1].getParams().getPITCreationTime(), mR_LD_PIT_INFO.getParams().getPITCreationTime()));
            mR_LD_PIT_INFOArray[n] = mR_LD_PIT_INFO;
        }
        return mR_LD_PIT_INFOArray;
    }

    public boolean isLesser(MR_TIME_STAMP mR_TIME_STAMP, MR_TIME_STAMP mR_TIME_STAMP2) {
        boolean bl = false;
        if (mR_TIME_STAMP.getyear() < mR_TIME_STAMP2.getyear()) {
            bl = true;
        } else if (mR_TIME_STAMP.getmonth() < mR_TIME_STAMP2.getmonth()) {
            bl = true;
        } else if (mR_TIME_STAMP.getday() < mR_TIME_STAMP2.getday()) {
            bl = true;
        } else if (mR_TIME_STAMP.gethour() < mR_TIME_STAMP2.gethour()) {
            bl = true;
        } else if (mR_TIME_STAMP.getmin() < mR_TIME_STAMP2.getmin()) {
            bl = true;
        } else if (mR_TIME_STAMP.getsec() < mR_TIME_STAMP2.getsec()) {
            bl = true;
        }
        return bl;
    }
}

