/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class SnapshotMissedLDsDetailpanel
extends VivaldiBaseDialog
implements ListSelectionListener,
TableModelListener {
    private AdapterHelper m_adap = null;
    private JButton m_okButton = new JButton();
    private String title = null;
    private JTable scheduleTable = null;
    private VDScheduleTabelModel scheduleTabelModel = null;
    private JRadioButton m_CreatePit = null;
    private JRadioButton m_IgnorePitCreation = null;
    private Vector<LogicalDriveHelper> ldHelpers = null;
    private Vector<Integer> i_nextExec = null;
    private Vector<Short> i_execFreq = null;

    public SnapshotMissedLDsDetailpanel(AdapterHelper adapterHelper) {
        this.m_adap = adapterHelper;
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Resource.getString("SCHEDULE_MISSED_DESC", "The following virtual drives missed one or more scheduled snapshots."));
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)new JLabel(stringBuffer.toString()), gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SELECT_BASE_VD_TEXT", "(V)irtual drives:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        LogicalDriveHelper[] logicalDriveHelperArray = this.m_adap.getLogicalDrives();
        this.ldHelpers = new Vector();
        this.i_nextExec = new Vector();
        this.i_execFreq = new Vector();
        for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
            if (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getSnapshotInformation().getLastSnapSchedMissed() != 1) continue;
            this.ldHelpers.add(logicalDriveHelperArray[i]);
            this.i_nextExec.add(((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getSnapshotInformation().getSchedProp().getNextExec());
            this.i_execFreq.add(((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getSnapshotInformation().getSchedProp().getExecFreq());
        }
        if (this.ldHelpers.size() == 0) {
            return;
        }
        this.scheduleTabelModel = this.ldHelpers.size() != 0 ? new VDScheduleTabelModel(this.ldHelpers, this.i_nextExec, this.i_execFreq) : new VDScheduleTabelModel();
        this.scheduleTabelModel.addTableModelListener(this);
        this.scheduleTable = new JTable(this.scheduleTabelModel);
        this.scheduleTable.setCellSelectionEnabled(false);
        this.scheduleTable.setColumnSelectionAllowed(false);
        this.scheduleTable.setRowSelectionAllowed(true);
        this.scheduleTable.getSelectionModel().addListSelectionListener(this);
        this.scheduleTable.setSelectionMode(0);
        this.scheduleTable.getTableHeader().setReorderingAllowed(false);
        this.scheduleTable.getTableHeader().setResizingAllowed(true);
        this.scheduleTable.setAutoResizeMode(4);
        TableColumn tableColumn = this.scheduleTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(150);
        jLabel.setLabelFor(this.scheduleTable);
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 30, 0, 15);
        JScrollPane jScrollPane = new JScrollPane(this.scheduleTable);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(jScrollPane.getPreferredSize().width, this.scheduleTable.getRowHeight() * 5));
        jLabel.setLabelFor(jScrollPane);
        ButtonGroup buttonGroup = new ButtonGroup();
        stringArray = Resource.getResourceMnemonic(Resource.getString("SNAP_MISSED_CONFIRMATION", "Do you want to take a snapshot now?"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SNAP_MISSED_CONFIRMATION_YES", "(Y)es, take a snapshot now and again at the next scheduled time."));
        this.m_CreatePit = new JRadioButton(stringArray[0], true);
        if (stringArray.length == 2) {
            this.m_CreatePit.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)this.m_CreatePit, gridBagConstraints);
        buttonGroup.add(this.m_CreatePit);
        stringArray = Resource.getResourceMnemonic(Resource.getString("SNAP_MISSED_CONFIRMATION_NO", "(N)o, do not take a snapshot now. Manually take a snapshot later or wait for the next scheduled time."));
        this.m_IgnorePitCreation = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_IgnorePitCreation.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        jPanel.add((Component)this.m_IgnorePitCreation, gridBagConstraints);
        buttonGroup.add(this.m_IgnorePitCreation);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_okButton = new JButton(stringArray[0]);
        this.getRootPane().setDefaultButton(this.m_okButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
        JButton jButton = new JButton(stringArray[0]);
        jPanel2.add(this.m_okButton);
        gridBagConstraints.gridy += 5;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SnapshotMissedLDsDetailpanel.this.warningDialog()) {
                    SnapshotMissedLDsDetailpanel.this.dispose();
                }
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SnapshotMissedLDsDetailpanel.this.m_CreatePit.isSelected()) {
                    for (int i = 0; i < SnapshotMissedLDsDetailpanel.this.ldHelpers.size(); ++i) {
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)SnapshotMissedLDsDetailpanel.this.ldHelpers.get(i)).getDeviceObject();
                        sASLogicalDrive.createSnapshot((byte)1, new String("MISSED_SNAP").getBytes());
                    }
                }
                SnapshotMissedLDsDetailpanel.this.dispose();
            }
        });
        this.add(jPanel);
        this.title = Resource.getString("SCHEDULED_SNAP_DIALOG_TITLE", "Scheduled Snapshot Missed");
        this.setTitle(this.title);
        this.setModal(false);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
    }

    private class VDScheduleTabelModel
    extends AbstractTableModel {
        private Vector<LogicalDriveHelper> m_ldHelpers = new Vector();
        private Vector<Integer> m_nextExec = null;
        private Vector<Short> m_execFreq = null;

        public VDScheduleTabelModel() {
        }

        public VDScheduleTabelModel(Vector<LogicalDriveHelper> vector, Vector<Integer> vector2, Vector<Short> vector3) {
            this.m_ldHelpers = vector;
            this.m_nextExec = vector2;
            this.m_execFreq = vector3;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.m_ldHelpers.size();
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            if (n == 0) {
                string = Resource.getString("TABLE_TEXT_FREQUENCY", "Frequency");
            } else if (n == 1) {
                string = Resource.getString("LAST_SNAP", "Last Snapshot");
            } else if (n == 2) {
                string = Resource.getString("TABLE_TEXT_NEXT_SNAP", "Next Snapshot");
            }
            return string;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            if (n2 == 0) {
                string = this.m_ldHelpers.get(n).getText();
            } else if (n2 == 1) {
                string = KernelConstants.getTimeText(KernelConstants.getTimeStamp(this.m_nextExec.get(n) - this.m_execFreq.get(n) * 60 * 60));
            } else if (n2 == 2) {
                string = KernelConstants.getTimeText(KernelConstants.getTimeStamp(this.m_nextExec.get(n).intValue()));
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

