/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.VivaldiStartupDialog;
import GUI.venus.wizard.DefaultWizardPage;
import GUIHelper.LogicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_SNAPSHOT_SCHEDULE_PROPERTIES;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASLogicalDrive;
import Utils.CustomMsgBox;
import Utils.HelpInterface;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SnapshotPropertySettingsPage
extends DefaultWizardPage
implements HelpInterface {
    private JPanel m_contentPanel = null;
    private JRadioButton autoDeleteOldSnapRadioButton = null;
    private JRadioButton stopSnapRadioButton = null;
    private JCheckBox autoSnapCheckBox = null;

    public SnapshotPropertySettingsPage() {
        this.m_isFinishWizardPage = true;
    }

    @Override
    public JPanel getContentPanel() {
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = null;
        this.m_contentPanel = new JPanel();
        this.m_contentPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(Resource.getString("SET_SNAPSHOT_PROPERTIES_DESC", "<html>Optionally, edit the advanced settings for automatic snapshots.<br><br>When at the snapshot limit:<br></html>"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        gridBagConstraints.anchor = 18;
        this.m_contentPanel.add((Component)jLabel, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("AUTO_DELETE_OLD_SNAP", "(A)utomatically delete the oldest snapshot"));
        this.autoDeleteOldSnapRadioButton = new JRadioButton(stringArray[0], true);
        if (stringArray.length == 2) {
            this.autoDeleteOldSnapRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.m_contentPanel.add((Component)this.autoDeleteOldSnapRadioButton, gridBagConstraints);
        buttonGroup.add(this.autoDeleteOldSnapRadioButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("STOP_SNAP", "St(o)p taking snapshots"));
        this.stopSnapRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.stopSnapRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.m_contentPanel.add((Component)this.stopSnapRadioButton, gridBagConstraints);
        buttonGroup.add(this.stopSnapRadioButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("AUTO_SNAP_ON_REBOOT", "(T)ake a snapshot on every reboot(recommended for boot virtual drives)"));
        this.autoSnapCheckBox = new JCheckBox(stringArray[0]);
        gridBagConstraints.gridy += 2;
        if (stringArray.length == 2) {
            this.autoSnapCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.m_contentPanel.add((Component)this.autoSnapCheckBox, gridBagConstraints);
        JLabel jLabel2 = new JLabel("");
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(130, 130, 130, 10);
        this.m_contentPanel.add((Component)jLabel2, gridBagConstraints);
        return this.m_contentPanel;
    }

    @Override
    public String getPageID() {
        return "SnapshotPropertySettingsPage";
    }

    @Override
    public String getTitle() {
        return Resource.getString("ENABLE_SNAPSHOT_TITLE", "Enable Snapshots");
    }

    @Override
    public void onNext() {
        this.enableSnapshot();
    }

    public void enableSchedule() {
        MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
        long l = (Long)this.m_hmWizardData.get("timeMilliSecs");
        int n = (Integer)this.m_hmWizardData.get("frequency");
        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec((int)l);
        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq((short)n);
        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)this.m_hmWizardData.get("LogicalDriveHelper")).getDeviceObject();
        sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
    }

    public void enableSnapshot() {
        boolean bl;
        StringBuffer stringBuffer;
        double d = (Double)this.m_hmWizardData.get("requiredSize");
        System.out.println("Size in Blocks 1 " + d);
        LogicalDriveHelper logicalDriveHelper = (LogicalDriveHelper)this.m_hmWizardData.get("chosenRepository");
        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)this.m_hmWizardData.get("LogicalDriveHelper")).getDeviceObject();
        SASLogicalDrive sASLogicalDrive2 = (SASLogicalDrive)logicalDriveHelper.getDeviceObject();
        if (sASLogicalDrive2.getInformation().getsnapshotRepository() == 1) {
            stringBuffer = new StringBuffer(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_REP", "<html>Once you enable snapshots on this virtual drive, you cannot change<br>the allocated capacity or the snapshot repository without<br>first disabling snapshots and losing any snapshot data.<br><br>Are you sure you want to enable snapshots on Virtual Drive:"));
            stringBuffer.append(sASLogicalDrive.getID() + " " + sASLogicalDrive.getName() + " ? </html>");
            if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_ENABLE_SNAPSHOT_TITLE", "Confirm Enable Snapshots"), stringBuffer.toString())) {
                return;
            }
        } else {
            stringBuffer = new StringBuffer(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_NON_REP", "<html>Once you enable snapshots on this virtual drive, you cannot change<br>the allocated capacity or the snapshot repository without<br>first disabling snapshots and losing any snapshot data.<br><br>Are you sure you want to enable snapshots on Virtual Drive:"));
            stringBuffer.append(Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive2.getID() + " " + sASLogicalDrive2.getName() + " ");
            stringBuffer.append(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_NON_REP_CONT1", "will become a snapshot repository.<br>It should now only be used for storing snapshot-related data. If there<br>is any existing data on"));
            stringBuffer.append(" " + Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive2.getID() + " " + sASLogicalDrive2.getName() + " ");
            stringBuffer.append(Resource.getString("CONFIRM_ENABLE_SNAPSHOT_NON_REP_CONT2", "it will be lost.<br><br> Are you sure you want to enable snapshots on"));
            stringBuffer.append(" " + Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive.getID() + " " + sASLogicalDrive.getName() + " ? </html>");
            if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_ENABLE_SNAPSHOT_TITLE", "Confirm Enable Snapshots"), stringBuffer.toString())) {
                return;
            }
        }
        boolean bl2 = false;
        if (this.autoSnapCheckBox.isSelected()) {
            bl2 = true;
        }
        if (bl = sASLogicalDrive.enableSnapshot((long)d, (byte)sASLogicalDrive.getID(), (byte)sASLogicalDrive2.getID(), bl2)) {
            this.setSnapProp();
            boolean bl3 = (Boolean)this.m_hmWizardData.get("noSchedule");
            if (!bl3) {
                this.enableSchedule();
            }
        }
        this.dispose();
    }

    public void setSnapProp() {
        OperationDetails operationDetails = new OperationDetails(2, null);
        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)((LogicalDriveHelper)this.m_hmWizardData.get("LogicalDriveHelper")).getDeviceObject();
        MR_LD_PROPERTIES mR_LD_PROPERTIES = sASLogicalDrive.getInformation().getldConfig().getproperties();
        if (this.autoSnapCheckBox.isSelected()) {
            mR_LD_PROPERTIES.setautoSnapshot((byte)1);
        } else {
            mR_LD_PROPERTIES.setautoSnapshot((byte)0);
        }
        if (this.autoDeleteOldSnapRadioButton.isSelected()) {
            mR_LD_PROPERTIES.setdisableAutoDeleteOldestPIT((byte)0);
        } else {
            mR_LD_PROPERTIES.setdisableAutoDeleteOldestPIT((byte)1);
        }
        operationDetails.setParameter(mR_LD_PROPERTIES);
        try {
            sASLogicalDrive.fireOperation(operationDetails);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dispose();
    }
}

