/*
 * Decompiled with CFR 0.152.
 */
package Snapshot;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.LogicalDriveHelper;
import KernelServices.NotifyObject;
import SASKernel.LibraryAPI.StoreLib.MR_EVT_DETAIL;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PIT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_ALL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_SNAPSHOT_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_LD_VIEW_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_SNAPSHOT_SCHEDULE_PROPERTIES;
import SASKernel.LibraryAPI.StoreLib.MR_TIME_STAMP;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import Services.KernelConstants;
import Snapshot.CreateViewDialog;
import Snapshot.EditSchedulePanel;
import Snapshot.SetSnapshotPropertiesPanel;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContext;
import Utils.HelpContextResourse;
import Utils.Resource;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class SnapshotsDetailPanel
extends VivaldiBaseDialog
implements Observer {
    private LogicalDriveHelper m_helper = null;
    private MR_LD_SNAPSHOT_INFO m_snapshotInfo = null;
    private MR_LD_PIT_INFO[] m_allPitInfo = null;
    private MR_LD_SNAPSHOT_ALL_INFO m_allLDSPitInfo = null;
    private JPanel mainPanel = null;
    private boolean isViewOnly = false;
    private MR_LD_PROPERTIES ldProp = null;
    private JTable manageTable = new JTable();
    public static boolean isWindows = false;
    JLabel descriptionLabel = null;
    GridBagConstraints gbc = new GridBagConstraints();
    private JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 10, 10));
    private JButton deleteSnapButton = null;
    private JButton createSnapButton = null;
    private JButton editSnapScheduleButton = null;
    private JButton createViewButton = null;
    private JButton deleteViewButton = null;
    private DefaultTableModel tableModel = null;
    public TableRowSorter tableSorter = null;
    private JPanel viewPanel = new JPanel();
    private JTextField snapshotNameTextField = new JTextField(16);
    private MR_LD_VIEW_INFO m_viewInfo = null;
    private JPanel viewSubPanel = null;
    private JButton closeButton = new JButton();
    private JButton helpButton = new JButton();
    private String m_strHelpPage = "MR_MANAGE_SNAPSHOTS";
    Vector<LogicalDriveHelper> lds = new Vector();
    int scheduleFreq;
    int nextSchedule;
    private JButton pauseButton = null;
    private JLabel l_nextSnapInfo = null;
    private JButton m_deleteScheduleButton = null;
    private String m_strHelpFileName = "MR_MANAGE_SNAPSHOTS";

    public SnapshotsDetailPanel(LogicalDriveHelper logicalDriveHelper) {
        this.m_helper = logicalDriveHelper;
        this.m_helper.addObserver(this);
        this.isViewOnly = ((AdapterHelper)this.m_helper.getParent()).isViewOnlyMode();
        this.m_allPitInfo = this.getPITInfo();
        this.buildUI();
    }

    public void buildUI() {
        try {
            Object object;
            if (this.mainPanel != null && ((Component[])(object = this.mainPanel.getComponents())).length > 0) {
                this.viewSubPanel.removeAll();
                this.mainPanel.removeAll();
                this.remove(this.mainPanel);
            }
            this.setDefaultCloseOperation(0);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.viewSubPanel = new JPanel(new GridBagLayout());
            object = System.getProperty("os.name");
            if (((String)object).contains("Windows")) {
                isWindows = true;
            }
            if (isWindows) {
                UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
            } else {
                UIManager.setLookAndFeel(UIManager.getInstalledLookAndFeels()[0].getClassName());
            }
            this.gbc.gridy = 0;
            this.gbc.gridx = 0;
            this.gbc.anchor = 18;
            this.gbc.gridwidth = 2;
            String string = Resource.getString("LDRIVE_OPERATION_MANAGE_SNAPSHOT_TITLE", "Manage Snapshots");
            this.descriptionLabel = new JLabel(this.m_helper.getText());
            this.gbc.insets = new Insets(10, 20, 0, 0);
            this.mainPanel.add((Component)this.descriptionLabel, this.gbc);
            this.gbc.gridwidth = 1;
            ++this.gbc.gridy;
            this.gbc.insets = new Insets(10, 20, 0, 0);
            MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp();
            this.l_nextSnapInfo = mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() == 0 ? new JLabel(Resource.getString("NEXT_SNAP_TEXT", "Next snapshot: ") + Resource.getString("NO_SCHED", "None schedule")) : new JLabel(Resource.getString("NEXT_SNAP_TEXT", "Next snapshot: ") + KernelConstants.getTimeText(KernelConstants.getTimeStamp(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec())));
            this.mainPanel.add((Component)this.l_nextSnapInfo, this.gbc);
            String[] stringArray = null;
            this.editSnapScheduleButton = new JButton();
            stringArray = Resource.getResourceMnemonic(Resource.getString("EDIT_SNAPSHOT_SCHEDULE_BUTTON_TEXT", "(E)dit Schedule"));
            this.editSnapScheduleButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.editSnapScheduleButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.editSnapScheduleButton.setToolTipText(Resource.getString("EDIT_SNAPSHOT_SCHEDULE_BUTTON_TEXT", "Edit Schedule"));
            this.gbc.insets = new Insets(10, 10, 0, 15);
            ++this.gbc.gridx;
            this.mainPanel.add((Component)this.editSnapScheduleButton, this.gbc);
            if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState() == 1) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("PAUSE_BUTTON"));
                this.pauseButton = new JButton(stringArray[0]);
                this.pauseButton.setToolTipText(Resource.getString("PAUSE_BUTTON", "(P)ause"));
                if (stringArray.length == 2) {
                    this.pauseButton.setMnemonic(stringArray[1].charAt(0));
                }
            } else {
                stringArray = Resource.getResourceMnemonic(Resource.getString("RESUME_TEXT"));
                this.pauseButton = new JButton(stringArray[0]);
                if (stringArray.length == 2) {
                    this.pauseButton.setMnemonic(stringArray[1].charAt(0));
                }
            }
            ++this.gbc.gridx;
            this.gbc.insets = new Insets(10, 10, 0, 15);
            this.mainPanel.add((Component)this.pauseButton, this.gbc);
            stringArray = Resource.getResourceMnemonic(Resource.getString("DELETE_BUTTON"));
            this.m_deleteScheduleButton = new JButton(stringArray[0]);
            this.m_deleteScheduleButton.setToolTipText(Resource.getString("DELETE_BUTTON", "De(l)ete"));
            if (stringArray.length == 2) {
                this.m_deleteScheduleButton.setMnemonic(stringArray[1].charAt(0));
            }
            ++this.gbc.gridx;
            this.gbc.insets = new Insets(10, 10, 0, 15);
            this.mainPanel.add((Component)this.m_deleteScheduleButton, this.gbc);
            if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() == 0) {
                this.editSnapScheduleButton.setEnabled(false);
                this.pauseButton.setEnabled(false);
                this.m_deleteScheduleButton.setEnabled(false);
            }
            this.pauseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp().getState() == 1) {
                        StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT", "All scheduled snapshots for the following virtual drives will be"));
                        stringBuffer.append("\n");
                        stringBuffer.append(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT_CONT_1", " skipped until you choose to resume the schedule."));
                        stringBuffer.append("\n");
                        stringBuffer.append("\n");
                        stringBuffer.append(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT_CONT_2", "Virtual drives:"));
                        stringBuffer.append("\n");
                        stringBuffer.append(" ");
                        stringBuffer.append(SnapshotsDetailPanel.this.m_helper + "\n");
                        stringBuffer.append("\n");
                        stringBuffer.append(Resource.getString("CONFIRM_PAUSE_SCHEDULE_TEXT_CONT_3", "Are you sure that you want to pause the schedule?"));
                        if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_PAUSE_SCHEDULE_TITLE", "Confirm Pause Schedule"), stringBuffer.toString())) {
                            return;
                        }
                        MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec(((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp().getNextExec());
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq((short)0);
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject();
                        sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
                    } else {
                        MR_TIME_STAMP mR_TIME_STAMP = KernelConstants.getTimeStamp(((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp().getNextExec());
                        MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec(((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp().getNextExec());
                        mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq(((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp().getExecFreq());
                        SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject();
                        sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
                        StringBuffer stringBuffer = new StringBuffer(Resource.getString("RESUME_SCHEDULE_TEXT", "The snapshot schedule has been resumed. The next"));
                        stringBuffer.append("\n");
                        stringBuffer.append(Resource.getString("RESUME_SCHEDULE_TEXT_CONT", " scheduled snapshot will occur on"));
                        stringBuffer.append(" " + KernelConstants.getTimeText(mR_TIME_STAMP));
                        JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, stringBuffer.toString(), Resource.getString("SCHEDULE_RESUMED_TITLE", "Snapshot Schedule Resumed"), 1);
                    }
                }
            });
            this.m_deleteScheduleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DELETE_SCHEDULE_TEXT", "Are you sure that you want to delete the selected schedule?"));
                    stringBuffer.append("\n");
                    if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, Resource.getString("CONFIRM_DELETE_SCHEDULE_TITLE", "Confirm Delete Schedule"), stringBuffer.toString())) {
                        return;
                    }
                    MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = new MR_SNAPSHOT_SCHEDULE_PROPERTIES();
                    long l = 0L;
                    boolean bl = false;
                    mR_SNAPSHOT_SCHEDULE_PROPERTIES.setNextExec((int)l);
                    mR_SNAPSHOT_SCHEDULE_PROPERTIES.setExecFreq((short)(bl ? 1 : 0));
                    SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject();
                    sASLogicalDrive.setScheduleProperties(mR_SNAPSHOT_SCHEDULE_PROPERTIES);
                }
            });
            stringArray = Resource.getResourceMnemonic(Resource.getString("MANAGE_SNAPSHOT_TABLE_LABEL", "(S)napshots:"));
            JLabel jLabel = new JLabel(stringArray[0]);
            jLabel.setHorizontalAlignment(2);
            if (stringArray.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            this.tableModel = new DefaultTableModel();
            this.tableSorter = new TableRowSorter<DefaultTableModel>(this.tableModel);
            this.manageTable = new JTable(this.tableModel){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.manageTable.setRowSorter(this.tableSorter);
            stringArray = Resource.getResourceMnemonic(Resource.getString("MANAGE_SNAPSHOT_COLUMN_NAME1_TEXT", "Name"));
            this.tableModel.addColumn(stringArray[0]);
            stringArray = Resource.getResourceMnemonic(Resource.getString("MANAGE_SNAPSHOT_COLUMN_NAME2_TEXT", "Creation time"));
            this.tableModel.addColumn(stringArray[0]);
            stringArray = Resource.getResourceMnemonic(Resource.getString("MANAGE_SNAPSHOT_COLUMN_NAME3_TEXT", "Status"));
            this.tableModel.addColumn(stringArray[0]);
            stringArray = Resource.getResourceMnemonic(Resource.getString("MANAGE_SNAPSHOT_COLUMN_NAME4_TEXT", "Capacity used"));
            this.tableModel.addColumn(stringArray[0]);
            int n = 0;
            ManageSnapshotCellRenderer manageSnapshotCellRenderer = new ManageSnapshotCellRenderer();
            TableColumn tableColumn = this.manageTable.getColumnModel().getColumn(n);
            tableColumn.setCellRenderer(manageSnapshotCellRenderer);
            this.manageTable.setSelectionMode(0);
            this.manageTable.setAutoResizeMode(0);
            this.manageTable.setAutoscrolls(true);
            this.manageTable.setOpaque(true);
            SelectionListener selectionListener = new SelectionListener(this.manageTable);
            this.manageTable.getSelectionModel().addListSelectionListener(selectionListener);
            this.manageTable.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
            JScrollPane jScrollPane = new JScrollPane(this.manageTable, 20, 30);
            JPanel jPanel = new JPanel();
            int n2 = MainFrame.SCREEN_SIZE.height > 700 ? 100 : 150;
            int n3 = MainFrame.SCREEN_SIZE.width > 1000 ? 450 : 480;
            int n4 = n3 / 10;
            this.manageTable.getColumnModel().getColumn(0).setPreferredWidth(2 * n4);
            this.manageTable.getColumnModel().getColumn(1).setPreferredWidth(3 * n4);
            this.manageTable.getColumnModel().getColumn(2).setPreferredWidth(3 * n4);
            this.manageTable.getColumnModel().getColumn(3).setPreferredWidth(2 * n4);
            jLabel.setLabelFor(jPanel);
            ++this.gbc.gridy;
            this.gbc.gridx = 0;
            this.gbc.gridwidth = 1;
            this.gbc.insets = new Insets(0, 20, 0, 0);
            this.mainPanel.add((Component)jLabel, this.gbc);
            jPanel.add(jScrollPane);
            jScrollPane.setPreferredSize(new Dimension(n3, n2));
            this.ldProp = ((SASLogicalDrive)this.m_helper.getDeviceObject()).getInformation().getldConfig().getproperties();
            ++this.gbc.gridy;
            this.gbc.gridx = 0;
            this.gbc.gridheight = 6;
            this.gbc.insets = new Insets(0, 10, 10, 10);
            this.gbc.gridwidth = 8;
            this.mainPanel.add((Component)jPanel, this.gbc);
            this.deleteSnapButton = new JButton();
            stringArray = Resource.getResourceMnemonic(Resource.getString("DELETE_SNAPSHOT_BUTTON_TEXT", "(D)elete Snapshot"));
            this.deleteSnapButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.deleteSnapButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.deleteSnapButton.setToolTipText(Resource.getString("DELETE_SNAPSHOT_BUTTON_TEXT", "Delete Snapshot"));
            this.deleteSnapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SnapshotsDetailPanel.this.manageTable.getSelectedRow();
                    if (n == -1) {
                        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
                        JOptionPane.showMessageDialog(null, Resource.getString("SELECT_SNAPSHOT_TEXT", "Please select a Snapshot from the Snapshots List."), Resource.getString("LDRIVE_OPERATION_MANAGE_SNAPSHOT_TITLE"), 0, icon);
                        return;
                    }
                    String string = Resource.getString("DELETE_SNAPSHOT_TITLE", "Delete Snapshot");
                    MR_LD_PIT_INFO mR_LD_PIT_INFO = (MR_LD_PIT_INFO)SnapshotsDetailPanel.this.manageTable.getValueAt(n, 0);
                    if (mR_LD_PIT_INFO.equals(SnapshotsDetailPanel.this.m_snapshotInfo.getLdPitInfo()[0])) {
                        StringBuffer stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DELETE_SNAPSHOT", "<html>You have chosen to delete the Snasphot.All the data <br>related to this Snapshot will be lost.<br><br>Are you sure you want to delete the Snapshot?</html>"));
                        if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, stringBuffer.toString())) {
                            return;
                        }
                        ((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).deleteSnapshot(mR_LD_PIT_INFO.getParams().getPITCreationTime());
                    } else {
                        String string2 = Resource.getString("CANNOT_DELETE_SNAPSHOT_TEXT", "is not the oldest snapshot. Before you can delete<br>this snapshot, you must first delete all older snapshots.<br></html>");
                        String string3 = "<html>" + new String(mR_LD_PIT_INFO.getParams().getPITName()).trim().toString() + " " + string2;
                        new CustomMsgBox((Component)VivaldiStartupDialog.mainScreen, (Object)string3, string);
                    }
                }
            });
            this.buttonsPanel.add(this.deleteSnapButton);
            stringArray = Resource.getResourceMnemonic(Resource.getString("CREATE_SNAPSHOT_BUTTON_TEXT", "C(r)eate Snapshot"));
            this.createSnapButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.createSnapButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.createSnapButton.setToolTipText(Resource.getString("CREATE_SNAPSHOT_BUTTON_TEXT", "Create Snapshot"));
            this.buttonsPanel.add(this.createSnapButton);
            this.createSnapButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (SnapshotsDetailPanel.this.m_allPitInfo.length == 8 && SnapshotsDetailPanel.this.ldProp.getdisableAutoDeleteOldestPIT() == 1) {
                        String string = Resource.getString("CANNOT_CREATE_SNAPSHOT_TITLE", "Cannot Create Snapshot");
                        String string2 = Resource.getString("CANNOT_CREATE_SNAPSHOT_TEXT", "Max Snapshot limitation has been exceeded");
                        new CustomMsgBox((Component)VivaldiStartupDialog.mainScreen, (Object)string2, string);
                    } else {
                        System.out.println("in createSnapButton addActionListener");
                        new CreateSnapshot();
                    }
                }
            });
            this.editSnapScheduleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SnapshotsDetailPanel.this.lds.removeAllElements();
                    LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)SnapshotsDetailPanel.this.m_helper.getParent()).getLogicalDrives();
                    SnapshotsDetailPanel.this.scheduleFreq = ((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp().getExecFreq();
                    SnapshotsDetailPanel.this.nextSchedule = ((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp().getNextExec();
                    for (int i = 0; i < logicalDriveHelperArray.length; ++i) {
                        if (((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getInformation().getldConfig().getparams().getSnapshotEnabled() != 1 || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getSnapshotInformation().getSchedProp().getNextExec() != SnapshotsDetailPanel.this.nextSchedule || ((SASLogicalDrive)logicalDriveHelperArray[i].getDeviceObject()).getSnapshotInformation().getSchedProp().getExecFreq() != SnapshotsDetailPanel.this.scheduleFreq) continue;
                        SnapshotsDetailPanel.this.lds.add(logicalDriveHelperArray[i]);
                    }
                    new EditSchedulePanel(SnapshotsDetailPanel.this.lds, SnapshotsDetailPanel.this.nextSchedule, SnapshotsDetailPanel.this.scheduleFreq, SnapshotsDetailPanel.this.m_helper, 12);
                }
            });
            this.gbc.gridy = 10;
            this.gbc.gridx = 0;
            this.gbc.gridheight = 5;
            this.gbc.insets = new Insets(0, 10, 10, 10);
            this.gbc.gridwidth = 4;
            this.mainPanel.add((Component)this.buttonsPanel, this.gbc);
            this.gbc.gridy = 20;
            this.gbc.gridx = 0;
            this.gbc.insets = new Insets(0, 10, 10, 0);
            this.gbc.gridwidth = 4;
            this.viewPanel.setPreferredSize(new Dimension(n3, n2));
            JScrollPane jScrollPane2 = new JScrollPane(this.viewSubPanel, 20, 30);
            this.viewSubPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("MANAGE_SNAPSHOT_VIEW_TEXT", "View Details")));
            this.viewPanel.add(jScrollPane2);
            this.mainPanel.add((Component)this.viewPanel, this.gbc);
            jScrollPane2.setPreferredSize(new Dimension(n3 - 10, n2 - 10));
            this.gbc.gridy = 35;
            this.gbc.gridx = 0;
            this.gbc.gridheight = 0;
            this.gbc.insets = new Insets(0, 10, 10, 10);
            this.gbc.anchor = 21;
            this.gbc.gridwidth = 0;
            JPanel jPanel2 = new JPanel(new FlowLayout());
            stringArray = Resource.getResourceMnemonic(Resource.getString("ADVANCED_SNAPSHOT_BUTTON_TEXT", "(A)dvanced"));
            JButton jButton = new JButton(stringArray[0]);
            jPanel2.add(jButton);
            if (stringArray.length == 2) {
                jButton.setMnemonic(stringArray[1].charAt(0));
            }
            jButton.setToolTipText(Resource.getString("ADVANCED_SNAPSHOT_BUTTON_TEXT", "Advanced"));
            this.mainPanel.add((Component)jPanel2, this.gbc);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    new SetSnapshotPropertiesPanel(SnapshotsDetailPanel.this.m_helper);
                }
            });
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_DELETE_VIEW", "Delete View"));
            this.deleteViewButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.deleteViewButton.setMnemonic(stringArray[1].charAt(0));
            }
            if (this.ldProp.getdisableAutoDeleteOldestPIT() == 1 && this.m_allPitInfo.length == 8) {
                this.createSnapButton.setEnabled(false);
            } else if (this.m_allPitInfo.length <= 0) {
                this.deleteSnapButton.setEnabled(false);
            }
            for (MR_LD_PIT_INFO mR_LD_PIT_INFO : this.m_allPitInfo) {
                MR_TIME_STAMP mR_TIME_STAMP = mR_LD_PIT_INFO.getParams().getPITCreationTime();
                StringBuffer stringBuffer = this.getTimeStamp(mR_TIME_STAMP);
                String string2 = "";
                String string3 = this.getStatus(mR_LD_PIT_INFO);
                String string4 = "";
                string2 = mR_LD_PIT_INFO.getState() == 1 ? string3 + "(" + Resource.getString("ROLLBACK_TEXT", "Rolling back") + ")" : string3;
                double d = mR_LD_PIT_INFO.getCapacityUsed();
                d *= 100.0;
                long l = this.m_allLDSPitInfo.getSnapshotInfo()[0].getParams().getSize();
                l *= (long)(d /= 65535.0);
                String string5 = KernelConstants.getConvertedSize(l /= 100L, this.m_helper.getBlockSize()) + "";
                this.tableModel.insertRow(0, new Object[]{mR_LD_PIT_INFO, stringBuffer.toString(), string2, string5});
            }
            if (this.m_allPitInfo.length > 0) {
                this.manageTable.changeSelection(0, 0, false, false);
            }
            this.gbc.gridy = 45;
            this.gbc.gridx = 0;
            this.gbc.gridheight = 5;
            this.gbc.insets = new Insets(0, 2, 10, 0);
            this.gbc.gridwidth = 10;
            this.gbc.anchor = 10;
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 10, 10));
            stringArray = Resource.getResourceMnemonic(Resource.getString("CLOSE_SNAPSHOT_BUTTON_TEXT", "(C)lose"));
            this.closeButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.closeButton.setMnemonic(stringArray[1].charAt(0));
            }
            this.getRootPane().setDefaultButton(this.closeButton);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SnapshotsDetailPanel.this.windowClosingOption();
                }
            });
            stringArray = Resource.getResourceMnemonic(Resource.getString("HELP_SNAPSHOT_BUTTON_TEXT", "(H)elp"));
            this.helpButton = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.helpButton.setMnemonic(stringArray[1].charAt(0));
            }
            jPanel3.add(this.closeButton);
            jPanel3.add(this.helpButton);
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HelpContext.executeHelpProcess(SnapshotsDetailPanel.this.getHelpPage());
                }
            });
            this.mainPanel.add((Component)jPanel3, this.gbc);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    SnapshotsDetailPanel.this.windowClosingOption();
                }
            });
            this.deleteViewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuffer stringBuffer;
                    String string = Resource.getString("DELETE_VIEW_TITLE", "Delete View");
                    if (!CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, string, (stringBuffer = new StringBuffer(Resource.getString("CONFIRM_DELETE_VIEW", "<html>You have chosen to delete the View.All the data <br>related to this view will be lost.<br><br>Are you sure you want to delete the View?</html>"))).toString())) {
                        return;
                    }
                    int n = SnapshotsDetailPanel.this.manageTable.getSelectedRow();
                    MR_LD_PIT_INFO mR_LD_PIT_INFO = (MR_LD_PIT_INFO)SnapshotsDetailPanel.this.manageTable.getValueAt(n, 0);
                    ((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).deleteView(mR_LD_PIT_INFO.getParams().getPITCreationTime());
                }
            });
            this.add((Component)this.mainPanel, "West");
            this.setTitle(string);
            this.setModal(true);
            this.setResizable(false);
            this.pack();
            GUIUtils.centerDialogOnScreen(this);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void helpPage() {
        HelpContext.executeHelpProcess(HelpContextResourse.getHelpPageName(this.m_strHelpPage));
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName(this.m_strHelpPage);
    }

    private void windowClosingOption() {
        if (JOptionPane.showConfirmDialog(this.getContentPane(), Resource.getString("POPUP_EXIT_CONFIRMATION", "Are you sure you want to exit?"), Resource.getString("POPUP_NOTIFICATION_TITLE", "Event Notification Application"), 0) == 0) {
            this.m_helper.deleteObserver(this);
            this.dispose();
        }
    }

    public MR_LD_PIT_INFO[] getPITInfo() {
        this.m_allLDSPitInfo = ((SASLogicalDrive)this.m_helper.getDeviceObject()).getSnapshotInfo((byte)((SASLogicalDrive)this.m_helper.getDeviceObject()).getID());
        MR_LD_PIT_INFO[] mR_LD_PIT_INFOArray = null;
        if (this.m_allLDSPitInfo != null) {
            for (byte by = 0; by < this.m_allLDSPitInfo.getNumVDs(); by = (byte)(by + 1)) {
                if (this.m_allLDSPitInfo.getSnapshotInfo()[by].getSourceTargetId() != (byte)((SASLogicalDrive)this.m_helper.getDeviceObject()).getID()) continue;
                this.m_snapshotInfo = this.m_allLDSPitInfo.getSnapshotInfo()[by];
                return this.m_snapshotInfo.getLdPitInfo();
            }
        }
        if (mR_LD_PIT_INFOArray == null) {
            return null;
        }
        return mR_LD_PIT_INFOArray;
    }

    public boolean isViewPresentOnThisPit(MR_LD_PIT_INFO mR_LD_PIT_INFO) {
        MR_LD_VIEW_INFO[] mR_LD_VIEW_INFOArray = this.m_snapshotInfo.getViewInfo();
        if (mR_LD_VIEW_INFOArray == null) {
            return false;
        }
        for (int i = 0; i < mR_LD_VIEW_INFOArray.length; ++i) {
            MR_TIME_STAMP mR_TIME_STAMP = mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime();
            if (!this.isEqual(mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime(), mR_LD_PIT_INFO.getParams().getPITCreationTime())) continue;
            return true;
        }
        return false;
    }

    public boolean isEqual(MR_TIME_STAMP mR_TIME_STAMP, MR_TIME_STAMP mR_TIME_STAMP2) {
        return mR_TIME_STAMP.getyear() == mR_TIME_STAMP2.getyear() && mR_TIME_STAMP.getmonth() == mR_TIME_STAMP2.getmonth() && mR_TIME_STAMP.getday() == mR_TIME_STAMP2.getday() && mR_TIME_STAMP.gethour() == mR_TIME_STAMP2.gethour() && mR_TIME_STAMP.getmin() == mR_TIME_STAMP2.getmin() && mR_TIME_STAMP.getsec() == mR_TIME_STAMP2.getsec();
    }

    public MR_LD_PIT_INFO[] Sort(MR_LD_PIT_INFO[] mR_LD_PIT_INFOArray) {
        for (int i = 1; i < mR_LD_PIT_INFOArray.length; ++i) {
            MR_LD_PIT_INFO mR_LD_PIT_INFO = mR_LD_PIT_INFOArray[i];
            for (int j = i; j > 0 && !this.isLesser(mR_LD_PIT_INFOArray[j - 1].getParams().getPITCreationTime(), mR_LD_PIT_INFO.getParams().getPITCreationTime()); --j) {
                mR_LD_PIT_INFOArray[j] = mR_LD_PIT_INFOArray[j - 1];
            }
            mR_LD_PIT_INFOArray[j] = mR_LD_PIT_INFO;
        }
        return mR_LD_PIT_INFOArray;
    }

    public boolean isLesser(MR_TIME_STAMP mR_TIME_STAMP, MR_TIME_STAMP mR_TIME_STAMP2) {
        boolean bl = false;
        if (mR_TIME_STAMP.getyear() < mR_TIME_STAMP2.getyear()) {
            bl = true;
        } else if (mR_TIME_STAMP.getmonth() < mR_TIME_STAMP2.getmonth()) {
            bl = true;
        } else if (mR_TIME_STAMP.getday() < mR_TIME_STAMP2.getday()) {
            bl = true;
        } else if (mR_TIME_STAMP.gethour() < mR_TIME_STAMP2.gethour()) {
            bl = true;
        } else if (mR_TIME_STAMP.getmin() < mR_TIME_STAMP2.getmin()) {
            bl = true;
        } else if (mR_TIME_STAMP.getsec() < mR_TIME_STAMP2.getsec()) {
            bl = true;
        }
        return bl;
    }

    public String getStatus(MR_LD_PIT_INFO mR_LD_PIT_INFO) {
        byte by = mR_LD_PIT_INFO.getStatus();
        if (by == 2) {
            return Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
        }
        if (by == 0) {
            return Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
        }
        if (by == 1) {
            return Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
        }
        if (by == 3) {
            return Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        return null;
    }

    public float getProgress(MR_LD_PIT_INFO mR_LD_PIT_INFO) {
        return mR_LD_PIT_INFO.getProgress().getprogress();
    }

    public void updateViewPanel() {
        this.viewSubPanel.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel();
        this.viewSubPanel.removeAll();
        JLabel jLabel2 = new JLabel();
        if (this.manageTable.getRowCount() > 0) {
            int n = this.manageTable.getSelectedRow();
            if (this.manageTable.getRowCount() == 1) {
                n = 0;
            }
            if (n >= 0) {
                MR_LD_PIT_INFO mR_LD_PIT_INFO = (MR_LD_PIT_INFO)this.manageTable.getValueAt(n, 0);
                this.m_viewInfo = this.getViewInfo(mR_LD_PIT_INFO);
                if (this.m_viewInfo != null) {
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = 0;
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.insets = new Insets(5, 10, 5, 5);
                    JLabel jLabel3 = new JLabel();
                    JLabel jLabel4 = new JLabel(Resource.getString("LABEL_VIEW_NAME", "View name"));
                    jLabel3.setText(new String(this.m_viewInfo.getParams().getViewName()).trim());
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel4, gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel3, gridBagConstraints);
                    JLabel jLabel5 = new JLabel();
                    JLabel jLabel6 = new JLabel();
                    jLabel5.setText(Resource.getString("PROPERTY_TIME_OF_CREATION", "Time of creation"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel5, gridBagConstraints);
                    MR_TIME_STAMP mR_TIME_STAMP = this.m_viewInfo.getParams().getViewCreationTime();
                    StringBuffer stringBuffer = this.getTimeStamp(mR_TIME_STAMP);
                    jLabel6.setText(stringBuffer.toString());
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel6, gridBagConstraints);
                    JLabel jLabel7 = new JLabel();
                    JLabel jLabel8 = new JLabel();
                    jLabel7.setText(Resource.getString("STATUS", "Status"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel7, gridBagConstraints);
                    jLabel8.setText(this.getViewState(this.m_viewInfo));
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel8, gridBagConstraints);
                    JLabel jLabel9 = new JLabel();
                    JLabel jLabel10 = new JLabel();
                    jLabel9.setText(Resource.getString("SNAP_NAME", "Snapshot Name"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    jLabel10.setText(jLabel2.getText());
                    gridBagConstraints.gridx = 1;
                    JLabel jLabel11 = new JLabel();
                    JLabel jLabel12 = new JLabel();
                    jLabel11.setText(Resource.getString("SCD", "Snapshot Creation Date"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    gridBagConstraints.gridx = 1;
                    jLabel12.setText(jLabel.getText());
                    JLabel jLabel13 = new JLabel();
                    JLabel jLabel14 = new JLabel();
                    jLabel13.setText(Resource.getString("TARGET_ID", "Target ID"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel13, gridBagConstraints);
                    jLabel14.setText(this.m_viewInfo.getParams().getViewTargetId() + "");
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel14, gridBagConstraints);
                    JLabel jLabel15 = new JLabel();
                    JLabel jLabel16 = new JLabel();
                    jLabel15.setText(Resource.getString("PROPERTY_OS_DISK_NAME", "OS disk name"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel15, gridBagConstraints);
                    String string = " ";
                    try {
                        string = new String(this.m_helper.getOSDiskName(this.m_viewInfo.getParams().getViewTargetId())).trim() + "";
                    }
                    catch (Exception exception) {
                        string = null;
                    }
                    if (string != null) {
                        jLabel16.setText(string);
                    } else {
                        jLabel16.setText("");
                    }
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel16, gridBagConstraints);
                    JLabel jLabel17 = new JLabel();
                    JLabel jLabel18 = new JLabel();
                    jLabel17.setText(Resource.getString("PROPERTY_ACCESSPOLICY_TEXT", "Access Policy"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel17, gridBagConstraints);
                    if (this.m_viewInfo.getParams().getAccessPolicy() == 0) {
                        jLabel18.setText(Resource.getString("LD_ACCESS_RDWRITE", "Read Write"));
                    }
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel18, gridBagConstraints);
                    JLabel jLabel19 = new JLabel();
                    JLabel jLabel20 = new JLabel();
                    jLabel19.setText(Resource.getString("PROPERTY_TOTAL_CAPACITY_TEXT", "Total Capacity"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel19, gridBagConstraints);
                    jLabel20.setText(KernelConstants.getConvertedSize(this.m_viewInfo.getParams().getViewSize(), this.m_helper.getBlockSize()) + "");
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel20, gridBagConstraints);
                    JLabel jLabel21 = new JLabel();
                    JLabel jLabel22 = new JLabel();
                    jLabel21.setText(Resource.getString("CAPACITY_USED", "Capacity used"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel21, gridBagConstraints);
                    double d = this.m_viewInfo.getCapacityUsed();
                    d *= 100.0;
                    d /= 65535.0;
                    d *= (double)this.m_viewInfo.getParams().getViewSize();
                    jLabel22.setText(KernelConstants.getConvertedSize(d /= 100.0, this.m_helper.getBlockSize()) + "");
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel22, gridBagConstraints);
                    JLabel jLabel23 = new JLabel();
                    JLabel jLabel24 = new JLabel();
                    jLabel23.setText(Resource.getString("CAPACITY_REMAINING", "Capacity remaining"));
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)jLabel23, gridBagConstraints);
                    jLabel24.setText(KernelConstants.getConvertedSize((double)this.m_viewInfo.getParams().getViewSize() - d, this.m_helper.getBlockSize()) + "");
                    gridBagConstraints.gridx = 1;
                    this.viewSubPanel.add((Component)jLabel24, gridBagConstraints);
                    if (this.isViewOnly) {
                        this.deleteViewButton.setEnabled(false);
                    }
                    ++gridBagConstraints.gridy;
                    this.viewSubPanel.add((Component)this.deleteViewButton, gridBagConstraints);
                } else {
                    String string = this.getViewInfoForAllPits();
                    String[] stringArray = Resource.getResourceMnemonic(Resource.getString("CREATE_VIEW_TEXT", "Create View"));
                    this.createViewButton = new JButton(stringArray[0]);
                    if (stringArray.length == 2) {
                        this.createViewButton.setMnemonic(stringArray[1].charAt(0));
                    }
                    if (string == null || string.equals("")) {
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 0;
                        JLabel jLabel25 = new JLabel();
                        String string2 = Resource.getString("NO_VIEW_LABEL_TEXT", "There is no view for") + " " + new String(mR_LD_PIT_INFO.getParams().getPITName()).trim().toString();
                        jLabel25.setText(string2);
                        this.viewSubPanel.add((Component)jLabel25, gridBagConstraints);
                        ++gridBagConstraints.gridy;
                        this.viewSubPanel.add((Component)this.createViewButton, gridBagConstraints);
                        if (this.isViewOnly || ((SASLogicalDrive)this.m_helper.getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') {
                            this.createViewButton.setEnabled(false);
                        } else if (!this.isViewOnly && ((SASLogicalDrive)this.m_helper.getDeviceObject()).getInformation().getldConfig().getparams().getstate() == '\u0000') {
                            this.createViewButton.setEnabled(true);
                        }
                        if (((SASLogicalDrive)this.m_helper.getDeviceObject()).getSnapshotInformation().getNumViews() == 0) {
                            this.createViewButton.setEnabled(true);
                        } else {
                            this.createViewButton.setEnabled(false);
                        }
                    } else {
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridy = 0;
                        JLabel jLabel26 = new JLabel();
                        String string3 = Resource.getString("NO_VIEW_LABEL_TEXT", "There is no view for") + " " + new String(mR_LD_PIT_INFO.getParams().getPITName()).trim().toString();
                        jLabel26.setText(string3);
                        this.viewSubPanel.add((Component)jLabel26, gridBagConstraints);
                        ++gridBagConstraints.gridy;
                        JLabel jLabel27 = new JLabel();
                        String string4 = Resource.getString("DELETE_VIEW_LABEL_TEXT", "There is no view for") + " " + string;
                        jLabel27.setText(string4);
                        this.viewSubPanel.add((Component)jLabel27, gridBagConstraints);
                        ++gridBagConstraints.gridy;
                        this.viewSubPanel.add((Component)this.createViewButton, gridBagConstraints);
                        this.createViewButton.setEnabled(false);
                    }
                    this.createViewButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = SnapshotsDetailPanel.this.manageTable.getSelectedRow();
                            if (n == -1) {
                                Icon icon = UIManager.getIcon("OptionPane.warningIcon");
                                JOptionPane.showMessageDialog(null, Resource.getString("SELECT_SNAPSHOT_TEXT", "Please select a Snapshot from the Snapshots List."), Resource.getString("LDRIVE_OPERATION_MANAGE_SNAPSHOT_TITLE"), 0, icon);
                                return;
                            }
                            MR_LD_PIT_INFO mR_LD_PIT_INFO = (MR_LD_PIT_INFO)SnapshotsDetailPanel.this.manageTable.getValueAt(n, 0);
                            new CreateViewDialog(SnapshotsDetailPanel.this.m_helper, mR_LD_PIT_INFO, SnapshotsDetailPanel.this.getRepository());
                        }
                    });
                }
            }
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        } else {
            this.viewPanel.revalidate();
            this.viewPanel.repaint();
        }
    }

    public String getViewState(MR_LD_VIEW_INFO mR_LD_VIEW_INFO) {
        byte by = mR_LD_VIEW_INFO.getStatus();
        if (by == 2) {
            return Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
        }
        if (by == 0) {
            return Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
        }
        if (by == 1) {
            return Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
        }
        if (by == 3) {
            return Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        return null;
    }

    public MR_LD_VIEW_INFO getViewInfo(MR_LD_PIT_INFO mR_LD_PIT_INFO) {
        this.m_allLDSPitInfo = ((SASLogicalDrive)this.m_helper.getDeviceObject()).getSnapshotInfo((byte)((SASLogicalDrive)this.m_helper.getDeviceObject()).getID());
        MR_LD_VIEW_INFO[] mR_LD_VIEW_INFOArray = this.m_allLDSPitInfo.getSnapshotInfo()[0].getViewInfo();
        if (mR_LD_VIEW_INFOArray == null) {
            return null;
        }
        for (int i = 0; i < mR_LD_VIEW_INFOArray.length; ++i) {
            MR_TIME_STAMP mR_TIME_STAMP = mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime();
            if (!this.isEqual(mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime(), mR_LD_PIT_INFO.getParams().getPITCreationTime())) continue;
            return mR_LD_VIEW_INFOArray[i];
        }
        return null;
    }

    public String getViewInfoForAllPits() {
        MR_LD_PIT_INFO[] mR_LD_PIT_INFOArray;
        this.m_allLDSPitInfo = ((SASLogicalDrive)this.m_helper.getDeviceObject()).getSnapshotInfo((byte)((SASLogicalDrive)this.m_helper.getDeviceObject()).getID());
        MR_LD_VIEW_INFO[] mR_LD_VIEW_INFOArray = this.m_allLDSPitInfo.getSnapshotInfo()[0].getViewInfo();
        if (mR_LD_VIEW_INFOArray == null) {
            return null;
        }
        for (MR_LD_PIT_INFO mR_LD_PIT_INFO : mR_LD_PIT_INFOArray = this.getPITInfo()) {
            for (int i = 0; i < mR_LD_VIEW_INFOArray.length; ++i) {
                MR_TIME_STAMP mR_TIME_STAMP = mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime();
                if (!this.isEqual(mR_LD_VIEW_INFOArray[i].getParams().getPITCreationTime(), mR_LD_PIT_INFO.getParams().getPITCreationTime())) continue;
                return new String(mR_LD_PIT_INFO.getParams().getPITName()).trim().toString();
            }
        }
        return null;
    }

    @Override
    public void update(Observable observable, Object object) {
        NotifyObject notifyObject = (NotifyObject)object;
        int n = notifyObject.getNotifyCode() - 0x102000;
        MR_EVT_DETAIL mR_EVT_DETAIL = (MR_EVT_DETAIL)notifyObject.getNotifyObject();
        if (mR_EVT_DETAIL != null) {
            System.out.println("PIT related AEN Received: " + new String(mR_EVT_DETAIL.getdescription()).trim());
        }
        System.out.println("eventCode " + n);
        try {
            switch (n) {
                case 350: {
                    this.deleteRow();
                    this.manageTable.changeSelection(0, 0, false, false);
                    break;
                }
                case 349: {
                    this.addRow();
                    this.manageTable.changeSelection(0, 0, false, false);
                    break;
                }
                case 351: 
                case 352: {
                    this.updateViewPanel();
                    break;
                }
                case 380: 
                case 381: {
                    MR_SNAPSHOT_SCHEDULE_PROPERTIES mR_SNAPSHOT_SCHEDULE_PROPERTIES = ((SASLogicalDrive)this.m_helper.getDeviceObject()).getSnapshotInformation().getSchedProp();
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getExecFreq() == 0) {
                        this.l_nextSnapInfo.setText(Resource.getString("NEXT_SNAP_TEXT", "Next snapshot: ") + Resource.getString("NO_SCHED", "None schedule"));
                        this.editSnapScheduleButton.setEnabled(false);
                        this.pauseButton.setEnabled(false);
                        this.m_deleteScheduleButton.setEnabled(false);
                    } else {
                        this.l_nextSnapInfo.setText(Resource.getString("NEXT_SNAP_TEXT", "Next snapshot: ") + KernelConstants.getTimeText(KernelConstants.getTimeStamp(mR_SNAPSHOT_SCHEDULE_PROPERTIES.getNextExec())));
                        this.m_deleteScheduleButton.setEnabled(true);
                    }
                    String[] stringArray = null;
                    if (mR_SNAPSHOT_SCHEDULE_PROPERTIES.getState() == 1) {
                        stringArray = Resource.getResourceMnemonic(Resource.getString("PAUSE_BUTTON"));
                        this.pauseButton.setText(stringArray[0]);
                        if (stringArray.length == 2) {
                            this.pauseButton.setMnemonic(stringArray[1].charAt(0));
                        }
                    } else {
                        stringArray = Resource.getResourceMnemonic(Resource.getString("RESUME_TEXT"));
                        this.pauseButton.setText(stringArray[0]);
                        if (stringArray.length == 2) {
                            this.pauseButton.setMnemonic(stringArray[1].charAt(0));
                        }
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRow() {
        try {
            this.m_allPitInfo = this.getPITInfo();
            MR_LD_PIT_INFO mR_LD_PIT_INFO = this.m_allPitInfo[this.m_allPitInfo.length - 1];
            MR_TIME_STAMP mR_TIME_STAMP = mR_LD_PIT_INFO.getParams().getPITCreationTime();
            StringBuffer stringBuffer = this.getTimeStamp(mR_TIME_STAMP);
            String string = "";
            String string2 = this.getStatus(mR_LD_PIT_INFO);
            String string3 = "";
            string = mR_LD_PIT_INFO.getState() == 1 ? string2 + "(" + Resource.getString("ROLLBACK_TEXT", "Rolling back") + ")" : string2;
            double d = mR_LD_PIT_INFO.getCapacityUsed();
            d *= 100.0;
            long l = this.m_allLDSPitInfo.getSnapshotInfo()[0].getParams().getSize();
            l *= (long)(d /= 65535.0);
            String string4 = KernelConstants.getConvertedSize(l /= 100L, this.m_helper.getBlockSize()) + "";
            this.tableModel.insertRow(0, new Object[]{mR_LD_PIT_INFO, stringBuffer.toString(), string, string4});
            if (this.m_allPitInfo.length > 0) {
                this.deleteSnapButton.setEnabled(true);
            }
            this.manageTable.revalidate();
            this.manageTable.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deleteRow() {
        this.m_allPitInfo = this.getPITInfo();
        if (this.manageTable.getSelectedRow() != -1) {
            try {
                System.out.println("going to delete row");
                int n = this.manageTable.getRowCount();
                int n2 = n - 1;
                System.out.println("manageTable.getSelectedRow() " + this.manageTable.getSelectedRow());
                System.out.println("rowId " + n2);
                this.tableModel.removeRow(n2);
                this.tableModel.fireTableDataChanged();
                System.out.println("after deleting the row");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.ldProp.getdisableAutoDeleteOldestPIT() == 1 && this.m_allPitInfo.length == 8) {
            this.createSnapButton.setEnabled(false);
        } else if (this.m_allPitInfo.length <= 0) {
            this.deleteSnapButton.setEnabled(false);
        }
        if (this.manageTable.getRowCount() < 8) {
            this.createSnapButton.setEnabled(true);
        }
        this.manageTable.revalidate();
        this.manageTable.repaint();
    }

    public String getDefaultName() {
        MR_TIME_STAMP mR_TIME_STAMP = ((SASAdapter)((SASLogicalDrive)this.m_helper.getDeviceObject()).parent()).getCtrlTime();
        String string = "SNAP_" + mR_TIME_STAMP.gethour() + ":" + mR_TIME_STAMP.getmin() + ":" + mR_TIME_STAMP.getsec();
        return string;
    }

    public LogicalDriveHelper getRepository() {
        if (this.m_allPitInfo == null) {
            return null;
        }
        byte by = this.m_allLDSPitInfo.getSnapshotInfo()[0].getParams().getTargetIDforSnapshot();
        LogicalDriveHelper[] logicalDriveHelperArray = ((AdapterHelper)this.m_helper.getParent()).getLogicalDrives();
        for (int n = 0; n < logicalDriveHelperArray.length; n = (int)((byte)(n + 1))) {
            if (by != ((SASLogicalDrive)logicalDriveHelperArray[n].getDeviceObject()).getID()) continue;
            return logicalDriveHelperArray[n];
        }
        return null;
    }

    public StringBuffer getTimeStamp(MR_TIME_STAMP mR_TIME_STAMP) {
        StringBuffer stringBuffer = new StringBuffer("<html>");
        stringBuffer.append(mR_TIME_STAMP.getyear() + "-");
        if (mR_TIME_STAMP.getmonth() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getmonth() + "-");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getmonth() + "-");
        }
        if (mR_TIME_STAMP.getday() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getday() + " ");
        } else {
            stringBuffer.append(mR_TIME_STAMP.getday() + " ");
        }
        if (mR_TIME_STAMP.gethour() == 0) {
            stringBuffer.append("12:");
        } else {
            float f = mR_TIME_STAMP.gethour() % 12;
            if (f <= 9.0f && f != 0.0f) {
                stringBuffer.append("0" + mR_TIME_STAMP.gethour() % 12 + ":");
            } else {
                stringBuffer.append(mR_TIME_STAMP.gethour() + ":");
            }
        }
        if (mR_TIME_STAMP.getmin() <= 9) {
            stringBuffer.append("0" + mR_TIME_STAMP.getmin());
        } else {
            stringBuffer.append(mR_TIME_STAMP.getmin());
        }
        if (mR_TIME_STAMP.gethour() / 12 == 0) {
            stringBuffer.append(" AM</html>");
        } else {
            stringBuffer.append(" PM</html>");
        }
        return stringBuffer;
    }

    class ManageSnapshotCellRenderer
    extends DefaultTableCellRenderer {
        ManageSnapshotCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel();
            String string = "";
            MR_LD_PIT_INFO mR_LD_PIT_INFO = (MR_LD_PIT_INFO)object;
            String string2 = new String(mR_LD_PIT_INFO.getParams().getPITName()).trim().toString();
            jLabel.setText(string2);
            jLabel.setOpaque(true);
            jLabel.setBackground(jTable.getBackground());
            jLabel.setForeground(jTable.getForeground());
            jLabel.setToolTipText(string2);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
                jLabel.setForeground(jTable.getSelectionForeground());
            }
            this.setHorizontalAlignment(0);
            return jLabel;
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                SnapshotsDetailPanel.this.updateViewPanel();
            }
        }
    }

    class CreateSnapshot
    extends VivaldiBaseDialog {
        public CreateSnapshot() {
            this.buildCreateSnapshotUI();
        }

        public void buildCreateSnapshotUI() {
            JPanel jPanel = new JPanel();
            String[] stringArray = null;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(new GridBagLayout());
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            String string = Resource.getString("LDRIVE_OPERATION_CREATE_SNAPSHOT_SINGLE_TITLE", "Create Snapshot");
            JLabel jLabel = new JLabel();
            stringArray = Resource.getResourceMnemonic(Resource.getString("LDDRIVE_OPERATION_SNAPSHOT_NAME_TEXT", "(S)napshot name:"));
            jLabel.setText(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            jPanel.add((Component)jLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            SnapshotsDetailPanel.this.snapshotNameTextField.setText(SnapshotsDetailPanel.this.getDefaultName());
            SnapshotsDetailPanel.this.snapshotNameTextField.setCaretPosition(0);
            SnapshotsDetailPanel.this.snapshotNameTextField.setSelectionStart(0);
            SnapshotsDetailPanel.this.snapshotNameTextField.setSelectionEnd(SnapshotsDetailPanel.this.snapshotNameTextField.getText().length());
            jPanel.add((Component)SnapshotsDetailPanel.this.snapshotNameTextField, gridBagConstraints);
            jLabel.setLabelFor(SnapshotsDetailPanel.this.snapshotNameTextField);
            SnapshotsDetailPanel.this.snapshotNameTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuffer stringBuffer;
                    Object object;
                    System.out.println("in snapshotNameTextField.addActionListener");
                    if (SnapshotsDetailPanel.this.snapshotNameTextField.getText().length() == 0) {
                        JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("SNAPSHOT_NAME_MANDATORY_MESSAGE", "You cannot leave this field blank. Enter a snapshot name to proceed."), Resource.getString("SNAPSHOT_NAME_MANDATORY", "Enter Snapshot Name - Mandatory"), -1, 2);
                        return;
                    }
                    if (SnapshotsDetailPanel.this.ldProp.getdisableAutoDeleteOldestPIT() == 0 && SnapshotsDetailPanel.this.m_allPitInfo.length == 8 && !CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, (String)(object = (Object)Resource.getString("CREATE_SNAPSHOT_TITLE", "Create Snapshot")), (stringBuffer = new StringBuffer(Resource.getString("CONFIRM_CREATE_SNAPSHOT", " <html>You have chosen to Create a Snapshot. This operation<br>will delete the Oldest Snapshot.<br><br>Are you sure you want to delete the Snapshot?</html>"))).toString())) {
                        return;
                    }
                    object = new byte[16];
                    object = SnapshotsDetailPanel.this.snapshotNameTextField.getText().getBytes();
                    ((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).createSnapshot((byte)1, (byte[])object);
                    CreateSnapshot.this.dispose();
                }
            });
            JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
            stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
            JButton jButton = new JButton(stringArray[0]);
            jPanel2.add(jButton);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringBuffer stringBuffer;
                    Object object;
                    if (SnapshotsDetailPanel.this.snapshotNameTextField.getText().length() == 0) {
                        JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("SNAPSHOT_NAME_MANDATORY_MESSAGE", "You cannot leave this field blank. Enter a snapshot name to proceed."), Resource.getString("SNAPSHOT_NAME_MANDATORY", "Enter Snapshot Name - Mandatory"), -1, 2);
                        return;
                    }
                    if (SnapshotsDetailPanel.this.ldProp.getdisableAutoDeleteOldestPIT() == 0 && SnapshotsDetailPanel.this.m_allPitInfo.length == 8 && !CustomMsgBox.confirmWithCheck(VivaldiStartupDialog.mainScreen, (String)(object = (Object)Resource.getString("CREATE_SNAPSHOT_TITLE", "Create Snapshot")), (stringBuffer = new StringBuffer(Resource.getString("CONFIRM_CREATE_SNAPSHOT", " <html>You have chosen to Create a Snapshot. This operation<br>will delete the Oldest Snapshot.<br><br>Are you sure you want to delete the Snapshot?</html>"))).toString())) {
                        return;
                    }
                    object = new byte[16];
                    object = SnapshotsDetailPanel.this.snapshotNameTextField.getText().getBytes();
                    ((SASLogicalDrive)SnapshotsDetailPanel.this.m_helper.getDeviceObject()).createSnapshot((byte)1, (byte[])object);
                    CreateSnapshot.this.dispose();
                }
            });
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
            JButton jButton2 = new JButton(stringArray[0]);
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (CreateSnapshot.this.warningDialog()) {
                        CreateSnapshot.this.dispose();
                    }
                }
            });
            jPanel2.add(jButton2);
            gridBagConstraints.gridy += 5;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 10, 0);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            this.add((Component)jPanel, "West");
            this.setTitle(string);
            this.setModal(true);
            this.setResizable(false);
            this.pack();
            GUIUtils.centerDialogOnScreen(this);
            this.setVisible(true);
        }
    }

    private class TextHandler
    implements ActionListener {
        private TextHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().toString().length() > 15) {
                // empty if block
            }
        }
    }
}

