/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Resource;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;

public class ColorHash {
    private static Hashtable hash = new Hashtable();

    public ColorHash(boolean bl) {
        hash.put("SELECTED_HOST_COLOR", new Color(169, 205, 255));
        hash.put("GRAPHICAL_VIEW_USED", Color.blue);
        hash.put("GRAPHICAL_VIEW_UNUSED", Color.white);
        hash.put("GRAPHICAL_VIEW_UNUSABLE", Color.red);
        hash.put("GRAPHICAL_VIEW_HIGHLIGHTED", Color.green);
        hash.put("BORDER_COLOR", Color.black);
        hash.put("LOG_INFO_COLOR", Color.blue);
        hash.put("LOG_ERROR_COLOR", Color.red);
        hash.put("LOG_WARNING_COLOR", Color.magenta);
        hash.put("LOG_FATAL_COLOR", Color.red.darker());
        hash.put("LOG_DEAD_COLOR", Color.red.darker().darker());
    }

    public ColorHash() {
        hash.put("TAB_BKGROUND", new Color(124, 148, 196));
        hash.put("TAB_FRGROUND_SELECTED", Color.white);
        hash.put("TAB_FRGROUND_DEFAULT", Color.black);
        hash.put("GENERAL_BKGROUND", new Color(124, 148, 196));
        hash.put("PROPERTY_VIEW_COLOR1", new Color(241, 244, 250));
        hash.put("PROPERTY_VIEW_COLOR2", new Color(228, 235, 249));
        hash.put("LOG_INFO_COLOR", Color.blue);
        hash.put("LOG_ERROR_COLOR", Color.red);
        hash.put("LOG_WARNING_COLOR", Color.magenta);
        hash.put("LOG_FATAL_COLOR", Color.red.darker());
        hash.put("LOG_DEAD_COLOR", Color.red.darker().darker());
        hash.put("GRAPHICAL_VIEW_USED", Color.blue);
        hash.put("GRAPHICAL_VIEW_UNUSED", Color.white);
        hash.put("GRAPHICAL_VIEW_UNUSABLE", Color.red);
        hash.put("GRAPHICAL_VIEW_HIGHLIGHTED", Color.green);
        hash.put("GRAPHICAL_VIEW_ARRAY", new Color(40, 100, 40));
        hash.put("BUTTON_BACKGROUND", new Color(134, 163, 207));
        hash.put("LIGHT_BACKGROUND", new Color(255, 255, 206));
        hash.put("DEFAULT_HOST_COLOR", new Color(200, 200, 200));
        hash.put("SELECTED_HOST_COLOR", new Color(169, 205, 255));
        hash.put("BORDER_COLOR", Color.black);
        hash.put("LABEL_FRGROUND_ON_BLUE", Color.white);
        hash.put("PROPERTY_VIEW_COLOR3", new Color(203, 216, 240));
        hash.put("DISABLED_TEXT", new Color(180, 180, 180));
        Enumeration enumeration = hash.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = (String)enumeration.nextElement();
            String string2 = Resource.getString(string);
            if (string2 == null || (n = Integer.parseInt(string2, 16)) < 0 || n > 0xFFFFFF) continue;
            hash.put(string, new Color(n));
        }
    }

    public static Color getColor(Object object) {
        return (Color)hash.get(object);
    }

    public static Color brighterColor(Color color, int n) {
        int n2 = color.getRed() + n;
        int n3 = color.getGreen() + n;
        int n4 = color.getBlue() + n;
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        return new Color(n2, n3, n4);
    }
}

