/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.ColorHash;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class Cube {
    private int startx;
    private int starty;
    private int width;
    private int height;
    private int capHeight;
    private int offset;
    public Color foreColor;
    public Color backColor;
    private Graphics2D g2d;

    public Cube(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, Color color, Color color2) {
        this.g2d = (Graphics2D)graphics;
        this.startx = n;
        this.starty = n2;
        this.width = n3;
        this.height = n4;
        this.capHeight = n5;
        this.offset = n6;
        this.foreColor = color;
        this.backColor = color2;
        this.draw();
    }

    public void draw() {
        this.fillCap(this.foreColor);
        this.fillBlock(0, this.height, this.backColor);
    }

    private void enableAntialiasing(boolean bl) {
        if (bl) {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public void fillCap(Color color) {
        this.enableAntialiasing(true);
        GradientPaint gradientPaint = new GradientPaint(this.startx, this.starty, ColorHash.brighterColor(color, 100), this.startx + this.width, this.starty, color);
        this.g2d.setPaint(gradientPaint);
        int[] nArray = new int[]{this.startx, this.startx + this.width, this.startx + this.width - this.offset, this.startx - this.offset};
        int[] nArray2 = new int[]{this.starty, this.starty, this.starty - this.capHeight, this.starty - this.capHeight};
        int n = 4;
        this.g2d.fillPolygon(nArray, nArray2, n);
        this.g2d.setColor(color);
        this.g2d.drawPolygon(nArray, nArray2, n);
    }

    public void fillBlock(int n, int n2, Color color) {
        GradientPaint gradientPaint = new GradientPaint(this.startx, this.starty + n, ColorHash.brighterColor(color, -120), this.startx + this.width, this.starty + n, color);
        this.g2d.setPaint(gradientPaint);
        this.enableAntialiasing(true);
        this.g2d.fillRect(this.startx, this.starty + n, this.width, n2 - n);
        this.g2d.setColor(ColorHash.brighterColor(color, -120));
        int[] nArray = new int[]{this.startx, this.startx - this.offset, this.startx - this.offset, this.startx};
        int[] nArray2 = new int[]{this.starty + n, this.starty + n - this.capHeight, this.starty - this.capHeight + n2, this.starty + n2};
        int n3 = 4;
        this.g2d.fillPolygon(nArray, nArray2, n3);
        this.g2d.setColor(this.foreColor);
        this.g2d.drawRect(this.startx, this.starty + n, this.width, n2 - n);
        this.g2d.drawPolygon(nArray, nArray2, n3);
    }
}

