/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import GUI.VivaldiStartupDialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class CustomComboBox
extends JComboBox {
    protected int i_intPopupWidth = 0;
    private CustomComboBoxUI c = new CustomComboBoxUI();

    public CustomComboBox() {
        if (!VivaldiStartupDialog.isWindows) {
            this.setUI(this.c);
        }
        this.i_intPopupWidth = 0;
    }

    public CustomComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        if (!VivaldiStartupDialog.isWindows) {
            this.setUI(this.c);
        }
        this.i_intPopupWidth = 0;
    }

    public CustomComboBox(Object[] objectArray) {
        super(objectArray);
        if (!VivaldiStartupDialog.isWindows) {
            this.setUI(this.c);
        }
        this.i_intPopupWidth = 0;
    }

    public CustomComboBox(Vector vector) {
        super(vector);
        if (!VivaldiStartupDialog.isWindows) {
            this.setUI(this.c);
        }
        this.i_intPopupWidth = 0;
    }

    public void setPopupWidth(int n) {
        this.i_intPopupWidth = n;
    }

    public Dimension getPopupSize() {
        this.i_intPopupWidth = this.measurePopupWidth();
        return new Dimension(this.i_intPopupWidth, this.getSize().height);
    }

    protected int measurePopupWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return this.getSize().width;
        }
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getAscent();
        int n3 = 0;
        int[] nArray = new int[this.getItemCount()];
        for (int i = 0; i < this.getItemCount(); ++i) {
            nArray[i] = fontMetrics.stringWidth(this.getItemAt(i).toString());
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        if (n3 < this.getSize().width) {
            n3 = this.getSize().width;
        }
        return n3;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        super.contentsChanged(listDataEvent);
        this.setToolTipText(this.getItemCount() <= 0 || this.getSelectedItem() == null ? null : this.getSelectedItem().toString());
    }

    class CustomComboBoxUI
    extends MetalComboBoxUI {
        CustomComboBoxUI() {
        }

        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox){

                @Override
                public void show() {
                    Dimension dimension = ((CustomComboBox)this.comboBox).getPopupSize();
                    dimension.setSize(dimension.width, this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
                    Rectangle rectangle = this.computePopupBounds(0, this.comboBox.getBounds().height, dimension.width, dimension.height);
                    this.scroller.setMaximumSize(rectangle.getSize());
                    this.scroller.setPreferredSize(rectangle.getSize());
                    this.scroller.setMinimumSize(rectangle.getSize());
                    this.list.invalidate();
                    int n = this.comboBox.getSelectedIndex();
                    if (n == -1) {
                        this.list.clearSelection();
                    } else {
                        this.list.setSelectedIndex(n);
                    }
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
                    this.show(this.comboBox, rectangle.x, rectangle.y);
                }
            };
            basicComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return basicComboPopup;
        }
    }
}

