/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.ColorHash;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class Cylinder3D {
    private int startx;
    private int starty;
    private int width;
    private int height;
    private int capHeight;
    public Color foreColor;
    public Color backColor;
    public Color highLightColor;
    private Graphics2D g2d;

    public Cylinder3D(Graphics graphics, int n, int n2, int n3, int n4, int n5, Color color, Color color2, Color color3) {
        this.g2d = (Graphics2D)graphics;
        this.startx = n;
        this.starty = n2;
        this.width = n3;
        this.height = n4;
        this.capHeight = n5;
        this.foreColor = color;
        this.backColor = color2;
        this.highLightColor = color3;
        this.draw();
    }

    public void draw() {
        this.fillCap(this.foreColor);
        this.fillCylinder(0, this.height, this.backColor);
        this.drawBorders();
    }

    public void drawBorders() {
        this.enableAntialiasing(true);
        this.g2d.setColor(this.foreColor);
        this.g2d.drawArc(this.startx, this.starty + this.height, this.width, this.capHeight, -180, 180);
    }

    private void enableAntialiasing(boolean bl) {
        if (bl) {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public void fillCap(Color color) {
        this.enableAntialiasing(true);
        GradientPaint gradientPaint = new GradientPaint(this.startx, this.starty, ColorHash.brighterColor(color, 100), this.startx + this.width, this.starty, color);
        this.g2d.setPaint(gradientPaint);
        this.g2d.fillOval(this.startx, this.starty, this.width, this.capHeight);
    }

    public void fillCylinder(int n, int n2, Color color) {
        GradientPaint gradientPaint = new GradientPaint(this.startx, this.starty + n, ColorHash.brighterColor(color, -120), this.startx + this.width, this.starty + n, color);
        this.g2d.setPaint(gradientPaint);
        this.enableAntialiasing(true);
        this.g2d.drawArc(this.startx, this.starty + n, this.width, this.capHeight, -180, 180);
        this.g2d.drawArc(this.startx, this.starty + n2 - 1, this.width, this.capHeight, -180, 180);
        this.enableAntialiasing(false);
        for (int i = n + 1; i < n2; ++i) {
            this.g2d.drawArc(this.startx, this.starty + i, this.width, this.capHeight, -180, 180);
        }
    }
}

