/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DOMUtil {
    private static Logger logger = Logger.getLogger(DOMUtil.class);
    private boolean validate = false;
    private static ThreadLocal builder = new ThreadLocal();

    public DOMUtil() {
    }

    public DOMUtil(boolean bl) {
        this.validate = bl;
    }

    public Document makeDocument(String string) throws IOException, JDOMException {
        return this.getBuilder().build((Reader)new StringReader(string));
    }

    protected final SAXBuilder getBuilder() {
        if (builder.get() == null) {
            builder.set(this.createBuilder());
        }
        return (SAXBuilder)builder.get();
    }

    protected SAXBuilder createBuilder() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setReuseParser(true);
        if (this.validate) {
            sAXBuilder.setValidation(true);
        }
        return sAXBuilder;
    }

    public String toXmlString(Document document) {
        Format format = Format.getRawFormat();
        format.setOmitEncoding(true);
        format.setOmitDeclaration(true);
        return new XMLOutputter(format).outputString(document);
    }

    public String toXmlString(Element element) {
        return new XMLOutputter().outputString(element);
    }

    public String formatXmlString(String string) throws IOException, JDOMException {
        Document document = this.makeDocument(string);
        return new XMLOutputter(Format.getRawFormat().setIndent("\t")).outputString(document);
    }

    public Element getElement(String string, Document document) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElement:" + string));
        Element element = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            List list = jDOMXPath.selectNodes((Object)document);
            if (list != null && list.size() == 1) {
                Element element2;
                Iterator iterator = list.iterator();
                element = element2 = (Element)iterator.next();
            } else {
                logger.info((Object)"Node does not exist or has multipule nodes.");
            }
        }
        catch (JaxenException jaxenException) {
            String string2 = "Exception in getElement with XPATH : " + string + jaxenException.getMessage();
            throw new JaxenException(string2);
        }
        logger.info((Object)("<--DOMUtil:getElement:" + string));
        return element;
    }

    public Element getElement(String string, Document document, String string2, String string3) throws JaxenException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        return this.getElement(string, document, hashMap);
    }

    public Element getElement(String string, Document document, Map map) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElement:" + string));
        Element element = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            for (Object object : map.keySet()) {
                jDOMXPath.addNamespace((String)object, (String)map.get(object));
            }
            List list = jDOMXPath.selectNodes((Object)document);
            if (list != null && list.size() == 1) {
                Element element2;
                Object object;
                object = list.iterator();
                element = element2 = (Element)object.next();
            } else {
                logger.info((Object)"Node does not exist or has multipule nodes.");
            }
        }
        catch (JaxenException jaxenException) {
            String string2 = "Exception in getElement with XPATH : " + string + jaxenException.getMessage();
            throw new JaxenException(string2);
        }
        logger.info((Object)("<--DOMUtil:getElement:" + string));
        return element;
    }

    public Element getElement(String string, Element element, Map map) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElement:" + string));
        Element element2 = null;
        try {
            Object object2;
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            for (Object object2 : map.keySet()) {
                jDOMXPath.addNamespace((String)object2, (String)map.get(object2));
            }
            List list = jDOMXPath.selectNodes((Object)element);
            if (list != null && list.size() == 1) {
                Element element3;
                object2 = list.iterator();
                element2 = element3 = (Element)object2.next();
            } else {
                object2 = "Node does not exist or has multipule nodes.";
                logger.info(object2);
            }
        }
        catch (JaxenException jaxenException) {
            String string2 = "Exception in getElement with XPATH : " + string + jaxenException.getMessage();
            throw new JaxenException(string2);
        }
        logger.info((Object)("<--DOMUtil:getElement:" + string));
        return element2;
    }

    public Element getElement(String string, Element element, String string2, String string3) throws JaxenException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string2, string3);
        return this.getElement(string, element, hashMap);
    }

    public Element getElement(String string, Element element) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElement:" + string));
        Element element2 = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            List list = jDOMXPath.selectNodes((Object)element);
            if (list != null && list.size() == 1) {
                Element element3;
                Iterator iterator = list.iterator();
                element2 = element3 = (Element)iterator.next();
            } else {
                String string2 = "Node does not exist or has multipule nodes.";
                logger.info((Object)string2);
            }
        }
        catch (JaxenException jaxenException) {
            String string3 = "Exception in getElement with XPATH : " + string + jaxenException.getMessage();
            throw new JaxenException(string3);
        }
        logger.info((Object)("<--DOMUtil:getElement:" + string));
        return element2;
    }

    public List getElementsList(String string, Document document) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElementsList:" + string));
        List list = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            list = jDOMXPath.selectNodes((Object)document);
        }
        catch (JaxenException jaxenException) {
            throw new JaxenException("Exception in getElementsList with XPATH : " + string + jaxenException.getMessage());
        }
        logger.info((Object)("<--DOMUtil:getElementsList:" + string));
        return list;
    }

    public List getElementsList(String string, Document document, String string2, String string3) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElementsList:" + string));
        List list = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            jDOMXPath.addNamespace(string2, string3);
            list = jDOMXPath.selectNodes((Object)document);
        }
        catch (JaxenException jaxenException) {
            throw new JaxenException("Exception in getElementsList with XPATH : " + string + jaxenException.getMessage());
        }
        logger.info((Object)("<--DOMUtil:getElementsList:" + string));
        return list;
    }

    public List getElementsList(String string, Document document, Map map) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElementsList:" + string));
        List list = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            for (String string2 : map.keySet()) {
                jDOMXPath.addNamespace(string2, (String)map.get(string2));
            }
            list = jDOMXPath.selectNodes((Object)document);
        }
        catch (JaxenException jaxenException) {
            throw new JaxenException("Exception in getElementsList with XPATH : " + string + jaxenException.getMessage());
        }
        logger.info((Object)("<--DOMUtil:getElementsList:" + string));
        return list;
    }

    public List getElementsList(String string, Element element, Map map) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElementsList:" + string));
        List list = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            for (String string2 : map.keySet()) {
                jDOMXPath.addNamespace(string2, (String)map.get(string2));
            }
            list = jDOMXPath.selectNodes((Object)element);
        }
        catch (JaxenException jaxenException) {
            throw new JaxenException("Exception in getElementsList with XPATH : " + string + jaxenException.getMessage());
        }
        logger.info((Object)("<--DOMUtil:getElementsList:" + string));
        return list;
    }

    public List getElementsList(String string, Element element) throws JaxenException {
        logger.info((Object)("-->DOMUtil:getElementsList:" + string));
        List list = null;
        try {
            JDOMXPath jDOMXPath = new JDOMXPath(string);
            list = jDOMXPath.selectNodes((Object)element);
        }
        catch (JaxenException jaxenException) {
            String string2 = "Exception in getElementsList with XPATH : " + string + jaxenException.getMessage();
            throw new JaxenException(string2);
        }
        logger.info((Object)("<--DOMUtil:getElementsList:" + string));
        return list;
    }

    public String lookup(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            boolean bl = false;
            while (!bl) {
                char[] cArray = new char[1001];
                int n = inputStreamReader.read(cArray, 0, 1000);
                if (n == -1) {
                    bl = true;
                    continue;
                }
                stringBuffer.append(new String(cArray, 0, n));
            }
        }
        catch (IOException iOException) {
            logger.error((Object)("Exception in lookup for fileName  " + string));
        }
        return stringBuffer.toString();
    }

    public String formatDoc(Document document) throws Exception {
        String string = null;
        try {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            xMLOutputter.output(document, (Writer)stringWriter);
            string = stringWriter.toString();
        }
        catch (Exception exception) {
            String string2 = "Exception in formatDoc:";
            throw new Exception(string2);
        }
        return string;
    }

    public String formatElem(Element element) throws Exception {
        String string = null;
        try {
            XMLOutputter xMLOutputter = new XMLOutputter();
            StringWriter stringWriter = new StringWriter();
            xMLOutputter.output(element, (Writer)stringWriter);
            string = stringWriter.toString();
            return string;
        }
        catch (Exception exception) {
            String string2 = "Exception in formatElem:";
            throw new Exception(string2);
        }
    }
}

