/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;

public class DoubleIcons
extends ImageIcon {
    public static final int VERTICALLY_TOP_JUSTFIED = 0;
    public static final int VERTICALLY_CENTER_JUSTFIED = 1;
    public static final int VERTICALLY_BOTTOM_JUSTFIED = 2;
    public static final int EXTRA_PIXEL_SPACE = 2;
    private ImageIcon m_LeftPaintIcon;
    private ImageIcon m_RightPaintIcon;
    private ImageIcon m_LeftIcon;
    private ImageIcon m_RightIcon;
    private ImageIcon m_LeftDisabledIcon;
    private ImageIcon m_RightDisabledIcon;
    private int m_VerticalLineUp;

    public DoubleIcons(ImageIcon imageIcon, ImageIcon imageIcon2, int n) {
        this.m_LeftIcon = imageIcon;
        this.m_RightIcon = imageIcon2;
        this.m_LeftPaintIcon = this.m_LeftIcon;
        this.m_RightPaintIcon = this.m_RightIcon;
        this.m_VerticalLineUp = n;
    }

    @Override
    public int getIconHeight() {
        return Math.max(this.m_LeftPaintIcon.getIconHeight(), this.m_RightPaintIcon.getIconHeight());
    }

    @Override
    public int getIconWidth() {
        return this.m_LeftPaintIcon.getIconWidth() + this.m_RightPaintIcon.getIconWidth() + 2;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        switch (this.m_VerticalLineUp) {
            case 1: {
                int n3 = (this.getIconHeight() - this.m_LeftPaintIcon.getIconHeight()) / 2;
                this.m_LeftPaintIcon.paintIcon(component, graphics, n, n2 + n3);
                n3 = (this.getIconHeight() - this.m_RightPaintIcon.getIconHeight()) / 2;
                this.m_RightPaintIcon.paintIcon(component, graphics, n + this.m_LeftIcon.getIconWidth() + 2, n2 + n3);
                break;
            }
            case 2: {
                int n4 = this.getIconHeight() - this.m_LeftPaintIcon.getIconHeight();
                this.m_LeftPaintIcon.paintIcon(component, graphics, n, n2 + n4);
                n4 = this.getIconHeight() - this.m_RightPaintIcon.getIconHeight();
                this.m_RightPaintIcon.paintIcon(component, graphics, n + this.m_LeftPaintIcon.getIconWidth() + 2, n2 + n4);
                break;
            }
            case 0: {
                this.m_LeftPaintIcon.paintIcon(component, graphics, n, n2);
                this.m_RightPaintIcon.paintIcon(component, graphics, n + this.m_LeftPaintIcon.getIconWidth() + 2, n2);
                break;
            }
        }
    }

    public void disableIcons() {
        if (this.m_LeftDisabledIcon == null || this.m_RightDisabledIcon == null) {
            if (this.m_LeftIcon instanceof DoubleIcons) {
                ((DoubleIcons)this.m_LeftIcon).disableIcons();
                try {
                    this.m_LeftDisabledIcon = (DoubleIcons)((DoubleIcons)this.m_LeftIcon).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                ((DoubleIcons)this.m_LeftIcon).enableIcons();
            } else {
                this.m_LeftDisabledIcon = GrayFilter.createDisabledImage(this.m_LeftIcon.getImage()) != null ? new ImageIcon(GrayFilter.createDisabledImage(this.m_LeftIcon.getImage())) : null;
            }
            if (this.m_RightIcon instanceof DoubleIcons) {
                ((DoubleIcons)this.m_RightIcon).disableIcons();
                try {
                    this.m_RightDisabledIcon = (DoubleIcons)((DoubleIcons)this.m_RightIcon).clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
                ((DoubleIcons)this.m_RightIcon).enableIcons();
            } else {
                this.m_RightDisabledIcon = GrayFilter.createDisabledImage(this.m_RightIcon.getImage()) != null ? new ImageIcon(GrayFilter.createDisabledImage(this.m_RightIcon.getImage())) : null;
            }
        }
        this.m_LeftPaintIcon = this.m_LeftDisabledIcon;
        this.m_RightPaintIcon = this.m_RightDisabledIcon;
    }

    public void enableIcons() {
        this.m_LeftPaintIcon = this.m_LeftIcon;
        this.m_RightPaintIcon = this.m_RightIcon;
    }
}

