/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import GUI.MainFrame;
import Wizard.ConfigWizard.GUIData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class GUIUtils {
    public static void setDefault(JComponent jComponent, Object object) {
        JComboBox jComboBox;
        if (jComponent instanceof JComboBox && (jComboBox = (JComboBox)jComponent).getItemCount() > 0 && jComboBox.getItemAt(0) instanceof GUIData) {
            GUIUtils.setDefaultValueToJComboBoxFromGUIData(jComboBox, (Integer)object);
        }
    }

    public static void setDefaultValueToJComboBoxFromGUIData(JComboBox jComboBox, int n) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            if (((GUIData)jComboBox.getItemAt((int)i)).flag != n) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
    }

    public static Font getDefaultFont(int n, String string, int n2, Component component) {
        Font font = new Font(string, 1, n2);
        int n3 = component.getFontMetrics(font).getHeight();
        if (n != n3) {
            int n4;
            int n5 = n4 = font.getSize();
            if (n < n3) {
                while (n < component.getFontMetrics(font = new Font(string, 1, --n5)).getHeight()) {
                }
            } else {
                int n6;
                do {
                    n6 = n5++;
                } while (n >= component.getFontMetrics(font = new Font(string, 1, n5)).getHeight());
                font = new Font(string, 1, n6);
            }
        }
        return font;
    }

    public static String getLocaleSpecificDirectory(byte by) {
        String string = by == 1 ? "docs" + File.separator + "MSM_MR_help" : (by == 2 ? "docs" + File.separator + "MSM_IR_help" : (by == 3 ? "docs" + File.separator + "MSM_NYTRO_XD_help" : (by == 4 ? "docs" + File.separator + "MSM_CSA_help" : "docs")));
        String string2 = File.separator + "Languages" + File.separator;
        String string3 = Locale.getDefault().getLanguage();
        if (string3.equals(Locale.CHINESE.getLanguage())) {
            string3 = string3 + "-" + Locale.getDefault().getCountry();
        }
        if (!new File("." + File.separator + string + string2 + string3).exists()) {
            string3 = "en";
        }
        if (!new File("." + File.separator + string + string2 + string3).exists()) {
            return string;
        }
        return string + string2 + string3;
    }

    public static void addItemListeningToolTip(JComboBox jComboBox) {
        if (jComboBox.getSelectedItem() != null) {
            jComboBox.setToolTipText(jComboBox.getSelectedItem().toString());
        }
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                if (jComboBox.getSelectedItem() != null) {
                    jComboBox.setToolTipText(jComboBox.getSelectedItem().toString());
                }
            }
        });
    }

    public static void setDefaultValueToJCheckboxFromGUIData(JCheckBox jCheckBox, boolean bl) {
        jCheckBox.setSelected(bl);
        jCheckBox.setEnabled(bl);
    }

    public static void centerDialogOnScreen(Window window) {
        GUIUtils.centerDialogOnScreen(window, null);
    }

    public static void centerDialogOnScreen(Window window, Container container) {
        if (container != null) {
            window.setLocation(container.getLocation().x + (container.getWidth() - window.getWidth()) / 2, container.getLocation().y + (container.getHeight() - window.getHeight()) / 2);
        } else {
            window.setLocation((MainFrame.SCREEN_SIZE.width - window.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - window.getHeight()) / 2);
        }
    }
}

