/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    protected ImageIcon icon;
    protected boolean horizontalStretch = true;
    protected boolean verticalStretch = false;
    protected boolean aspectRatio = false;
    private int drawWidth;
    private int drawHeight;

    public ImagePanel(String string, boolean bl, boolean bl2, boolean bl3) {
        this(string);
        this.horizontalStretch = bl;
        this.verticalStretch = bl2;
        this.aspectRatio = bl3;
    }

    public ImagePanel(String string) {
        this.icon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string)));
        this.setOpaque(false);
    }

    public Dimension getDimension() {
        return new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    public Dimension getDrawDimension() {
        return new Dimension(this.drawWidth, this.drawHeight);
    }

    @Override
    public void paint(Graphics graphics) {
        this.drawWidth = this.horizontalStretch ? this.getWidth() : this.icon.getIconWidth();
        this.drawHeight = this.verticalStretch ? this.getHeight() : this.icon.getIconHeight();
        if (this.horizontalStretch && !this.verticalStretch && this.aspectRatio) {
            this.drawHeight = this.drawWidth * this.icon.getIconHeight() / this.icon.getIconWidth();
        }
        if (this.verticalStretch && !this.horizontalStretch && this.aspectRatio) {
            this.drawWidth = this.drawHeight * this.icon.getIconWidth() / this.icon.getIconHeight();
        }
        graphics.drawImage(this.icon.getImage(), 0, 0, this.drawWidth, this.drawHeight, this.getBackground(), null);
        super.paint(graphics);
    }
}

