/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import GUIHelper.LogicalDriveHelper;
import java.awt.Color;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MultiSelectList
extends JPanel {
    private Object[] listItems;
    private JCheckBox[] checkBox;
    String mnemonicChar;

    public MultiSelectList(Object[] objectArray) {
        this.setItems(objectArray);
    }

    private void setItems(Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            this.setVisible(false);
            return;
        }
        this.listItems = objectArray;
        this.setLayout(new GridLayout(0, 1));
        this.checkBox = new JCheckBox[objectArray.length];
        this.setOpaque(true);
        this.setBackground((Color)UIManager.get("Button.background"));
        for (int i = 0; i < this.checkBox.length; ++i) {
            this.mnemonicChar = "" + i + "";
            this.checkBox[i] = new JCheckBox(objectArray[i].toString());
            if (objectArray[i] instanceof LogicalDriveHelper) {
                this.checkBox[i].setMnemonic(this.mnemonicChar.charAt(0));
            }
            this.checkBox[i].setSelected(false);
            this.checkBox[i].setOpaque(false);
            this.add(this.checkBox[i]);
        }
    }

    public MultiSelectList(ArrayList arrayList) {
        Object[] objectArray = new Object[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        this.setItems(objectArray);
    }

    public void setTitle(String string) {
        this.setBorder(BorderFactory.createTitledBorder(string));
    }

    public void setSelectedIndex(int n, boolean bl) {
        if (n >= 0 && n < this.checkBox.length) {
            this.checkBox[n].setSelected(bl);
        }
    }

    public boolean isSelectedIndex(int n) {
        if (n >= 0 && n < this.checkBox.length) {
            return this.checkBox[n].isSelected();
        }
        return false;
    }

    public int[] getSelectedIndices() {
        int n = 0;
        for (int i = 0; i < this.checkBox.length; ++i) {
            if (!this.checkBox[i].isSelected()) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i < this.checkBox.length; ++i) {
            if (!this.checkBox[i].isSelected()) continue;
            nArray[n] = i;
            ++n;
        }
        return nArray;
    }

    public Object[] getSelectedObjects() {
        int n = 0;
        if (this.checkBox == null) {
            return new Object[0];
        }
        for (int i = 0; i < this.checkBox.length; ++i) {
            if (!this.checkBox[i].isSelected()) continue;
            ++n;
        }
        Object[] objectArray = new Object[n];
        n = 0;
        for (int i = 0; i < this.checkBox.length; ++i) {
            if (!this.checkBox[i].isSelected()) continue;
            objectArray[n] = this.listItems[i];
            ++n;
        }
        return objectArray;
    }

    public int getListCount() {
        if (this.listItems != null) {
            return this.listItems.length;
        }
        return 0;
    }

    public Object[] getUnSelectedObjects() {
        int n = 0;
        if (this.checkBox == null) {
            return new Object[0];
        }
        for (int i = 0; i < this.checkBox.length; ++i) {
            if (this.checkBox[i].isSelected()) continue;
            ++n;
        }
        Object[] objectArray = new Object[n];
        n = 0;
        System.out.println("IN MULTI SELECT LIST Lenght is  :" + this.checkBox.length);
        for (int i = 0; i < this.checkBox.length; ++i) {
            if (this.checkBox[i].isSelected()) continue;
            objectArray[n] = this.listItems[i];
            ++n;
        }
        return objectArray;
    }

    public Object[] getAllObjects() {
        return this.listItems;
    }

    public void setSelection(boolean bl, int n) {
        if (n >= 0 && n < this.checkBox.length) {
            this.checkBox[n].setEnabled(bl);
        }
    }
}

