/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesFileHandler {
    private String m_fileName = null;
    private String m_filePath = null;
    private Properties m_Properties = null;

    public PropertiesFileHandler(String string, String string2) {
        this.m_filePath = string;
        this.m_fileName = string2;
        this.load();
    }

    public PropertiesFileHandler(String string) {
        this.m_fileName = string;
        this.m_filePath = "";
        this.load();
    }

    private void load() {
        this.m_Properties = new Properties();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(this.m_filePath + this.m_fileName);
            this.m_Properties.load(inputStream);
        }
        catch (IOException iOException) {
            System.out.println("Got Exception in loading the property file:" + this.m_fileName + iOException.getMessage());
            try {
                File file = new File(this.m_fileName);
                System.out.println(file.getCanonicalPath());
                this.m_Properties.load(new FileInputStream(this.m_fileName));
            }
            catch (Exception exception) {
                System.out.println("Got Exception again");
            }
        }
    }

    public String getProperty(String string) {
        String string2 = null;
        string2 = this.m_Properties.getProperty(string);
        return string2;
    }

    public void setProperty(String string, String string2) {
        this.m_Properties.setProperty(string, string2);
        try {
            this.m_Properties.store(new FileOutputStream(this.m_filePath + this.m_fileName), null);
        }
        catch (IOException iOException) {
            System.out.println("got exception trying in the classpath");
            try {
                this.m_Properties.store(new FileOutputStream(this.m_fileName), null);
            }
            catch (Exception exception) {
                System.out.println("got exception again!");
            }
        }
    }

    public static void main(String[] stringArray) {
        PropertiesFileHandler propertiesFileHandler = new PropertiesFileHandler("DiscoverySettings.properties");
        if (propertiesFileHandler != null) {
            System.out.println(propertiesFileHandler.getProperty("DISCOVERYOPTION"));
            System.out.println(propertiesFileHandler.getProperty("IPADDRESS"));
        }
    }
}

