/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import GUI.PopupViewPanel;
import GUI.VivaldiStartupDialog;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Properties;
import javax.swing.ImageIcon;

public class Resource {
    private static Properties prop = null;
    private static Properties errorMsgProp = null;
    private static Properties eventMsgProp = null;
    private static Properties PopupProp = null;

    public static String getString(String string) {
        if (prop == null) {
            Resource.loadResource("resource" + VivaldiStartupDialog.OEM_TYPE + ".ini");
        }
        return prop.getProperty(string);
    }

    public static String getEvtString(String string) {
        if (eventMsgProp == null) {
            Resource.loadEvtMsg();
        }
        return eventMsgProp.getProperty(string);
    }

    public static String getPopupString(String string) {
        if (PopupProp == null) {
            Resource.loadPopupProp("resource" + PopupViewPanel.OEM_TYPE + ".ini");
        }
        return PopupProp.getProperty(string);
    }

    public static String getPopupString(String string, String string2) {
        if (PopupProp == null) {
            Resource.loadPopupProp("resource" + PopupViewPanel.OEM_TYPE + ".ini");
        }
        return PopupProp.getProperty(string, string2);
    }

    public static String getString(String string, String string2) {
        if (prop == null) {
            Resource.loadResource("resource" + VivaldiStartupDialog.OEM_TYPE + ".ini");
        }
        return prop.getProperty(string, string2);
    }

    public static ImageIcon getImage(String string) {
        String string2 = Resource.getString(string);
        if (string2 == null) {
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string2)));
    }

    public static ImageIcon getImage(String string, String string2) {
        String string3 = Resource.getString(string, string2);
        if (string3 == null) {
            return null;
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(string3)));
    }

    public static String zeroTrim(byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            return "";
        }
        String string = new String(byArray);
        if (string == null || string.length() <= 0) {
            return "";
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\u0000') continue;
            return string.substring(0, i + 1).trim();
        }
        return string.trim();
    }

    public static boolean isLocaleSupportedForOEM() {
        Locale locale = Locale.getDefault();
        if (VivaldiStartupDialog.OEM_TYPE == 2561) {
            return locale.getLanguage().equals(Locale.ENGLISH.getLanguage()) || locale.getLanguage().equals("es") || locale.getLanguage().equals(Locale.GERMAN.getLanguage()) || locale.getLanguage().equals(Locale.GERMANY.getLanguage()) || locale.getLanguage().equals(Locale.FRANCE.getLanguage()) || locale.getLanguage().equals(Locale.FRENCH.getLanguage());
        }
        return true;
    }

    public static void loadResource(String string) {
        prop = new Properties();
        String string2 = "." + File.separator + "Languages" + File.separator;
        String string3 = Locale.getDefault().getLanguage();
        System.out.println("localePath for res file::" + string3);
        if (string3.equals(Locale.CHINESE.getLanguage())) {
            string3 = string3 + "-" + Locale.getDefault().getCountry();
        }
        string3 = string3 + File.separator;
        if (!new File(string2 + string3 + string).exists()) {
            string3 = "en" + File.separator;
        }
        try {
            prop.load(new FileInputStream(string2 + string3 + string));
        }
        catch (Exception exception) {
            try {
                prop.load(new FileInputStream("resource71244.ini"));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public static void loadPopupProp(String string) {
        PopupProp = new Properties();
        String string2 = ".." + File.separator + "Languages" + File.separator;
        String string3 = Locale.getDefault().getLanguage();
        System.out.println("localePath for res file::" + string3);
        if (string3.equals(Locale.CHINESE.getLanguage())) {
            string3 = string3 + "-" + Locale.getDefault().getCountry();
        }
        string3 = string3 + File.separator;
        if (!new File(string2 + string3 + string).exists()) {
            string3 = "en" + File.separator;
        }
        try {
            PopupProp.load(new FileInputStream(string2 + string3 + string));
        }
        catch (Exception exception) {
            try {
                PopupProp.load(new FileInputStream("resource71244.ini"));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    public static String[] getResourceMnemonic(String string) {
        String[] stringArray = null;
        if (string.indexOf("(") != -1 || string.indexOf(")") != -1) {
            stringArray = new String[2];
            stringArray[1] = string.substring(string.indexOf("(") + 1, string.indexOf(")"));
            stringArray[0] = string.substring(0, string.indexOf("(")) + string.substring(string.indexOf("(") + 1, string.indexOf(")")) + string.substring(string.indexOf(")") + 1);
        } else {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    public static String[] getStringWithMnemonic(String string) {
        String[] stringArray = new String[]{"", ""};
        if (string == null || string.length() == 0) {
            return stringArray;
        }
        if (string.indexOf("[") == 0) {
            return stringArray;
        }
        if (string.lastIndexOf("]") == string.length() - 1 && string.lastIndexOf("[") == string.length() - 3) {
            stringArray[1] = string.substring(string.length() - 2, string.length() - 1);
            stringArray[0] = string.substring(0, string.length() - 3);
            if (!Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
                stringArray[0] = stringArray[0] + "(" + stringArray[1] + ")";
            }
        } else {
            stringArray[0] = string;
        }
        return stringArray;
    }

    public static String getMfiStatString(String string) {
        if (errorMsgProp == null) {
            if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                Resource.loadMfiStatResource("MfiStatMsgDell-en.csv");
            } else {
                Resource.loadMfiStatResource("MfiStatMsgGen-en.csv");
            }
        }
        return errorMsgProp.getProperty(string);
    }

    public static String getMfiStatString(String string, String string2) {
        if (errorMsgProp == null) {
            if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                Resource.loadMfiStatResource("MfiStatMsgDell-en.csv");
            } else {
                Resource.loadMfiStatResource("MfiStatMsgGen-en.csv");
            }
        }
        return errorMsgProp.getProperty(string, string2);
    }

    public static void loadMfiStatResource(String string) {
        errorMsgProp = new Properties();
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string);
            errorMsgProp.load(inputStream);
        }
        catch (IOException iOException) {
            System.out.println("Caught exception inside getContextClassLoader.");
        }
    }

    public static void loadEvtMsg() {
        System.out.println("Inside loadEvtMsg()");
        if (eventMsgProp == null) {
            eventMsgProp = new Properties();
        }
        String string = "." + File.separator + "Languages" + File.separator;
        String string2 = Locale.getDefault().getLanguage();
        if (string2.equals(Locale.CHINESE.getLanguage())) {
            string2 = string2 + "-" + Locale.getDefault().getCountry();
        }
        string2 = string2 + File.separator;
        if (!new File(string + string2 + "MR_Events.properties").exists()) {
            string2 = "en" + File.separator;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(string + string2 + "MR_Events.properties");
            eventMsgProp.load(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (Exception exception) {
            System.out.println("Got Exception while loading the MR_Events.properties");
            try {
                eventMsgProp.load(new FileInputStream("MR_Events.properties"));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }
}

