/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.GUIUtils;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class VivaldiBaseOptionDialog
extends JDialog {
    private int m_iOptionType = -1;
    private int m_iMessageType = 1;
    protected JPanel m_panel = null;
    private JButton m_btnYes = null;
    private JButton m_btnNo = null;
    private JButton m_btnOk = null;
    private JButton m_btnCancel = null;
    private String m_strTitle = null;
    private boolean m_isModal = false;
    private boolean m_isEnableYesButton = true;
    private boolean m_isEnableOKButton = true;
    private int m_selectedOption = -1;

    public VivaldiBaseOptionDialog(Window window) {
        super(window);
    }

    public VivaldiBaseOptionDialog(Window window, String string, JPanel jPanel, int n, int n2) {
        super(window);
        this.initUI(string, n, n2);
        this.setPanel(jPanel);
    }

    public void initUI(String string, int n, int n2) {
        this.m_strTitle = string;
        this.m_iOptionType = n;
        this.m_iMessageType = n2;
    }

    public void setPanel(JPanel jPanel) {
        this.m_panel = jPanel;
    }

    public void buildUI() {
        Object object;
        try {
            object = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
            this.setIconImage((Image)object);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        this.setTitle(this.m_strTitle);
        this.setModal(this.m_isModal);
        object = new JLabel();
        if (this.m_iMessageType == 1) {
            ((JLabel)object).setIcon(UIManager.getIcon("OptionPane.informationIcon"));
        } else if (this.m_iMessageType == 0) {
            ((JLabel)object).setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        } else if (this.m_iMessageType == 2) {
            ((JLabel)object).setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        } else if (this.m_iMessageType == 3) {
            ((JLabel)object).setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        }
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(20, 30, 10, 10);
        gridBagConstraints.anchor = 12;
        this.getContentPane().add((Component)object, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(20, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        this.getContentPane().add((Component)this.m_panel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        this.getContentPane().add((Component)this.getOptionPanel(), gridBagConstraints);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    public void onOkAction() {
        this.m_selectedOption = 0;
        this.closeDialog();
    }

    public void onCancelAction() {
        this.m_selectedOption = 2;
        this.closeDialog();
    }

    public void onYesOption() {
        this.m_selectedOption = 0;
        this.closeDialog();
    }

    public void onNoAction() {
        this.m_selectedOption = 1;
        this.closeDialog();
    }

    public void setYesEnabled(boolean bl) {
        this.m_isEnableYesButton = bl;
        if (this.m_btnYes != null) {
            this.m_btnYes.setEnabled(bl);
        }
    }

    public void setOKEnabled(boolean bl) {
        this.m_isEnableOKButton = bl;
        if (this.m_btnOk != null) {
            this.m_btnOk.setEnabled(bl);
        }
    }

    public void setModalProperty(boolean bl) {
        this.m_isModal = bl;
    }

    public int getSelectedOption() {
        return this.m_selectedOption;
    }

    public int getOptionType() {
        return this.m_iOptionType;
    }

    private JPanel getOptionPanel() {
        JPanel jPanel = new JPanel();
        if (this.m_iOptionType == -1) {
            this.m_btnOk = new JButton(Resource.getString("BUTTON_LABEL_OK", "Ok"));
            jPanel.add(this.m_btnOk);
            this.m_btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onOkAction();
                }
            });
            this.m_btnOk.setEnabled(this.m_isEnableOKButton);
        } else if (this.m_iOptionType == 2) {
            this.m_btnOk = new JButton(Resource.getString("BUTTON_LABEL_OK", "Ok"));
            jPanel.add(this.m_btnOk);
            this.m_btnCancel = new JButton(Resource.getString("BUTTON_LABEL_CANCEL", "Cancel"));
            jPanel.add(this.m_btnCancel);
            this.m_btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onOkAction();
                }
            });
            this.m_btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onCancelAction();
                }
            });
            this.m_btnOk.setEnabled(this.m_isEnableOKButton);
        } else if (this.m_iOptionType == 1) {
            String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LABEL_YES", "(Y)es"));
            this.m_btnYes = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_btnYes.setMnemonic(stringArray[1].charAt(0));
            }
            jPanel.add(this.m_btnYes);
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTON_LABEL_NO", "(N)o"));
            this.m_btnNo = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_btnNo.setMnemonic(stringArray[1].charAt(0));
            }
            jPanel.add(this.m_btnNo);
            this.m_btnCancel = new JButton(Resource.getString("BUTTON_LABEL_CANCEL", "Cancel"));
            jPanel.add(this.m_btnCancel);
            this.m_btnYes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onYesOption();
                }
            });
            this.m_btnNo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onNoAction();
                }
            });
            this.m_btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onCancelAction();
                }
            });
            this.m_btnYes.setEnabled(this.m_isEnableYesButton);
        } else if (this.m_iOptionType == 0) {
            String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LABEL_YES", "(Y)es"));
            this.m_btnYes = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_btnYes.setMnemonic(stringArray[1].charAt(0));
            }
            jPanel.add(this.m_btnYes);
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTON_LABEL_NO", "(N)o"));
            this.m_btnNo = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_btnNo.setMnemonic(stringArray[1].charAt(0));
            }
            jPanel.add(this.m_btnNo);
            this.m_btnYes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onYesOption();
                }
            });
            this.m_btnNo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    VivaldiBaseOptionDialog.this.onNoAction();
                }
            });
            this.m_btnYes.setEnabled(this.m_isEnableYesButton);
        }
        return jPanel;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("LABEL_CONTROLLER", "Controller:"));
        stringBuffer.append(" ");
        stringBuffer.append("ABC");
        stringBuffer.append("\n\n");
        stringBuffer.append(Resource.getString("MESSAGE_CANNOT_DISABLE_ENCRYPTION"));
        Vector<String> vector = new Vector<String>();
        vector.add("Virtual Drive 1, RAID 1 Volume, 1000GB");
        vector.add("Virtual Drive 2, RAID 1 Volume, 1000GB");
        vector.add("Virtual Drive 3, RAID 1 Volume, 1000GB");
        vector.add("Virtual Drive 4, RAID 1 Volume, 1000GB");
        vector.add("Virtual Drive 5, RAID 1 Volume, 1000GB");
        vector.add("Virtual Drive 6, RAID 1 Volume, 1000GB");
        vector.add("Virtual Drive 7, RAID 1 Volume, 1000GB");
        vector.add("Virtual Drive 8, RAID 1 Volume, 1000GB");
        JList jList = new JList(vector);
        jList.setVisibleRowCount(5);
        jList.setSelectionMode(0);
        String[] stringArray2 = Resource.getResourceMnemonic(Resource.getString("LABEL_ENCRYPTED_VIRTUAL_DRIVES", "(E)ncrypted Virtual Drives:"));
        JLabel jLabel = new JLabel(stringArray2[0]);
        if (stringArray2.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray2[1].charAt(0));
        }
        JScrollPane jScrollPane = new JScrollPane(jList, 20, 31);
        JLabel jLabel2 = new JLabel();
        jLabel2.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(stringBuffer.toString());
        jTextArea.setFont(jPanel.getFont());
        jTextArea.setBackground(jPanel.getBackground());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jTextArea, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        VivaldiBaseOptionDialog vivaldiBaseOptionDialog = new VivaldiBaseOptionDialog(null, "Cannot Disable Encryption", jPanel, 2, 2);
        vivaldiBaseOptionDialog.buildUI();
    }
}

