/*
 * Decompiled with CFR 0.152.
 */
package Wizard;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import Utils.ColorHash;
import Utils.Resource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;

public abstract class BaseWizardDialog
extends VivaldiBaseDialog {
    protected JPanel navigatePanel;
    protected JPanel centerPanel;
    protected JPanel bottomPanel;
    protected JLabel statusLabel;
    protected JButton nextButton;
    protected JButton backButton;
    protected JButton cancelButton;
    private String[] mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_NEXT_TEXT", "Next"));
    private Object[] stepNames;
    private int count;

    public BaseWizardDialog() {
        this.nextButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.nextButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_BACK_TEXT", "Back"));
        this.backButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.backButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        this.cancelButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.cancelButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.navigatePanel = new JPanel();
        this.navigatePanel.setLayout(new FlowLayout(1, 0, MainFrame.SCREEN_SIZE.height * 20 / 768));
        this.stepNames = this.getStepNames(true);
        if (this.stepNames != null && this.stepNames.length > 0) {
            this.count = 0;
            while (this.count < this.stepNames.length) {
                this.mnemonics = Resource.getResourceMnemonic(this.stepNames[this.count].toString());
                JButton jButton = new JButton(this.mnemonics[0]);
                jButton.setToolTipText(jButton.getText());
                jButton.setBackground(ColorHash.getColor("GENERAL_BKGROUND"));
                jButton.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 170 / 1024, MainFrame.SCREEN_SIZE.height * 20 / 768));
                jButton.setHorizontalAlignment(0);
                if (this.mnemonics.length == 2) {
                    jButton.setMnemonic(this.mnemonics[1].charAt(0));
                }
                jButton.setBorder(null);
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Object[] objectArray = BaseWizardDialog.this.getStepNames(false);
                        if (objectArray != null && objectArray.length > 0) {
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (!objectArray[i].equals(((JButton)actionEvent.getSource()).getText())) continue;
                                BaseWizardDialog.this.goToStep(i);
                                return;
                            }
                        }
                    }
                });
                jButton.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        ((JButton)mouseEvent.getSource()).setBorder(BorderFactory.createBevelBorder(1));
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        ((JButton)mouseEvent.getSource()).setBorder(null);
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        Object[] objectArray = BaseWizardDialog.this.getStepNames(false);
                        if (objectArray != null && objectArray.length > 0) {
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (!objectArray[i].equals(((JButton)mouseEvent.getSource()).getText())) continue;
                                BaseWizardDialog.this.goToStep(i);
                                return;
                            }
                        }
                    }
                });
                if (this.count == this.getStep()) {
                    jButton.setFont(jButton.getFont().deriveFont(3));
                    jButton.setForeground(ColorHash.getColor("LABEL_FRGROUND_ON_BLUE"));
                }
                this.navigatePanel.add(jButton);
                ++this.count;
            }
        }
        this.centerPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new FlowLayout(2));
        this.bottomPanel.add(this.cancelButton);
        this.bottomPanel.add(this.backButton);
        this.bottomPanel.add(this.nextButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseWizardDialog.this.closeOpt();
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseWizardDialog.this.back();
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseWizardDialog.this.next();
            }
        });
        this.getRootPane().setDefaultButton(this.nextButton);
        this.bottomPanel.setBorder(BorderFactory.createEtchedBorder());
        this.navigatePanel.setBorder(BorderFactory.createEtchedBorder());
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.bottomPanel.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 800 / 1024, MainFrame.SCREEN_SIZE.height * 50 / 768));
        this.navigatePanel.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 180 / 1024, MainFrame.SCREEN_SIZE.height * 600 / 768));
        if (this.stepNames != null && this.stepNames.length > 0) {
            this.contentPane.add((Component)this.navigatePanel, "West");
        } else {
            this.contentPane.add((Component)new JPanel(), "West");
        }
        this.contentPane.add((Component)this.centerPanel, "Center");
        this.contentPane.add((Component)this.bottomPanel, "South");
        this.setSize(MainFrame.SCREEN_SIZE.width * 800 / 1024, MainFrame.SCREEN_SIZE.height * 600 / 768);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        this.setModal(true);
        this.setResizable(false);
    }

    public abstract void back();

    public abstract void next();

    public void goToStep(int n) {
    }

    public String getStatus() {
        return "";
    }

    public abstract int getStep();

    public void cancel() {
        this.dispose();
    }

    public abstract Object[] getStepNames(boolean var1);

    public static void expandTree(JTree jTree) {
        int n = 0;
        do {
            jTree.expandRow(n);
        } while (++n < jTree.getRowCount());
    }
}

