/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import GUI.security.SelectEncryptionMethodDialog;
import GUIHelper.EnclosureHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.IRConfigHelper.IRConfigEngine;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.ConfigurationHelpers.SpareData;
import SASKernel.ConfigurationHelpers.UnsupportedConfigException;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_DETAILS_T;
import SASKernel.LibraryAPI.StoreLib.SL_PARTITION_INFO_T;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASEnclosure;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomComboBox;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import Wizard.ConfigWizard.GUIData;
import Wizard.ConfigWizard.IRVirtualDiskCreationDialog;
import Wizard.ConfigWizard.ModeSelectionDialog;
import Wizard.ConfigWizard.VirtualDiskCreationDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ArraySelectionDialog
extends BaseConfigWizardDialog {
    private JLabel labelHotSpare;
    private JTree arrayTree = new JTree();
    private DefaultTreeModel arrayTreeModel;
    private DefaultTreeModel pdTreeModel;
    private JTree pdTree = new JTree();
    private DefaultMutableTreeNode arrayNdRoot = new DefaultMutableTreeNode();
    private PhysicalDriveHelper[] pdHelpers = new PhysicalDriveHelper[0];
    private ArrayList pdListForCurrentArray = new ArrayList();
    private JButton rightArrow = new JButton(Resource.getImage("RIGHT_ARROW", "rightarrow.jpg"));
    private JButton leftArrow = new JButton(Resource.getImage("LEFT_ARROW", "leftarrow.jpg"));
    private JButton acceptButton = new JButton(Resource.getString("ACCEPT_ARRAY", "Accept"));
    private JComboBox hspArray = new CustomComboBox();
    public static final int NEW_ARRAY_CREATED = 1;
    private static final int PD_IN_NEW_ARRAY = 2;
    public static final int NEW_ARRAY_TO_BE_CREATED = 3;
    public static final int PD_IN_OLD_ARRAY = -2;
    public static final int OLD_ARRAY = -1;
    private static final int ADAPTER_NODE = 4;
    private static final int PORT_NODE = 5;
    private static final int PD_HOT_SPARE = 6;
    private static final int ENCLOSURE_NODE = 7;
    int m_iEncryptionMethod = 0;

    public ArraySelectionDialog(BaseConfigEngine baseConfigEngine, int n) {
        super(baseConfigEngine);
        JComponent jComponent;
        Serializable serializable;
        JPanel jPanel;
        String[] stringArray = null;
        stringArray = Resource.getResourceMnemonic(Resource.getString("ACCEPT_ARRAY", "Accept"));
        this.hspArray.setToolTipText(Resource.getString("HOTSPEAR_ARRAY_DSC", "Hotspear Array"));
        this.acceptButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.acceptButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.setSelectedMode(n);
        this.acceptButton.setToolTipText(Resource.getString("ACCEPT_ARRAY_DSC", "Accept"));
        if (baseConfigEngine instanceof IRConfigEngine) {
            this.backButton.setEnabled(false);
        }
        this.refreshUnconfiguredPDList();
        this.refreshArraysWithSpace();
        this.arrayTree.setRootVisible(false);
        this.arrayTree.getSelectionModel().setSelectionMode(1);
        this.pdTree.setRootVisible(true);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADD_TEXT", "Add"));
        this.rightArrow.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.rightArrow.setMnemonic(stringArray[1].charAt(0));
        }
        this.rightArrow.setToolTipText(Resource.getString("BUTTON_ADD_DSC", "Add"));
        this.rightArrow.setHorizontalTextPosition(2);
        this.rightArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                byte by;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                if (!ArraySelectionDialog.this.engine.canCreateNewArray()) {
                    if (ArraySelectionDialog.this.engine instanceof IRConfigEngine) {
                        new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_NOMORE_ARRAY_INONESHOT", "No additional arrays may be created in this configuration."));
                    } else {
                        BaseConfigEngine cfr_ignored_0 = ArraySelectionDialog.this.engine;
                        new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_NOMORE_ARRAY", "No more array can be created : Maximum Number is : ") + BaseConfigEngine.MAX_ARRAYS);
                    }
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ArraySelectionDialog.this.arrayNdRoot.getChildAt(ArraySelectionDialog.this.arrayNdRoot.getChildCount() - 1);
                TreePath[] treePathArray = ArraySelectionDialog.this.pdTree.getSelectionPaths();
                if (treePathArray == null || treePathArray.length <= 0) {
                    return;
                }
                ArrayList<GUIData> arrayList = new ArrayList<GUIData>();
                for (n5 = 0; n5 < treePathArray.length; ++n5) {
                    GUIData gUIData = (GUIData)((DefaultMutableTreeNode)treePathArray[n5].getLastPathComponent()).getUserObject();
                    if (gUIData.flag != 2) continue;
                    arrayList.add(gUIData);
                }
                if (arrayList.size() <= 0) {
                    return;
                }
                n5 = 0;
                int n6 = ArraySelectionDialog.this.engine.getCurrentAdapter().getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
                int n7 = ArraySelectionDialog.this.engine.getCurrentAdapter().getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
                int n8 = ArraySelectionDialog.this.engine.getCurrentAdapter().getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
                if (ArraySelectionDialog.this.pdListForCurrentArray.size() <= 0) {
                    n4 = ((SASPhysicalDrive)((GUIData)arrayList.get((int)0)).value).getMediatype();
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        if (((SASPhysicalDrive)((GUIData)arrayList.get((int)n3)).value).getMediatype() == n4) continue;
                        n5 = 1;
                        if (n6 != 0) continue;
                        StringBuffer stringBuffer = new StringBuffer(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix "));
                        stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_SSD", "SSD "));
                        stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with "));
                        stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_NON_SSD", "non-SSD "));
                        stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives."));
                        String string = stringBuffer.toString();
                        new CustomMsgBox(string);
                        return;
                    }
                    if (n4 == 1 && n5 == 0) {
                        n3 = ((SASPhysicalDrive)((GUIData)arrayList.get((int)0)).value).getDriveType();
                        for (n2 = 0; n2 < arrayList.size(); ++n2) {
                            if (((SASPhysicalDrive)((GUIData)arrayList.get((int)n2)).value).getDriveType() == n3 || n7 != 0) continue;
                            StringBuffer stringBuffer = new StringBuffer(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix "));
                            stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_SSD_SAS", "SSD(SAS) "));
                            stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with "));
                            stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_SSD_SATA", "SSD(SATA) "));
                            stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives."));
                            String string = stringBuffer.toString();
                            new CustomMsgBox(string);
                            return;
                        }
                    }
                    if (n8 == 0 || ArraySelectionDialog.this.engine instanceof IRConfigEngine) {
                        n3 = ((SASPhysicalDrive)((GUIData)arrayList.get((int)0)).value).getDriveType();
                        n2 = ((SASPhysicalDrive)((GUIData)arrayList.get((int)0)).value).getMediatype();
                        for (n = 0; n < arrayList.size(); ++n) {
                            by = ((SASPhysicalDrive)((GUIData)arrayList.get((int)n)).value).getDriveType();
                            if (n2 != 0 || ((SASPhysicalDrive)((GUIData)arrayList.get((int)n)).value).getMediatype() != 0 || by == n3) continue;
                            new CustomMsgBox(Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array."));
                            return;
                        }
                    }
                } else {
                    if (((SASPhysicalDrive)ArraySelectionDialog.this.pdListForCurrentArray.get(0)).getInformation().getUserDataBlockSize() != ((SASPhysicalDrive)((GUIData)arrayList.get((int)0)).value).getInformation().getUserDataBlockSize()) {
                        return;
                    }
                    for (n4 = 0; n4 < ArraySelectionDialog.this.pdListForCurrentArray.size(); ++n4) {
                        n3 = ((SASPhysicalDrive)ArraySelectionDialog.this.pdListForCurrentArray.get(n4)).getMediatype();
                        n2 = ((SASPhysicalDrive)ArraySelectionDialog.this.pdListForCurrentArray.get(n4)).getDriveType();
                        for (n = 0; n < arrayList.size(); ++n) {
                            if (((SASPhysicalDrive)((GUIData)arrayList.get((int)n)).value).getMediatype() == n3) continue;
                            n5 = 1;
                            if (n6 != 0) continue;
                            StringBuffer stringBuffer = new StringBuffer(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix "));
                            stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_SSD", "SSD "));
                            stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with "));
                            stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_NON_SSD", "non-SSD "));
                            stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives."));
                            String string = stringBuffer.toString();
                            new CustomMsgBox(string);
                            return;
                        }
                        if (n3 == 1 && n5 == 0) {
                            for (n = 0; n < arrayList.size(); ++n) {
                                if (((SASPhysicalDrive)((GUIData)arrayList.get((int)n)).value).getDriveType() == n2 || n7 != 0) continue;
                                StringBuffer stringBuffer = new StringBuffer(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix "));
                                stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_SSD_SAS", "SSD(SAS) "));
                                stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with "));
                                stringBuffer.append(Resource.getString("TEXT_DRIVE_TYPE_SSD_SATA", "SSD(SATA) "));
                                stringBuffer.append(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives."));
                                String string = stringBuffer.toString();
                                new CustomMsgBox(string);
                                return;
                            }
                        }
                        if (n8 != 0 && !(ArraySelectionDialog.this.engine instanceof IRConfigEngine)) continue;
                        for (n = 0; n < arrayList.size(); ++n) {
                            by = ((SASPhysicalDrive)((GUIData)arrayList.get((int)n)).value).getDriveType();
                            if (ArraySelectionDialog.this.pdListForCurrentArray.size() <= 0) continue;
                            if (((SASPhysicalDrive)ArraySelectionDialog.this.pdListForCurrentArray.get(n4)).getMediatype() == 0 && ((SASPhysicalDrive)((GUIData)arrayList.get((int)n)).value).getMediatype() == 0) {
                                if (by == n2) continue;
                                new CustomMsgBox(Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array."));
                                return;
                            }
                            if (n6 != 0 || ((SASPhysicalDrive)ArraySelectionDialog.this.pdListForCurrentArray.get(n4)).getMediatype() == ((SASPhysicalDrive)((GUIData)arrayList.get((int)n)).value).getMediatype()) continue;
                            new CustomMsgBox(Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array."));
                            return;
                        }
                    }
                }
                BaseConfigEngine cfr_ignored_1 = ArraySelectionDialog.this.engine;
                if (defaultMutableTreeNode.getChildCount() + arrayList.size() > BaseConfigEngine.MAX_ROW_SIZE) {
                    BaseConfigEngine cfr_ignored_2 = ArraySelectionDialog.this.engine;
                    new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_MAXPDINARRAY_EXCEEDED", "No more Physical Drive can be added to this array : Maximum Number is : ") + BaseConfigEngine.MAX_ROW_SIZE);
                    return;
                }
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    ArraySelectionDialog.this.pdListForCurrentArray.add(((GUIData)arrayList.get((int)n4)).value);
                }
                ArraySelectionDialog.this.refreshArraysWithSpace();
                ArraySelectionDialog.this.refreshUnconfiguredPDList();
            }
        });
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVE_TEXT", "Remove"));
        this.leftArrow.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.leftArrow.setMnemonic(stringArray[1].charAt(0));
        }
        this.leftArrow.setHorizontalTextPosition(4);
        this.leftArrow.setToolTipText(Resource.getString("BUTTON_REMOVE_DSC", "Remove"));
        this.leftArrow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = ArraySelectionDialog.this.arrayTree.getLastSelectedPathComponent();
                if (object == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                GUIData gUIData = (GUIData)defaultMutableTreeNode.getUserObject();
                switch (gUIData.flag) {
                    case 3: {
                        ArraySelectionDialog.this.pdListForCurrentArray.clear();
                        break;
                    }
                    case 1: {
                        if (!CustomMsgBox.confirm(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_CONFIRM_ARRAYDELETE", "This will delete the Array. Are you sure ?"))) {
                            return;
                        }
                        try {
                            ((ArrayData)gUIData.value).deleteNewArray();
                        }
                        catch (IlligalConfigOperationException illigalConfigOperationException) {
                            new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_DELARRAY_ILLEGAL", "Cannot Delete new Array : Illegal Configuration Exception !"));
                            illigalConfigOperationException.printStackTrace();
                        }
                        catch (Exception exception) {
                            new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_DELARRAY_FAILED", "Cannot Delete new Array : Unknown Exception !"));
                            exception.printStackTrace();
                        }
                        break;
                    }
                    case 2: {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                        GUIData gUIData2 = (GUIData)defaultMutableTreeNode2.getUserObject();
                        if (gUIData2.flag == 3) {
                            ArraySelectionDialog.this.pdListForCurrentArray.remove(((GUIData)defaultMutableTreeNode.getUserObject()).value);
                            break;
                        }
                        ArrayData arrayData = (ArrayData)gUIData2.value;
                        if (ArraySelectionDialog.this.engine instanceof IRConfigEngine) {
                            BaseConfigEngine cfr_ignored_0 = ArraySelectionDialog.this.engine;
                            if (arrayData.getRowSize() <= BaseConfigEngine.MIN_ROW_SIZE) break;
                        }
                        if (!arrayData.isAnyLDDefinedOnThisArray()) {
                            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)((GUIData)defaultMutableTreeNode.getUserObject()).value;
                            try {
                                arrayData.deletePDFromArray(sASPhysicalDrive);
                            }
                            catch (Exception exception) {
                                new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_DELPDFROMARRAY_FAILED", "Cannot delete Physical Drive from the array !"));
                                exception.printStackTrace();
                            }
                            break;
                        }
                        new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_DELPDFROMARRAY_LDEXISTS", "Cannot delete Physical Drive from the array because one or more Virtual Disk is defined on this array!"));
                        break;
                    }
                }
                ArraySelectionDialog.this.refreshArraysWithSpace();
                ArraySelectionDialog.this.refreshUnconfiguredPDList();
            }
        });
        this.centerPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(Resource.getString("CONFIGURATION_NOTE", "<html>Note: Drives containing boot partitions or foreign configurations will not \nbe listed because they can not be used in new configurations.</html>"));
        this.centerPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout(20, 20));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_DRIVES", "Unconfigured Drives"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel2.setLabelFor(this.pdTree);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jLabel2, "North");
        jPanel3.add((Component)new JScrollPane(this.pdTree), "Center");
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.rightArrow);
        jPanel4.add((Component)jPanel5, "North");
        if (this.engine.getCurrentAdapter().getAdapterType() != 2 && this.engine.getCurrentAdapter().getAdapterType() != 3 && this.engine.getCurrentAdapter().getAdapterType() != 4) {
            this.hspArray.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (ArraySelectionDialog.this.hspArray.getSelectedIndex() <= 0) {
                        return;
                    }
                    ArrayData arrayData = (ArrayData)((GUIData)((ArraySelectionDialog)ArraySelectionDialog.this).hspArray.getSelectedItem()).value;
                    if (arrayData == null) {
                        return;
                    }
                    try {
                        GUIData gUIData = (GUIData)((DefaultMutableTreeNode)ArraySelectionDialog.this.pdTree.getLastSelectedPathComponent()).getUserObject();
                        if (gUIData.flag == 2) {
                            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)gUIData.value;
                            arrayData.addHotSpare(new SpareData(sASPhysicalDrive, true, ArraySelectionDialog.this.engine, '0'));
                        } else if (gUIData.flag == 6) {
                            SpareData spareData = (SpareData)gUIData.value;
                            arrayData.addHotSpare(spareData);
                        } else {
                            return;
                        }
                        ArraySelectionDialog.this.refreshArraysWithSpace();
                        ArraySelectionDialog.this.refreshUnconfiguredPDList();
                        ArraySelectionDialog.this.clearHotSpareCombo();
                    }
                    catch (Exception exception) {
                        new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_ADDHOTSPARE_FAILURE", "Can not add Hotspare to the array !"));
                        exception.printStackTrace();
                    }
                }
            });
            jPanel = new JPanel(new BorderLayout());
            this.clearHotSpareCombo();
            if (this.engine.getCurrentAdapter().getInformation().getadapterOperations_MR_CTRL_INFO().getdedicatedHotSpares() != 0) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_HOTSPARE_TEXT", "Hot Spare"));
                this.labelHotSpare = new JLabel(stringArray[0]);
                if (stringArray.length == 2) {
                    this.labelHotSpare.setDisplayedMnemonic(stringArray[1].charAt(0));
                }
                this.labelHotSpare.setLabelFor(this.hspArray);
                jPanel.add((Component)this.labelHotSpare, "North");
                jPanel.add((Component)this.hspArray, "Center");
            }
            this.pdTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    GUIData[] gUIDataArray;
                    ArraySelectionDialog.this.clearHotSpareCombo();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ArraySelectionDialog.this.pdTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    GUIData gUIData = (GUIData)defaultMutableTreeNode.getUserObject();
                    if (gUIData == null) {
                        return;
                    }
                    ArrayList<GUIData> arrayList = new ArrayList<GUIData>();
                    ArrayList arrayList2 = ArraySelectionDialog.this.engine.getArraysWithFreeSpaceRemaining();
                    if (gUIData.flag == 6) {
                        gUIDataArray = (GUIData[])gUIData.value;
                        object = gUIDataArray.arraysToWhichThisSpareIsDedicated();
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            ArrayData arrayData = (ArrayData)arrayList2.get(i);
                            Short s = new Short(arrayData.getSLArrayInfoT().getarray().getarrayRef());
                            if (((ArrayList)object).contains(s) || !arrayData.isPDEligibleForDHSP(gUIDataArray.getSASPhysicalDrive())) continue;
                            arrayList.add(new GUIData(arrayData, -1));
                        }
                    } else if (gUIData.flag == 2) {
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            object = (ArrayData)arrayList2.get(i);
                            if (!((ArrayData)object).isPDEligibleForDHSP((SASPhysicalDrive)gUIData.value)) continue;
                            arrayList.add(new GUIData(object, -1));
                        }
                    } else {
                        return;
                    }
                    gUIDataArray = new GUIData[arrayList.size() + 1];
                    gUIDataArray[0] = new GUIData(Resource.getString("LABEL_ADD_HSP", "-- Add Hotspare To --"), 0);
                    for (int i = 1; i < gUIDataArray.length; ++i) {
                        gUIDataArray[i] = (GUIData)arrayList.get(i - 1);
                    }
                    DefaultComboBoxModel<GUIData> defaultComboBoxModel = new DefaultComboBoxModel<GUIData>(gUIDataArray);
                    ArraySelectionDialog.this.hspArray.setModel(defaultComboBoxModel);
                    ArraySelectionDialog.this.hspArray.setSelectedIndex(0);
                    if (defaultComboBoxModel.getSize() > 1 && ArraySelectionDialog.this.pdTree.getSelectionCount() == 1) {
                        ArraySelectionDialog.this.hspArray.setEnabled(true);
                    }
                }
            });
            jPanel4.add((Component)jPanel, "Center");
        }
        jPanel2.add((Component)jPanel4, "South");
        this.centerPanel.add((Component)jPanel2, "West");
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(0, 20, 20, 20)));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        jPanel2.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 260 / 1024, 0));
        jPanel = new JPanel(new BorderLayout(20, 20));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ARRAY_TEXT", "Available Arrays"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel3.setLabelFor(this.arrayTree);
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)jLabel3, "North");
        jPanel6.add((Component)new JScrollPane(this.arrayTree), "Center");
        jPanel.add((Component)jPanel6, "Center");
        JPanel jPanel7 = new JPanel(new BorderLayout());
        JPanel jPanel8 = new JPanel();
        jPanel8.add(this.leftArrow);
        jPanel8.add(this.acceptButton);
        jPanel7.add((Component)jPanel8, "North");
        if (this.engine.getCurrentAdapter().getAdapterType() != 2) {
            serializable = new JPanel();
            stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_REMOVEHSP_TEXT", "Remove HotSpare"));
            jComponent = new JButton(stringArray[0]);
            if (stringArray.length == 2) {
                jComponent.setMnemonic(stringArray[1].charAt(0));
            }
            jComponent.setToolTipText(Resource.getString("BUTTON_REMOVEHSP_DSC", "Remove HotSpare"));
            jComponent.setEnabled(false);
            jComponent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ArraySelectionDialog.this.arrayTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    GUIData gUIData = (GUIData)defaultMutableTreeNode2.getUserObject();
                    if (gUIData.flag != 1 && gUIData.flag != -1) {
                        return;
                    }
                    GUIData gUIData2 = (GUIData)defaultMutableTreeNode.getUserObject();
                    if (gUIData2.flag != 6) {
                        return;
                    }
                    SpareData spareData = (SpareData)gUIData2.value;
                    ArrayData arrayData = (ArrayData)gUIData.value;
                    try {
                        arrayData.deleteHotSpare(spareData);
                    }
                    catch (Exception exception) {
                        new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_REMOVEHSP_FAILED", "Can not remove hotspare !"));
                        exception.printStackTrace();
                    }
                    ArraySelectionDialog.this.refreshArraysWithSpace();
                    ArraySelectionDialog.this.refreshUnconfiguredPDList();
                }
            });
            this.arrayTree.addTreeSelectionListener(new TreeSelectionListener((JButton)jComponent){
                final /* synthetic */ JButton val$removeHsp;
                {
                    this.val$removeHsp = jButton;
                }

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    this.val$removeHsp.setEnabled(false);
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ArraySelectionDialog.this.arrayTree.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode == null) {
                        return;
                    }
                    GUIData gUIData = (GUIData)defaultMutableTreeNode.getUserObject();
                    if (gUIData == null) {
                        return;
                    }
                    if (gUIData.flag == 6) {
                        this.val$removeHsp.setEnabled(true);
                    }
                }
            });
            if (this.engine.getCurrentAdapter().getInformation().getadapterOperations_MR_CTRL_INFO().getdedicatedHotSpares() != 0) {
                ((Container)serializable).add(jComponent);
            }
            jPanel7.add((Component)serializable, "South");
        }
        jPanel.add((Component)jPanel7, "South");
        this.centerPanel.add((Component)jPanel, "Center");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(0, 20, 20, 20)));
        serializable = new Dimension(MainFrame.SCREEN_SIZE.width * 120 / 1024, MainFrame.SCREEN_SIZE.height * 40 / 768);
        this.leftArrow.setPreferredSize((Dimension)serializable);
        this.rightArrow.setPreferredSize((Dimension)serializable);
        this.acceptButton.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 120 / 1024, MainFrame.SCREEN_SIZE.height * 40 / 768));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ArraySelectionDialog.this.pdListForCurrentArray == null || ArraySelectionDialog.this.pdListForCurrentArray.size() <= 0) {
                    return;
                }
                try {
                    byte by = 0;
                    if (BaseConfigWizardDialog.getAdapterHelper().isLockKeyAssigned()) {
                        int n = 0;
                        if (ArraySelectionDialog.this.engine.getNumArrays() == 1) {
                            n = 1;
                        } else if (ArraySelectionDialog.this.engine.getNumArrays() > 1) {
                            n = ArraySelectionDialog.this.engine.getNumArrays() - 1;
                        }
                        SelectEncryptionMethodDialog selectEncryptionMethodDialog = new SelectEncryptionMethodDialog(ArraySelectionDialog.this.pdListForCurrentArray, n);
                        by = selectEncryptionMethodDialog.getSelectedDriveSecurity();
                        List list = selectEncryptionMethodDialog.getSecuredFDEList();
                        if (by == -1) {
                            return;
                        }
                        if (by != 1) {
                            ArraySelectionDialog.this.removeSecuredFDEDrives(list);
                        }
                    }
                    ArrayData arrayData = ArraySelectionDialog.this.engine.createNewArray(ArraySelectionDialog.this.pdListForCurrentArray);
                    arrayData.setEncryptionType(by);
                    ArraySelectionDialog.this.pdListForCurrentArray.clear();
                }
                catch (MaxConfigLimitCrossedException maxConfigLimitCrossedException) {
                    new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_MAXCONFIG_EXCEEDED", "Can not create new Array : Maximum Configuration Limit Exceeded !"));
                }
                catch (IlligalConfigOperationException illigalConfigOperationException) {
                    new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_ILLEGAL_CONFIG", "Can not create new Array : Illegal Configuration Exception !"));
                }
                catch (UnsupportedConfigException unsupportedConfigException) {
                    new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_ARRAYCREATIONIR_FAILED", "Can not create new Array : At least 2 physical drives needed !"));
                }
                catch (Exception exception) {
                    new CustomMsgBox(ArraySelectionDialog.this.getContentPane(), Resource.getString("MSG_UNKNOWN", "Unknown Exception !"));
                }
                ArraySelectionDialog.this.refreshArraysWithSpace();
                ArraySelectionDialog.this.refreshUnconfiguredPDList();
            }
        });
        jComponent = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 == null) {
                    return this;
                }
                if (!(object2 instanceof GUIData)) {
                    return this;
                }
                switch (((GUIData)object2).flag) {
                    case -1: {
                        if (!VivaldiStartupDialog.isWindows) {
                            this.setForeground(Color.black);
                        }
                        this.setIcon(Resource.getImage("ARRAY_IMAGE", "array.jpg"));
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (!VivaldiStartupDialog.isWindows) {
                            this.setForeground(Color.blue);
                        }
                        this.setIcon(Resource.getImage("ARRAY_IMAGE", "array.jpg"));
                        break;
                    }
                    case -2: {
                        if (!VivaldiStartupDialog.isWindows) {
                            this.setForeground(Color.black);
                        }
                        this.setIcon(ArraySelectionDialog.this.getPdImage((SASPhysicalDrive)((GUIData)object2).value, 2));
                        break;
                    }
                    case 2: {
                        if (!VivaldiStartupDialog.isWindows) {
                            this.setForeground(Color.blue);
                        }
                        this.setIcon(ArraySelectionDialog.this.getPdImage((SASPhysicalDrive)((GUIData)object2).value, 2));
                        break;
                    }
                    case 4: {
                        this.setIcon(BaseConfigWizardDialog.getAdapterHelper().getIcon());
                        break;
                    }
                    case 5: {
                        this.setIcon(Resource.getImage("PORT_IMAGE", "port.jpg"));
                        break;
                    }
                    case 6: {
                        this.setIcon(ArraySelectionDialog.this.getPdImage(((SpareData)((GUIData)object2).value).getSASPhysicalDrive(), 5));
                        break;
                    }
                }
                return this;
            }
        };
        this.arrayTree.setCellRenderer((TreeCellRenderer)((Object)jComponent));
        this.pdTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 == null) {
                    return this;
                }
                if (!(object2 instanceof GUIData)) {
                    return this;
                }
                switch (((GUIData)object2).flag) {
                    case 2: {
                        if (!VivaldiStartupDialog.isWindows) {
                            this.setForeground(Color.blue);
                        }
                        this.setIcon(ArraySelectionDialog.this.getPdImage((SASPhysicalDrive)((GUIData)object2).value, 2));
                        break;
                    }
                    case 4: {
                        this.setIcon(BaseConfigWizardDialog.getAdapterHelper().getIcon());
                        break;
                    }
                    case 5: {
                        this.setIcon(Resource.getImage("PORT_IMAGE", "port.jpg"));
                        break;
                    }
                    case 6: {
                        this.setIcon(ArraySelectionDialog.this.getPdImage(((SpareData)((GUIData)object2).value).getSASPhysicalDrive(), 5));
                        break;
                    }
                    case 7: {
                        if (((EnclosureHelper)((GUIData)object2).value).isBackplane()) {
                            this.setIcon(Resource.getImage("BACKPLANE_IMAGE", "backplane.png"));
                            break;
                        }
                        this.setIcon(Resource.getImage("ENCLOSURE_IMAGE", "enclosure.png"));
                        break;
                    }
                }
                return this;
            }
        });
        this.pack();
        this.setSize(MainFrame.SCREEN_SIZE.width * 800 / 1024, MainFrame.SCREEN_SIZE.height * 600 / 768);
        this.show();
    }

    private void clearHotSpareCombo() {
        GUIData[] gUIDataArray = new GUIData[]{new GUIData(Resource.getString("LABEL_ADD_HSP", "-- Add Hotspare To --"), 0)};
        DefaultComboBoxModel<GUIData> defaultComboBoxModel = new DefaultComboBoxModel<GUIData>(gUIDataArray);
        this.hspArray.setModel(defaultComboBoxModel);
        this.hspArray.setEnabled(false);
    }

    @Override
    public void next() {
        if (this.engine.newLDCanBeAddedWithoutCreatingNewArrays() || this.engine.getNewlyCreatedLDs().size() > 0) {
            if (this.engine instanceof IRConfigEngine) {
                ArrayList arrayList = this.engine.getNewArraysCreated();
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (((ArrayData)arrayList.get(i)).getRowSize() >= 2) continue;
                    new CustomMsgBox(this, Resource.getString("MSG_INVALID_ARRAYSIZE", "Please Create arrays with at least 2 physical drives then go to next step !"));
                    return;
                }
                this.dispose();
                new IRVirtualDiskCreationDialog((IRConfigEngine)this.engine, this.getSelectedMode());
            } else {
                this.dispose();
                new VirtualDiskCreationDialog(this.engine, this.getSelectedMode());
            }
        } else {
            new CustomMsgBox(this, Resource.getString("MSG_NOLD_POSSIBLE", "Please Create at least one array then go to next step !"));
        }
    }

    @Override
    public void back() {
        this.dispose();
        new ModeSelectionDialog(this.engine, this.getSelectedMode());
    }

    @Override
    public int getStep() {
        return 1;
    }

    @Override
    public Object[] getStepNames(boolean bl) {
        if (bl) {
            Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP", "Mode (S)election"), Resource.getString("MANUAL_MODE_ARRAY", "(A)rray Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE", "V(i)rtual Disk Creation")};
            return objectArray;
        }
        Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP_1", "Mode Selection"), Resource.getString("MANUAL_MODE_ARRAY_1", "Array Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE_1", "Virtual Disk Creation")};
        return objectArray;
    }

    @Override
    public void goToStep(int n) {
        if (n == 0 && this.engine instanceof ConfigEngine) {
            this.back();
        } else if (n == 2) {
            this.next();
        }
    }

    private DefaultMutableTreeNode createArrayNode(ArrayData arrayData, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        int n;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GUIData(arrayData, bl ? -1 : 1));
        for (n = 0; n < arrayData.getConstituentPDList().size(); ++n) {
            object = (SASPhysicalDrive)arrayData.getConstituentPDList().get(n);
            if (object == null) continue;
            defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(object, bl ? -2 : 2, true));
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        for (n = 0; n < arrayData.getHotSparesNewlyDedicatedToThisArray().size(); ++n) {
            object = (SpareData)arrayData.getHotSparesNewlyDedicatedToThisArray().get(n);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(object, 6, true));
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        return defaultMutableTreeNode2;
    }

    private void refreshUnconfiguredPDList() {
        int n;
        SASAdapter sASAdapter = this.engine.getCurrentAdapter();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(sASAdapter, 4));
        PhysicalDriveHelper[] physicalDriveHelperArray = this.getPdHelpersForPdList(this.engine.getUnconfiguredPDList());
        if (physicalDriveHelperArray == null || physicalDriveHelperArray.length == 0 || this.pdListForCurrentArray.size() == physicalDriveHelperArray.length) {
            this.rightArrow.setEnabled(false);
        } else {
            this.rightArrow.setEnabled(true);
        }
        EnclosureHelper[] enclosureHelperArray = ArraySelectionDialog.getAdapterHelper().getEnclosures();
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[enclosureHelperArray.length];
        for (n = 0; n < enclosureHelperArray.length; ++n) {
            defaultMutableTreeNodeArray[n] = new DefaultMutableTreeNode(new GUIData(enclosureHelperArray[n], 7));
            defaultMutableTreeNode.add(defaultMutableTreeNodeArray[n]);
        }
        for (n = 0; n < physicalDriveHelperArray.length; ++n) {
            pdType_MR_PD_INFO pdType_MR_PD_INFO2;
            if (this.pdListForCurrentArray.contains((SASPhysicalDrive)physicalDriveHelperArray[n].getDeviceObject()) || (pdType_MR_PD_INFO2 = ((SASPhysicalDrive)physicalDriveHelperArray[n].getDeviceObject()).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1()).getisForeign() == 1) continue;
            if (physicalDriveHelperArray[n].getEnclosureID() == -1) {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(new GUIData((SASPhysicalDrive)physicalDriveHelperArray[n].getDeviceObject(), 2)));
                continue;
            }
            for (int i = 0; i < defaultMutableTreeNodeArray.length; ++i) {
                if (physicalDriveHelperArray[n].getEnclosureID() != ((SASEnclosure)enclosureHelperArray[i].getDeviceObject()).getInformation().getenclDeviceId() || physicalDriveHelperArray[n].getEnclosureID() == -1 || defaultMutableTreeNodeArray[i] == null) continue;
                defaultMutableTreeNodeArray[i].add(new DefaultMutableTreeNode(new GUIData((SASPhysicalDrive)physicalDriveHelperArray[n].getDeviceObject(), 2)));
            }
        }
        this.pdTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.pdTree.setModel(this.pdTreeModel);
        ArraySelectionDialog.expandTree(this.pdTree);
        this.validate();
    }

    private void refreshArraysWithSpace() {
        ArrayList arrayList = this.engine.getOldArraysWithSpace();
        this.arrayNdRoot = new DefaultMutableTreeNode();
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayData arrayData = (ArrayData)arrayList.get(i);
            if (arrayData == null || arrayData.getRowSize() != arrayData.getRowSizeFromFW()) continue;
            this.arrayNdRoot.add(this.createArrayNode(arrayData, true));
        }
        ArrayList arrayList2 = this.engine.getNewArraysCreated();
        for (int i = 0; i < arrayList2.size(); ++i) {
            ArrayData arrayData = (ArrayData)arrayList2.get(i);
            if (arrayData == null) continue;
            this.arrayNdRoot.add(this.createArrayNode(arrayData, false));
        }
        if (this.engine.canCreateNewArray() && this.engine.getUnconfiguredPDList().size() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(Resource.getString("NEW_ARRAY_TEXT", "New Array"), 3));
            if (this.pdListForCurrentArray.size() > 0) {
                for (int i = 0; i < this.pdListForCurrentArray.size(); ++i) {
                    GUIData gUIData = new GUIData(this.pdListForCurrentArray.get(i), 2);
                    defaultMutableTreeNode.add(new DefaultMutableTreeNode(gUIData));
                }
            }
            this.arrayNdRoot.add(defaultMutableTreeNode);
            this.acceptButton.setEnabled(true);
        } else {
            this.acceptButton.setEnabled(false);
        }
        if (this.pdListForCurrentArray == null || this.pdListForCurrentArray.size() == 0) {
            this.acceptButton.setEnabled(false);
        } else {
            this.acceptButton.setEnabled(true);
        }
        if (this.pdListForCurrentArray != null && this.pdListForCurrentArray.size() > 0) {
            this.nextButton.setEnabled(false);
        } else if (arrayList.size() != 0 || arrayList2.size() != 0) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
        if (arrayList2.size() > 0 || this.pdListForCurrentArray != null && this.pdListForCurrentArray.size() > 0) {
            this.leftArrow.setEnabled(true);
        } else {
            this.leftArrow.setEnabled(false);
        }
        this.arrayTreeModel = new DefaultTreeModel(this.arrayNdRoot);
        this.arrayTree.setModel(this.arrayTreeModel);
        ArraySelectionDialog.expandTree(this.arrayTree);
        this.arrayTree.repaint();
    }

    @Override
    public String getStatus() {
        return Resource.getString("MSG_STATUS_ARRAYSEL", "Select one or more physical drive(s) and use the right arrow to move them to the right panel to create arrays");
    }

    @Override
    public String getHelpPage() {
        switch (this.getSelectedMode()) {
            case 2: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_MANUAL_DIALOG");
            }
            case 1: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_AUTO_DIALOG");
            }
            case 3: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_GUIDED_DIALOG");
            }
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }

    @Override
    public boolean warningDialog() {
        if (this.engine.getNewArraysCreated().size() > 0) {
            return CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_WARNING_DIALOG", "Do you want to close the window ?"));
        }
        return true;
    }

    public boolean isOSDrive(SASLogicalDrive sASLogicalDrive) {
        boolean bl = false;
        try {
            SL_PARTITION_INFO_T sL_PARTITION_INFO_T = sASLogicalDrive.getPartitionInfo();
            SL_PARTITION_DETAILS_T[] sL_PARTITION_DETAILS_TArray = sL_PARTITION_INFO_T.getPartitionDetails();
            for (int i = 0; i < sL_PARTITION_INFO_T.getPartitionCount(); ++i) {
                if (sL_PARTITION_DETAILS_TArray[i].getBootIndicator() != 1) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    private boolean isEncryptionPossible(SASAdapter sASAdapter, ArrayList arrayList) {
        return !this.isFDEOnlySet(sASAdapter) || this.isFDECapableDriveGroup(arrayList);
    }

    private boolean isFDEOnlySet(SASAdapter sASAdapter) {
        return sASAdapter.getUseFDEOnly();
    }

    private boolean isFDECapableDriveGroup(ArrayList arrayList) {
        boolean bl = true;
        for (SASPhysicalDrive sASPhysicalDrive : arrayList) {
            if (sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public ImageIcon getPdImage(SASPhysicalDrive sASPhysicalDrive, int n) {
        boolean bl = sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable();
        if (n == 5) {
            if (bl) {
                return Resource.getImage("HOTSPARE_FDE_IMAGE", "hotspare_fde.png");
            }
            return Resource.getImage("HOTSPARE_IMAGE", "hotspare.png");
        }
        if (bl) {
            return Resource.getImage("DRIVE_FDE_LOCK_IMAGE", "fde_locked.png");
        }
        if (sASPhysicalDrive.getState() == 0 || sASPhysicalDrive.getState() == 1) {
            return Resource.getImage("UNCONFIGURED_IMAGE", "unconfigured.png");
        }
        if (sASPhysicalDrive.getState() == 24) {
            return Resource.getImage("CONFIGURED_IMAGE", "configured.png");
        }
        return Resource.getImage("PHDRIVE_IMAGE", "phdrive.png");
    }

    protected PhysicalDriveHelper[] getPdHelpersForPdList(ArrayList arrayList) {
        PhysicalDriveHelper[] physicalDriveHelperArray = new PhysicalDriveHelper[arrayList.size()];
        PhysicalDriveHelper[] physicalDriveHelperArray2 = ArraySelectionDialog.getAdapterHelper().getPhysicalDrives();
        int n = 0;
        for (int i = 0; i < physicalDriveHelperArray2.length; ++i) {
            if (!arrayList.contains((SASPhysicalDrive)physicalDriveHelperArray2[i].getDeviceObject())) continue;
            physicalDriveHelperArray[n++] = physicalDriveHelperArray2[i];
        }
        return physicalDriveHelperArray;
    }

    private void removeSecuredFDEDrives(List list) {
        DefaultTreeModel defaultTreeModel;
        int n;
        if (list != null && list.size() > 0 && (n = (defaultTreeModel = (DefaultTreeModel)this.arrayTree.getModel()).getChildCount(this.arrayNdRoot)) > 0) {
            for (int i = 0; i < n; ++i) {
                int n2;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.arrayNdRoot.getChildAt(i);
                GUIData gUIData = (GUIData)defaultMutableTreeNode.getUserObject();
                if (gUIData == null) continue;
                TreePath treePath = null;
                if (gUIData.flag != 3 || (n2 = defaultMutableTreeNode.getChildCount()) <= 0) continue;
                for (int j = 0; j < n2; ++j) {
                    SASPhysicalDrive sASPhysicalDrive;
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j);
                    GUIData gUIData2 = (GUIData)defaultMutableTreeNode2.getUserObject();
                    if (gUIData2 == null || gUIData2.flag != 2 || !list.contains((sASPhysicalDrive = (SASPhysicalDrive)gUIData2.value).getDeviceId())) continue;
                    treePath = new TreePath(defaultMutableTreeNode2.getPath());
                    this.arrayTree.setSelectionPath(treePath);
                    this.leftArrow.doClick();
                }
            }
        }
    }
}

