/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.DrivesSpinUpProgressDialog;
import GUI.VivaldiStartupDialog;
import GUI.security.ConfirmCtrlEncryptionDialog;
import GUI.security.ConfirmFDEDialog;
import GUI.security.DrivesUsingFDEDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.AutoConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.LibraryAPI.StoreLib.MR_CTRL_INFO;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomComboBox;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.ArraySelectionDialog;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import Wizard.ConfigWizard.GUIData;
import Wizard.ConfigWizard.ModeSelectionDialog;
import Wizard.ConfigWizard.VirtualDiskCreationDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class AutoConfigWizardDialog
extends BaseConfigWizardDialog {
    private JTree summaryTree = new JTree();
    private ConfigEngine m_objConfigEngine;
    private AdapterHelper m_adapterHelper;
    private JComboBox autoMode = new CustomComboBox(new Object[]{Resource.getString("LABEL_NOREDUNDANCY_TEXT", "No Redundancy"), Resource.getString("LABEL_WITHREDUNDANCY_TEXT", "With Redundancy")});
    private JComboBox initState = new CustomComboBox(new Object[]{new GUIData(Resource.getString("NO_INIT_TEXT", "No Initialization"), 0), new GUIData(Resource.getString("QUICK_INIT_TEXT", "Fast Initialization"), 1), new GUIData(Resource.getString("FULL_INIT_TEXT", "Full Initialization"), 2)});
    private JComboBox cbEncryption = null;

    public AutoConfigWizardDialog(ConfigEngine configEngine, int n) {
        super(configEngine);
        String[] stringArray = null;
        this.m_objConfigEngine = configEngine;
        this.setSelectedMode(n);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_FINISH_TEXT", "Finish"));
        this.nextButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.nextButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_MODIFY_TEXT", "Modify"));
        this.backButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.backButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.centerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.summaryTree.setCellRenderer(this.renderer);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_LDSUMMARY_TEXT", "Virtual Disk Summary"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel.setLabelFor(this.summaryTree);
        this.centerPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.centerPanel.add((Component)new JScrollPane(this.summaryTree), gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_INITIALIZATION_TEXT", "Initialization Type:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel2.setLabelFor(this.initState);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        jPanel.add((Component)this.initState, gridBagConstraints2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_REDUNDANCY_TEXT", "Redundancy Type :"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel3.setLabelFor(this.autoMode);
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        jPanel.add((Component)this.autoMode, gridBagConstraints2);
        this.autoMode.setToolTipText(Resource.getString("AUTO_MODE_DSC", "Auto Mode"));
        SASAdapter sASAdapter = this.m_objConfigEngine.getCurrentAdapter();
        MR_CTRL_INFO mR_CTRL_INFO = sASAdapter.getInformation();
        if (mR_CTRL_INFO.getadapterOperations_MR_CTRL_INFO().isSupportSecurity()) {
            boolean bl = mR_CTRL_INFO.getAdapterStatus_MR_CTRL_INFO().isLockKeyAssigned();
            boolean bl2 = mR_CTRL_INFO.getproperties().getOnOffProperties_MR_CTRL_PROP().getUseFdeOnly();
            Vector<GUIData> vector = new Vector<GUIData>();
            if (bl) {
                if (bl2) {
                    vector.add(new GUIData(Resource.getString("TEXT_FDE_WHEN_POSSIBLE", "Full Disk Encryption (FDE) when possible"), 1));
                    vector.add(new GUIData(Resource.getString("TEXT_NO_ENCRYPTION", "No Encryption"), 0));
                } else {
                    boolean bl3 = false;
                    ArrayList arrayList = configEngine.getUnconfiguredPDList();
                    if (arrayList != null && arrayList.size() > 0) {
                        int n2 = arrayList.size();
                        for (int i = 0; i < n2; ++i) {
                            MR_PD_INFO mR_PD_INFO = ((SASPhysicalDrive)arrayList.get(i)).getInformation();
                            if (!mR_PD_INFO.getSecurity_MR_PD_INFO().getFDECapable()) continue;
                            bl3 = true;
                            break;
                        }
                    }
                    if (bl3) {
                        vector.add(new GUIData(Resource.getString("TEXT_FDE_WHEN_POSSIBLE", "Full Disk Encryption (FDE) when possible"), 1));
                    }
                    vector.add(new GUIData(Resource.getString("TEXT_CONTROLLER_BASED", "Controller-based only"), 2));
                    vector.add(new GUIData(Resource.getString("TEXT_NO_ENCRYPTION", "No Encryption"), 0));
                }
            } else {
                vector.add(new GUIData(Resource.getString("TEXT_NO_ENCRYPTION", "No Encryption"), 0));
            }
            this.cbEncryption = new CustomComboBox((Vector)vector);
            this.cbEncryption.setEnabled(bl);
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ENCRYPTION_TEXT", "Drive Se(c)urity Method:"));
            JLabel jLabel4 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel4.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            jLabel4.setLabelFor(this.cbEncryption);
            gridBagConstraints2.gridy = 2;
            gridBagConstraints2.gridx = 0;
            jPanel.add((Component)jLabel4, gridBagConstraints2);
            gridBagConstraints2.gridx = 1;
            jPanel.add((Component)this.cbEncryption, gridBagConstraints2);
        }
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.centerPanel.add((Component)jPanel, gridBagConstraints);
        this.autoMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (AutoConfigWizardDialog.this.autoMode.getSelectedIndex() < 0) {
                    return;
                }
                AutoConfigWizardDialog.this.autoConfigure(AutoConfigWizardDialog.this.autoMode.getSelectedIndex() == 1);
            }
        });
        this.autoMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AutoConfigWizardDialog.this.autoMode.getSelectedIndex() < 0) {
                    return;
                }
                AutoConfigWizardDialog.this.autoConfigure(AutoConfigWizardDialog.this.autoMode.getSelectedIndex() == 1);
            }
        });
        this.initState.setToolTipText(Resource.getString("INIT_STATE_DSC", "intialization stage"));
        if (this.cbEncryption != null) {
            this.cbEncryption.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n = AutoConfigWizardDialog.this.cbEncryption.getSelectedIndex();
                    if (n < 0) {
                        return;
                    }
                    AutoConfigWizardDialog.this.autoConfigure(AutoConfigWizardDialog.this.autoMode.getSelectedIndex() == 1);
                }
            });
        }
        this.autoConfigure(false);
        this.show();
    }

    @Override
    public int getStep() {
        return 3;
    }

    private void autoConfigure(boolean bl) {
        String string = Resource.getString("AUTO_VD_NAME", "Auto VD ");
        try {
            Object object;
            this.engine = new AutoConfigEngine(this.engine.getCurrentAdapter());
            if (((AutoConfigEngine)this.engine).isRedundancyPossible()) {
                this.autoMode.setEnabled(true);
            } else {
                this.autoMode.setEnabled(false);
            }
            ((AutoConfigEngine)this.engine).setOEM(VivaldiStartupDialog.OEM_TYPE);
            byte by = 0;
            if (this.cbEncryption != null) {
                object = (GUIData)this.cbEncryption.getSelectedItem();
                by = (byte)((GUIData)object).flag;
            }
            ((AutoConfigEngine)this.engine).doAutoConfig(bl, string, by);
            object = this.engine.getNewlyCreatedLDs();
            int n = ((GUIData)this.initState.getSelectedItem()).flag;
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                LDData lDData = (LDData)((ArrayList)object).get(i);
                lDData.setInitState((byte)n);
            }
        }
        catch (MaxConfigLimitCrossedException maxConfigLimitCrossedException) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_MAXCONFIG_EXCEEDED", "Max Configuration limit exceeded !"));
            maxConfigLimitCrossedException.printStackTrace();
        }
        catch (ConfigurationNotAllowedException configurationNotAllowedException) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_CONFIG_NOTALLOWED", "Configuration on this adapter is not allowed !"));
            configurationNotAllowedException.printStackTrace();
        }
        catch (Exception exception) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_AUTOCONFIG_FAILED", "Auto Configuration failed !"));
            exception.printStackTrace();
        }
        this.refreshLDSummary();
    }

    @Override
    public void next() {
        try {
            Object object;
            Object object2;
            byte by = 0;
            if (this.cbEncryption != null) {
                object2 = (GUIData)this.cbEncryption.getSelectedItem();
                by = (byte)((GUIData)object2).flag;
            }
            if (((AdapterHelper)(object2 = BaseConfigWizardDialog.getAdapterHelper())).isLockKeyAssigned()) {
                AbstractList abstractList;
                if (by == 1) {
                    ConfirmFDEDialog confirmFDEDialog;
                    object = BaseConfigWizardDialog.getAdapterHelper().getPhysicalDrives();
                    abstractList = new Vector();
                    if (object != null && ((PhysicalDriveHelper[])object).length > 0) {
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            SASPhysicalDrive sASPhysicalDrive;
                            if (((PhysicalDriveHelper)object[i]).isFDECapable() || (sASPhysicalDrive = (SASPhysicalDrive)((PhysicalDriveHelper)object[i]).getDeviceObject()).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1().getisGlobalSpare() != 1) continue;
                            ((Vector)abstractList).add(object[i]);
                        }
                    }
                    if (((Vector)abstractList).size() > 0 && (confirmFDEDialog = new ConfirmFDEDialog((Window)this, (Vector)abstractList)).getSelectedOption() != 0) {
                        return;
                    }
                } else {
                    object = new ArrayList();
                    abstractList = this.m_objConfigEngine.getUnconfiguredPDList();
                    if (abstractList != null && abstractList.size() > 0) {
                        int n = abstractList.size();
                        for (int i = 0; i < n; ++i) {
                            MR_PD_INFO mR_PD_INFO = ((SASPhysicalDrive)abstractList.get(i)).getInformation();
                            if (!mR_PD_INFO.getSecurity_MR_PD_INFO().getSecured()) continue;
                            object.add(abstractList.get(i));
                        }
                    }
                    if (object.size() > 0) {
                        Vector<PhysicalDriveHelper> vector = new Vector<PhysicalDriveHelper>();
                        PhysicalDriveHelper[] physicalDriveHelperArray = ((AdapterHelper)object2).getPhysicalDrives();
                        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                            if (!object.contains(physicalDriveHelperArray[i].getDeviceObject())) continue;
                            vector.add(physicalDriveHelperArray[i]);
                        }
                        if (abstractList != null) {
                            DrivesUsingFDEDialog drivesUsingFDEDialog = new DrivesUsingFDEDialog((Window)this, vector, object.size() != abstractList.size());
                            if (object.size() == abstractList.size()) {
                                return;
                            }
                            if (drivesUsingFDEDialog.getSelectedOption() != 0) {
                                return;
                            }
                        }
                    }
                }
            }
            this.autoConfigure(this.autoMode.getSelectedIndex() == 1);
            if (((AdapterHelper)object2).isLockKeyAssigned() && by == 2) {
                ConfirmCtrlEncryptionDialog confirmCtrlEncryptionDialog;
                object = this.engine.getNewArraysCreated();
                boolean bl = false;
                if (object != null && ((ArrayList)object).size() > 0) {
                    for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                        ArrayData arrayData = (ArrayData)((ArrayList)object).get(i);
                        if (!arrayData.isFDEOnlyDriveGroup()) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl && (confirmCtrlEncryptionDialog = new ConfirmCtrlEncryptionDialog((Window)this, -1)).getSelectedOption() != 0) {
                    return;
                }
            }
            if (this.engine.getCurrentAdapter().getInformation().getpdOperations_MR_CTRL_INFO().isPowerStateForConfig() && (object = this.engine.getPhysicalDrivesInPowerSaveMode()).size() > 0) {
                System.out.println("Before calling DrivesSpinUpProgressDialog.");
                DrivesSpinUpProgressDialog drivesSpinUpProgressDialog = new DrivesSpinUpProgressDialog(this.engine.getCurrentAdapter(), (List)object);
                System.out.println("After calling DrivesSpinUpProgressDialog.");
            }
            this.engine.writeConfiguration();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            CustomMsgBox.errorMsg(vKOperationFailedException);
            vKOperationFailedException.printStackTrace();
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            new CustomMsgBox(this, Resource.getString("MSG_DEVNOT_RESPONDING", "Device not responding !"));
            vKNotRespondingException.printStackTrace();
        }
        catch (Exception exception) {
            new CustomMsgBox(this, Resource.getString("MSG_CONFIG_FAILED", "Can not write configuraion : Unknown Exception !"));
            exception.printStackTrace();
        }
        flag = 0;
        this.dispose();
    }

    @Override
    public void back() {
        this.dispose();
        new VirtualDiskCreationDialog(this.engine, this.getSelectedMode());
    }

    @Override
    public void goToStep(int n) {
        if (n == 0 && this.engine instanceof ConfigEngine) {
            this.dispose();
            new ModeSelectionDialog(this.engine, this.getSelectedMode());
        } else if (n == 1) {
            this.dispose();
            new ArraySelectionDialog(this.engine, this.getSelectedMode());
        } else if (n == 2) {
            this.dispose();
            new VirtualDiskCreationDialog(this.engine, this.getSelectedMode());
        } else if (n == 3) {
            this.next();
        }
    }

    @Override
    public Object[] getStepNames(boolean bl) {
        if (bl) {
            Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP", "Mode (S)election"), Resource.getString("MANUAL_MODE_ARRAY", "(A)rray Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE", "V(i)rtual Disk Creation"), Resource.getString("AUTO_MODE_FINISH", "Fi(n)ish")};
            return objectArray;
        }
        Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP_1", "Mode Selection"), Resource.getString("MANUAL_MODE_ARRAY_1", "Array Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE_1", "Virtual Disk Creation"), Resource.getString("AUTO_MODE_FINISH_1", "Finish")};
        return objectArray;
    }

    private void refreshLDSummary() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.returnRootForRefreshLDSummary();
        this.summaryTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        AutoConfigWizardDialog.expandTree(this.summaryTree);
    }

    @Override
    public String getStatus() {
        return Resource.getString("MSG_STATUS_AUTOCONFIG", "Select modify to make desired changes to auto configuration parameters or Select Finish to complete Auto Configuration Wizard.");
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_AUTO_DIALOG");
    }

    @Override
    public boolean warningDialog() {
        return CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_WARNING_DIALOG", "Do you want to close the window ?"));
    }
}

