/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.DrivesSpinUpProgressDialog;
import GUI.MainFrame;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.AssistedConfigEngine;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.IRConfigHelper.IRConfigEngine;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.ArraySelectionDialog;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import Wizard.ConfigWizard.GUIData;
import Wizard.ConfigWizard.GuidedConfigDialog;
import Wizard.ConfigWizard.IRVirtualDiskCreationDialog;
import Wizard.ConfigWizard.ModeSelectionDialog;
import Wizard.ConfigWizard.VirtualDiskCreationDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class FinishWizardDialog
extends BaseConfigWizardDialog {
    private String[] mnemonics;
    private JTree unusedArrayTree = new JTree();
    private JTree summaryTree = new JTree();
    private boolean isGuidedMode;
    private ArrayList unusedArrays;

    public FinishWizardDialog(BaseConfigEngine baseConfigEngine, boolean bl, int n) {
        super(baseConfigEngine);
        JPanel jPanel;
        this.setSelectedMode(n);
        this.isGuidedMode = bl;
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_FINISH_TEXT", "Finish"));
        this.nextButton.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.nextButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.centerPanel.setLayout(new BorderLayout());
        this.refreshUnusedArrays();
        this.unusedArrayTree.setCellRenderer(this.renderer);
        this.refreshLDSummary();
        this.summaryTree.setCellRenderer(this.renderer);
        if (this.unusedArrays.size() > 0) {
            jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("LABEL_UNUSEDARRAYS_TEXT", "Unused Arrays")));
            jPanel.add(new JScrollPane(this.unusedArrayTree));
            jPanel.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 150 / 1024, 0));
            this.centerPanel.add((Component)jPanel, "East");
        }
        jPanel = new JPanel(new BorderLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_LDSUMMARY_TEXT", "Virtual Disk Summary"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jLabel.setLabelFor(this.summaryTree);
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)new JScrollPane(this.summaryTree), "Center");
        this.centerPanel.add((Component)jPanel, "Center");
        if (bl) {
            this.bottomPanel.removeAll();
            this.bottomPanel.add(this.cancelButton);
            this.bottomPanel.add(this.backButton);
            this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_MODIFY_TEXT", "Modify"));
            JButton jButton = new JButton(this.mnemonics[0]);
            if (this.mnemonics.length == 2) {
                jButton.setMnemonic(this.mnemonics[1].charAt(0));
            }
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FinishWizardDialog.this.dispose();
                    new VirtualDiskCreationDialog(FinishWizardDialog.this.engine, FinishWizardDialog.this.getSelectedMode());
                }
            });
            jButton.setToolTipText(Resource.getString("BUTTON_MODIFY_DSC", "Modify"));
            this.bottomPanel.add(jButton);
            this.bottomPanel.add(this.nextButton);
        }
        this.pack();
        this.setSize(MainFrame.SCREEN_SIZE.width * 800 / 1024, MainFrame.SCREEN_SIZE.height * 600 / 768);
        this.show();
    }

    @Override
    public void back() {
        this.dispose();
        if (this.isGuidedMode) {
            try {
                this.engine.deleteEveryThing();
            }
            catch (Exception exception) {
                new CustomMsgBox(this, Resource.getString("MSG_CONFIG_CORRUPTED", "Configuration Corrupted !"));
                exception.printStackTrace();
                return;
            }
            try {
                this.engine = new AssistedConfigEngine(this.engine.getCurrentAdapter());
            }
            catch (Exception exception) {
                // empty catch block
            }
            new GuidedConfigDialog((ConfigEngine)this.engine, this.getSelectedMode());
        } else if (this.engine.getCurrentAdapter().getAdapterType() == 2 || this.engine.getCurrentAdapter().getAdapterType() == 3 || this.engine.getCurrentAdapter().getAdapterType() == 4) {
            new IRVirtualDiskCreationDialog((IRConfigEngine)this.engine, this.getSelectedMode());
        } else {
            new VirtualDiskCreationDialog(this.engine, this.getSelectedMode());
        }
    }

    @Override
    public void next() {
        try {
            List list;
            if (this.engine.getCurrentAdapter().getInformation().getpdOperations_MR_CTRL_INFO().isPowerStateForConfig() && (list = this.engine.getPhysicalDrivesInPowerSaveMode()).size() > 0) {
                System.out.println("Before calling DrivesSpinUpProgressDialog.");
                DrivesSpinUpProgressDialog drivesSpinUpProgressDialog = new DrivesSpinUpProgressDialog(this.engine.getCurrentAdapter(), list);
                System.out.println("After calling DrivesSpinUpProgressDialog.");
            }
            this.engine.writeConfiguration();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            CustomMsgBox.errorMsg(vKOperationFailedException);
            vKOperationFailedException.printStackTrace();
        }
        catch (VKNotRespondingException vKNotRespondingException) {
            new CustomMsgBox(this, Resource.getString("MSG_DEVNOT_RESPONDING", "Device not responding !"));
            vKNotRespondingException.printStackTrace();
        }
        catch (Exception exception) {
            new CustomMsgBox(this, Resource.getString("MSG_CONFIG_FAILED", "Can not write configuraion : Unknown Exception !"));
            exception.printStackTrace();
        }
        flag = 0;
        this.dispose();
    }

    @Override
    public int getStep() {
        return 3;
    }

    @Override
    public Object[] getStepNames(boolean bl) {
        if (bl) {
            Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP", "Mode (S)election"), Resource.getString("MANUAL_MODE_ARRAY", "(A)rray Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE", "V(i)rtual Disk Creation"), Resource.getString("MANUAL_MODE_FINISH", "Fi(n)ish")};
            return objectArray;
        }
        Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP_1", "Mode Selection"), Resource.getString("MANUAL_MODE_ARRAY_1", "Array Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE_1", "Virtual Disk Creation"), Resource.getString("MANUAL_MODE_FINISH_1", "Finish")};
        return objectArray;
    }

    @Override
    public void goToStep(int n) {
        if (n == 0 && this.engine instanceof ConfigEngine) {
            this.dispose();
            new ModeSelectionDialog(this.engine, this.getSelectedMode());
        } else if (n == 1) {
            this.dispose();
            new ArraySelectionDialog(this.engine, this.getSelectedMode());
        } else if (n == 2) {
            this.back();
        }
    }

    private void refreshUnusedArrays() {
        this.unusedArrays = this.engine.getListOfUnusedNewlyCreatedArraysIfIWriteConfigNOW();
        if (this.unusedArrays.size() <= 0) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(Resource.getString("UNUSED_ARRAYS_TEXT", "Unused Arrays"), 0));
        for (int i = 0; i < this.unusedArrays.size(); ++i) {
            ArrayData arrayData = (ArrayData)this.unusedArrays.get(i);
            defaultMutableTreeNode.add(this.populateArrayNode(arrayData));
        }
        this.unusedArrayTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        FinishWizardDialog.expandTree(this.unusedArrayTree);
    }

    private void refreshLDSummary() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.returnRootForRefreshLDSummary();
        this.summaryTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        FinishWizardDialog.expandTree(this.summaryTree);
    }

    @Override
    public String getStatus() {
        return Resource.getString("MSG_STATUS_FINISH", "View the summary and finally press Finish to write the configuration");
    }

    @Override
    public String getHelpPage() {
        switch (this.getSelectedMode()) {
            case 2: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_MANUAL_DIALOG");
            }
            case 1: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_AUTO_DIALOG");
            }
            case 3: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_GUIDED_DIALOG");
            }
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }

    @Override
    public boolean warningDialog() {
        return CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_WARNING_DIALOG", "Do you want to close the window ?"));
    }
}

