/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import SASKernel.ConfigurationHelpers.AssistedConfigEngine;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.MaxConfigLimitCrossedException;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import Wizard.ConfigWizard.GuidedFinishDialog;
import Wizard.ConfigWizard.ModeSelectionDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class GuidedConfigDialog
extends BaseConfigWizardDialog {
    private JRadioButton redundancyOnly;
    private JRadioButton redundancyTry;
    private JRadioButton noRedundancy;
    private JRadioButton existingOnly;
    private JRadioButton noExistingArray;
    private JRadioButton bothArrays;
    private JRadioButton buttonFDEWhenPossible;
    private JRadioButton buttonCtrlbasedEncryption;
    private JRadioButton buttonNoEncryption;
    private JSpinner txtNumHint;

    public GuidedConfigDialog(ConfigEngine configEngine, int n) {
        super(configEngine);
        String[] stringArray = null;
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_REDUNDANCY_ONLY", "Redundancy Only"));
        this.redundancyOnly = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.redundancyOnly.setMnemonic(stringArray[1].charAt(0));
        }
        this.redundancyOnly.setToolTipText(Resource.getString("REDUNDANCY_ONLY_DSC", "Redundancy Only"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_REDUNDANCY_TRY", "Redundancy when possible"));
        this.redundancyTry = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.redundancyTry.setMnemonic(stringArray[1].charAt(0));
        }
        this.redundancyTry.setToolTipText(Resource.getString("REDUNDANCY_TRY_DSC", "Redundancy when possible"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_REDUNDANCY_NO", "No Redundancy"));
        this.noRedundancy = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.noRedundancy.setMnemonic(stringArray[1].charAt(0));
        }
        this.noRedundancy.setToolTipText(Resource.getString("REDUNDANCY_NO_DSC", "No Redundancy"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_EXISTINGARRAY_ONLY", "Use Existing drive groups Only"));
        this.existingOnly = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.existingOnly.setMnemonic(stringArray[1].charAt(0));
        }
        this.existingOnly.setToolTipText(Resource.getString("EXISTINGARRAY_ONLY_DSC", "Use Existing drive groups Only"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_NO_EXISTINGARRAY", "Don't use Existing drive groups"));
        this.noExistingArray = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.noExistingArray.setMnemonic(stringArray[1].charAt(0));
        }
        this.noExistingArray.setToolTipText(Resource.getString("NO_EXISTINGARRAY_DSC", "Don't use Existing drive groups"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_ALLARRAYS", "Use Existing and New drive groups"));
        this.bothArrays = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.bothArrays.setMnemonic(stringArray[1].charAt(0));
        }
        this.bothArrays.setToolTipText(Resource.getString("USE_ALLARRAYS_DSC", "Use Existing and New drive groups"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_FDE_WHEN_POSSIBLE", "Use full disk encryption (FDE) when possible"));
        this.buttonFDEWhenPossible = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.buttonFDEWhenPossible.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_CTRL_BASED_ENCRYPTION", "Use controller-based encryption only"));
        this.buttonCtrlbasedEncryption = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.buttonCtrlbasedEncryption.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_NO_ENCRYPTION", "No Encryption"));
        this.buttonNoEncryption = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.buttonNoEncryption.setMnemonic(stringArray[1].charAt(0));
        }
        this.setSelectedMode(n);
        this.centerPanel.setLayout(new FlowLayout(1, 5, MainFrame.SCREEN_SIZE.height * 20 / 768));
        JPanel jPanel = new JPanel(new GridLayout(3, 1, 0, MainFrame.SCREEN_SIZE.height * 10 / 768));
        jPanel.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 500 / 1024, MainFrame.SCREEN_SIZE.height * 120 / 768));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.redundancyOnly);
        jPanel.add(this.redundancyOnly);
        buttonGroup.add(this.redundancyTry);
        jPanel.add(this.redundancyTry);
        buttonGroup.add(this.noRedundancy);
        jPanel.add(this.noRedundancy);
        this.redundancyTry.setSelected(true);
        jPanel.setBorder(BorderFactory.createTitledBorder(Resource.getString("LABEL_REDUNDANCY_GROUP", "Redundancy")));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1, 0, MainFrame.SCREEN_SIZE.height * 10 / 768));
        jPanel2.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 500 / 1024, MainFrame.SCREEN_SIZE.height * 120 / 768));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.existingOnly);
        jPanel2.add(this.existingOnly);
        buttonGroup2.add(this.noExistingArray);
        jPanel2.add(this.noExistingArray);
        buttonGroup2.add(this.bothArrays);
        jPanel2.add(this.bothArrays);
        this.bothArrays.setSelected(true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(Resource.getString("LABEL_EXISTINGARRAYS_GROUP", "Existing Drive Groups")));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1, 0, MainFrame.SCREEN_SIZE.height * 10 / 768));
        jPanel3.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 500 / 1024, MainFrame.SCREEN_SIZE.height * 120 / 768));
        SASAdapter sASAdapter = this.engine.getCurrentAdapter();
        boolean bl = this.isFDEDrivePresent();
        boolean bl2 = sASAdapter.getUseFDEOnly();
        if (m_adapterHelper.isLockKeyAssigned()) {
            this.buttonFDEWhenPossible.setSelected(bl);
            this.buttonCtrlbasedEncryption.setSelected(!bl);
            this.buttonFDEWhenPossible.setEnabled(bl);
            this.buttonCtrlbasedEncryption.setEnabled(!bl2);
        }
        ButtonGroup buttonGroup3 = new ButtonGroup();
        if (bl) {
            buttonGroup3.add(this.buttonFDEWhenPossible);
            jPanel3.add(this.buttonFDEWhenPossible);
        }
        if (!bl2) {
            buttonGroup3.add(this.buttonCtrlbasedEncryption);
            jPanel3.add(this.buttonCtrlbasedEncryption);
        }
        buttonGroup3.add(this.buttonNoEncryption);
        jPanel3.add(this.buttonNoEncryption);
        jPanel3.setBorder(BorderFactory.createTitledBorder(Resource.getString("LABEL_ENCRYPTION_GROUP", "Drive Security Method")));
        JPanel jPanel4 = new JPanel();
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_LDNUM_HINT", "<html>Desired Number of Virtual Disks : <br>(Actual number of virtual disks will depend upon<br>current configuration.)</html>"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        int n2 = 0;
        try {
            ArrayList arrayList = this.engine.getCurrentAdapter().getSASObjectsArrayList((short)8192);
            n2 = arrayList.size();
        }
        catch (Exception exception) {
            System.out.println("Exception while finding Logical Devices ...");
            exception.printStackTrace();
        }
        int n3 = configEngine.getCurrentAdapter().getInformation().getmaxLDs() - n2;
        this.txtNumHint = new JSpinner(new SpinnerNumberModel(n3, 1, n3, 1));
        jLabel.setLabelFor(this.txtNumHint);
        jPanel4.add(jLabel);
        jPanel4.add(this.txtNumHint);
        this.centerPanel.add(jPanel);
        this.centerPanel.add(jPanel2);
        if (m_adapterHelper.isLockKeyAssigned()) {
            this.centerPanel.add(jPanel3);
        }
        this.centerPanel.add(jPanel4);
        if (!((AssistedConfigEngine)this.engine).isRedundancyPossible()) {
            this.redundancyOnly.setEnabled(false);
            this.redundancyTry.setEnabled(false);
            this.noRedundancy.setSelected(true);
        }
        this.noRedundancy.setEnabled(((AssistedConfigEngine)this.engine).isNoRedundancyPossible());
        if (this.engine.getOldArraysWithSpace().size() <= 0) {
            this.existingOnly.setEnabled(false);
            this.bothArrays.setEnabled(false);
            this.noExistingArray.setEnabled(true);
            this.noExistingArray.setSelected(true);
        }
        if (this.engine.getUnconfiguredPDList().size() <= 0) {
            this.noExistingArray.setEnabled(false);
            this.bothArrays.setEnabled(false);
            this.existingOnly.setEnabled(true);
            this.existingOnly.setSelected(true);
        }
        this.show();
    }

    @Override
    public void back() {
        this.dispose();
        new ModeSelectionDialog(this.engine, this.getSelectedMode());
    }

    @Override
    public void next() {
        int n = 0;
        int n2 = 0;
        SASAdapter sASAdapter = this.engine.getCurrentAdapter();
        byte by = 0;
        int n3 = 0;
        n = this.redundancyOnly.isSelected() ? 1 : (this.redundancyTry.isSelected() ? 3 : 2);
        n2 = this.existingOnly.isSelected() ? 1 : (this.bothArrays.isSelected() ? 3 : 2);
        n3 = (Integer)this.txtNumHint.getValue();
        if (m_adapterHelper.isLockKeyAssigned()) {
            if (this.buttonCtrlbasedEncryption.isSelected()) {
                by = 2;
            } else if (this.buttonFDEWhenPossible.isSelected()) {
                by = 1;
            } else if (this.buttonNoEncryption.isSelected()) {
                by = 0;
            }
        }
        try {
            ((AssistedConfigEngine)this.engine).setAssistedConfigOptions(n, n2, n3, by);
            this.dispose();
            new GuidedFinishDialog((AssistedConfigEngine)this.engine, this.getSelectedMode());
        }
        catch (MaxConfigLimitCrossedException maxConfigLimitCrossedException) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_MAXCONFIG_EXCEEDED", "Max Configuration limit exceeded !"));
            maxConfigLimitCrossedException.printStackTrace();
        }
        catch (Exception exception) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_GUIDEDCONFIG_FAILED", "Guided Configuration failed !"));
            exception.printStackTrace();
        }
    }

    @Override
    public Object[] getStepNames(boolean bl) {
        if (bl) {
            Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP", "Mode (S)election"), Resource.getString("GUIDED_CONFIG_STEP1", "G(u)ided Config"), Resource.getString("GUIDED_CONFIG_STEP2", "V(i)rtual Disk Parameters")};
            return objectArray;
        }
        Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP_1", "Mode Selection"), Resource.getString("GUIDED_CONFIG_STEP1_1", "Guided Config"), Resource.getString("GUIDED_CONFIG_STEP2_1", "Virtual Disk Parameters")};
        return objectArray;
    }

    @Override
    public int getStep() {
        return 1;
    }

    @Override
    public void goToStep(int n) {
        if (n == 0) {
            this.back();
        } else if (n == 2) {
            this.next();
        }
    }

    @Override
    public String getStatus() {
        return Resource.getString("MSG_STATUS_GUIDED", "Select the choices given above and then proceed to next step for guided configuration");
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_GUIDED_DIALOG");
    }

    private boolean isFDEDrivePresent() {
        try {
            ArrayList arrayList = this.engine.getCurrentAdapter().getSASObjectsArrayList((short)4096);
            if (arrayList != null && arrayList.size() > 0) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i);
                    if (sASPhysicalDrive.getState() != 0 || !sASPhysicalDrive.getInformation().getSecurity_MR_PD_INFO().getFDECapable()) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }
}

