/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import KernelExceptions.VKObjectNotPresentException;
import SASKernel.ConfigurationHelpers.AssistedConfigEngine;
import SASKernel.ConfigurationHelpers.AssistedConfigRAIDLevelAndSizeInfo;
import SASKernel.ConfigurationHelpers.ConfigEngine;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.RAIDParameters;
import SASKernel.SASAdapter.SASAdapter;
import Utils.CustomComboBox;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import Wizard.ConfigWizard.FinishWizardDialog;
import Wizard.ConfigWizard.GUIData;
import Wizard.ConfigWizard.GuidedConfigDialog;
import Wizard.ConfigWizard.ModeSelectionDialog;
import Wizard.ConfigWizard.VolumeParamPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class GuidedFinishDialog
extends BaseConfigWizardDialog {
    private AssistedConfigEngine assistedEngine;
    private VolumeParamPanel[] volumePanels;
    private String[] mnemonics;
    private JComboBox stripeSize;
    private JComboBox readPolicy;
    private JComboBox writePolicy;
    private JComboBox cachePolicy;
    private JComboBox diskCachePolicy;
    private JComboBox accessPolicy;
    private JComboBox initState;
    private JCheckBox bbucheck;
    private ItemListener bbuCheckListener;
    boolean bbuPresent = false;

    public GuidedFinishDialog(ConfigEngine configEngine, int n) {
        super(configEngine);
        this.setSelectedMode(n);
        this.assistedEngine = (AssistedConfigEngine)configEngine;
        this.centerPanel.setLayout(new FlowLayout(0));
        this.refresh();
        this.show();
    }

    @Override
    public void back() {
        this.dispose();
        try {
            this.engine.deleteEveryThing();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new GuidedConfigDialog((ConfigEngine)this.engine, this.getSelectedMode());
    }

    @Override
    public void next() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.volumePanels.length; ++n3) {
            n4 += this.volumePanels[n3].getLDNumber();
        }
        if (n4 <= 0) {
            new CustomMsgBox(this, Resource.getString("MSG_LD_ZERO", "Total Number of Virtual Disks must be greater than 0 !"));
            return;
        }
        n3 = 0;
        try {
            n3 = this.engine.getCurrentAdapter().getSASObjectsArrayList((short)8192).size();
        }
        catch (Exception exception) {
            n3 = 0;
            exception.printStackTrace();
        }
        if (this.engine.getNewlyCreatedLDs().size() + n4 + n3 > this.assistedEngine.getCurrentAdapter().getInformation().getmaxLDs()) {
            new CustomMsgBox(this, Resource.getString("MSG_MAXLDNUM_EXCEEDED", "Total number of Virtual Disks must not exceed ") + this.assistedEngine.getCurrentAdapter().getInformation().getmaxLDs());
            return;
        }
        for (int i = 0; i < this.volumePanels.length; ++i) {
            AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo = this.volumePanels[i].getVolumeInfo();
            if (assistedConfigRAIDLevelAndSizeInfo == null) continue;
            try {
                String string = Resource.getString("MSG_GUIDED_VD", "Guided VD ");
                n2 = ((GUIData)this.stripeSize.getSelectedItem()).flag;
                this.assistedEngine.createLogicalDrives(assistedConfigRAIDLevelAndSizeInfo, n2, string);
                n = this.assistedEngine.checkDDFParitition(assistedConfigRAIDLevelAndSizeInfo);
                if (n != 1 || CustomMsgBox.confirm(this.getContentPane(), Resource.getString("CONFIRM_64_VDS_DDF_PARTITION", "Following this operation, your storage configuration \nwill contain more than 16 virtual disks.While supported \nby your system, the configuration ay not be compatible \nwith other systems that support a maximum of 16 virtual \ndisks per array.Proceeding with this operation may prevent \nyou from moving your configuration to an incompatible system\nAre you sure you want to continue?"))) continue;
                return;
            }
            catch (Exception exception) {
                new CustomMsgBox(this, Resource.getString("MSG_ASSISTEDCONF_FAILED", "Assisted Configuration Failed !"));
                exception.printStackTrace();
                return;
            }
        }
        ArrayList arrayList = this.engine.getNewlyCreatedLDs();
        if (arrayList.size() <= 0) {
            return;
        }
        int n5 = ((GUIData)this.stripeSize.getSelectedItem()).flag;
        int n6 = ((GUIData)this.initState.getSelectedItem()).flag;
        n2 = ((GUIData)this.readPolicy.getSelectedItem()).flag;
        n = ((GUIData)this.writePolicy.getSelectedItem()).flag;
        n = ((GUIData)this.writePolicy.getSelectedItem()).flag;
        if (n == 1) {
            n = this.bbucheck.isSelected() ? 1 : 17;
        }
        int n7 = ((GUIData)this.cachePolicy.getSelectedItem()).flag;
        int n8 = ((GUIData)this.accessPolicy.getSelectedItem()).flag;
        int n9 = ((GUIData)this.diskCachePolicy.getSelectedItem()).flag;
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                LDData lDData = (LDData)arrayList.get(i);
                lDData.setStripeSize((byte)n5);
                lDData.setInitState((byte)n6);
                lDData.setPolicy((byte)n2, (byte)n, (byte)n7, (byte)n8, (byte)n9);
                continue;
            }
            catch (Exception exception) {
                new CustomMsgBox(this, Resource.getString("MSG_SETLDPARAM_FAILED", "Can not set virtual disk parameters !"));
                exception.printStackTrace();
            }
        }
        this.dispose();
        new FinishWizardDialog(this.engine, true, this.getSelectedMode());
    }

    private void refresh() {
        int n;
        int n2;
        Serializable serializable;
        try {
            serializable = this.assistedEngine.getRAIDLevelAndSize();
            if (serializable == null || ((ArrayList)serializable).size() <= 0) {
                new CustomMsgBox(this, Resource.getString("MSG_NOASSISTED_POSSIBLE", "No configuration possible for the given parameters !"));
                return;
            }
            this.volumePanels = new VolumeParamPanel[((ArrayList)serializable).size()];
            int n3 = this.assistedEngine.getHintLDNumber();
            for (int i = 0; i < this.volumePanels.length; ++i) {
                AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo = (AssistedConfigRAIDLevelAndSizeInfo)((ArrayList)serializable).get(i);
                this.volumePanels[i] = new VolumeParamPanel(assistedConfigRAIDLevelAndSizeInfo, n3, this.assistedEngine.getCurrentAdapter().getInformation().getmaxLDs());
                n3 -= this.volumePanels[i].getLDNumber();
                this.centerPanel.add(this.volumePanels[i]);
            }
            if (this.volumePanels.length >= 0) {
                JLabel jLabel = new JLabel("<html>" + Resource.getString("GUIDED_MSG_TEXT", "The capacity mentioned will be used as a hint while creating the virtual disks.<br>Actual capacity will depend upon current configuration.") + "</html>");
                jLabel.setFont(jLabel.getFont().deriveFont(9.0f));
                jLabel.setPreferredSize(new Dimension(400, 35));
                this.centerPanel.add(jLabel);
            }
        }
        catch (Exception exception) {
            new CustomMsgBox(this, Resource.getString("MSG_ASSISTEDCONF_FAILED", "Assisted Configuration Failed !"));
            exception.printStackTrace();
        }
        serializable = new JPanel(new FlowLayout(0));
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder(Resource.getString("LABEL_VOLUMEPROP_TEXT", "Virtual Disk Parameters")));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GUIDED_LABEL_STRIPESIZE_TEXT", "Stripe Size : "));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        SASAdapter sASAdapter = this.engine.getCurrentAdapter();
        int n4 = sASAdapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmin();
        char c = sASAdapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmax();
        DefaultComboBoxModel<GUIData> defaultComboBoxModel = new DefaultComboBoxModel<GUIData>();
        for (n2 = n4; n2 <= c; ++n2) {
            int n5;
            if (n2 == 0) {
                defaultComboBoxModel.addElement(new GUIData("512 Byte", n2));
                continue;
            }
            if (n2 < 11) {
                n5 = (int)Math.pow(2.0, n2 - '\u0001');
                defaultComboBoxModel.addElement(new GUIData(n5 + " KB", n2));
                continue;
            }
            n5 = (int)Math.pow(2.0, n2 - 11);
            defaultComboBoxModel.addElement(new GUIData(n5 + " MB", n2));
        }
        this.stripeSize = new CustomComboBox((ComboBoxModel)defaultComboBoxModel);
        n2 = this.engine.getmfcDefaults().getstripeSize();
        if (n4 <= n2 && c >= n2) {
            this.stripeSize.setSelectedIndex(n2 - n4);
        }
        jLabel.setLabelFor(this.stripeSize);
        this.stripeSize.setToolTipText(Resource.getString("STRIPE_SIZE_DSC", "Stripe Size"));
        ((Container)serializable).add(jLabel);
        ((Container)serializable).add(this.stripeSize);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GUIDED_LABEL_READPOLICY_TEXT", "Read Policy : "));
        JLabel jLabel2 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel2.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        RAIDParameters[] rAIDParametersArray = new RAIDParameters[this.volumePanels.length];
        for (n = 0; n < rAIDParametersArray.length; ++n) {
            rAIDParametersArray[n] = RAIDParameters.getDefaultParams(VivaldiStartupDialog.OEM_TYPE, this.engine.getmfcDefaults(), this.engine.getCurrentAdapter(), this.volumePanels[n].getData().getRaidLevel());
        }
        this.readPolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("READ_AHEAD_NONE", "No Read Ahead"), 0), new GUIData(Resource.getString("READ_AHEAD_ADAPTIVE", "Adaptive Read Ahead"), 12), new GUIData(Resource.getString("READ_AHEAD_ALWAYS", "Always Read Ahead"), 4)});
        n = rAIDParametersArray[0].getReadPolicy();
        for (int i = 0; i < this.readPolicy.getItemCount(); ++i) {
            if (((GUIData)this.readPolicy.getItemAt((int)i)).flag != n) continue;
            this.readPolicy.setSelectedIndex(i);
            break;
        }
        jLabel2.setLabelFor(this.readPolicy);
        ((Container)serializable).add(jLabel2);
        this.readPolicy.setToolTipText(Resource.getString("READ_POLICY_DSC", "Read Policy"));
        ((Container)serializable).add(this.readPolicy);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_DEFWRITEPOLICY_TEXT", "Default Write Policy : "));
        JLabel jLabel3 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel3.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.bbuPresent = false;
        try {
            sASAdapter.getBBUObject();
            this.bbuPresent = true;
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            // empty catch block
        }
        this.writePolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("WRITE_THROUGH", "Write Through"), 0), new GUIData(Resource.getString("WRITE_BACK", "Write Back"), 1)});
        this.writePolicy.setToolTipText(Resource.getString("WRITE_POLICY_DSC", "Write Policy"));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GUIDED_VD_WR_POLICY_BAD_BBU", "Use Write Through for failed or missing battery"));
        this.bbucheck = new JCheckBox(this.mnemonics[0], true);
        if (this.mnemonics.length == 2) {
            this.bbucheck.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.bbuCheckListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (GuidedFinishDialog.this.bbucheck.isShowing() && !GuidedFinishDialog.this.bbucheck.isSelected()) {
                    new CustomMsgBox(GuidedFinishDialog.this.getContentPane(), Resource.getString("MSG_WRITE_BACK_WARN", "Write-through is recommended for maximum data integrity when no battery is present !"));
                }
            }
        };
        this.bbucheck.setToolTipText(Resource.getString("BBU_DSC", "Battary Backup Unit Check"));
        this.bbucheck.addItemListener(this.bbuCheckListener);
        byte by = 0;
        if (this.bbuPresent || this.engine.getmfcDefaults().getcacheWhenBBUBad() != 0) {
            by = rAIDParametersArray.length > 0 ? rAIDParametersArray[0].getWritePolicy() : this.engine.getmfcDefaults().getwriteBack();
            for (int i = 1; i < rAIDParametersArray.length && by != 0; ++i) {
                if (rAIDParametersArray[i].getWritePolicy() != 0) continue;
                by = rAIDParametersArray[i].getWritePolicy();
            }
        }
        GUIUtils.setDefaultValueToJComboBoxFromGUIData(this.writePolicy, by);
        if (by == 0) {
            GUIUtils.setDefaultValueToJCheckboxFromGUIData(this.bbucheck, false);
        }
        this.writePolicy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                GuidedFinishDialog.this.bbucheck.removeItemListener(GuidedFinishDialog.this.bbuCheckListener);
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                if (GuidedFinishDialog.this.writePolicy.getSelectedIndex() == 1) {
                    GUIUtils.setDefaultValueToJCheckboxFromGUIData(GuidedFinishDialog.this.bbucheck, true);
                } else {
                    GUIUtils.setDefaultValueToJCheckboxFromGUIData(GuidedFinishDialog.this.bbucheck, false);
                }
                GuidedFinishDialog.this.bbucheck.addItemListener(GuidedFinishDialog.this.bbuCheckListener);
            }
        });
        jLabel3.setLabelFor(this.writePolicy);
        ((Container)serializable).add(jLabel3);
        ((Container)serializable).add(this.writePolicy);
        ((Container)serializable).add(this.bbucheck);
        this.bbucheck.setBackground(((Component)serializable).getBackground());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GUIDED_LABEL_IOPOLICY_TEXT", "IO Policy"));
        JLabel jLabel4 = new JLabel(this.mnemonics[0] + " : ");
        if (this.mnemonics.length == 2) {
            jLabel4.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.cachePolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("DIRECT_IO", "Direct IO"), 0), new GUIData(Resource.getString("CACHED_IO", "Cached IO"), 96)});
        this.cachePolicy.setToolTipText(Resource.getString("CACHE_POLICY_DSC", "Cache Policy"));
        byte by2 = rAIDParametersArray[0].getIoPolicy();
        for (int i = 0; i < this.cachePolicy.getItemCount(); ++i) {
            if (((GUIData)this.cachePolicy.getItemAt((int)i)).flag != by2) continue;
            this.cachePolicy.setSelectedIndex(i);
            break;
        }
        jLabel4.setLabelFor(this.cachePolicy);
        ((Container)serializable).add(jLabel4);
        ((Container)serializable).add(this.cachePolicy);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GUIDED_LABEL_ACCESSPOLICY_TEXT", "Access Policy : "));
        JLabel jLabel5 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel5.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.accessPolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("ACCESS_READ_WRITE", "Read Write"), 0), new GUIData(Resource.getString("ACCESS_READ_ONLY", "Read Only"), 2), new GUIData(Resource.getString("ACCESS_BLOCKED", "Blocked"), 3)});
        jLabel5.setLabelFor(this.accessPolicy);
        this.accessPolicy.setToolTipText(Resource.getString("ACCESSPOLICY_DSC", "Access Policy"));
        ((Container)serializable).add(jLabel5);
        ((Container)serializable).add(this.accessPolicy);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GUIDED_LABEL_DISKCACHEPOLICY_TEXT", "Disk Cache Policy : "));
        JLabel jLabel6 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel6.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.diskCachePolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("DISK_CACHE_UNCHANGED", "Unchanged"), 0), new GUIData(Resource.getString("DISK_CACHE_ENABLED", "Enabled"), 1), new GUIData(Resource.getString("DISK_CACHE_DISABLED", "Disabled"), 2)});
        this.diskCachePolicy.setToolTipText(Resource.getString("DISK_CACHEPOLICY_DSC", "Disk Cache Policy"));
        if (this.engine.getCurrentAdapter().getInformation().getldOperations_MR_CTRL_INFO().getdiskCachePolicy() != 0) {
            jLabel6.setLabelFor(this.diskCachePolicy);
            ((Container)serializable).add(jLabel6);
            ((Container)serializable).add(this.diskCachePolicy);
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("GUIDED_LABEL_INITSTATE_TEXT", "Init State : "));
        JLabel jLabel7 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel7.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.initState = new CustomComboBox(new Object[]{new GUIData(Resource.getString("NO_INIT_TEXT", "No Initialization"), 0), new GUIData(Resource.getString("QUICK_INIT_TEXT", "Fast Initialization"), 1), new GUIData(Resource.getString("FULL_INIT_TEXT", "Full Initialization"), 2)});
        jLabel7.setLabelFor(this.initState);
        this.initState.setToolTipText(Resource.getString("INITSTATE_DSC", "Initialization state"));
        ((Container)serializable).add(jLabel7);
        ((Container)serializable).add(this.initState);
        JScrollPane jScrollPane = new JScrollPane((Component)serializable, 20, 30);
        this.centerPanel.add(jScrollPane);
        Dimension dimension = new Dimension(MainFrame.SCREEN_SIZE.width * 170 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        Dimension dimension2 = new Dimension(MainFrame.SCREEN_SIZE.width * 310 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        jLabel.setPreferredSize(dimension2);
        jLabel.setToolTipText(jLabel.getText());
        this.stripeSize.setPreferredSize(dimension);
        jLabel2.setPreferredSize(dimension2);
        jLabel2.setToolTipText(jLabel2.getText());
        this.readPolicy.setPreferredSize(dimension);
        jLabel3.setPreferredSize(dimension2);
        jLabel3.setToolTipText(jLabel3.getText());
        this.writePolicy.setPreferredSize(dimension);
        jLabel4.setPreferredSize(dimension2);
        jLabel4.setToolTipText(jLabel4.getText());
        this.cachePolicy.setPreferredSize(dimension);
        jLabel5.setPreferredSize(dimension2);
        jLabel5.setToolTipText(jLabel5.getText());
        this.accessPolicy.setPreferredSize(dimension);
        jLabel6.setPreferredSize(dimension2);
        jLabel6.setToolTipText(jLabel6.getText());
        this.diskCachePolicy.setPreferredSize(dimension);
        jLabel7.setPreferredSize(dimension2);
        jLabel7.setToolTipText(jLabel7.getText());
        this.initState.setPreferredSize(dimension);
        this.bbucheck.setPreferredSize(new Dimension((int)(dimension2.getWidth() + dimension.getWidth()), (int)dimension2.getHeight()));
        this.bbucheck.setToolTipText(this.bbucheck.getText());
        GUIUtils.addItemListeningToolTip(this.stripeSize);
        GUIUtils.addItemListeningToolTip(this.readPolicy);
        GUIUtils.addItemListeningToolTip(this.writePolicy);
        GUIUtils.addItemListeningToolTip(this.cachePolicy);
        GUIUtils.addItemListeningToolTip(this.diskCachePolicy);
        GUIUtils.addItemListeningToolTip(this.accessPolicy);
        GUIUtils.addItemListeningToolTip(this.initState);
        ((JComponent)serializable).setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 600 / 1024, MainFrame.SCREEN_SIZE.height * 270 / 768));
        int n6 = MainFrame.SCREEN_SIZE.height <= 700 ? 270 : 370;
        jScrollPane.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 600 / 1024, MainFrame.SCREEN_SIZE.height * (n6 - (this.volumePanels.length - 1) * 90) / 768));
    }

    @Override
    public Object[] getStepNames(boolean bl) {
        if (bl) {
            Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP"), Resource.getString("GUIDED_CONFIG_STEP1"), Resource.getString("GUIDED_CONFIG_STEP2"), Resource.getString("GUIDED_CONFIG_STEP3")};
            return objectArray;
        }
        Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP_1", "Mode Selection"), Resource.getString("GUIDED_CONFIG_STEP1_1", "Guided Config"), Resource.getString("GUIDED_CONFIG_STEP2_1", "Virtual Disk Parameters"), Resource.getString("GUIDED_CONFIG_STEP3_1", "Finish")};
        return objectArray;
    }

    @Override
    public int getStep() {
        return 2;
    }

    @Override
    public void goToStep(int n) {
        if (n == 0) {
            this.dispose();
            new ModeSelectionDialog(this.engine, this.getSelectedMode());
        } else if (n == 1) {
            this.back();
        } else if (n == 3) {
            this.next();
        }
    }

    @Override
    public String getHelpPage() {
        switch (this.getSelectedMode()) {
            case 2: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_MANUAL_DIALOG");
            }
            case 1: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_AUTO_DIALOG");
            }
            case 3: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_GUIDED_DIALOG");
            }
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }
}

