/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import KernelExceptions.VKObjectNotPresentException;
import Utils.ColorHash;
import Utils.CustomMsgBox;
import Utils.Resource;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class HotspareAffinitySelectionDialog
extends VivaldiBaseDialog {
    String[] mnemonics;
    ButtonGroup i_objRadioGroup = new ButtonGroup();
    JRadioButton[] i_objRadioButtons = new JRadioButton[2];
    JButton i_objOkButton = new JButton(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
    private char hotspareAffinityOption = '\u0000';

    public HotspareAffinitySelectionDialog() throws VKObjectNotPresentException {
        this.init();
        this.setSize(MainFrame.SCREEN_SIZE.width * 360 / 1024, MainFrame.SCREEN_SIZE.height * 280 / 768);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setModal(true);
        this.show();
    }

    @Override
    protected boolean closeWindowFunction(WindowEvent windowEvent) {
        return this.performOkButton();
    }

    private void init() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel();
        this.createRadioButtons();
        if (this.i_objRadioButtons.length != 0) {
            for (int i = 0; i < this.i_objRadioButtons.length; ++i) {
                if (i % 2 == 1) {
                    this.i_objRadioButtons[i].setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                } else {
                    this.i_objRadioButtons[i].setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                }
                jPanel.add(this.i_objRadioButtons[i]);
                this.i_objRadioGroup.add(this.i_objRadioButtons[i]);
            }
        }
        this.setTitle(Resource.getString("TITLE_SELECT_HOTSPARE_AFFINITY", "Select affinity option"));
        this.i_objOkButton.setToolTipText(Resource.getString("ABOUT_OKBUTTON_TEXT_DSC", "OK"));
        this.i_objOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HotspareAffinitySelectionDialog.this.performOkButton();
            }
        });
        jPanel2.add(this.i_objOkButton);
        this.contentPane.add(new JScrollPane(jPanel));
        this.contentPane.add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(this.i_objOkButton);
    }

    private boolean performOkButton() {
        try {
            if (!this.i_objRadioButtons[0].isSelected() && !this.i_objRadioButtons[1].isSelected()) {
                new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_SELECT_AFFINITY_OPTION", "Please select affinity option !"));
                return false;
            }
            this.setHotspareAffinityOption((char)(this.i_objRadioButtons[1].isSelected() ? 1 : 0));
        }
        catch (Exception exception) {
            return false;
        }
        this.dispose();
        return true;
    }

    private void createRadioButtons() {
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("MSG_NO_AFFINITY_OPTION", "No Affinity"));
        this.i_objRadioButtons[0] = new JRadioButton(this.mnemonics[0], false);
        if (this.mnemonics.length == 2) {
            this.i_objRadioButtons[0].setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("MSG_WITH_AFFINITY_OPTION", "With Affinity"));
        this.i_objRadioButtons[1] = new JRadioButton(this.mnemonics[0], false);
        if (this.mnemonics.length == 2) {
            this.i_objRadioButtons[1].setMnemonic(this.mnemonics[1].charAt(0));
        }
    }

    public char getHotspareAffinityOption() {
        return this.hotspareAffinityOption;
    }

    public void setHotspareAffinityOption(char c) {
        this.hotspareAffinityOption = c;
    }
}

