/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import KernelExceptions.VKObjectNotPresentException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.ArrayHoleData;
import SASKernel.ConfigurationHelpers.IRConfigHelper.IRConfigEngine;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.RAIDLevelAndSize;
import Services.KernelConstants;
import Utils.CustomComboBox;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.ArraySelectionDialog;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import Wizard.ConfigWizard.FinishWizardDialog;
import Wizard.ConfigWizard.GUIData;
import Wizard.ConfigWizard.PrimaryDiskSelectionDialog;
import Wizard.UnitsComboBoxModel;
import Wizard.UnitsRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class IRVirtualDiskCreationDialog
extends BaseConfigWizardDialog {
    private JPanel selectArray = new JPanel(new GridLayout(0, 1));
    private ArrayList possibleRAIDLevelSize = null;
    private JPanel rightPart = new JPanel();
    private ArrayList holeData = new ArrayList();
    private JTree ldTreeView = new JTree();
    private JSplitPane split;
    private JComboBox arrayCmb;
    private JComboBox rdLevel;
    private JSpinner sizeText;
    private JComboBox sizeUnit;
    private UnitsComboBoxModel sizeUnitModel;
    JPanel sizeAndUnit = new JPanel(new FlowLayout(0, 10, 0));
    private JButton acceptButton;
    private JScrollPane arrayHolderScrollPane;
    private JPanel treePanel;
    private JButton changePrimaryDiskButton;
    private String[] mnemonics;
    private JLabel labelArrays = new JLabel("");
    private double[] maxSizeAndUnit = new double[2];
    private long maxSizeInBlocks = 0L;

    public IRVirtualDiskCreationDialog(IRConfigEngine iRConfigEngine, int n) {
        super(iRConfigEngine);
        this.setSelectedMode(n);
        this.ldTreeView.getSelectionModel().setSelectionMode(1);
        this.refreshArraysWithHoles();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("VDC_LABEL_ARRAY_TEXT", "Arrays"));
        this.labelArrays.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.labelArrays.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel.add((Component)this.labelArrays, "North");
        jPanel.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 250 / 1024, 0));
        this.rightPart.setBorder(BorderFactory.createTitledBorder(Resource.getString("NEWLD_PROPERTY_INPUT", "Virtual Disk Properties")));
        this.rightPart.setLayout(new FlowLayout(0, 5 * MainFrame.SCREEN_SIZE.width / 1024, 5 * MainFrame.SCREEN_SIZE.height / 768));
        this.populateNewLDInputs(this.rightPart);
        this.initRightPart(false);
        this.ldTreeView.setCellRenderer(this.renderer);
        this.treePanel = new JPanel(new BorderLayout());
        this.treePanel.add((Component)new JScrollPane(this.ldTreeView), "Center");
        this.changePrimaryDiskButton = new JButton(Resource.getString("BUTTON_SELECTPRIMARYDISK_TEXT", "Change Primary Disk"));
        this.changePrimaryDiskButton.setToolTipText(Resource.getString("BUTTON_SELECTPRIMARYDISK_DSC", "Change Primary Disk"));
        this.changePrimaryDiskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GUIData gUIData = (GUIData)((DefaultMutableTreeNode)IRVirtualDiskCreationDialog.this.ldTreeView.getLastSelectedPathComponent()).getUserObject();
                    IRVirtualDiskCreationDialog.this.processPrimaryDisk(((LDData)gUIData.value).getGUIRAIDLavel(), (LDData)gUIData.value);
                }
                catch (Exception exception) {
                    new CustomMsgBox(IRVirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_ERR_PRIMARY_DISK_CHANGE", "Failed to change Primary Disk !"));
                    exception.printStackTrace();
                }
            }
        });
        this.treePanel.add((Component)this.changePrimaryDiskButton, "South");
        this.changePrimaryDiskButton.setVisible(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(0, MainFrame.SCREEN_SIZE.height * 160 / 768));
        this.refreshLDSummary();
        jPanel2.setLayout(new BorderLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_NEWVIRTUALDISK_TEXT", " New Virtual Disks"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jLabel.setLabelFor(this.ldTreeView);
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)this.treePanel, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_RECLAIM_TEXT", "Reclaim"));
        final JButton jButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        jButton.setToolTipText(Resource.getString("BUTTON_RECLAIM_DSC", "Reclaim"));
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIData gUIData = (GUIData)((DefaultMutableTreeNode)IRVirtualDiskCreationDialog.this.ldTreeView.getLastSelectedPathComponent()).getUserObject();
                if (gUIData.flag == 3) {
                    if (!CustomMsgBox.confirm(IRVirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_CONFIRM_LDRECLAIM", "This will delete the newly created Virtual Disk! Are you sure?"))) {
                        return;
                    }
                    try {
                        ((LDData)gUIData.value).deleteNewLD();
                        IRVirtualDiskCreationDialog.this.refreshArraysWithHoles();
                        IRVirtualDiskCreationDialog.this.refreshParameters();
                        IRVirtualDiskCreationDialog.this.refreshLDSummary();
                        IRVirtualDiskCreationDialog.this.validatePrimaryDiskButton(null);
                    }
                    catch (Exception exception) {
                        new CustomMsgBox(IRVirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_DELETLD_FAILED", "Can not delete newly created Virtual Disk : Unknown Exception !"));
                        exception.printStackTrace();
                    }
                }
            }
        });
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.selectArray);
        this.arrayHolderScrollPane = new JScrollPane(jPanel4);
        this.arrayHolderScrollPane.setMinimumSize(new Dimension(jPanel4.getWidth(), MainFrame.SCREEN_SIZE.height * 60 / 768));
        this.split = new JSplitPane(0, this.arrayHolderScrollPane, new JScrollPane(jPanel2));
        jPanel.add(this.split);
        this.centerPanel.setLayout(new BorderLayout(5, 5));
        this.centerPanel.add((Component)jPanel, "West");
        this.centerPanel.add((Component)this.rightPart, "Center");
        if (this.arrayCmb.getItemCount() > 0) {
            this.arrayCmb.setSelectedIndex(0);
            this.refreshParameters();
        }
        this.ldTreeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                jButton.setEnabled(false);
                if (IRVirtualDiskCreationDialog.this.ldTreeView.getSelectionCount() <= 0) {
                    return;
                }
                Object object = ((DefaultMutableTreeNode)IRVirtualDiskCreationDialog.this.ldTreeView.getSelectionPath().getLastPathComponent()).getUserObject();
                if (object instanceof GUIData) {
                    if (((GUIData)object).flag == 3) {
                        jButton.setEnabled(true);
                    }
                    IRVirtualDiskCreationDialog.this.validatePrimaryDiskButton((GUIData)object);
                }
            }
        });
        this.show();
        this.refreshSplitPane();
    }

    private void refreshArraysWithHoles() {
        this.selectArray.removeAll();
        ArrayList arrayList = this.engine.getArraysWithFreeSpaceRemaining();
        Object[] objectArray = new Object[arrayList.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new GUIData(arrayList.get(i), 0);
        }
        this.arrayCmb = new CustomComboBox(objectArray);
        this.arrayCmb.setToolTipText(Resource.getString("ARRAYCMB_DSC", "Array Combination"));
        this.arrayCmb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                IRVirtualDiskCreationDialog.this.refreshParameters();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(0));
        if (objectArray.length > 0) {
            jPanel.add(this.arrayCmb);
        }
        this.arrayCmb.setOpaque(false);
        this.labelArrays.setLabelFor(this.arrayCmb);
        jPanel.setOpaque(false);
        this.selectArray.add(jPanel);
        this.selectArray.validate();
        this.refreshSplitPane();
        this.validate();
    }

    private void populateNewLDInputs(JPanel jPanel) {
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_RAIDLEVEL_TEXT", "RAID Level : "));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel.add(jLabel);
        this.rdLevel = new CustomComboBox();
        this.rdLevel.setToolTipText(Resource.getString("RAID_LEVEL_DSC", "RAID Level"));
        jPanel.add(this.rdLevel);
        jLabel.setLabelFor(this.rdLevel);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_SIZE_TEXT", "Size: "));
        JLabel jLabel2 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel2.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel.add(jLabel2);
        this.sizeText = new JSpinner();
        this.sizeAndUnit.add(this.sizeText);
        this.sizeUnitModel = new UnitsComboBoxModel(-1);
        this.sizeUnit = new JComboBox(this.sizeUnitModel);
        this.sizeUnit.setRenderer(new UnitsRenderer());
        this.sizeAndUnit.add(this.sizeUnit);
        this.sizeText.setEnabled(false);
        this.sizeUnit.setEnabled(false);
        jPanel.add(this.sizeAndUnit);
        Dimension dimension = new Dimension(MainFrame.SCREEN_SIZE.width * 160 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        Dimension dimension2 = new Dimension(MainFrame.SCREEN_SIZE.width * 150 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        jLabel.setPreferredSize(dimension2);
        this.rdLevel.setPreferredSize(dimension);
        Dimension dimension3 = new Dimension(MainFrame.SCREEN_SIZE.width * 90 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        Dimension dimension4 = new Dimension(MainFrame.SCREEN_SIZE.width * 140 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        jLabel2.setPreferredSize(dimension4);
        jLabel2.setToolTipText(jLabel2.getText());
        this.sizeText.setPreferredSize(dimension3);
        dimension3 = new Dimension(MainFrame.SCREEN_SIZE.width * 60 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        this.sizeUnit.setPreferredSize(dimension3);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_ACCEPT_TEXT", "Accept"));
        this.acceptButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.acceptButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.acceptButton.setToolTipText(Resource.getString("BUTTON_ACCEPT_DSC", "Accept"));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (!IRVirtualDiskCreationDialog.this.rdLevel.isEnabled()) {
                    new CustomMsgBox(IRVirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_SELECT_ARRAY", "Please select one or more arrays !"));
                    return;
                }
                int n2 = ((GUIData)((IRVirtualDiskCreationDialog)IRVirtualDiskCreationDialog.this).rdLevel.getSelectedItem()).flag;
                byte by = 0;
                double d = Double.parseDouble(IRVirtualDiskCreationDialog.this.sizeText.getValue() + "");
                double d2 = KernelConstants.getSizeInBlocks(d, n = ((Integer)IRVirtualDiskCreationDialog.this.sizeUnit.getSelectedItem()).intValue());
                if (d2 == (double)KernelConstants.getSizeInBlocks(IRVirtualDiskCreationDialog.this.maxSizeAndUnit[0], (int)IRVirtualDiskCreationDialog.this.maxSizeAndUnit[1])) {
                    d2 = IRVirtualDiskCreationDialog.this.maxSizeInBlocks;
                }
                try {
                    if (n2 == 17) {
                        for (int i = 0; i < IRVirtualDiskCreationDialog.this.holeData.size(); ++i) {
                            ArrayHoleData arrayHoleData = (ArrayHoleData)IRVirtualDiskCreationDialog.this.holeData.get(i);
                            ArrayData arrayData = arrayHoleData.getArrayData();
                            if (arrayData.getRowSize() % 2 == 0 || CustomMsgBox.confirmWithCheck(Resource.getString("MSG_RAID1E_WARNING", "The virtual dirve cannot be migrated to MegaRAID controller. Do you want to continue?"))) continue;
                            IRVirtualDiskCreationDialog.this.rdLevel.setSelectedIndex(0);
                            return;
                        }
                    }
                    LDData lDData = new LDData(IRVirtualDiskCreationDialog.this.holeData, (byte)n2, (long)d2, IRVirtualDiskCreationDialog.this.engine, by);
                    byte by2 = (byte)IRVirtualDiskCreationDialog.this.engine.getCurrentAdapter().getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmax();
                    lDData.setStripeSize(by2);
                    lDData.setInitState((byte)1);
                    IRVirtualDiskCreationDialog.this.engine.addNewLD(lDData);
                    IRVirtualDiskCreationDialog.this.processPrimaryDisk(n2, lDData);
                    IRVirtualDiskCreationDialog.this.refreshArraysWithHoles();
                    IRVirtualDiskCreationDialog.this.refreshParameters();
                    IRVirtualDiskCreationDialog.this.refreshLDSummary();
                }
                catch (Exception exception) {
                    new CustomMsgBox(IRVirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_INVALID_LDOPTION", "Can not create Virtual Disk : Invalid input parameters for creating Virtual Disk !"));
                    exception.printStackTrace();
                }
            }
        });
        if (this.engine.getNewlyCreatedLDs().size() > 0) {
            this.acceptButton.setEnabled(false);
        }
        jPanel2.add(this.acceptButton);
        jPanel.add(jPanel2);
        jPanel2.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 300 / 1024, MainFrame.SCREEN_SIZE.height * 40 / 768));
    }

    @Override
    public void next() {
        if (this.engine.getNewlyCreatedLDs().size() <= 0) {
            new CustomMsgBox(this, Resource.getString("MSG_NOLD_TEXT", "Please create at least one virtual disk and then proceed to next step !"));
            return;
        }
        this.dispose();
        new FinishWizardDialog(this.engine, false, this.getSelectedMode());
    }

    @Override
    public void back() {
        this.dispose();
        new ArraySelectionDialog(this.engine, this.getSelectedMode());
    }

    @Override
    public Object[] getStepNames(boolean bl) {
        if (bl) {
            Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP", "Mode (S)election"), Resource.getString("MANUAL_MODE_ARRAY", "(A)rray Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE", "V(i)rtual Disk Creation"), Resource.getString("MANUAL_MODE_FINISH", "Fi(n)ish")};
            return objectArray;
        }
        Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP_1", "Mode Selection"), Resource.getString("MANUAL_MODE_ARRAY_1", "Array Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE_1", "Virtual Disk Creation"), Resource.getString("MANUAL_MODE_FINISH_1", "Finish")};
        return objectArray;
    }

    @Override
    public int getStep() {
        return 2;
    }

    @Override
    public void goToStep(int n) {
        if (n == 1) {
            this.back();
        } else if (n == 3) {
            this.next();
        }
    }

    private void refreshParameters() {
        Object object;
        this.holeData.clear();
        if (this.arrayCmb.getSelectedIndex() >= 0) {
            object = (ArrayData)((GUIData)this.arrayCmb.getSelectedItem()).value;
            this.holeData.add(new ArrayHoleData((ArrayData)object, 0));
        }
        if (this.holeData.size() <= 0) {
            this.initRightPart(false);
            return;
        }
        try {
            object = new ArrayList();
            ((ArrayList)object).add(((GUIData)this.arrayCmb.getSelectedItem()).value);
            this.possibleRAIDLevelSize = this.engine.getPossibleRAIDLevelAndSize((ArrayList)object);
            Vector<GUIData> vector = new Vector<GUIData>();
            for (int i = 0; i < this.possibleRAIDLevelSize.size(); ++i) {
                RAIDLevelAndSize rAIDLevelAndSize = (RAIDLevelAndSize)this.possibleRAIDLevelSize.get(i);
                byte by = rAIDLevelAndSize.getGUIRAIDLevel();
                GUIData gUIData = new GUIData(this.RAIDLevelString(by), by);
                vector.add(gUIData);
            }
            this.rdLevel.setModel(new DefaultComboBoxModel(vector));
            this.rdLevel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (IRVirtualDiskCreationDialog.this.rdLevel.getSelectedIndex() < 0) {
                        return;
                    }
                    GUIData gUIData = (GUIData)IRVirtualDiskCreationDialog.this.rdLevel.getSelectedItem();
                    for (int i = 0; i < IRVirtualDiskCreationDialog.this.possibleRAIDLevelSize.size(); ++i) {
                        RAIDLevelAndSize rAIDLevelAndSize = (RAIDLevelAndSize)IRVirtualDiskCreationDialog.this.possibleRAIDLevelSize.get(i);
                        if (rAIDLevelAndSize.getGUIRAIDLevel() != gUIData.flag) continue;
                        IRVirtualDiskCreationDialog.this.maxSizeInBlocks = rAIDLevelAndSize.getMaxSizeInBlocks();
                        double[] dArray = KernelConstants.getSizeAndUnit(rAIDLevelAndSize.getMaxSizeInBlocks());
                        double[] dArray2 = KernelConstants.getSizeAndUnit(rAIDLevelAndSize.getMinSizeInBlocks());
                        if (dArray[1] != dArray2[1]) {
                            dArray2[0] = KernelConstants.getSizeInSpecifiedUnit(dArray2[0], (int)dArray2[1], (int)dArray[1]);
                            dArray2[1] = dArray[1];
                        }
                        ((IRVirtualDiskCreationDialog)IRVirtualDiskCreationDialog.this).maxSizeAndUnit[0] = dArray[0];
                        ((IRVirtualDiskCreationDialog)IRVirtualDiskCreationDialog.this).maxSizeAndUnit[1] = dArray[1];
                        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(dArray[0], dArray2[0], dArray[0], 1.0);
                        IRVirtualDiskCreationDialog.this.sizeText.setModel(spinnerNumberModel);
                        IRVirtualDiskCreationDialog.this.sizeUnitModel.setUnit((int)dArray[1]);
                    }
                }
            });
            this.initRightPart(true);
        }
        catch (Exception exception) {
            new CustomMsgBox(this, Resource.getString("MSG_GETRDLEVELSIZE_FAILED", "Can not get possible RAID level and size : Unknown Exception !"));
            exception.printStackTrace();
        }
    }

    private String RAIDLevelString(int n) {
        String string = Resource.getString("RAID_TEXT", "RAID") + " ";
        switch (n) {
            case 0: {
                return string + "0";
            }
            case 1: {
                return string + "1";
            }
            case 17: {
                if (this.engine.getCurrentAdapter().getAdapterType() == 3 || this.engine.getCurrentAdapter().getAdapterType() == 4) {
                    if (this.engine.getCurrentAdapter().getInformation().getadapterOperations_MR_CTRL_INFO().isSupportOddEvenIn1E()) {
                        ArrayList arrayList = this.engine.getNewArraysCreated();
                        ArrayData arrayData = (ArrayData)arrayList.get(0);
                        if (arrayData.getConstituentPDList().size() % 2 == 0) {
                            return string + "10";
                        }
                        return string + "1E";
                    }
                    return string + "10";
                }
                return string + "1E";
            }
            case 5: {
                return string + "5";
            }
            case 65: {
                return string + "10";
            }
            case 69: {
                return string + "50";
            }
            case 6: {
                return string + "6";
            }
            case 70: {
                return string + "60";
            }
        }
        return string;
    }

    private void initRightPart(boolean bl) {
        this.rdLevel.setEnabled(bl);
        this.acceptButton.setEnabled(bl);
        if (this.engine.getNewlyCreatedLDs().size() > 0) {
            this.acceptButton.setEnabled(false);
        }
        if (bl) {
            this.rdLevel.setSelectedIndex(-1);
            this.setDefaultRAIDLevel(this.rdLevel);
        }
    }

    private void refreshLDSummary() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.returnRootForRefreshLDSummary();
        this.ldTreeView.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        if (this.engine.getNewlyCreatedLDs().size() > 0) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
        IRVirtualDiskCreationDialog.expandTree(this.ldTreeView);
    }

    public void refreshSplitPane() {
        if (this.split != null) {
            this.arrayHolderScrollPane.validate();
            this.split.validate();
            this.split.setDividerLocation(-1);
        }
    }

    public void setDefaultRAIDLevel(JComboBox jComboBox) {
        if (jComboBox.getItemCount() > 0) {
            jComboBox.setSelectedIndex(0);
        }
        for (int i = 1; i < jComboBox.getItemCount(); ++i) {
            GUIData gUIData = (GUIData)jComboBox.getItemAt(i);
            if (gUIData.flag != 5 && gUIData.flag != 1) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public String getStatus() {
        return Resource.getString("MSG_STATUS_IR_MANUALVDCREATE", "<html>Select one Array from the top left panel, change the various properties and press accept to create a virtual disk.To undo creation of virtual disk, select the virtual disk and press reclaim</html>");
    }

    private void validatePrimaryDiskButton(GUIData gUIData) {
        this.changePrimaryDiskButton.setVisible(false);
        if (gUIData == null) {
            return;
        }
        if (!(gUIData.value instanceof LDData)) {
            return;
        }
        if (((LDData)gUIData.value).getGUIRAIDLavel() == 1) {
            this.changePrimaryDiskButton.setVisible(true);
        }
    }

    private void processPrimaryDisk(int n, LDData lDData) {
        if (n != 1) {
            return;
        }
        try {
            if (new PrimaryDiskSelectionDialog((IRConfigEngine)this.engine, lDData, 2, this.getSelectedMode()).isPrimaryDiskChanged()) {
                this.refreshLDSummary();
                this.validatePrimaryDiskButton(null);
            }
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            vKObjectNotPresentException.printStackTrace();
            return;
        }
    }

    @Override
    public String getHelpPage() {
        switch (this.getSelectedMode()) {
            case 2: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_MANUAL_DIALOG");
            }
            case 1: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_AUTO_DIALOG");
            }
            case 3: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_GUIDED_DIALOG");
            }
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }
}

