/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import KernelExceptions.VKObjectNotPresentException;
import SASKernel.ConfigurationHelpers.ArrayHoleData;
import SASKernel.ConfigurationHelpers.ConfigurationNotAllowedException;
import SASKernel.ConfigurationHelpers.IRConfigHelper.IRConfigEngine;
import SASKernel.ConfigurationHelpers.IlligalConfigOperationException;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.ColorHash;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.GUIData;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;

public class PrimaryDiskSelectionDialog
extends VivaldiBaseDialog
implements ItemListener {
    IRConfigEngine i_objIRConfigEngine;
    ArrayList i_objPrimaryDiskList;
    ArrayList i_objAllDiskList;
    LDData i_objLDData;
    int i_intDeviceType;
    ButtonGroup i_objRadioGroup = new ButtonGroup();
    JRadioButton[] i_objRadioButtons = null;
    JButton i_objOkButton = new JButton(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
    private boolean i_boolSelectPrimaryDisk = false;
    private short i_shortDeviceId = (short)-1;
    private boolean i_boolPrimaryDiskChanged = false;
    private int i_intSelectedMode = 0;

    public PrimaryDiskSelectionDialog(IRConfigEngine iRConfigEngine, LDData lDData, int n, int n2) throws VKObjectNotPresentException {
        this.i_intSelectedMode = n2;
        if (iRConfigEngine == null) {
            throw new VKObjectNotPresentException(7);
        }
        this.i_objIRConfigEngine = iRConfigEngine;
        this.i_objPrimaryDiskList = iRConfigEngine.getEligiblePrimaryDisks();
        this.i_objAllDiskList = ((ArrayHoleData)lDData.constituentArrayHoles().get(0)).getArrayData().getConstituentPDList();
        this.i_intDeviceType = n;
        this.init();
        this.setSize(MainFrame.SCREEN_SIZE.width * 412 / 1024, MainFrame.SCREEN_SIZE.height * 280 / 768);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        this.setResizable(false);
        this.setModal(true);
        this.show();
    }

    @Override
    protected boolean closeWindowFunction(WindowEvent windowEvent) {
        return this.performOkButton();
    }

    private void init() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        JPanel jPanel2 = new JPanel();
        this.i_objRadioButtons = this.createRadioButtons();
        if (this.i_objRadioButtons.length != 0) {
            for (int i = 0; i < this.i_objRadioButtons.length; ++i) {
                if (i % 2 == 1) {
                    this.i_objRadioButtons[i].setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR1"));
                } else {
                    this.i_objRadioButtons[i].setBackground(ColorHash.getColor("PROPERTY_VIEW_COLOR2"));
                }
                jPanel.add(this.i_objRadioButtons[i]);
                this.i_objRadioGroup.add(this.i_objRadioButtons[i]);
            }
        }
        if (this.i_objRadioGroup.getSelection() == null) {
            this.setTitle(Resource.getString("TITLE_SELECT_PRIMARY_DISK", "Select Primary Disk"));
        } else {
            this.setTitle(Resource.getString("BUTTON_SELECTPRIMARYDISK_TEXT", "Change Primary Disk"));
        }
        this.i_objOkButton.setToolTipText(Resource.getString("ABOUT_OKBUTTON_TEXT_DSC", "OK"));
        this.i_objOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrimaryDiskSelectionDialog.this.performOkButton();
            }
        });
        jPanel2.add(this.i_objOkButton);
        this.contentPane.add(new JScrollPane(jPanel));
        this.contentPane.add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(this.i_objOkButton);
    }

    private boolean performOkButton() {
        if (!this.i_boolSelectPrimaryDisk) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_SELECT_PRIMARY_DISK", "Please select one disk as Primary Disk !"));
            return false;
        }
        if (this.setPrimaryDisk()) {
            this.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.i_boolSelectPrimaryDisk = true;
        if (itemEvent.getSource() instanceof PrimaryDiskButton) {
            this.i_shortDeviceId = ((PrimaryDiskButton)itemEvent.getSource()).getDeviceId();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.i_boolSelectPrimaryDisk = true;
        if (changeEvent.getSource() instanceof PrimaryDiskButton) {
            this.i_shortDeviceId = ((PrimaryDiskButton)changeEvent.getSource()).getDeviceId();
        }
    }

    private boolean setPrimaryDisk() {
        short s;
        short s2 = s = this.i_objIRConfigEngine.getPrimaryDisk() != null ? (short)this.i_objIRConfigEngine.getPrimaryDisk().getDeviceId() : (short)-1;
        if (s == this.i_shortDeviceId) {
            this.i_boolPrimaryDiskChanged = false;
            return true;
        }
        this.i_boolPrimaryDiskChanged = true;
        try {
            this.i_objIRConfigEngine.setPrimaryDisk(this.i_shortDeviceId);
            return true;
        }
        catch (ConfigurationNotAllowedException configurationNotAllowedException) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_SELECT_PRIMARY_DISK", "Please select one disk as Primary Disk !"));
        }
        catch (IlligalConfigOperationException illigalConfigOperationException) {
            new CustomMsgBox(this.getContentPane(), Resource.getString("MSG_SELECT_PRIMARY_DISK", "Please select one disk as Primary Disk !"));
        }
        return false;
    }

    private JRadioButton[] createRadioButtons() {
        boolean bl = this.i_objIRConfigEngine.isPrimaryDiskSelected();
        JRadioButton[] jRadioButtonArray = null;
        if (this.i_objAllDiskList == null || this.i_objAllDiskList.size() == 0) {
            jRadioButtonArray = new PrimaryDiskButton[]{};
            return jRadioButtonArray;
        }
        jRadioButtonArray = new PrimaryDiskButton[this.i_objAllDiskList.size()];
        for (int i = 0; i < this.i_objAllDiskList.size(); ++i) {
            jRadioButtonArray[i] = new PrimaryDiskButton(new GUIData((SASPhysicalDrive)this.i_objAllDiskList.get(i), this.i_intDeviceType));
            jRadioButtonArray[i].addItemListener(this);
            if (this.isPrimaryDisk((SASPhysicalDrive)this.i_objAllDiskList.get(i))) {
                if (bl && ((SASPhysicalDrive)this.i_objAllDiskList.get(i)).getDeviceId() == this.i_objIRConfigEngine.getPrimaryDisk().getDeviceId()) {
                    jRadioButtonArray[i].setSelected(true);
                }
                jRadioButtonArray[i].setEnabled(true);
                continue;
            }
            jRadioButtonArray[i].setEnabled(false);
        }
        return jRadioButtonArray;
    }

    private boolean isPrimaryDisk(SASPhysicalDrive sASPhysicalDrive) {
        for (int i = 0; i < this.i_objPrimaryDiskList.size(); ++i) {
            if (((SASPhysicalDrive)this.i_objPrimaryDiskList.get(i)).getDeviceId() != sASPhysicalDrive.getDeviceId()) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryDiskChanged() {
        return this.i_boolPrimaryDiskChanged;
    }

    @Override
    public String getHelpPage() {
        switch (this.i_intSelectedMode) {
            case 2: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_MANUAL_DIALOG");
            }
            case 1: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_AUTO_DIALOG");
            }
            case 3: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_GUIDED_DIALOG");
            }
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }

    class PrimaryDiskButton
    extends JRadioButton {
        short i_shortDeviceId;
        GUIData i_objGUIData;

        PrimaryDiskButton(GUIData gUIData) {
            super(gUIData.toString());
            this.i_objGUIData = gUIData;
            this.setDeviceId(((SASPhysicalDrive)this.i_objGUIData.value).getDeviceId());
        }

        PrimaryDiskButton(String string) {
            super(string);
        }

        private void setDeviceId(short s) {
            this.i_shortDeviceId = s;
        }

        short getDeviceId() {
            return this.i_shortDeviceId;
        }
    }
}

