/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import KernelExceptions.VKObjectNotPresentException;
import SASKernel.ConfigurationHelpers.ArrayData;
import SASKernel.ConfigurationHelpers.ArrayHoleData;
import SASKernel.ConfigurationHelpers.BaseConfigEngine;
import SASKernel.ConfigurationHelpers.IRConfigHelper.IRConfigEngine;
import SASKernel.ConfigurationHelpers.LDData;
import SASKernel.ConfigurationHelpers.RAIDLevelAndSize;
import SASKernel.ConfigurationHelpers.RAIDParameters;
import SASKernel.LibraryAPI.StoreLib.MR_BBU_FW_STATUS;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.CustomComboBox;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.ConfigWizard.ArraySelectionDialog;
import Wizard.ConfigWizard.BaseConfigWizardDialog;
import Wizard.ConfigWizard.FinishWizardDialog;
import Wizard.ConfigWizard.GUIData;
import Wizard.ConfigWizard.ModeSelectionDialog;
import Wizard.UnitsComboBoxModel;
import Wizard.UnitsRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class VirtualDiskCreationDialog
extends BaseConfigWizardDialog {
    private String[] mnemonics;
    private JPanel arrayWithHoles = new JPanel(new GridLayout(0, 1));
    private JComboBox[] arrayCmb = null;
    private JCheckBox[] chBox = null;
    private int selArrayRowNum = -1;
    private ArrayList possibleRAIDLevelSize = null;
    private JPanel rightPart = new JPanel();
    private ArrayList holeData = new ArrayList();
    private JTree ldTreeView = new JTree();
    private JSplitPane split;
    private JComboBox stripeSize;
    private JComboBox readPolicy;
    private JComboBox writePolicy;
    private JComboBox cachePolicy;
    private JComboBox diskCachePolicy;
    private JComboBox accessPolicy;
    private JComboBox initState;
    private JButton acceptButton;
    private JScrollPane arrayHolderScrollPane;
    private JCheckBox bbucheck;
    JPanel sizeAndUnit = new JPanel(new FlowLayout(0, 10, 0));
    private int prevUnit;
    private double[] minSizeAndUnit = new double[2];
    private double[] maxSizeAndUnit = new double[2];
    private long maxSizeInBlocks = 0L;
    private boolean bbuPresent = false;
    private static boolean checkFlag = false;
    private JLabel labelArrays = new JLabel("");
    private JComboBox rdLevel;
    private JSpinner sizeText;
    private JComboBox sizeUnit;
    private UnitsComboBoxModel sizeUnitModel;
    private JComboBox volumeID;
    private JTextField volumeName;
    private byte defWritePolicy = 0;
    static boolean stripFlag = true;

    public VirtualDiskCreationDialog(BaseConfigEngine baseConfigEngine, int n) {
        super(baseConfigEngine);
        this.setSelectedMode(n);
        this.ldTreeView.getSelectionModel().setSelectionMode(1);
        this.refreshArraysWithHoles();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("VDC_LABEL_ARRAY_TEXT", "Arrays"));
        this.labelArrays.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.labelArrays.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel.add((Component)this.labelArrays, "North");
        jPanel.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 250 / 1024, 0));
        this.rightPart.setBorder(BorderFactory.createTitledBorder(Resource.getString("NEWLD_PROPERTY_INPUT", "Virtual Disk Properties")));
        this.rightPart.setLayout(new FlowLayout(0, 5 * MainFrame.SCREEN_SIZE.width / 1024, 5 * MainFrame.SCREEN_SIZE.height / 768));
        this.populateNewLDInputs(this.rightPart);
        this.initRightPart(false);
        this.ldTreeView.setCellRenderer(this.renderer);
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(0, MainFrame.SCREEN_SIZE.height * 160 / 768));
        this.refreshLDSummary();
        jPanel2.setLayout(new BorderLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_NEWVIRTUALDISK_TEXT", " New Virtual Disks"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel2.add((Component)new JScrollPane(this.ldTreeView), "Center");
        jLabel.setLabelFor(this.ldTreeView);
        jPanel2.add((Component)jLabel, "North");
        JPanel jPanel3 = new JPanel(new FlowLayout());
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_RECLAIM_TEXT", "Reclaim"));
        final JButton jButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        jButton.setToolTipText(Resource.getString("BUTTON_RECLAIM_DSC", "Reclaim"));
        jButton.setEnabled(false);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIData gUIData = (GUIData)((DefaultMutableTreeNode)VirtualDiskCreationDialog.this.ldTreeView.getLastSelectedPathComponent()).getUserObject();
                if (gUIData.flag == 3) {
                    if (!CustomMsgBox.confirm(VirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_CONFIRM_LDRECLAIM", "This will delete the newly created Virtual Disk! Are you sure?"))) {
                        return;
                    }
                    try {
                        ((LDData)gUIData.value).deleteNewLD();
                        VirtualDiskCreationDialog.this.refreshArraysWithHoles();
                        VirtualDiskCreationDialog.this.refreshParameters();
                        VirtualDiskCreationDialog.this.refreshLDSummary();
                    }
                    catch (Exception exception) {
                        new CustomMsgBox(VirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_DELETLD_FAILED", "Can not delete newly created Virtual Disk : Unknown Exception !"));
                        exception.printStackTrace();
                    }
                }
            }
        });
        jPanel3.add(jButton);
        jPanel2.add((Component)jPanel3, "South");
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.arrayWithHoles);
        this.arrayHolderScrollPane = new JScrollPane(jPanel4);
        this.arrayHolderScrollPane.setMinimumSize(new Dimension(jPanel4.getWidth(), MainFrame.SCREEN_SIZE.height * 60 / 768));
        this.split = new JSplitPane(0, this.arrayHolderScrollPane, new JScrollPane(jPanel2));
        jPanel.add((Component)this.split, "Center");
        this.centerPanel.setLayout(new BorderLayout(5, 5));
        this.centerPanel.add((Component)jPanel, "West");
        this.centerPanel.add((Component)this.rightPart, "Center");
        if (this.chBox.length > 0) {
            this.chBox[0].doClick();
        }
        GUIUtils.addItemListeningToolTip(this.rdLevel);
        GUIUtils.addItemListeningToolTip(this.volumeID);
        GUIUtils.addItemListeningToolTip(this.stripeSize);
        GUIUtils.addItemListeningToolTip(this.readPolicy);
        GUIUtils.addItemListeningToolTip(this.writePolicy);
        GUIUtils.addItemListeningToolTip(this.cachePolicy);
        GUIUtils.addItemListeningToolTip(this.diskCachePolicy);
        GUIUtils.addItemListeningToolTip(this.accessPolicy);
        GUIUtils.addItemListeningToolTip(this.initState);
        this.ldTreeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                jButton.setEnabled(false);
                if (VirtualDiskCreationDialog.this.ldTreeView.getSelectionCount() <= 0) {
                    return;
                }
                Object object = ((DefaultMutableTreeNode)VirtualDiskCreationDialog.this.ldTreeView.getSelectionPath().getLastPathComponent()).getUserObject();
                if (object instanceof GUIData && ((GUIData)object).flag == 3) {
                    jButton.setEnabled(true);
                }
            }
        });
        this.pack();
        this.setSize(MainFrame.SCREEN_SIZE.width * 800 / 1024, MainFrame.SCREEN_SIZE.height * 600 / 768);
        this.show();
        this.refreshSplitPane();
    }

    private void refreshArraysWithHoles() {
        this.selArrayRowNum = -1;
        this.arrayWithHoles.removeAll();
        ArrayList arrayList = this.engine.getArraysWithFreeSpaceRemaining();
        this.arrayCmb = new JComboBox[arrayList.size()];
        this.chBox = new JCheckBox[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayData arrayData = (ArrayData)arrayList.get(i);
            int n = arrayData.getSLArrayInfoT().getfreeCount();
            Object[] objectArray = new Object[n];
            for (int j = 0; j < n; ++j) {
                objectArray[j] = new ArrayHoleData(arrayData, j){

                    public String toString() {
                        String string = super.getArrayData().isOld() ? Resource.getString("ARRAY_TEXT", "Array") : Resource.getString("NEW_ARRAY_TEXT", "New Array");
                        string = string + " " + super.getArrayData().getSLArrayInfoT().getarray().getarrayRef() + " : " + Resource.getString("HOLE_TEXT", "Hole") + " " + super.getFreeIndex() + " : " + KernelConstants.getConvertedSize(super.getRaidSpecificFreeSpaceInBlocks(1));
                        return string;
                    }
                };
            }
            this.chBox[i] = new JCheckBox();
            this.arrayCmb[i] = new CustomComboBox(objectArray);
            this.arrayCmb[i].setEnabled(true);
            this.arrayCmb[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    VirtualDiskCreationDialog.this.refreshParameters();
                }
            });
            this.chBox[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2;
                    int n3;
                    if (checkFlag) {
                        return;
                    }
                    VirtualDiskCreationDialog.this.setEnabled(true);
                    if (VirtualDiskCreationDialog.this.engine.getCurrentAdapter().getAdapterType() == 2) {
                        if (VirtualDiskCreationDialog.this.isVDCompriseOfSASDrives()) {
                            VirtualDiskCreationDialog.this.diskCachePolicy.setSelectedIndex(1);
                        } else if (VirtualDiskCreationDialog.this.isVDCompriseOfSATADrives()) {
                            VirtualDiskCreationDialog.this.diskCachePolicy.setSelectedIndex(0);
                        }
                    } else if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                        VirtualDiskCreationDialog.this.diskCachePolicy.setSelectedIndex(0);
                    } else {
                        VirtualDiskCreationDialog.this.diskCachePolicy.setSelectedIndex(2);
                    }
                    checkFlag = true;
                    JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                    int n4 = -1;
                    for (int i = 0; i < VirtualDiskCreationDialog.this.chBox.length; ++i) {
                        if (VirtualDiskCreationDialog.this.chBox[i] != jCheckBox) continue;
                        n4 = i;
                        break;
                    }
                    if (n4 < 0) {
                        checkFlag = false;
                        return;
                    }
                    if (jCheckBox.isSelected() && !VirtualDiskCreationDialog.this.engine.newLDCanBeAdded()) {
                        jCheckBox.setSelected(false);
                        new CustomMsgBox(Resource.getString("MSG_NO_MORE_VD", "No more virtual disk can be added"));
                        checkFlag = false;
                        return;
                    }
                    ArrayHoleData arrayHoleData = (ArrayHoleData)VirtualDiskCreationDialog.this.arrayCmb[n4].getSelectedItem();
                    if (arrayHoleData == null) {
                        checkFlag = false;
                        return;
                    }
                    ArrayData arrayData = arrayHoleData.getArrayData();
                    int n5 = VirtualDiskCreationDialog.this.engine.getCurrentAdapter().getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixSSDHDDInLD();
                    int n6 = VirtualDiskCreationDialog.this.engine.getCurrentAdapter().getInformation().getpdMixSupport_MR_CTRL_INFO().getallowSSDMixInLD();
                    int n7 = VirtualDiskCreationDialog.this.engine.getCurrentAdapter().getInformation().getpdMixSupport_MR_CTRL_INFO().getallowMixInLD();
                    ArrayList arrayList = arrayData.getConstituentPDList();
                    for (n3 = 0; n3 < arrayList.size(); ++n3) {
                        n2 = ((SASPhysicalDrive)arrayList.get(n3)).getMediatype();
                        n = ((SASPhysicalDrive)arrayList.get(n3)).getDriveType();
                        for (int i = 0; i < VirtualDiskCreationDialog.this.chBox.length; ++i) {
                            if (i == n4 || !VirtualDiskCreationDialog.this.chBox[i].isSelected()) continue;
                            ArrayList arrayList2 = ((ArrayHoleData)VirtualDiskCreationDialog.this.arrayCmb[i].getSelectedItem()).getArrayData().getConstituentPDList();
                            for (int j = 0; j < arrayList2.size(); ++j) {
                                byte by = ((SASPhysicalDrive)arrayList2.get(j)).getMediatype();
                                byte by2 = ((SASPhysicalDrive)arrayList2.get(j)).getDriveType();
                                if (((SASPhysicalDrive)arrayList.get(n3)).getInformation().getUserDataBlockSize() != ((SASPhysicalDrive)arrayList2.get(j)).getInformation().getUserDataBlockSize()) {
                                    jCheckBox.setSelected(false);
                                    checkFlag = false;
                                    return;
                                }
                                if (n2 != by && n5 == 0) {
                                    String string = new String(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix ") + Resource.getString("TEXT_DRIVE_TYPE_SSD", "SSD ") + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with ") + Resource.getString("TEXT_DRIVE_TYPE_NON_SSD", "non-SSD ") + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives."));
                                    new CustomMsgBox(string);
                                    jCheckBox.setSelected(false);
                                    checkFlag = false;
                                    return;
                                }
                                if (by == 1 && n2 == 1 && n != by2 && n6 == 0) {
                                    String string = new String(Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES", "The drive group contains an unsupported mix of drives. You cannot mix ") + Resource.getString("TEXT_DRIVE_TYPE_SSD_SAS", "SSD(SAS) ") + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT1", "drives with ") + Resource.getString("TEXT_DRIVE_TYPE_SSD_SATA", "SSD(SATA) ") + Resource.getString("MSG_UNSUPPROTED_MIX_OF_DRIVES_TEXT2", "drives."));
                                    new CustomMsgBox(string);
                                    jCheckBox.setSelected(false);
                                    checkFlag = false;
                                    return;
                                }
                                if (n7 != 0 && !(VirtualDiskCreationDialog.this.engine instanceof IRConfigEngine)) continue;
                                if (n2 == 0 && by == 0) {
                                    if (n == by2) continue;
                                    new CustomMsgBox(Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array."));
                                    jCheckBox.setSelected(false);
                                    checkFlag = false;
                                    return;
                                }
                                if (n5 != 0 || n2 == by) continue;
                                new CustomMsgBox(Resource.getString("MSG_SAS_SATA_MIX_NOT_ALLOWED", "Configuration is not possible with SAS/SATA mixed drives. Please select same types of drive to add into this array."));
                                return;
                            }
                        }
                    }
                    if (jCheckBox.isSelected()) {
                        VirtualDiskCreationDialog.this.arrayCmb[n4].setEnabled(true);
                        n3 = 0;
                        for (n2 = 0; n2 < VirtualDiskCreationDialog.this.chBox.length; ++n2) {
                            if (n2 == n4 || ((ArrayHoleData)VirtualDiskCreationDialog.this.arrayCmb[n2].getSelectedItem()).getArrayData().canSpan(arrayData)) {
                                if (VirtualDiskCreationDialog.this.chBox[n2].isSelected()) {
                                    ++n3;
                                }
                                VirtualDiskCreationDialog.this.chBox[n2].setEnabled(true);
                                VirtualDiskCreationDialog.this.arrayCmb[n2].setEnabled(true);
                                if (((ArrayHoleData)VirtualDiskCreationDialog.this.arrayCmb[n2].getSelectedItem()).getArrayData().getLogicalDriveCount() > 0) {
                                    VirtualDiskCreationDialog.this.chBox[n2].setSelected(true);
                                }
                                if (n3 < 8) continue;
                                for (n = 0; n < VirtualDiskCreationDialog.this.chBox.length; ++n) {
                                    if (VirtualDiskCreationDialog.this.chBox[n].isSelected()) continue;
                                    VirtualDiskCreationDialog.this.chBox[n].setSelected(false);
                                    VirtualDiskCreationDialog.this.chBox[n].setEnabled(false);
                                    VirtualDiskCreationDialog.this.arrayCmb[n].setEnabled(false);
                                }
                                break;
                            }
                            VirtualDiskCreationDialog.this.chBox[n2].setSelected(false);
                            VirtualDiskCreationDialog.this.chBox[n2].setEnabled(false);
                            VirtualDiskCreationDialog.this.arrayCmb[n2].setEnabled(false);
                        }
                    } else {
                        VirtualDiskCreationDialog.this.arrayCmb[n4].setEnabled(true);
                        for (n3 = 0; n3 < VirtualDiskCreationDialog.this.chBox.length; ++n3) {
                            if (n3 != n4 && !((ArrayHoleData)VirtualDiskCreationDialog.this.arrayCmb[n3].getSelectedItem()).getArrayData().canSpan(arrayData)) continue;
                            VirtualDiskCreationDialog.this.chBox[n3].setEnabled(true);
                            VirtualDiskCreationDialog.this.arrayCmb[n3].setEnabled(true);
                            if (((ArrayHoleData)VirtualDiskCreationDialog.this.arrayCmb[n3].getSelectedItem()).getArrayData().getLogicalDriveCount() <= 0) continue;
                            VirtualDiskCreationDialog.this.chBox[n3].setSelected(false);
                        }
                        n3 = 0;
                        for (n2 = 0; n2 < VirtualDiskCreationDialog.this.chBox.length; ++n2) {
                            if (!VirtualDiskCreationDialog.this.chBox[n2].isSelected()) continue;
                            ++n3;
                        }
                        if (n3 <= 0) {
                            for (n2 = 0; n2 < VirtualDiskCreationDialog.this.chBox.length; ++n2) {
                                VirtualDiskCreationDialog.this.chBox[n2].setEnabled(true);
                                VirtualDiskCreationDialog.this.arrayCmb[n2].setEnabled(true);
                            }
                        }
                    }
                    VirtualDiskCreationDialog.this.refreshParameters();
                    checkFlag = false;
                }
            });
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(this.chBox[i]);
            if (i == 0) {
                this.mnemonics = Resource.getResourceMnemonic(Resource.getString("VDC_LABEL_ARRAY_TEXT", "Arrays"));
                if (this.mnemonics.length == 2) {
                    this.chBox[i].setMnemonic(this.mnemonics[1].charAt(0));
                }
            }
            jPanel.add(this.arrayCmb[i]);
            this.chBox[i].setOpaque(false);
            this.arrayCmb[i].setOpaque(false);
            jPanel.setOpaque(false);
            this.arrayWithHoles.add(jPanel);
        }
        this.arrayWithHoles.validate();
        this.refreshSplitPane();
        this.validate();
    }

    private void populateNewLDInputs(JPanel jPanel) {
        int n;
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_RAIDLEVEL_TEXT", "RAID Level : "));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.rdLevel = new CustomComboBox();
        jLabel.setLabelFor(this.rdLevel);
        this.rdLevel.requestFocusInWindow();
        jPanel.add(jLabel);
        jPanel.add(this.rdLevel);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_SIZE_TEXT", "Size: "));
        JLabel jLabel2 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel2.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel.add(jLabel2);
        this.sizeText = new JSpinner();
        this.sizeAndUnit.add(this.sizeText);
        this.sizeUnitModel = new UnitsComboBoxModel(-1);
        this.sizeUnit = new JComboBox(this.sizeUnitModel);
        this.sizeUnit.setRenderer(new UnitsRenderer());
        this.sizeAndUnit.add(this.sizeUnit);
        jPanel.add(this.sizeAndUnit);
        jLabel2.setLabelFor(this.sizeText);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_VOLUMEID_TEXT", "Volume ID : "));
        JLabel jLabel3 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel3.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.volumeID = new CustomComboBox();
        jLabel3.setLabelFor(this.volumeID);
        jPanel.add(jLabel3);
        jPanel.add(this.volumeID);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_VOLUMENAME_TEXT", "Volume Name : "));
        JLabel jLabel4 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel4.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.volumeName = new JTextField();
        this.volumeName.setToolTipText(Resource.getString("VOLUMENAME_DSC", "Volume Name"));
        jLabel4.setLabelFor(this.volumeName);
        if (!Resource.isLocaleSupportedForOEM()) {
            this.volumeName.setEnabled(false);
            this.volumeName.setText("");
        } else {
            this.volumeName.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\b') {
                        return;
                    }
                    if (VirtualDiskCreationDialog.this.volumeName.getText().length() >= 15) {
                        keyEvent.consume();
                    }
                }
            });
        }
        jPanel.add(jLabel4);
        jPanel.add(this.volumeName);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_STRIPESIZE_TEXT", "Stripe Size : "));
        JLabel jLabel5 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel5.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        SASAdapter sASAdapter = this.engine.getCurrentAdapter();
        int n2 = sASAdapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmin();
        char c = sASAdapter.getInformation().getstripeSizeOptions_MR_CTRL_INFO().getmax();
        DefaultComboBoxModel<GUIData> defaultComboBoxModel = new DefaultComboBoxModel<GUIData>();
        for (n = n2; n <= c; ++n) {
            int n3;
            if (n == 0) {
                defaultComboBoxModel.addElement(new GUIData("512 Byte", n));
                continue;
            }
            if (n < 11) {
                n3 = (int)Math.pow(2.0, n - '\u0001');
                defaultComboBoxModel.addElement(new GUIData(n3 + " KB", n));
                continue;
            }
            n3 = (int)Math.pow(2.0, n - 11);
            defaultComboBoxModel.addElement(new GUIData(n3 + " MB", n));
        }
        this.stripeSize = new CustomComboBox((ComboBoxModel)defaultComboBoxModel);
        jLabel5.setLabelFor(this.stripeSize);
        this.stripeSize.setToolTipText(Resource.getString("STRIPE_SIZE_DSC", "Stripe Size"));
        n = this.engine.getmfcDefaults().getstripeSize();
        if (n2 <= n && c >= n) {
            this.stripeSize.setSelectedIndex(n - n2);
        }
        jPanel.add(jLabel5);
        jPanel.add(this.stripeSize);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("VDC_LABEL_READPOLICY_TEXT", "Read Policy : "));
        JLabel jLabel6 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel6.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.readPolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("READ_AHEAD_NONE", "No Read Ahead"), 0), new GUIData(Resource.getString("READ_AHEAD_ADAPTIVE", "Adaptive Read Ahead"), 12), new GUIData(Resource.getString("READ_AHEAD_ALWAYS", "Always Read Ahead"), 4)});
        byte by = this.engine.getmfcDefaults().getreadAhead();
        GUIUtils.setDefaultValueToJComboBoxFromGUIData(this.readPolicy, by);
        jLabel6.setLabelFor(this.readPolicy);
        this.readPolicy.setToolTipText(Resource.getString("READ_POLICY_DSC", "Read Policy"));
        jPanel.add(jLabel6);
        jPanel.add(this.readPolicy);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_DEFWRITEPOLICY_TEXT", "Default Write Policy : "));
        JLabel jLabel7 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel7.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.bbuPresent = false;
        try {
            sASAdapter.getBBUObject();
            this.bbuPresent = true;
        }
        catch (VKObjectNotPresentException vKObjectNotPresentException) {
            // empty catch block
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("VDC_VD_WR_POLICY_BAD_BBU", "Use Write Through for failed or missing battery"));
        this.writePolicy = new JComboBox<Object>(new Object[]{new GUIData(Resource.getString("WRITE_THROUGH", "Write Through"), 0), new GUIData(Resource.getString("WRITE_BACK", "Write Back"), 17), new GUIData(Resource.getString("WRITE_BACK_WITH_BBU", "Write Back with BBU"), 1)});
        this.writePolicy.setToolTipText(Resource.getString("WRITE_POLICY_DSC", "Write Policy"));
        int n4 = this.engine.getmfcDefaults().getwriteBack() == 0 ? 0 : (this.engine.getmfcDefaults().getcacheWhenBBUBad() == 1 ? 17 : 1);
        GUIUtils.setDefaultValueToJComboBoxFromGUIData(this.writePolicy, n4);
        jLabel7.setLabelFor(this.writePolicy);
        jPanel.add(jLabel7);
        jPanel.add(this.writePolicy);
        this.writePolicy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
            }
        });
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_IOPOLICY_TEXT", "IO Policy"));
        JLabel jLabel8 = new JLabel(this.mnemonics[0] + " : ");
        if (this.mnemonics.length == 2) {
            jLabel8.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.cachePolicy = new JComboBox<Object>(new Object[]{new GUIData(Resource.getString("DIRECT_IO", "Direct IO"), 0), new GUIData(Resource.getString("CACHED_IO", "Cached IO"), 96)});
        this.cachePolicy.setToolTipText(Resource.getString("CACHE_POLICY_DSC", "Cache Policy"));
        byte by2 = this.engine.getmfcDefaults().getcachedIo();
        GUIUtils.setDefaultValueToJComboBoxFromGUIData(this.cachePolicy, by2);
        jLabel8.setLabelFor(this.cachePolicy);
        jPanel.add(jLabel8);
        jPanel.add(this.cachePolicy);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("VDC_LABEL_ACCESSPOLICY_TEXT", "Access Policy : "));
        JLabel jLabel9 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel9.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.accessPolicy = new CustomComboBox(new Object[]{new GUIData(Resource.getString("ACCESS_READ_WRITE", "Read Write"), 0), new GUIData(Resource.getString("ACCESS_READ_ONLY", "Read Only"), 2), new GUIData(Resource.getString("ACCESS_BLOCKED", "Blocked"), 3)});
        jLabel9.setLabelFor(this.accessPolicy);
        this.accessPolicy.setToolTipText(Resource.getString("ACCESSPOLICY_DSC", "Access Policy"));
        jPanel.add(jLabel9);
        jPanel.add(this.accessPolicy);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_DISKCACHEPOLICY_TEXT", "Disk Cache Policy : "));
        JLabel jLabel10 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel10.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        Object[] objectArray = null;
        objectArray = this.engine.getCurrentAdapter().getAdapterType() == 2 ? new Object[]{new GUIData(Resource.getString("DISK_CACHE_ENABLED", "Enabled"), 1), new GUIData(Resource.getString("DISK_CACHE_DISABLED", "Disabled"), 2)} : new Object[]{new GUIData(Resource.getString("DISK_CACHE_UNCHANGED", "Unchanged"), 0), new GUIData(Resource.getString("DISK_CACHE_ENABLED", "Enabled"), 1), new GUIData(Resource.getString("DISK_CACHE_DISABLED", "Disabled"), 2)};
        this.diskCachePolicy = new CustomComboBox(objectArray);
        this.diskCachePolicy.setToolTipText(Resource.getString("DISK_CACHEPOLICY_DSC", "Disk Cache Policy"));
        if (this.engine.getCurrentAdapter().getInformation().getldOperations_MR_CTRL_INFO().getdiskCachePolicy() != 0) {
            jLabel10.setLabelFor(this.diskCachePolicy);
            jPanel.add(jLabel10);
            jPanel.add(this.diskCachePolicy);
        }
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_INITSTATE_TEXT", "Init State : "));
        JLabel jLabel11 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel11.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        this.initState = new CustomComboBox(new Object[]{new GUIData(Resource.getString("NO_INIT_TEXT", "No Initialization"), 0), new GUIData(Resource.getString("QUICK_INIT_TEXT", "Fast Initialization"), 1), new GUIData(Resource.getString("FULL_INIT_TEXT", "Full Initialization"), 2)});
        jLabel11.setLabelFor(this.initState);
        this.initState.setToolTipText(Resource.getString("INITSTATE_DSC", "Initialization state"));
        jPanel.add(jLabel11);
        jPanel.add(this.initState);
        Dimension dimension = new Dimension(MainFrame.SCREEN_SIZE.width * 160 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        Dimension dimension2 = new Dimension(MainFrame.SCREEN_SIZE.width * 150 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        jLabel.setPreferredSize(dimension2);
        jLabel.setToolTipText(jLabel.getText());
        this.rdLevel.setPreferredSize(dimension);
        jLabel5.setPreferredSize(dimension2);
        jLabel5.setToolTipText(jLabel5.getText());
        this.stripeSize.setPreferredSize(dimension);
        jLabel6.setPreferredSize(dimension2);
        jLabel6.setToolTipText(jLabel6.getText());
        this.readPolicy.setPreferredSize(dimension);
        jLabel7.setPreferredSize(dimension2);
        jLabel7.setToolTipText(jLabel7.getText());
        this.writePolicy.setPreferredSize(dimension);
        jLabel8.setPreferredSize(dimension2);
        jLabel8.setToolTipText(jLabel8.getText());
        this.cachePolicy.setPreferredSize(dimension);
        Dimension dimension3 = new Dimension(MainFrame.SCREEN_SIZE.width * 90 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        Dimension dimension4 = new Dimension(MainFrame.SCREEN_SIZE.width * 140 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        jLabel2.setPreferredSize(dimension4);
        jLabel2.setToolTipText(jLabel2.getText());
        this.sizeText.setPreferredSize(dimension3);
        dimension3 = new Dimension(MainFrame.SCREEN_SIZE.width * 60 / 1024, MainFrame.SCREEN_SIZE.height * 25 / 768);
        this.sizeUnit.setPreferredSize(dimension3);
        jLabel4.setPreferredSize(dimension2);
        jLabel4.setToolTipText(jLabel4.getText());
        this.volumeName.setPreferredSize(dimension);
        jLabel3.setPreferredSize(dimension2);
        jLabel3.setToolTipText(jLabel3.getText());
        this.volumeID.setPreferredSize(dimension);
        jLabel9.setPreferredSize(dimension2);
        jLabel9.setToolTipText(jLabel9.getText());
        this.accessPolicy.setPreferredSize(dimension);
        jLabel10.setPreferredSize(dimension2);
        jLabel10.setToolTipText(jLabel10.getText());
        this.diskCachePolicy.setPreferredSize(dimension);
        jLabel11.setPreferredSize(dimension2);
        jLabel11.setToolTipText(jLabel11.getText());
        this.initState.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_ACCEPT_TEXT", "Accept"));
        this.acceptButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.acceptButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.acceptButton.setToolTipText(Resource.getString("BUTTON_ACCEPT_DSC", "Accept"));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Object object;
                Object object2;
                Object object3;
                int n2;
                if (!VirtualDiskCreationDialog.this.rdLevel.isEnabled()) {
                    new CustomMsgBox(VirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_SELECT_ARRAY", "Please select one or more arrays !"));
                    return;
                }
                int n3 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).rdLevel.getSelectedItem()).flag;
                for (n2 = 0; n2 < VirtualDiskCreationDialog.this.holeData.size(); ++n2) {
                    object3 = (ArrayHoleData)VirtualDiskCreationDialog.this.holeData.get(n2);
                    object2 = ((ArrayHoleData)object3).getArrayData();
                    object = ((ArrayData)object2).getOldDedicatedSpares();
                    if (!VirtualDiskCreationDialog.this.engine.checkForDDFValue((ArrayData)object2) || CustomMsgBox.confirm(VirtualDiskCreationDialog.this.getContentPane(), Resource.getString("CONFIRM_64_VDS_DDF_PARTITION", "Following this operation, your storage configuration \nwill contain more than 16 virtual disks.While supported \nby your system, the configuration ay not be compatible \nwith other systems that support a maximum of 16 virtual \ndisks per array.Proceeding with this operation may prevent \nyou from moving your configuration to an incompatible system\nAre you sure you want to continue?"))) continue;
                    return;
                }
                n2 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).writePolicy.getSelectedItem()).flag;
                object3 = null;
                object2 = null;
                if (n2 == 0) {
                    object3 = Resource.getString("TITLE_WRITE_THROUGH_SELECTED", "Write Through Selected");
                    object2 = Resource.getString("WRITE_THROUGH_SELECTED_DESC", "<html>Write Through mode eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Are you sure you want to select Write Through mode? <br><br></html>");
                } else if (n2 == 17) {
                    object3 = Resource.getString("TITLE_ALWAYS_WRITE_BACK_SELECTED", "Always Write Back Selected");
                    object2 = Resource.getString("ALWAYS_WRITE_BACK_SELECTED_DESC", "<html>Always Write Back mode provides optimal performance, but data loss will <br>occur if there is a power failure and no cache battery installed or the battery <br>is failed or discharged.<br><br>Are you sure you want to select Always Write Back mode? <br><br></html> ");
                } else if (n2 == 1) {
                    object3 = Resource.getString("TITLE_WRITE_BACK_WITH_BBU_SELECTED", "Write Back with BBU Selected");
                    object2 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_DESC", "<html>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance. <br><br>However, slower performance should be expected when BBU is not <br>installed,not fully charged, or running through re-learn cycle.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                    if (VirtualDiskCreationDialog.this.engine.getCurrentAdapter().getInformation().gethwPresent_MR_CTRL_INFO().getbbu() == 0) {
                        object2 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                    } else {
                        object = null;
                        int n4 = 5;
                        try {
                            n4 = VirtualDiskCreationDialog.this.engine.getCurrentAdapter().getBBUObject().getInformation().getStatus().getbatteryType();
                            object = VirtualDiskCreationDialog.this.engine.getCurrentAdapter().getBBUObject().getStatus().getMrbbufwStatus();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (((MR_BBU_FW_STATUS)object).getreplacePack() || ((MR_BBU_FW_STATUS)object).getremainingCapacityLow()) {
                            object2 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                        } else if (n4 == 1 && (((MR_BBU_FW_STATUS)object).getlearnCycleRequested() || ((MR_BBU_FW_STATUS)object).getlearnCycleActive() || ((MR_BBU_FW_STATUS)object).getdischargeActive())) {
                            object2 = Resource.getString("WRITE_BACK_WITH_BBU_SELECTED_NO_OR_BAD_BATTERY_DESC", "<html>You have selected Write Back with BBU.<br><br>Write policy will switch to Write Through due to one of the following reasons: <br>1. Battery is not installed<br><br>2. Battery charge is low.<br><br> 3. Battery has failed.<br><br> 4. Battery is undergoing re-learn cycle.<br><br>Write Through eliminates risk of losing cached data in case of power<br>failure. But it may result in slower performance.<br><br>Write Back with BBU policy enables Write Back caching when BBU is <br>installed and charged. It provides optimal balance between data safety and <br>performance.<br><br>Are you sure you want to select Write Back with BBU mode?<br><br></html>");
                        }
                    }
                }
                if (JOptionPane.showConfirmDialog(null, object2, (String)object3, 0, 2) == 1) {
                    return;
                }
                if (n3 == 0 || n3 == 64) {
                    for (int i = 0; i < VirtualDiskCreationDialog.this.holeData.size(); ++i) {
                        ArrayHoleData arrayHoleData = (ArrayHoleData)VirtualDiskCreationDialog.this.holeData.get(i);
                        ArrayData arrayData = arrayHoleData.getArrayData();
                        ArrayList arrayList = arrayData.getOldDedicatedSpares();
                        if (arrayData.getHotSparesNewlyDedicatedToThisArray().size() <= 0 && (arrayList == null || arrayList.size() <= 0)) continue;
                        new CustomMsgBox(VirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_RAID0_NOTPOSSIBLE", "This RAID level is not possible as there is dedicated hotspare for the specified arrays"));
                        return;
                    }
                }
                byte by = Byte.parseByte(VirtualDiskCreationDialog.this.volumeID.getSelectedItem() + "");
                double d = Double.parseDouble(VirtualDiskCreationDialog.this.sizeText.getValue() + "");
                long l = KernelConstants.getSizeInBlocks(d, n = ((Integer)VirtualDiskCreationDialog.this.sizeUnit.getSelectedItem()).intValue());
                if (l == KernelConstants.getSizeInBlocks(VirtualDiskCreationDialog.this.maxSizeAndUnit[0], (int)VirtualDiskCreationDialog.this.maxSizeAndUnit[1])) {
                    l = VirtualDiskCreationDialog.this.maxSizeInBlocks;
                }
                try {
                    int n5 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).stripeSize.getSelectedItem()).flag;
                    LDData lDData = new LDData(VirtualDiskCreationDialog.this.holeData, (byte)n3, l, VirtualDiskCreationDialog.this.engine, by, (byte)n5);
                    lDData.setName(VirtualDiskCreationDialog.this.volumeName.getText());
                    lDData.setStripeSize((byte)n5);
                    int n6 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).initState.getSelectedItem()).flag;
                    lDData.setInitState((byte)n6);
                    int n7 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).readPolicy.getSelectedItem()).flag;
                    int n8 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).cachePolicy.getSelectedItem()).flag;
                    int n9 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).accessPolicy.getSelectedItem()).flag;
                    int n10 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).diskCachePolicy.getSelectedItem()).flag;
                    lDData.setPolicy((byte)n7, (byte)n2, (byte)n8, (byte)n9, (byte)n10);
                    VirtualDiskCreationDialog.this.engine.addNewLD(lDData);
                    VirtualDiskCreationDialog.this.refreshArraysWithHoles();
                    VirtualDiskCreationDialog.this.refreshParameters();
                    VirtualDiskCreationDialog.this.refreshLDSummary();
                }
                catch (Exception exception) {
                    new CustomMsgBox(VirtualDiskCreationDialog.this.getContentPane(), Resource.getString("MSG_INVALID_LDOPTION", "Can not create Virtual Disk : Invalid input parameters for creating Virtual Disk !"));
                    exception.printStackTrace();
                }
            }
        });
        jPanel2.add(this.acceptButton);
        jPanel.add(jPanel2);
        jPanel2.setPreferredSize(new Dimension(MainFrame.SCREEN_SIZE.width * 300 / 1024, MainFrame.SCREEN_SIZE.height * 40 / 768));
    }

    @Override
    public void next() {
        if (this.engine.getNewlyCreatedLDs().size() <= 0) {
            new CustomMsgBox(this, Resource.getString("MSG_NOLD_TEXT", "Please create at least one virtual disk and then proceed to next step !"));
            return;
        }
        this.dispose();
        new FinishWizardDialog(this.engine, false, this.getSelectedMode());
    }

    @Override
    public void back() {
        this.dispose();
        new ArraySelectionDialog(this.engine, this.getSelectedMode());
    }

    @Override
    public Object[] getStepNames(boolean bl) {
        if (bl) {
            Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP", "Mode (S)election"), Resource.getString("MANUAL_MODE_ARRAY", "(A)rray Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE", "V(i)rtual Disk Creation"), Resource.getString("MANUAL_MODE_FINISH", "Fi(n)ish")};
            return objectArray;
        }
        Object[] objectArray = new String[]{Resource.getString("MODE_SEL_STEP_1", "Mode Selection"), Resource.getString("MANUAL_MODE_ARRAY_1", "Array Selection"), Resource.getString("MANUAL_MODE_LOGICALDRIVE_1", "Virtual Disk Creation"), Resource.getString("MANUAL_MODE_FINISH_1", "Finish")};
        return objectArray;
    }

    @Override
    public int getStep() {
        return 2;
    }

    @Override
    public void goToStep(int n) {
        if (n == 0) {
            this.dispose();
            new ModeSelectionDialog(this.engine, this.getSelectedMode());
        } else if (n == 1) {
            this.back();
        } else if (n == 3) {
            this.next();
        }
    }

    private void refreshParameters() {
        this.holeData.clear();
        for (int i = 0; i < this.chBox.length; ++i) {
            if (!this.chBox[i].isSelected()) continue;
            this.holeData.add(this.arrayCmb[i].getSelectedItem());
        }
        if (this.holeData.size() <= 0) {
            this.initRightPart(false);
            return;
        }
        try {
            byte[] byArray = this.engine.getOccupiedLDIDList();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != 0) continue;
                vector.add(i + "");
            }
            this.volumeID.setModel(new DefaultComboBoxModel(vector));
            this.possibleRAIDLevelSize = this.engine.getPossibleRAIDLevelAndSize(this.holeData);
            Vector<GUIData> vector2 = new Vector<GUIData>();
            for (int i = 0; i < this.possibleRAIDLevelSize.size(); ++i) {
                RAIDLevelAndSize rAIDLevelAndSize = (RAIDLevelAndSize)this.possibleRAIDLevelSize.get(i);
                byte by = rAIDLevelAndSize.getGUIRAIDLevel();
                GUIData gUIData = new GUIData(this.RAIDLevelString(by), by);
                vector2.add(gUIData);
            }
            this.rdLevel.setModel(new DefaultComboBoxModel(vector2));
            this.rdLevel.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n;
                    int n2;
                    boolean bl = false;
                    for (int i = 0; i < VirtualDiskCreationDialog.this.chBox.length; ++i) {
                        if (!VirtualDiskCreationDialog.this.chBox[i].isSelected()) continue;
                        ArrayList arrayList = ((ArrayHoleData)VirtualDiskCreationDialog.this.arrayCmb[i].getSelectedItem()).getArrayData().getConstituentPDList();
                        if (arrayList.size() <= 3) {
                            bl = true;
                            continue;
                        }
                        bl = false;
                        break;
                    }
                    if (VirtualDiskCreationDialog.this.rdLevel.getSelectedIndex() < 0) {
                        return;
                    }
                    GUIData gUIData = (GUIData)VirtualDiskCreationDialog.this.rdLevel.getSelectedItem();
                    int n3 = gUIData.flag;
                    if (bl && (n3 == 6 || n3 == 70)) {
                        for (n2 = 0; n2 < VirtualDiskCreationDialog.this.stripeSize.getItemCount(); ++n2) {
                            n = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).stripeSize.getItemAt((int)n2)).flag;
                            if (n != 4) continue;
                            VirtualDiskCreationDialog.this.stripeSize.removeItemAt(n2);
                            stripFlag = true;
                        }
                    } else if (stripFlag) {
                        n2 = 0;
                        for (n = 0; n < VirtualDiskCreationDialog.this.stripeSize.getItemCount(); ++n) {
                            int n4 = ((GUIData)((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).stripeSize.getItemAt((int)n)).flag;
                            if (n4 != 4) continue;
                            n2 = 1;
                        }
                        if (n2 == 0) {
                            VirtualDiskCreationDialog.this.stripeSize.insertItemAt(new GUIData("8 KB", 4), 0);
                        }
                        stripFlag = false;
                        n2 = 0;
                    }
                    for (n2 = 0; n2 < VirtualDiskCreationDialog.this.possibleRAIDLevelSize.size(); ++n2) {
                        RAIDLevelAndSize rAIDLevelAndSize = (RAIDLevelAndSize)VirtualDiskCreationDialog.this.possibleRAIDLevelSize.get(n2);
                        if (rAIDLevelAndSize.getGUIRAIDLevel() != gUIData.flag) continue;
                        VirtualDiskCreationDialog.this.maxSizeInBlocks = rAIDLevelAndSize.getMaxSizeInBlocks();
                        double[] dArray = KernelConstants.getSizeAndUnit(rAIDLevelAndSize.getMaxSizeInBlocks());
                        VirtualDiskCreationDialog.this.prevUnit = (int)dArray[1];
                        double[] dArray2 = KernelConstants.getSizeAndUnit(rAIDLevelAndSize.getMinSizeInBlocks());
                        if (dArray[1] != dArray2[1]) {
                            dArray2[0] = KernelConstants.getSizeInSpecifiedUnit(dArray2[0], (int)dArray2[1], (int)dArray[1]);
                            dArray2[1] = dArray[1];
                        }
                        ((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).maxSizeAndUnit[0] = dArray[0];
                        ((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).maxSizeAndUnit[1] = dArray[1];
                        ((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).minSizeAndUnit[0] = dArray2[0];
                        ((VirtualDiskCreationDialog)VirtualDiskCreationDialog.this).minSizeAndUnit[1] = dArray2[1];
                        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(dArray[0], dArray2[0], dArray[0], 1.0);
                        VirtualDiskCreationDialog.this.sizeText.setModel(spinnerNumberModel);
                        VirtualDiskCreationDialog.this.sizeUnitModel.setUnit((int)dArray[1]);
                    }
                    VirtualDiskCreationDialog.this.setDefaultPolicies();
                }
            });
            this.sizeUnit.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (VirtualDiskCreationDialog.this.sizeUnit.getSelectedIndex() != -1) {
                        int n = (Integer)itemEvent.getItem();
                        double d = Double.parseDouble(VirtualDiskCreationDialog.this.sizeText.getValue() + "");
                        double d2 = KernelConstants.getSizeInSpecifiedUnit(d, VirtualDiskCreationDialog.this.prevUnit, n);
                        double d3 = KernelConstants.getSizeInSpecifiedUnit(VirtualDiskCreationDialog.this.minSizeAndUnit[0], (int)VirtualDiskCreationDialog.this.minSizeAndUnit[1], n);
                        double d4 = KernelConstants.getSizeInSpecifiedUnit(VirtualDiskCreationDialog.this.maxSizeAndUnit[0], (int)VirtualDiskCreationDialog.this.maxSizeAndUnit[1], n);
                        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(d2, d3, d4, 1.0);
                        VirtualDiskCreationDialog.this.prevUnit = n;
                        VirtualDiskCreationDialog.this.sizeText.setModel(spinnerNumberModel);
                        VirtualDiskCreationDialog.this.sizeText.updateUI();
                    }
                }
            });
            this.initRightPart(true);
        }
        catch (Exception exception) {
            new CustomMsgBox(this, Resource.getString("MSG_GETRDLEVELSIZE_FAILED", "Can not get possible RAID level and size : Unknown Exception !"));
            exception.printStackTrace();
        }
    }

    private String RAIDLevelString(int n) {
        String string = Resource.getString("RAID_TEXT", "RAID") + " ";
        switch (n) {
            case 64: {
                return string + "00";
            }
            case 0: {
                return string + "0";
            }
            case 1: {
                return string + "1";
            }
            case 5: {
                return string + "5";
            }
            case 65: {
                return string + "10";
            }
            case 69: {
                return string + "50";
            }
            case 6: {
                return string + "6";
            }
            case 70: {
                return string + "60";
            }
            case 17: {
                return string + "1";
            }
            case 81: {
                return string + "10";
            }
        }
        return string;
    }

    private void initRightPart(boolean bl) {
        this.rdLevel.setEnabled(bl);
        this.volumeID.setEnabled(bl);
        this.sizeText.setEnabled(bl);
        this.sizeUnit.setEnabled(bl);
        this.sizeAndUnit.setEnabled(bl);
        if (Resource.isLocaleSupportedForOEM()) {
            this.volumeName.setEnabled(bl);
        }
        this.stripeSize.setEnabled(bl);
        this.readPolicy.setEnabled(bl);
        this.writePolicy.setEnabled(bl);
        this.initState.setEnabled(bl);
        if (VivaldiStartupDialog.OEM_TYPE == 2561) {
            this.diskCachePolicy.setEnabled(false);
        } else {
            this.diskCachePolicy.setEnabled(bl);
        }
        this.cachePolicy.setEnabled(bl);
        this.accessPolicy.setEnabled(bl);
        this.acceptButton.setEnabled(bl);
        if (bl) {
            this.rdLevel.setSelectedIndex(-1);
            this.volumeID.setSelectedIndex(-1);
            this.setDefaultRAIDLevel(this.rdLevel);
            this.volumeID.setSelectedIndex(0);
            this.volumeName.setText("");
        }
    }

    private void setDefaultPolicies() {
        if (this.rdLevel.getItemCount() <= 0) {
            return;
        }
        RAIDParameters rAIDParameters = RAIDParameters.getDefaultParams(VivaldiStartupDialog.OEM_TYPE, this.engine.getmfcDefaults(), this.engine.getCurrentAdapter(), ((GUIData)this.rdLevel.getItemAt((int)this.rdLevel.getSelectedIndex())).flag);
        GUIUtils.setDefaultValueToJComboBoxFromGUIData(this.readPolicy, rAIDParameters.getReadPolicy());
        GUIUtils.setDefaultValueToJComboBoxFromGUIData(this.cachePolicy, rAIDParameters.getIoPolicy());
    }

    private void refreshLDSummary() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.returnRootForRefreshLDSummary();
        this.ldTreeView.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        if (this.engine.getNewlyCreatedLDs().size() > 0) {
            this.nextButton.setEnabled(true);
        } else {
            this.nextButton.setEnabled(false);
        }
        VirtualDiskCreationDialog.expandTree(this.ldTreeView);
    }

    public void refreshSplitPane() {
        if (this.chBox != null && this.chBox.length > 0 && this.split != null) {
            this.arrayHolderScrollPane.validate();
            this.split.validate();
        }
        if (this.split != null) {
            this.split.setDividerLocation(-1);
        }
    }

    public void setDefaultRAIDLevel(JComboBox jComboBox) {
        if (jComboBox.getItemCount() > 0) {
            jComboBox.setSelectedIndex(0);
        }
        for (int i = 1; i < jComboBox.getItemCount(); ++i) {
            GUIData gUIData = (GUIData)jComboBox.getItemAt(i);
            if (gUIData.flag != 5 && gUIData.flag != 1) continue;
            jComboBox.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public String getStatus() {
        return Resource.getString("MSG_STATUS_MANUALVDCREATE", "<html>Check one or more Array holes from the top left panel, change the various properties and press accept to create a virtual disk.To undo creation of virtual disk, select the virtual disk and press reclaim</html>");
    }

    @Override
    public String getHelpPage() {
        switch (this.getSelectedMode()) {
            case 2: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_MANUAL_DIALOG");
            }
            case 1: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_AUTO_DIALOG");
            }
            case 3: {
                return HelpContextResourse.getHelpPageName("HELP_PAGE_CONF_WIZ_GUIDED_DIALOG");
            }
        }
        return HelpContextResourse.getHelpPageName("HELP_PAGE_DEFAULT");
    }

    @Override
    public boolean warningDialog() {
        if (this.engine.getNewlyCreatedLDs().size() > 0 || this.engine.getNewArraysCreated().size() > 0) {
            return CustomMsgBox.confirm(this.getContentPane(), Resource.getString("MSG_WARNING_DIALOG", "Do you want to close the window ?"));
        }
        return true;
    }

    public boolean isVDCompriseOfSASDrives() {
        boolean bl = true;
        for (int i = 0; i < this.chBox.length; ++i) {
            ArrayHoleData arrayHoleData;
            if (!this.chBox[i].isSelected() || (arrayHoleData = (ArrayHoleData)this.arrayCmb[i].getSelectedItem()) == null) continue;
            ArrayData arrayData = arrayHoleData.getArrayData();
            ArrayList arrayList = arrayData.getConstituentPDList();
            if (this.isAllSASDrives(arrayList)) {
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isVDCompriseOfSATADrives() {
        boolean bl = true;
        for (int i = 0; i < this.chBox.length; ++i) {
            ArrayHoleData arrayHoleData;
            if (!this.chBox[i].isSelected() || (arrayHoleData = (ArrayHoleData)this.arrayCmb[i].getSelectedItem()) == null) continue;
            ArrayData arrayData = arrayHoleData.getArrayData();
            ArrayList arrayList = arrayData.getConstituentPDList();
            if (this.isAllSATADrives(arrayList)) {
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isAllSATADrives(List list) {
        boolean bl = true;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)list.get(i);
                if (sASPhysicalDrive.getDriveType() != 3) {
                    bl = false;
                    break;
                }
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isAllSASDrives(List list) {
        boolean bl = true;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)list.get(i);
                if (sASPhysicalDrive.getDriveType() != 2) {
                    bl = false;
                    break;
                }
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }
}

