/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ConfigWizard;

import GUI.MainFrame;
import SASKernel.ConfigurationHelpers.AssistedConfigRAIDLevelAndSizeInfo;
import Services.KernelConstants;
import Utils.Resource;
import Wizard.UnitsComboBoxModel;
import Wizard.UnitsRenderer;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class VolumeParamPanel
extends JPanel {
    private String[] mnemonics;
    private AssistedConfigRAIDLevelAndSizeInfo volumeData;
    private JSpinner percent = new JSpinner(new SpinnerNumberModel(100, 0, 100, 1));
    private JSpinner volumeSize = new JSpinner();
    private UnitsComboBoxModel sizeUnitModel = new UnitsComboBoxModel(-1);
    private JComboBox sizeUnit = new JComboBox(this.sizeUnitModel);
    private JSpinner numDrives = new JSpinner();
    private int tryToCreateLDNum;
    int maxLDAllowed;
    private int prevUnit;
    private double[] minSizeAndUnit = new double[2];
    private double[] maxSizeAndUnit = new double[2];
    private long maxSizeInBlocks = 0L;

    public VolumeParamPanel(AssistedConfigRAIDLevelAndSizeInfo assistedConfigRAIDLevelAndSizeInfo, int n, int n2) {
        this.maxLDAllowed = n2;
        this.volumeData = assistedConfigRAIDLevelAndSizeInfo;
        this.tryToCreateLDNum = n;
        this.setLayout(new FlowLayout(0));
        String string = Resource.getString("RAID_TEXT", "RAID") + " ";
        switch (assistedConfigRAIDLevelAndSizeInfo.getRaidLevel()) {
            case 64: {
                string = string + "00";
                break;
            }
            case 0: {
                string = string + "0";
                break;
            }
            case 1: {
                string = string + "1";
                break;
            }
            case 5: {
                string = string + "5";
                break;
            }
            case 6: {
                string = string + "6";
                break;
            }
            case 65: {
                string = string + "10";
                break;
            }
            case 69: {
                string = string + "50";
                break;
            }
            case 70: {
                string = string + "60";
                break;
            }
        }
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_CAPACITY_TEXT", "Total Capacity :"));
        JLabel jLabel = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jLabel.setLabelFor(this.percent);
        jPanel.add(jLabel);
        jPanel.add(this.percent);
        JLabel jLabel2 = new JLabel(" %");
        jPanel.add(jLabel2);
        this.maxSizeInBlocks = assistedConfigRAIDLevelAndSizeInfo.getMaxSizeInBlocks();
        double[] dArray = KernelConstants.getSizeAndUnit(assistedConfigRAIDLevelAndSizeInfo.getMaxSizeInBlocks());
        this.prevUnit = (int)dArray[1];
        double[] dArray2 = KernelConstants.getSizeAndUnit(assistedConfigRAIDLevelAndSizeInfo.getMinSizeInBlocks());
        if (dArray[1] != dArray2[1]) {
            dArray2[0] = KernelConstants.getSizeInSpecifiedUnit(dArray2[0], (int)dArray2[1], (int)dArray[1]);
            dArray2[1] = dArray[1];
        }
        this.maxSizeAndUnit[0] = dArray[0];
        this.maxSizeAndUnit[1] = dArray[1];
        this.minSizeAndUnit[0] = dArray2[0];
        this.minSizeAndUnit[1] = dArray2[1];
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(dArray[0], dArray2[0], dArray[0], 1.0);
        this.volumeSize.setModel(spinnerNumberModel);
        jPanel.add(this.volumeSize);
        if (MainFrame.SCREEN_SIZE.width < 900) {
            this.volumeSize.setPreferredSize(new Dimension(100, (int)this.percent.getPreferredSize().getHeight()));
        }
        Dimension dimension = new Dimension(MainFrame.SCREEN_SIZE.width * 40 / 1024, (int)this.sizeUnit.getPreferredSize().getHeight());
        this.sizeUnit.setPreferredSize(dimension);
        jPanel.add(this.sizeUnit);
        this.sizeUnit.setRenderer(new UnitsRenderer());
        this.sizeUnitModel.setUnit((int)dArray[1]);
        this.setBorder(BorderFactory.createTitledBorder(string));
        this.setDriveNumberLimit(this.tryToCreateLDNum);
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("LABEL_NUMVIRTUALDISK_TEXT", "Virtual Disk Count :"));
        JLabel jLabel3 = new JLabel(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel3.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jLabel3.setLabelFor(this.numDrives);
        jPanel2.add(jLabel3);
        jPanel2.add(this.numDrives);
        this.percent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    int n = Integer.parseInt(VolumeParamPanel.this.percent.getValue() + "");
                    ChangeListener changeListener = VolumeParamPanel.this.volumeSize.getChangeListeners()[0];
                    VolumeParamPanel.this.volumeSize.removeChangeListener(changeListener);
                    int n2 = (Integer)VolumeParamPanel.this.sizeUnit.getSelectedItem();
                    double d = VolumeParamPanel.this.volumeData.getMaxSizeInBlocks();
                    double d2 = KernelConstants.getSizeInSpecifiedUnit(d, 999, n2);
                    double d3 = KernelConstants.getSizeInSpecifiedUnit(VolumeParamPanel.this.minSizeAndUnit[0], (int)VolumeParamPanel.this.minSizeAndUnit[1], n2);
                    SpinnerNumberModel spinnerNumberModel = n == 100 ? new SpinnerNumberModel(d2, d3, d2, 1.0) : new SpinnerNumberModel(d2 * (double)n / 100.0, d3, d2, 1.0);
                    VolumeParamPanel.this.prevUnit = n2;
                    VolumeParamPanel.this.volumeSize.setModel(spinnerNumberModel);
                    VolumeParamPanel.this.volumeSize.updateUI();
                    VolumeParamPanel.this.volumeSize.addChangeListener(changeListener);
                    VolumeParamPanel.this.setDriveNumberLimit(Math.min((Integer)VolumeParamPanel.this.numDrives.getValue(), VolumeParamPanel.this.tryToCreateLDNum));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.volumeSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    ChangeListener changeListener = VolumeParamPanel.this.percent.getChangeListeners()[0];
                    VolumeParamPanel.this.percent.removeChangeListener(changeListener);
                    double d = Double.parseDouble(VolumeParamPanel.this.volumeSize.getValue() + "");
                    int n = (Integer)VolumeParamPanel.this.sizeUnit.getSelectedItem();
                    double d2 = KernelConstants.getSizeInBlocks(d, n);
                    VolumeParamPanel.this.percent.setValue(new Long((long)(d2 / (double)VolumeParamPanel.this.volumeData.getMaxSizeInBlocks() * 100.0)));
                    VolumeParamPanel.this.percent.addChangeListener(changeListener);
                    VolumeParamPanel.this.setDriveNumberLimit(Math.min((Integer)VolumeParamPanel.this.numDrives.getValue(), VolumeParamPanel.this.tryToCreateLDNum));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.sizeUnit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (VolumeParamPanel.this.sizeUnit.getSelectedIndex() != -1) {
                    int n = (Integer)itemEvent.getItem();
                    double d = Double.parseDouble(VolumeParamPanel.this.volumeSize.getValue() + "");
                    double d2 = KernelConstants.getSizeInSpecifiedUnit(d, VolumeParamPanel.this.prevUnit, n);
                    double d3 = KernelConstants.getSizeInSpecifiedUnit(VolumeParamPanel.this.minSizeAndUnit[0], (int)VolumeParamPanel.this.minSizeAndUnit[1], n);
                    double d4 = KernelConstants.getSizeInSpecifiedUnit(VolumeParamPanel.this.volumeData.getMaxSizeInBlocks(), 999, n);
                    SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(d2, d3, d4, 1.0);
                    VolumeParamPanel.this.prevUnit = n;
                    VolumeParamPanel.this.volumeSize.setModel(spinnerNumberModel);
                    VolumeParamPanel.this.volumeSize.updateUI();
                }
            }
        });
        this.add(jPanel2);
        this.add(jPanel);
    }

    private void setDriveNumberLimit(int n) {
        int n2;
        double d = Double.parseDouble(this.volumeSize.getValue() + "");
        double d2 = KernelConstants.getSizeInBlocks(d, n2 = ((Integer)this.sizeUnit.getSelectedItem()).intValue());
        int n3 = (int)(d2 / (double)this.volumeData.getMinSizeInBlocks());
        if (n3 > this.maxLDAllowed) {
            n3 = this.maxLDAllowed;
        }
        n3 = Math.min(this.volumeData.maxLDSThatCanBeCreated(), n3);
        int n4 = Math.min(n3, n);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n4, 0, n3, 1);
        this.numDrives.setModel(spinnerNumberModel);
    }

    public AssistedConfigRAIDLevelAndSizeInfo getVolumeInfo() {
        int n = this.getLDNumber();
        if (n <= 0) {
            return null;
        }
        this.volumeData.setSelectedNumLogicalDrives(n);
        double d = Double.parseDouble(this.volumeSize.getValue() + "");
        int n2 = (Integer)this.sizeUnit.getSelectedItem();
        long l = KernelConstants.getSizeInBlocks(d, n2);
        if (l == KernelConstants.getSizeInBlocks(this.maxSizeAndUnit[0], (int)this.maxSizeAndUnit[1])) {
            l = this.maxSizeInBlocks;
        }
        this.volumeData.setSelectedSizeInBlocks(l);
        return this.volumeData;
    }

    public int getLDNumber() {
        return Integer.parseInt(this.numDrives.getValue() + "");
    }

    public String getStatus() {
        return Resource.getString("MSG_STATUS_GUIDEDFINISH", "Change the number, size and other parameters for Virtual Disks and press Next");
    }

    public AssistedConfigRAIDLevelAndSizeInfo getData() {
        return this.volumeData;
    }
}

