/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUIHelper.AdapterHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_FOREIGN_CFG_GUIDS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_PD_REF;
import SASKernel.LibraryAPI.StoreLib.MR_SPARE;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.DoubleIcons;
import Utils.Resource;
import Wizard.ForeignConfigWizard.GUIData;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;

public class BaseForeignConfigDialog
extends VivaldiBaseDialog {
    protected static final int INVALID_NODE = 0;
    protected static final int ARRAY_NODE = 1;
    protected static final int PHDRIVE_NODE = 2;
    protected static final int LDRIVE_NODE = 3;
    protected static final int DEDICATED_HOTSPARE_NODE = 4;
    protected static final int GLOBAL_HOTSPARE_NODE = 5;
    protected static final int ADAPTER_NODE = 6;
    protected static final int PHDRIVE_NODE_ONLINE = 7;
    protected static final int PHDRIVE_NODE_OFFLINE = 8;
    protected static final int PHDRIVE_NODE_MISSING = 9;
    protected static final int PHDRIVE_NODE_REBUILD = 10;
    protected static final int PHDRIVE_NODE_FOREIGN = 11;
    protected static final int PHDRIVE_NODE_ORPHAN = 13;
    protected static final int TYPE_CONTAINER_VIRTUALDRIVES = 14;
    protected static final int TYPE_CONTAINER_DRIVES = 15;
    protected static final int TYPE_CONTAINER_DEDICATEDHOTSPARES = 16;
    protected static final int TYPE_CONTAINER_GLOBALHOTSPARES = 17;
    protected static final int TYPE_CONTAINER_SPANNEDDRIVEGROUP = 18;
    protected static final int TYPE_CONTAINER_SSCD = 19;
    protected static final int SSCD_NODE = 20;
    protected static final int TARGET_ID = 255;
    protected SASAdapter adapter;
    protected AdapterHelper m_adapterHelper = null;
    protected MR_FOREIGN_CFG_GUIDS guidList = null;
    private HashMap m_arrHashMap = new HashMap();
    protected DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 == null) {
                return this;
            }
            if (!(object2 instanceof GUIData)) {
                return this;
            }
            MR_LD_CONFIG mR_LD_CONFIG = null;
            int n2 = 4;
            if (((GUIData)object2).flag == 3 || ((GUIData)object2).flag == 20) {
                mR_LD_CONFIG = (MR_LD_CONFIG)((GUIData)object2).value;
                n2 = mR_LD_CONFIG.getparams().getstate();
            }
            switch (((GUIData)object2).flag) {
                case 1: {
                    this.setIcon(Resource.getImage("ARRAY_IMAGE", "array.png"));
                    break;
                }
                case 2: {
                    this.setIcon(Resource.getImage("PHDRIVE_IMAGE", "phdrive.png"));
                    break;
                }
                case 4: {
                    this.setIcon(Resource.getImage("HOTSPARE_IMAGE", "hotspare.png"));
                    break;
                }
                case 5: {
                    this.setIcon(Resource.getImage("HOTSPARE_GLOBAL_IMAGE", "hotspare_global.png"));
                    break;
                }
                case 3: {
                    if (mR_LD_CONFIG.getproperties().getldRef().gettargetId() == '\uffff' || n2 == 0) {
                        this.setIcon(Resource.getImage("VIRTUAL_DISK_NOIMP_IMAGE", "virtual_disk_noimp.png"));
                        break;
                    }
                    if (n2 == 2) {
                        this.setIcon(new DoubleIcons(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("VOLUME_IMAGE", "volume.png")))), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("DEGRADED_IMAGE", "degraded.png")))), 1));
                        break;
                    }
                    if (n2 == 1) {
                        this.setIcon(new DoubleIcons(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("VOLUME_IMAGE", "volume.png")))), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("PARTIAL_DEGRADED_IMAGE", "partialdegraded.png")))), 1));
                        break;
                    }
                    this.setIcon(Resource.getImage("VOLUME_IMAGE", "volume.png"));
                    break;
                }
                case 6: {
                    this.setIcon(BaseForeignConfigDialog.this.m_adapterHelper.getIcon());
                    break;
                }
                case 7: {
                    this.setIcon(Resource.getImage("CONFIGURED_IMAGE", "configured.png"));
                    break;
                }
                case 8: 
                case 9: {
                    this.setIcon(new DoubleIcons(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("CONFIGURED_IMAGE", "configured.png")))), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("FAILED_IMAGE", "failed.png")))), 1));
                    break;
                }
                case 10: {
                    this.setIcon(Resource.getImage("REBUILD_IMAGE", "rebuild.png"));
                    break;
                }
                case 11: {
                    this.setIcon(Resource.getImage("FOREIGN_DRIVE_IMAGE", "foreign_drive.png"));
                    break;
                }
                case 13: {
                    this.setIcon(Resource.getImage("NO_IMPORT_IMAGE", "no_import.png"));
                    break;
                }
                case 14: {
                    this.setIcon(Resource.getImage("VOLUMES_IMAGE", "volumes.png"));
                    break;
                }
                case 15: {
                    this.setIcon(Resource.getImage("CONFIGURED_DRIVES_IMAGE", "configured_drives.png"));
                    break;
                }
                case 16: {
                    this.setIcon(Resource.getImage("HOTSPARES_IMAGE", "hotspares.png"));
                    break;
                }
                case 17: {
                    this.setIcon(Resource.getImage("HOTSPARES_GLOBAL_IMAGE", "hotspares_global.png"));
                    break;
                }
                case 18: {
                    this.setIcon(Resource.getImage("SPAN_IMAGE", "span.png"));
                    break;
                }
                case 19: {
                    this.setIcon(Resource.getImage("SSC_GROUP_IMAGE", "sscds_group.png"));
                    break;
                }
                case 20: {
                    if (n2 == 2) {
                        this.setIcon(new DoubleIcons(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("SSCD_VD_IMAGE", "sscd_vd.png")))), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("DEGRADED_IMAGE", "degraded.png")))), 1));
                        break;
                    }
                    if (n2 == 1) {
                        this.setIcon(new DoubleIcons(new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("SSCD_VD_IMAGE", "sscd_vd.png")))), new ImageIcon(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource(Resource.getString("PARTIAL_DEGRADED_IMAGE", "partialdegraded.png")))), 1));
                        break;
                    }
                    this.setIcon(Resource.getImage("SSCD_VD_IMAGE", "sscd_vd.png"));
                    break;
                }
            }
            return this;
        }
    };

    public BaseForeignConfigDialog(AdapterHelper adapterHelper) {
        this.adapter = (SASAdapter)adapterHelper.getDeviceObject();
        this.m_adapterHelper = adapterHelper;
        this.setTitle(Resource.getString("FOREIGN_CONFIG_WIZARD", "Foreign Configuration Wizard"));
        this.setModal(true);
        this.setResizable(false);
        this.setSize(MainFrame.SCREEN_SIZE.width * 640 / 1024, MainFrame.SCREEN_SIZE.height * 480 / 768);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
    }

    public void getGUIDList() {
        try {
            OperationDetails operationDetails = new OperationDetails(3, null);
            this.adapter.fireConfigOperation(operationDetails);
            this.guidList = (MR_FOREIGN_CFG_GUIDS)operationDetails.getParam();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            CustomMsgBox.errorMsg(vKOperationFailedException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MR_LD_CONFIG[] getLDForThisArray(MR_ARRAY mR_ARRAY, MR_CONFIG_DATA mR_CONFIG_DATA) {
        ArrayList<MR_LD_CONFIG> arrayList = new ArrayList<MR_LD_CONFIG>();
        for (int i = 0; i < mR_CONFIG_DATA.getlogDrvCount(); ++i) {
            MR_LD_CONFIG mR_LD_CONFIG = mR_CONFIG_DATA.getld()[i];
            int n = mR_LD_CONFIG.getparams().getspanDepth();
            for (int j = 0; j < n; ++j) {
                short s = mR_LD_CONFIG.getspan()[j].getarrayRef();
                if (mR_ARRAY.getarrayRef() != s) continue;
                arrayList.add(mR_LD_CONFIG);
            }
        }
        MR_LD_CONFIG[] mR_LD_CONFIGArray = new MR_LD_CONFIG[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            mR_LD_CONFIGArray[i] = (MR_LD_CONFIG)arrayList.get(i);
        }
        return mR_LD_CONFIGArray;
    }

    public int getSpanDepth(MR_ARRAY mR_ARRAY, MR_CONFIG_DATA mR_CONFIG_DATA) {
        MR_LD_CONFIG[] mR_LD_CONFIGArray = this.getLDForThisArray(mR_ARRAY, mR_CONFIG_DATA);
        if (mR_LD_CONFIGArray != null && mR_LD_CONFIGArray.length > 0) {
            return mR_LD_CONFIGArray[0].getparams().getspanDepth();
        }
        return 0;
    }

    public MR_ARRAY[] getArraysForThisLD(MR_LD_CONFIG mR_LD_CONFIG, MR_CONFIG_DATA mR_CONFIG_DATA) {
        int n;
        ArrayList<MR_ARRAY> arrayList = new ArrayList<MR_ARRAY>();
        MR_ARRAY[] mR_ARRAYArray = mR_CONFIG_DATA.getarray();
        int n2 = mR_CONFIG_DATA.getarrayCount();
        int n3 = mR_LD_CONFIG.getparams().getspanDepth();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            n = mR_LD_CONFIG.getspan()[i].getarrayRef();
            for (int j = 0; j < n2; ++j) {
                if (mR_ARRAYArray[j].getarrayRef() != n) continue;
                arrayList.add(mR_ARRAYArray[j]);
            }
        }
        MR_ARRAY[] mR_ARRAYArray2 = new MR_ARRAY[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            mR_ARRAYArray2[n] = (MR_ARRAY)arrayList.get(n);
        }
        return mR_ARRAYArray2;
    }

    protected DefaultMutableTreeNode createTreeStructure(MR_CONFIG_DATA mR_CONFIG_DATA) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        int n;
        GUIData.setCFGdata(mR_CONFIG_DATA);
        int n2 = 0;
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new GUIData(this.adapter, 6));
        ArrayList arrayList = this.getForeignDrives();
        MR_SPARE[] mR_SPAREArray = mR_CONFIG_DATA.getspare();
        MR_ARRAY[] mR_ARRAYArray = mR_CONFIG_DATA.getarray();
        int n3 = mR_CONFIG_DATA.getarrayCount();
        for (n = 0; n < n3; ++n) {
            DefaultMutableTreeNode defaultMutableTreeNode3;
            Cloneable cloneable;
            Object[] objectArray;
            if (this.getSpanDepth(mR_ARRAYArray[n], mR_CONFIG_DATA) == 1) {
                int n4;
                int n5;
                if (this.m_arrHashMap.containsKey(mR_ARRAYArray[n])) continue;
                this.m_arrHashMap.put(mR_ARRAYArray[n], true);
                object = null;
                objectArray = this.getLDForThisArray(mR_ARRAYArray[n], mR_CONFIG_DATA);
                if (objectArray[0].getparams().getisSSCD() != 0) {
                    object = new DefaultMutableTreeNode(new GUIData(mR_ARRAYArray[n], 19));
                    defaultMutableTreeNode = null;
                    for (n5 = 0; n5 < objectArray.length; ++n5) {
                        defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(objectArray[n5], 20));
                        ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
                    }
                } else {
                    object = new DefaultMutableTreeNode(new GUIData(mR_ARRAYArray[n], 1));
                    defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(Resource.getString("VIRTUAL_DRIVES_TEXT", "Virtual Drives"), 14));
                    ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
                    DefaultMutableTreeNode defaultMutableTreeNode4 = null;
                    for (n4 = 0; n4 < objectArray.length; ++n4) {
                        defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(objectArray[n4], 3));
                        defaultMutableTreeNode.add(defaultMutableTreeNode4);
                    }
                }
                defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(Resource.getString("DRIVES_TEXT", "Drives"), 15));
                ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode);
                n5 = mR_ARRAYArray[n].getnumDrives();
                for (n4 = 0; n4 < n5; ++n4) {
                    pd_MR_ARRAY pd_MR_ARRAY2 = mR_ARRAYArray[n].getpd_MR_ARRAY1()[n4];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (pd_MR_ARRAY2.getref().getdeviceId() != ((SASPhysicalDrive)arrayList.get(i)).getDeviceId()) continue;
                        arrayList.remove(i);
                        break;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode5 = pd_MR_ARRAY2.getfwState() == 20 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY2, 10)) : (pd_MR_ARRAY2.getref().getdeviceId() == -1 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY2, 9)) : (pd_MR_ARRAY2.getfwState() == 16 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY2, 8)) : (this.isForeignDrive(pd_MR_ARRAY2.getref().getdeviceId()) && pd_MR_ARRAY2.getfwState() == 24 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY2, 11)) : (pd_MR_ARRAY2.getfwState() == 24 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY2, 7)) : new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY2, 2))))));
                    defaultMutableTreeNode.add(defaultMutableTreeNode5);
                }
                cloneable = new ArrayList();
                for (int i = 0; i < mR_CONFIG_DATA.getsparesCount(); ++i) {
                    for (int j = 0; j < mR_SPAREArray[i].getarrayCount(); ++j) {
                        if (mR_SPAREArray[i].getarrayRef()[j] != mR_ARRAYArray[n].getarrayRef() || mR_SPAREArray[i].getspareType_MR_SPARE1().getisDedicated() != '\u0001') continue;
                        ((ArrayList)cloneable).add(mR_SPAREArray[i].getref());
                    }
                }
                if (((ArrayList)cloneable).size() > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new GUIData(Resource.getString("DEDICATED_HOT_SPARES_TEXT", "Dedicated Hot Spares"), 16));
                    ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode6);
                    for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                        defaultMutableTreeNode3 = new DefaultMutableTreeNode(new GUIData((MR_PD_REF)((ArrayList)cloneable).get(i), 4));
                        defaultMutableTreeNode6.add(defaultMutableTreeNode3);
                    }
                }
                defaultMutableTreeNode2.add((MutableTreeNode)object);
                continue;
            }
            if (this.m_arrHashMap.containsKey(mR_ARRAYArray[n])) continue;
            this.m_arrHashMap.put(mR_ARRAYArray[n], true);
            object = this.getLDForThisArray(mR_ARRAYArray[n], mR_CONFIG_DATA);
            objectArray = this.getArraysForThisLD(object[0], mR_CONFIG_DATA);
            defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData(Resource.getString("SPANNED_DRIVE_GROUP_TEXT", "Spanned Drive Group") + ": " + n2 + ", " + this.getRAIDLevelString(object[0]), 1));
            ++n2;
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new GUIData(Resource.getString("VIRTUAL_DRIVES_TEXT", "Virtual Drives"), 14));
            defaultMutableTreeNode.add(defaultMutableTreeNode7);
            cloneable = null;
            for (int i = 0; i < ((Object)object).length; ++i) {
                cloneable = new DefaultMutableTreeNode(new GUIData(object[i], 3));
                defaultMutableTreeNode7.add((MutableTreeNode)((Object)cloneable));
            }
            DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new GUIData(Resource.getString("DRIVES_TEXT", "Drives"), 15));
            defaultMutableTreeNode.add(defaultMutableTreeNode8);
            for (int i = 0; i < objectArray.length; ++i) {
                this.m_arrHashMap.put(objectArray[i], true);
                defaultMutableTreeNode3 = new DefaultMutableTreeNode(new GUIData(objectArray[i], 18));
                int n6 = ((MR_ARRAY)objectArray[i]).getnumDrives();
                for (int j = 0; j < n6; ++j) {
                    pd_MR_ARRAY pd_MR_ARRAY3 = ((MR_ARRAY)objectArray[i]).getpd_MR_ARRAY1()[j];
                    for (int k = 0; k < arrayList.size(); ++k) {
                        if (pd_MR_ARRAY3.getref().getdeviceId() != ((SASPhysicalDrive)arrayList.get(k)).getDeviceId()) continue;
                        arrayList.remove(k);
                        break;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode9 = pd_MR_ARRAY3.getfwState() == 20 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY3, 10)) : (pd_MR_ARRAY3.getref().getdeviceId() == -1 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY3, 9)) : (pd_MR_ARRAY3.getfwState() == 16 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY3, 8)) : (this.isForeignDrive(pd_MR_ARRAY3.getref().getdeviceId()) && pd_MR_ARRAY3.getfwState() == 24 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY3, 11)) : (pd_MR_ARRAY3.getfwState() == 24 ? new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY3, 7)) : new DefaultMutableTreeNode(new GUIData(pd_MR_ARRAY3, 2))))));
                    defaultMutableTreeNode3.add(defaultMutableTreeNode9);
                }
                ArrayList<MR_PD_REF> arrayList2 = new ArrayList<MR_PD_REF>();
                for (int j = 0; j < mR_CONFIG_DATA.getsparesCount(); ++j) {
                    for (int k = 0; k < mR_SPAREArray[j].getarrayCount(); ++k) {
                        if (mR_SPAREArray[j].getarrayRef()[k] != ((MR_ARRAY)objectArray[i]).getarrayRef() || mR_SPAREArray[j].getspareType_MR_SPARE1().getisDedicated() != '\u0001') continue;
                        arrayList2.add(mR_SPAREArray[j].getref());
                    }
                }
                if (arrayList2.size() > 0) {
                    DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new GUIData(Resource.getString("DEDICATED_HOT_SPARES_TEXT", "Dedicated Hot Spares"), 16));
                    defaultMutableTreeNode3.add(defaultMutableTreeNode10);
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new GUIData((MR_PD_REF)arrayList2.get(j), 4));
                        defaultMutableTreeNode10.add(defaultMutableTreeNode11);
                    }
                }
                defaultMutableTreeNode8.add(defaultMutableTreeNode3);
            }
            defaultMutableTreeNode2.add(defaultMutableTreeNode);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = new DefaultMutableTreeNode(new GUIData(((SASPhysicalDrive)arrayList.get(n)).getInformation().getref(), 13));
        }
        ArrayList<MR_PD_REF> arrayList3 = new ArrayList<MR_PD_REF>();
        for (int i = 0; i < mR_CONFIG_DATA.getsparesCount(); ++i) {
            if (mR_SPAREArray[i].getspareType_MR_SPARE1().getisDedicated() != '\u0000') continue;
            arrayList3.add(mR_SPAREArray[i].getref());
        }
        if (arrayList3.size() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new GUIData(Resource.getString("GLOBAL_HOT_SPARES_TEXT", "Global Hot Spares"), 17));
            defaultMutableTreeNode2.add(defaultMutableTreeNode12);
            for (int i = 0; i < arrayList3.size(); ++i) {
                defaultMutableTreeNode = new DefaultMutableTreeNode(new GUIData((MR_PD_REF)arrayList3.get(i), 5));
                defaultMutableTreeNode12.add(defaultMutableTreeNode);
            }
        }
        return defaultMutableTreeNode2;
    }

    private String getRAIDLevelString(MR_LD_CONFIG mR_LD_CONFIG) {
        byte by = mR_LD_CONFIG.getparams().getPRL();
        byte by2 = mR_LD_CONFIG.getparams().getSRL();
        char c = mR_LD_CONFIG.getparams().getspanDepth();
        char c2 = mR_LD_CONFIG.getparams().getnumDrives();
        String string = Resource.getString("RAID_TEXT", "RAID") + " ";
        if (by == 17) {
            if (c > '\u0001' && this.adapter.getAdapterType() == 1) {
                return string + "10";
            }
            if (this.adapter.getAdapterType() == 1) {
                return string + "1";
            }
            return string + "1E";
        }
        if (c > '\u0001') {
            return string + by + "0";
        }
        if (this.adapter.getAdapterType() == 2 && by == 1 && c2 > '\u0002') {
            return string + "1E";
        }
        return string + by;
    }

    public boolean isForeignDrive(short s) {
        try {
            ArrayList arrayList = this.adapter.getSASObjectsArrayList((short)4096);
            for (int i = 0; i < arrayList.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)arrayList.get(i);
                pdType_MR_PD_INFO pdType_MR_PD_INFO2 = sASPhysicalDrive.getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
                if (pdType_MR_PD_INFO2.getisForeign() != 1 || sASPhysicalDrive.getDeviceId() != s) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public ArrayList getForeignDrives() {
        ArrayList arrayList = new ArrayList();
        try {
            ArrayList arrayList2 = this.adapter.getSASObjectsArrayList((short)4096);
            for (int i = 0; i < arrayList2.size(); ++i) {
                pdType_MR_PD_INFO pdType_MR_PD_INFO2 = ((SASPhysicalDrive)arrayList2.get(i)).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
                if (pdType_MR_PD_INFO2.getisForeign() != 1) continue;
                arrayList.add(arrayList2.get(i));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    protected MR_CONFIG_DATA readConfigAfterImport(int n) throws Exception {
        OperationDetails operationDetails = new OperationDetails(5, new Short((short)n));
        this.adapter.fireConfigOperation(operationDetails);
        return (MR_CONFIG_DATA)operationDetails.getParam();
    }

    public boolean validMergedData(MR_CONFIG_DATA mR_CONFIG_DATA) throws Exception {
        MR_LD_CONFIG[] mR_LD_CONFIGArray;
        if (mR_CONFIG_DATA != null && (mR_LD_CONFIGArray = mR_CONFIG_DATA.getld()) != null && mR_LD_CONFIGArray.length > 0) {
            for (int i = 0; i < mR_LD_CONFIGArray.length; ++i) {
                if (mR_LD_CONFIGArray[i].getproperties().getldRef().gettargetId() == '\u00ff' && mR_LD_CONFIGArray[i].getparams().getstate() == '\u0000') continue;
                return true;
            }
        }
        return true;
    }
}

