/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUI.DeviceTreeRenderer;
import GUI.MainFrame;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_FOREIGN_CFG_GUIDS;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import Wizard.ConfigWizard.GUIData;
import Wizard.ForeignConfigWizard.FoundForeignConfig;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class EncrtyptionRequiredToImportDialog
extends VivaldiBaseOptionDialog {
    SASAdapter sasAdapter;
    AdapterHelper adapter;
    DeviceTreeRenderer deviceRenderer;
    private DefaultTreeModel pdTreeModel;
    PhysicalDriveHelper[] pdHelpers;
    VivaldiBaseOptionDialog optionDialog;
    TreePath treePath;
    FoundForeignConfig founfForeignConfig;
    private static final int ENCLOSURE_NODE = 7;
    private static final int ADAPTER_NODE = 5;
    private MR_FOREIGN_CFG_GUIDS guidList = null;
    private JTree pdTree = new JTree();

    public EncrtyptionRequiredToImportDialog(AdapterHelper adapterHelper, PhysicalDriveHelper[] physicalDriveHelperArray, boolean bl) {
        super((Window)null);
        this.adapter = adapterHelper;
        this.pdHelpers = physicalDriveHelperArray;
        this.buildUI(bl);
    }

    public EncrtyptionRequiredToImportDialog(AdapterHelper adapterHelper, boolean bl) {
        super((Window)VivaldiStartupDialog.mainScreen);
        this.adapter = adapterHelper;
        this.createTree();
        this.buildUI(bl);
    }

    public EncrtyptionRequiredToImportDialog(AdapterHelper adapterHelper, FoundForeignConfig foundForeignConfig) {
        super((Window)VivaldiStartupDialog.mainScreen);
        this.adapter = adapterHelper;
        this.founfForeignConfig = foundForeignConfig;
        this.createTree();
        this.buildUI(true);
    }

    private void buildUI(boolean bl) {
        String[] stringArray = null;
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        this.setIconImage(image);
        this.setResizable(false);
        this.setSize(MainFrame.SCREEN_SIZE.width * 640 / 1028, MainFrame.SCREEN_SIZE.height * 480 / 800);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth() + 200) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getLockedPhysicalDrives();
        this.m_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String string = Resource.getString("ENCRYPTION_REQUIRED_DESC", "<html>You cannot import the following locked foreign drives because <br> encryption is disabled on your controller.Only unlocked drives <br> may be imported");
        System.out.println("strPassPhraseDesc  :" + string);
        StringBuffer stringBuffer = new StringBuffer(string);
        JLabel jLabel = new JLabel();
        jLabel.setText(stringBuffer.toString());
        jLabel.setOpaque(false);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_LOCKED_DRIVES", "(L)ocked Drives:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel2.setLabelFor(this.pdTree);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        this.m_panel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.m_panel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.pdTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 == null) {
                    return this;
                }
                if (!(object2 instanceof GUIData)) {
                    return this;
                }
                System.out.println("((GUIData) val).flag  :" + ((GUIData)object2).flag);
                switch (((GUIData)object2).flag) {
                    case 17: {
                        this.setIcon(Resource.getImage("FAILED_IMAGE", "failed.png"));
                        break;
                    }
                    case 1: {
                        this.setIcon(Resource.getImage("PHDRIVE_IMAGE", "phdrive.jpg"));
                        break;
                    }
                    case 0: {
                        this.setIcon(Resource.getImage("PHDRIVE_IMAGE", "phdrive.jpg"));
                        break;
                    }
                    case 24: {
                        this.setIcon(Resource.getImage("PHDRIVE_IMAGE", "phdrive.jpg"));
                        break;
                    }
                    case 7: {
                        this.setIcon(Resource.getImage("ENCLOSURE_IMAGE", "enclosure.png"));
                        break;
                    }
                    case 5: {
                        this.setIcon(EncrtyptionRequiredToImportDialog.this.adapter.getIcon());
                        break;
                    }
                }
                return this;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.pdTree, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(450, 200));
        this.m_panel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        JPanel jPanel = new JPanel();
        JLabel jLabel3 = new JLabel(Resource.getString("ENCRYPTION_REQUIRED_CONTINUE_LABEL", "Do you want to continue?"));
        jPanel.add(jLabel3);
        this.m_panel.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 10;
        jPanel2.setLayout(new FlowLayout(1));
        this.m_panel.add((Component)jPanel2, gridBagConstraints);
        this.initUI(Resource.getString("ENCRYPTION_REQUIRED_TO_IMPORT_DIALOG_TITLE", "Encryption Required To Import"), 0, 1);
        this.add((Component)this.m_panel, "Center");
        System.out.println("the location is :" + this.getLocation());
        System.out.println("continueLabel Location :" + jLabel3.getBounds());
        super.buildUI();
        if (bl) {
            this.setYesEnabled(true);
        } else {
            this.setYesEnabled(false);
        }
    }

    @Override
    public void onYesOption() {
        super.onYesOption();
        this.getGUIDList();
        if (this.guidList == null || this.guidList.getcount() <= 0) {
            String string = Resource.getString("MSG_NO_FOREIGN_IMPORT_TITLE", "No Configurations To Import");
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel(Resource.getString("MSG_NO_FOREIGN_CONFIG", "There are no configurations to import at this time."));
            jPanel.add(jLabel);
            System.out.println("title  :" + string);
            VivaldiBaseOptionDialog vivaldiBaseOptionDialog = new VivaldiBaseOptionDialog(VivaldiStartupDialog.mainScreen, string, jPanel, -1, 1);
            vivaldiBaseOptionDialog.setLocation(MainFrame.SCREEN_SIZE.width - this.getWidth(), MainFrame.SCREEN_SIZE.height - this.getHeight());
            vivaldiBaseOptionDialog.buildUI();
            this.dispose();
            return;
        }
        if (this.guidList.getcount() > 8) {
            new CustomMsgBox(Resource.getString("FOREIGN_CONFIG_MAX_LIMIT_EXIT_MSG", "<html>The number of foreign configurations detected exceeds the number that can be displayed.<br> Import or clear the configurations that are displayed <br>and then scan for foreign configurations again.</html>"));
        } else {
            this.founfForeignConfig.importSelectedForeignConfig();
        }
    }

    public void getGUIDList() {
        try {
            OperationDetails operationDetails = new OperationDetails(3, null);
            ((SASAdapter)this.adapter.getDeviceObject()).fireConfigOperation(operationDetails);
            this.guidList = (MR_FOREIGN_CFG_GUIDS)operationDetails.getParam();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            CustomMsgBox.errorMsg(vKOperationFailedException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void createTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new GUIData(this.adapter, 5));
        System.out.println("((AdapterHelper)adapter).getEnclosures().length :" + this.adapter.getEnclosures().length);
        PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getLockedPhysicalDrives();
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray[i];
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject();
            short s = sASPhysicalDrive.getState();
            if (s == 17) {
                System.out.println("in createTree  PD_STATE_FAILED  :");
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 17));
            }
            if (s == 2) {
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 2));
            }
            if (s == 16) {
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 16));
            }
            if (s == 24) {
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 24));
            }
            if (s == 20) {
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 20));
            }
            if (s == 1) {
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 1));
            }
            if (s == 0) {
                System.out.println("in createTree  PD_STATE_UNCONFIGURED_GOOD  :");
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 0));
            }
            if (s == 32) {
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 32));
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        this.pdTreeModel = new DefaultTreeModel(defaultMutableTreeNode3);
        this.pdTree.setModel(this.pdTreeModel);
    }
}

