/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_FOREIGN_CFG_GUIDS;
import SASKernel.LibraryAPI.StoreLib.pdType_MR_PD_INFO;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDevice;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import Wizard.ForeignConfigWizard.FoundForeignConfig;
import Wizard.ForeignConfigWizard.ImportForeignConfigDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class ForeignConfigDetectedDialog
extends VivaldiBaseOptionDialog {
    private ButtonGroup m_buttonGroup = null;
    private JRadioButton m_rdBtnImport = null;
    private JRadioButton m_rdBtnClear = null;
    private JRadioButton m_rdBtnAdvanced = null;
    private AdapterHelper m_adapterHelper = null;
    private MR_FOREIGN_CFG_GUIDS m_foreignConfigGuidList = null;

    public ForeignConfigDetectedDialog(AdapterHelper adapterHelper, MR_FOREIGN_CFG_GUIDS mR_FOREIGN_CFG_GUIDS) {
        super((Window)VivaldiStartupDialog.mainScreen);
        this.m_adapterHelper = adapterHelper;
        this.m_foreignConfigGuidList = mR_FOREIGN_CFG_GUIDS;
        this.buildUI();
    }

    @Override
    public void buildUI() {
        Observable observable;
        this.initUI(Resource.getString("TITLE_FOREIGN_CONFIG_DETECTED", "Foreign Configuration Detected"), 2, 1);
        this.setModalProperty(true);
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_IMPORT_LABEL", "I(m)port: Import logical configuration from all foreign drives."));
        this.m_rdBtnImport = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnImport.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_rdBtnImport.setSelected(true);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLEAR_LABEL", "(C)lear: Remove logical configuration from all foreign drives."));
        this.m_rdBtnClear = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnClear.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_ADVANCED_LABEL", "(A)dvanced: Preview, import and clear specific foreign configurations."));
        this.m_rdBtnAdvanced = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_rdBtnAdvanced.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_buttonGroup = new ButtonGroup();
        this.m_buttonGroup.add(this.m_rdBtnImport);
        this.m_buttonGroup.add(this.m_rdBtnClear);
        this.m_buttonGroup.add(this.m_rdBtnAdvanced);
        if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getInformation().getadapterOperations_MR_CTRL_INFO().getsupportEnhForeignImport() == 0) {
            this.m_rdBtnImport.disable();
            this.m_rdBtnClear.disable();
        }
        this.m_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getPhysicalDrives();
        int n = 0;
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            observable = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            pdType_MR_PD_INFO pdType_MR_PD_INFO2 = ((SASPhysicalDevice)observable).getInformation().getstate_MR_PD_INFO1().getpdType_MR_PD_INFO1();
            if (pdType_MR_PD_INFO2.getisForeign() != 1) continue;
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(n + " ");
        stringBuffer.append(Resource.getString("MESSAGE_FOREIGN_CONFIG_DETECTED", "Foreign drives were detected. You must import or clear these<br>drives before they can be used."));
        stringBuffer.append("<br><br></html>");
        this.m_panel.add((Component)new JLabel(stringBuffer.toString()), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.m_panel.add((Component)new JLabel(Resource.getString("LABEL_CHOOSE_AN_OPTION", "Choose an option:")), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.m_panel.add((Component)this.m_rdBtnImport, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.m_panel.add((Component)this.m_rdBtnClear, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        observable = (SASAdapter)this.m_adapterHelper.getDeviceObject();
        if (((SASAdapter)observable).getAdapterType() == 2 || ((SASAdapter)observable).getAdapterType() == 3 || ((SASAdapter)observable).getAdapterType() == 4) {
            if (((SASAdapter)observable).getInformation().getadapterOperations_MR_CTRL_INFO().getsupportEnhForeignImport() == 1) {
                this.m_buttonGroup.add(this.m_rdBtnAdvanced);
                this.m_panel.add((Component)this.m_rdBtnAdvanced, gridBagConstraints);
            }
        } else {
            this.m_buttonGroup.add(this.m_rdBtnAdvanced);
            this.m_panel.add((Component)this.m_rdBtnAdvanced, gridBagConstraints);
        }
        this.setResizable(false);
        super.buildUI();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_rdBtnImport) || actionEvent.getSource().equals(this.m_rdBtnClear) || actionEvent.getSource().equals(this.m_rdBtnAdvanced)) {
            // empty if block
        }
    }

    @Override
    public void onOkAction() {
        super.onOkAction();
        if (this.m_rdBtnImport.isSelected()) {
            int n = 0;
            if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
                new ImportForeignConfigDialog(this.m_adapterHelper, n);
            } else {
                new ImportForeignConfigDialog(this.m_adapterHelper, 255);
            }
        } else if (this.m_rdBtnClear.isSelected()) {
            if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_CLEAR_FOREIGN_CONFIG", "<html>This operation will remove the foreign configuration.<br>Are you sure you want to continue? </html>"))) {
                return;
            }
            OperationDetails operationDetails = null;
            int n = 0;
            if (((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 2 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 3 || ((SASAdapter)this.m_adapterHelper.getDeviceObject()).getAdapterType() == 4) {
                for (n = 0; n < this.m_foreignConfigGuidList.getcount(); ++n) {
                    operationDetails = new OperationDetails(7, new Short((short)n));
                }
            } else {
                operationDetails = new OperationDetails(7, new Short(255));
            }
            try {
                ((SASAdapter)this.m_adapterHelper.getDeviceObject()).fireConfigOperation(operationDetails);
                OperationDetails operationDetails2 = new OperationDetails(3, null);
                ((SASAdapter)this.m_adapterHelper.getDeviceObject()).fireConfigOperation(operationDetails2);
                MR_FOREIGN_CFG_GUIDS mR_FOREIGN_CFG_GUIDS = (MR_FOREIGN_CFG_GUIDS)operationDetails2.getParam();
                if (mR_FOREIGN_CFG_GUIDS == null || mR_FOREIGN_CFG_GUIDS.getcount() <= 0) {
                    JOptionPane.showMessageDialog(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_FOREIGN_CONFIG_CLEARED", "The foreign configuration was cleared successfully."), Resource.getString("TITLE_FOREIGN_CONFIG_CLEARED", "Clear Successful"), 1);
                }
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
                CustomMsgBox.errorMsg(vKOperationFailedException);
            }
            catch (Exception exception) {}
        } else {
            new FoundForeignConfig(this.m_adapterHelper);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

