/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKObjectNotPresentException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_PD_INFO;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASLogical.SASArray;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.BaseWizardDialog;
import Wizard.ForeignConfigWizard.BaseForeignConfigDialog;
import Wizard.ForeignConfigWizard.EncrtyptionRequiredToImportDialog;
import Wizard.ForeignConfigWizard.ForeignConfigDetectedDialog;
import Wizard.ForeignConfigWizard.GUIData;
import Wizard.ForeignConfigWizard.ImportForeignConfigDialog;
import Wizard.ForeignConfigWizard.UnlockForeignDrives;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class FoundForeignConfig
extends BaseForeignConfigDialog {
    private JSplitPane split;
    private JPanel bottomPanel = new JPanel();
    private DefaultComboBoxModel listModel = new DefaultComboBoxModel();
    private DefaultTreeModel treeModel = new DefaultTreeModel(null);
    private JTree tree = new JTree();
    private JLabel comboLabel = new JLabel();
    private JLabel treeLabel = new JLabel();
    private JComboBox list = new JComboBox(this.listModel);
    private JButton clearConfig = new JButton();
    private JButton importConfig = new JButton();
    private JButton cancelButton = new JButton();
    private JPanel buttonPan = new JPanel();
    private JLabel desPan = new JLabel();
    private JTextArea desc_area = new JTextArea();
    private GridBagConstraints constr = new GridBagConstraints();
    private GridBagLayout layout = new GridBagLayout();
    private JPanel centerPane = new JPanel();
    protected Hashtable treeCache = new Hashtable();
    private MR_CONFIG_DATA mergedForeignConfigData = null;
    private int guiIdIndex;
    private String[] allDetailMsg = new String[]{Resource.getString("NOIMPORTABLE_VD_MSG_1", "Cannot import virtual disk:\nOne or more drives are missing.\nInsert the missing drive(s) and re-scan."), Resource.getString("NOIMPORTABLE_VD_MSG_2", "Cannot import virtual disk:\nOne or more spans are missing.\nInsert the missing drive(s) and re-scan."), Resource.getString("NOIMPORTABLE_VD_MSG_3", "Cannot import virtual disk:\nExceeded number of virtual drives allowed.\nRemove some of the existing virtual disks and re-scan."), Resource.getString("NOIMPORTABLE_VD_MSG_4", "Cannot import virtual disk:\nUnsupported Configuration. Clear the configuration \nor return the drive(s) to the original controller."), Resource.getString("NOIMPORTABLE_VD_MSG_5", "Cannot import virtual disk:\nOutdated drive data. Insert the missing drive(s) and re-scan."), Resource.getString("NOIMPORTABLE_VD_MSG_6", "Import warning: \nPossible outdated drive data.\nInsert the missing drive before importing the configuration.\nImporting the virtual disk without the missing drive may result in data loss."), Resource.getString("NOIMPORTABLE_VD_MSG_7", "Cannot import physical drive: Configuration conflict. The drive\u2019s place may have been taken by another drive,\nit could be part of another configuration, or the drive\u2019s configuration may be incompatible.\nIm,port or clear any other configurations that exist \nand then re-scan or return the drive to the original controller."), Resource.getString("NOIMPORTABLE_VD_MSG_8", "Cannot import virtual disk: One or more drives are orphan. Insert the missing drive(s) and re-scan."), Resource.getString("NOIMPORTABLE_VD_MSG_9", "Cannot import virtual disk: R1E is not supported on this controller."), Resource.getString("NOIMPORTABLE_VD_MSG_10", "If you import a data protection capable virtual drive on this controller, you will lose the data protection for \nthis virtual drive, because the protection capability is disabled on this controller.")};
    private AdapterHelper m_adapterHelper = null;

    public FoundForeignConfig(AdapterHelper adapterHelper) {
        super(adapterHelper);
        this.m_adapterHelper = adapterHelper;
        GUIData.setAdapterHelper(this.m_adapterHelper);
        this.contentPane.add((Component)this.centerPane, "Center");
        this.centerPane.setLayout(this.layout);
        this.getGUIDList();
        if (this.guidList == null || this.guidList.getcount() <= 0) {
            new CustomMsgBox(Resource.getString("MSG_NO_FOREIGN_CONFIG", "No Foreign Configuration is found !"));
            this.dispose();
            return;
        }
        if (this.guidList.getcount() > 8) {
            new CustomMsgBox(Resource.getString("FOREIGN_CONFIG_MAX_LIMIT_EXIT_MSG", "<html>The number of foreign configurations detected exceeds the number that can be displayed.<br> Import or clear the configurations that are displayed <br>and then scan for foreign configurations again.</html>"));
        }
        this.refreshList();
        if (this.listModel.getSize() == 0) {
            return;
        }
        this.list.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FoundForeignConfig.this.refreshTree();
            }
        });
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("FOREIGN_CFG_GUID_COMBO_LABEL", "Select Configuration"));
        this.comboLabel.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.comboLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.comboLabel.setLabelFor(this.list);
        stringArray = Resource.getResourceMnemonic(Resource.getString("FOREIGN_CFG_GUID_TREE_LABEL", "Configuration Preview"));
        this.treeLabel.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.treeLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.treeLabel.setLabelFor(this.tree);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLEAR_CONFIG", "Clear"));
        this.clearConfig.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.clearConfig.setMnemonic(stringArray[1].charAt(0));
        }
        this.clearConfig.setToolTipText(Resource.getString("BUTTON_CLEAR_CONFIG_DSC", "Clear"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_IMPORT_CONFIG", "Import"));
        this.importConfig.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.importConfig.setMnemonic(stringArray[1].charAt(0));
        }
        this.importConfig.setToolTipText(Resource.getString("BUTTON_IMPORT_CONFIG_DSC", "Import"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_FOREIGN_CONFIG", "Close"));
        this.cancelButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.cancelButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.cancelButton.setToolTipText(Resource.getString("BUTTON_CANCEL_FOREIGN_CONFIG_DSC", "Close"));
        this.list.setSelectedIndex(0);
        this.tree.setCellRenderer(this.renderer);
        this.tree.setModel(this.treeModel);
        this.constr.insets = new Insets(0, 5, 5, 0);
        this.constr.gridx = -1;
        this.constr.gridy = 0;
        this.constr.anchor = 17;
        this.centerPane.add((Component)this.comboLabel, this.constr);
        this.constr.gridy = 1;
        this.constr.ipadx = 100;
        this.centerPane.add((Component)this.list, this.constr);
        this.constr.insets = new Insets(10, 5, 5, 0);
        this.constr.gridy = 2;
        this.constr.ipadx = 0;
        this.centerPane.add((Component)this.treeLabel, this.constr);
        this.constr.insets = new Insets(0, 5, 5, 10);
        this.constr.gridy = 3;
        this.constr.weightx = 1.0;
        this.constr.weighty = 1.0;
        this.constr.fill = 1;
        this.constr.gridwidth = 0;
        this.centerPane.add((Component)new JScrollPane(this.tree), this.constr);
        this.tree.getSelectionModel().setSelectionMode(1);
        ForeignConfigSelectionListener foreignConfigSelectionListener = new ForeignConfigSelectionListener();
        this.tree.addMouseListener(foreignConfigSelectionListener);
        this.tree.addTreeSelectionListener(foreignConfigSelectionListener);
        stringArray = Resource.getResourceMnemonic(Resource.getString("FOREIGN_CFG_LABEL_WARNINGS", "(W)arnings"));
        this.desPan.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.desPan.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.desPan.setLabelFor(this.desc_area);
        this.constr.gridy = 4;
        this.constr.fill = 2;
        this.constr.weightx = 0.0;
        this.constr.weighty = 0.0;
        this.centerPane.add((Component)this.desPan, this.constr);
        this.constr.gridy = 5;
        JScrollPane jScrollPane = new JScrollPane(this.desc_area, 20, 30);
        jScrollPane.setMinimumSize(new Dimension(100, 50));
        this.centerPane.add((Component)jScrollPane, this.constr);
        this.constr.weightx = 0.0;
        this.constr.weighty = 0.0;
        this.constr.gridheight = 0;
        this.constr.gridy = -1;
        this.constr.fill = 1;
        this.constr.anchor = 20;
        this.buttonPan.setLayout(new FlowLayout(2));
        this.centerPane.add((Component)this.buttonPan, this.constr);
        this.desc_area.setEditable(false);
        this.clearConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FoundForeignConfig.this.clearSelectedForeignConfig();
            }
        });
        this.importConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FoundForeignConfig.this.dispose();
                FoundForeignConfig.this.importSelectedForeignConfig();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomMsgBox.confirm(Resource.getString("MSG_IGNORE_FOREIGN_CONFIG", "Do you want to ignore the foreign configuration ?"))) {
                    FoundForeignConfig.this.dispose();
                }
            }
        });
        this.buttonPan.add(this.importConfig);
        this.buttonPan.add(this.clearConfig);
        this.buttonPan.add(this.cancelButton);
        this.buttonPan.setAlignmentX(2.0f);
        this.show();
    }

    public boolean scanForMargedConfig() {
        if (this.adapter.getInformation().getadapterOperations_MR_CTRL_INFO().getsupportEnhForeignImport() != 0) {
            try {
                this.mergedForeignConfigData = this.readConfigAfterImport(255);
                if (this.validMergedData(this.mergedForeignConfigData)) {
                    this.listModel.addElement(new GUIData(Resource.getString("TEXT_GUID_ALL", "All"), 255));
                    return true;
                }
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                CustomMsgBox.errorMsg(vKOperationFailedException);
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private void checkingLockedDrives() {
        boolean bl = false;
        PhysicalDriveHelper[] physicalDriveHelperArray = this.m_adapterHelper.getLockedPhysicalDrives();
        if (physicalDriveHelperArray.length > 0) {
            if (this.m_adapterHelper.isSecuritySupported()) {
                new UnlockForeignDrives(this.m_adapterHelper, physicalDriveHelperArray);
            } else {
                new EncrtyptionRequiredToImportDialog(this.m_adapterHelper, this);
            }
        } else {
            this.importSelectedForeignConfig();
        }
    }

    private void refreshList() {
        this.listModel.removeAllElements();
        boolean bl = false;
        bl = this.scanForMargedConfig();
        if (!bl) {
            return;
        }
        if (VivaldiStartupDialog.OEM_TYPE != 2561) {
            this.guiIdIndex = 0;
            while (this.guiIdIndex < this.guidList.getcount()) {
                this.listModel.addElement(new GUIData(this.guidList.getddf()[this.guiIdIndex], this.guiIdIndex));
                ++this.guiIdIndex;
            }
        } else if (this.adapter.getAdapterType() == 2 || this.adapter.getAdapterType() == 3 || this.adapter.getAdapterType() == 4 || this.guidList.getcount() == 1) {
            this.guiIdIndex = 0;
            while (this.guiIdIndex < this.guidList.getcount()) {
                this.listModel.addElement(new GUIData(this.guidList.getddf()[this.guiIdIndex], this.guiIdIndex));
                ++this.guiIdIndex;
            }
        }
        this.list.repaint();
    }

    private void refreshTree() {
        if (this.list.getSelectedIndex() < 0 || this.list.getSelectedItem() == null) {
            return;
        }
        GUIData gUIData = (GUIData)this.list.getSelectedItem();
        this.treeModel = new DefaultTreeModel(null);
        try {
            MR_CONFIG_DATA mR_CONFIG_DATA = this.readConfigAfterImport(((GUIData)this.list.getSelectedItem()).flag);
            if (mR_CONFIG_DATA == null) {
                return;
            }
            if (!this.validMergedData(mR_CONFIG_DATA)) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createTreeStructure(mR_CONFIG_DATA);
            this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.treeCache.put(gUIData, this.treeModel);
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            new CustomMsgBox(this, Resource.getString("MSG_INCOMPLETE_FOREIGN_CFG_WARN", "Incomplete Foreign Config"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new CustomMsgBox(this, Resource.getString("MSG_FAILED_FOREIGNCFG", "Can not read Foreign Config !"));
            return;
        }
        this.tree.setModel(this.treeModel);
        BaseWizardDialog.expandTree(this.tree);
        this.tree.repaint();
    }

    private MR_CONFIG_DATA readForeignConfig(int n) throws Exception {
        OperationDetails operationDetails = new OperationDetails(4, new Short((short)n));
        this.adapter.fireConfigOperation(operationDetails);
        return (MR_CONFIG_DATA)operationDetails.getParam();
    }

    private void clearSelectedForeignConfig() {
        if (!CustomMsgBox.confirmWithCheck(Resource.getString("MSG_CLEAR_FOREIGN_CONFIG", "<html>This operation will remove the foreign configuration.<br> Are you sure you want to continue? </html>"))) {
            return;
        }
        GUIData gUIData = (GUIData)this.list.getSelectedItem();
        int n = gUIData.flag;
        OperationDetails operationDetails = new OperationDetails(7, new Short((short)n));
        try {
            this.adapter.fireConfigOperation(operationDetails);
            this.treeCache.clear();
            this.getGUIDList();
            this.dispose();
            if (this.guidList == null || this.guidList.getcount() <= 0) {
                new CustomMsgBox((Component)this, (Object)Resource.getString("MSG_CLEAR_FOREIGN_CONFIG_SUCCESS", "Foreign Configuration Cleared Successfully !"), 1);
                return;
            }
            this.refreshList();
            if (CustomMsgBox.confirm(Resource.getString("MSG_CLEAR_FOREIGNCFG_SUCCESS_RESCAN", "<html>Foreign Configuration was cleared successfully. <br>More foreign configurations were detected.<br>Would you like to re-scan for foreign configurations?<br><br></html>"), 1)) {
                new ForeignConfigDetectedDialog(this.m_adapterHelper, this.guidList);
            }
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            CustomMsgBox.errorMsg(vKOperationFailedException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new CustomMsgBox(this, Resource.getString("MSG_CLEAR_FOREIGN_FAILED", "Clear Foreign Config failed !"));
        }
    }

    public void importSelectedForeignConfig() {
        new ImportForeignConfigDialog(this.m_adapterHelper, ((GUIData)this.list.getSelectedItem()).flag);
        this.treeCache.clear();
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("HELP_PAGE_FOREIGN_CONFIG_DIALOG");
    }

    public MR_ARRAY getMRArrayForArrayRef(short s, List list) {
        MR_ARRAY mR_ARRAY = null;
        if (list != null && list.size() > 0) {
            SASArray sASArray;
            for (int i = 0; i < list.size() && (mR_ARRAY = (sASArray = (SASArray)list.get(i)).getInformation()).getarrayRef() != s; ++i) {
            }
        }
        return mR_ARRAY;
    }

    class ForeignConfigSelectionListener
    extends MouseAdapter
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            block19: {
                int n;
                int n2;
                int n3;
                GUIData gUIData;
                block20: {
                    MR_PD_INFO mR_PD_INFO;
                    block21: {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FoundForeignConfig.this.tree.getLastSelectedPathComponent();
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        gUIData = (GUIData)defaultMutableTreeNode.getUserObject();
                        FoundForeignConfig.this.desc_area.setText("");
                        if (gUIData.flag != 2) break block20;
                        mR_PD_INFO = (MR_PD_INFO)gUIData.value;
                        if (mR_PD_INFO.getfwState() != 8) break block21;
                        FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[0]);
                        break block19;
                    }
                    if (mR_PD_INFO.getfwState() != 13) break block19;
                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[7]);
                    break block19;
                }
                if (gUIData.flag != 3) break block19;
                MR_LD_CONFIG mR_LD_CONFIG = (MR_LD_CONFIG)gUIData.value;
                MR_CONFIG_DATA mR_CONFIG_DATA = null;
                try {
                    mR_CONFIG_DATA = FoundForeignConfig.this.readConfigAfterImport(((GUIData)((FoundForeignConfig)FoundForeignConfig.this).list.getSelectedItem()).flag);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(FoundForeignConfig.this.m_adapterHelper.isPISupported() && FoundForeignConfig.this.m_adapterHelper.isPIEnabledOnController() || mR_LD_CONFIG.getparams().getPIEnabled() != 1)) {
                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[9]);
                }
                if (mR_LD_CONFIG.getparams().getPRL() == 17 && VivaldiStartupDialog.OEM_TYPE == 2561) {
                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[3]);
                }
                MR_ARRAY[] mR_ARRAYArray = mR_CONFIG_DATA.getarray();
                boolean bl = false;
                int n4 = mR_LD_CONFIG.getparams().getspanDepth();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = mR_LD_CONFIG.getspan()[n3].getarrayRef();
                    for (n = 0; n < mR_ARRAYArray.length; ++n) {
                        if (mR_ARRAYArray[n].getarrayRef() != n2) continue;
                        pd_MR_ARRAY[] pd_MR_ARRAYArray = mR_ARRAYArray[n].getpd_MR_ARRAY1();
                        for (int i = 0; i < mR_ARRAYArray[n].getnumDrives(); ++i) {
                            if (mR_LD_CONFIG.getparams().getPRL() != 1 || pd_MR_ARRAYArray[i].getfwState() != 0) continue;
                            FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[5]);
                            bl = true;
                            break;
                        }
                        if (bl) break;
                    }
                    if (bl) break;
                }
                if ((short)mR_LD_CONFIG.getproperties().getldRef().gettargetId() == 255) {
                    if (mR_LD_CONFIG.getparams().getstate() == '\u0000') {
                        n3 = mR_LD_CONFIG.getparams().getspanDepth();
                        for (n2 = 0; n2 < n3; ++n2) {
                            n = mR_LD_CONFIG.getspan()[n2].getarrayRef();
                            if (n != 255) continue;
                            FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[1]);
                            break;
                        }
                        MR_ARRAY[] mR_ARRAYArray2 = mR_CONFIG_DATA.getarray();
                        n = 0;
                        for (int i = 0; i < mR_ARRAYArray2.length; ++i) {
                            pd_MR_ARRAY[] pd_MR_ARRAYArray = mR_ARRAYArray2[i].getpd_MR_ARRAY1();
                            if (pd_MR_ARRAYArray == null || pd_MR_ARRAYArray.length <= 0) continue;
                            for (int j = 0; j < pd_MR_ARRAYArray.length; ++j) {
                                if (pd_MR_ARRAYArray[j].getref().getdeviceId() == -1) {
                                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[0]);
                                    n = 1;
                                    break;
                                }
                                if (pd_MR_ARRAYArray[j].getref().getseqNum() != 0) continue;
                                FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[5]);
                                n = 1;
                                break;
                            }
                            if (n != 1) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        ArrayList arrayList = null;
                        try {
                            arrayList = FoundForeignConfig.this.adapter.getSASObjectsArrayList((short)8192);
                            n2 = arrayList.size() + mR_CONFIG_DATA.getlogDrvCount();
                            if (n2 >= FoundForeignConfig.this.adapter.getInformation().getmaxLDs()) {
                                FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[2]);
                            }
                            FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[3]);
                        }
                        catch (VKObjectNotPresentException vKObjectNotPresentException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            block19: {
                int n;
                int n2;
                int n3;
                GUIData gUIData;
                block20: {
                    MR_PD_INFO mR_PD_INFO;
                    block21: {
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)FoundForeignConfig.this.tree.getLastSelectedPathComponent();
                        if (defaultMutableTreeNode == null) {
                            return;
                        }
                        gUIData = (GUIData)defaultMutableTreeNode.getUserObject();
                        FoundForeignConfig.this.desc_area.setText("");
                        if (gUIData.flag != 2) break block20;
                        mR_PD_INFO = (MR_PD_INFO)gUIData.value;
                        if (mR_PD_INFO.getfwState() != 8) break block21;
                        FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[0]);
                        break block19;
                    }
                    if (mR_PD_INFO.getfwState() != 13) break block19;
                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[7]);
                    break block19;
                }
                if (gUIData.flag != 3) break block19;
                MR_LD_CONFIG mR_LD_CONFIG = (MR_LD_CONFIG)gUIData.value;
                MR_CONFIG_DATA mR_CONFIG_DATA = null;
                try {
                    mR_CONFIG_DATA = FoundForeignConfig.this.readConfigAfterImport(((GUIData)((FoundForeignConfig)FoundForeignConfig.this).list.getSelectedItem()).flag);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(FoundForeignConfig.this.m_adapterHelper.isPISupported() && FoundForeignConfig.this.m_adapterHelper.isPIEnabledOnController() || mR_LD_CONFIG.getparams().getPIEnabled() != 1)) {
                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[9]);
                }
                if (mR_LD_CONFIG.getparams().getPRL() == 17 && VivaldiStartupDialog.OEM_TYPE == 2561) {
                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[3]);
                }
                MR_ARRAY[] mR_ARRAYArray = mR_CONFIG_DATA.getarray();
                boolean bl = false;
                int n4 = mR_LD_CONFIG.getparams().getspanDepth();
                for (n3 = 0; n3 < n4; ++n3) {
                    n2 = mR_LD_CONFIG.getspan()[n3].getarrayRef();
                    for (n = 0; n < mR_ARRAYArray.length; ++n) {
                        if (mR_ARRAYArray[n].getarrayRef() != n2) continue;
                        pd_MR_ARRAY[] pd_MR_ARRAYArray = mR_ARRAYArray[n].getpd_MR_ARRAY1();
                        for (int i = 0; i < mR_ARRAYArray[n].getnumDrives(); ++i) {
                            if (mR_LD_CONFIG.getparams().getPRL() != 1 || pd_MR_ARRAYArray[i].getfwState() != 0) continue;
                            FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[5]);
                            bl = true;
                            break;
                        }
                        if (bl) break;
                    }
                    if (bl) break;
                }
                if ((short)mR_LD_CONFIG.getproperties().getldRef().gettargetId() == 255) {
                    if (mR_LD_CONFIG.getparams().getstate() == '\u0000') {
                        n3 = mR_LD_CONFIG.getparams().getspanDepth();
                        for (n2 = 0; n2 < n3; ++n2) {
                            n = mR_LD_CONFIG.getspan()[n2].getarrayRef();
                            if (n != 255) continue;
                            FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[1]);
                            break;
                        }
                        MR_ARRAY[] mR_ARRAYArray2 = mR_CONFIG_DATA.getarray();
                        n = 0;
                        for (int i = 0; i < mR_ARRAYArray2.length; ++i) {
                            pd_MR_ARRAY[] pd_MR_ARRAYArray = mR_ARRAYArray2[i].getpd_MR_ARRAY1();
                            if (pd_MR_ARRAYArray == null || pd_MR_ARRAYArray.length <= 0) continue;
                            for (int j = 0; j < pd_MR_ARRAYArray.length; ++j) {
                                if (pd_MR_ARRAYArray[j].getref().getdeviceId() == -1) {
                                    FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[0]);
                                    n = 1;
                                    break;
                                }
                                if (pd_MR_ARRAYArray[j].getref().getseqNum() != 0) continue;
                                FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[5]);
                                n = 1;
                                break;
                            }
                            if (n != 1) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        ArrayList arrayList = null;
                        try {
                            arrayList = FoundForeignConfig.this.adapter.getSASObjectsArrayList((short)8192);
                            n2 = arrayList.size() + mR_CONFIG_DATA.getlogDrvCount();
                            if (n2 >= FoundForeignConfig.this.adapter.getInformation().getmaxLDs()) {
                                FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[2]);
                            }
                            FoundForeignConfig.this.desc_area.setText(FoundForeignConfig.this.allDetailMsg[3]);
                        }
                        catch (VKObjectNotPresentException vKObjectNotPresentException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

