/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.LibraryAPI.StoreLib.MR_ARRAY;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_DDF_HEADER_GUID;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.LibraryAPI.StoreLib.MR_MFC_DEFAULTS;
import SASKernel.LibraryAPI.StoreLib.MR_PD_REF;
import SASKernel.LibraryAPI.StoreLib.pd_MR_ARRAY;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import java.util.ArrayList;

public class GUIData {
    public Object value;
    public int flag;
    private static SASAdapter m_sasAdapter = null;
    private static AdapterHelper m_adapterHelper = null;
    private static MR_CONFIG_DATA m_CFGdata = null;

    public GUIData(Object object, int n) {
        this.value = object;
        this.flag = n;
    }

    private String getRAIDLevelString(MR_LD_CONFIG mR_LD_CONFIG) {
        byte by = mR_LD_CONFIG.getparams().getPRL();
        byte by2 = mR_LD_CONFIG.getparams().getSRL();
        char c = mR_LD_CONFIG.getparams().getspanDepth();
        char c2 = mR_LD_CONFIG.getparams().getnumDrives();
        String string = Resource.getString("RAID_TEXT", "RAID") + " ";
        if (mR_LD_CONFIG.getparams().getisSSCD() == 2) {
            return Resource.getString("RAID_LEVEL_EC", "Elastic Cache");
        }
        if (by == 17) {
            if (c > '\u0001' && m_sasAdapter.getAdapterType() == 1) {
                return string + "10";
            }
            if (m_sasAdapter.getAdapterType() == 1) {
                try {
                    MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)m_adapterHelper.getDeviceObject()).getMFCDefaults();
                    if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1) {
                        return string + "10";
                    }
                    return string + "1";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return string + "1";
                }
            }
            if (m_sasAdapter.getAdapterType() == 3 || m_sasAdapter.getAdapterType() == 4) {
                try {
                    MR_MFC_DEFAULTS mR_MFC_DEFAULTS = ((SASAdapter)m_adapterHelper.getDeviceObject()).getMFCDefaults();
                    if (mR_MFC_DEFAULTS.gettreatR1EAsR10() == 1 && c2 % 2 == 0) {
                        return string + "10";
                    }
                    return string + "1E";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return string + "1";
                }
            }
            return string + "1E";
        }
        if (c > '\u0001') {
            return string + by + "0";
        }
        if (m_sasAdapter.getAdapterType() == 2 && by == 1 && c2 > '\u0002') {
            return string + "1E";
        }
        return string + by;
    }

    public String toString() {
        if (this.value instanceof SASAdapter) {
            SASAdapter sASAdapter = (SASAdapter)this.value;
            if (sASAdapter.getInformation().getAdapterStatus_MR_CTRL_INFO().getHeadLessMode() == 1) {
                return Resource.zeroTrim(sASAdapter.getInformation().getproductName()) + Resource.getString("BUS", "(Bus ") + sASAdapter.getPciInformation().getbusNumber() + Resource.getString("DEV", ",Dev ") + sASAdapter.getPciInformation().getdeviceNumber() + ")" + Resource.getString("SAFE_MODE_TXT", "(Safe Mode)");
            }
            return Resource.zeroTrim(sASAdapter.getInformation().getproductName()) + Resource.getString("BUS", "(Bus ") + sASAdapter.getPciInformation().getbusNumber() + Resource.getString("DEV", ",Dev ") + sASAdapter.getPciInformation().getdeviceNumber();
        }
        if (this.value instanceof MR_DDF_HEADER_GUID) {
            byte[] byArray = ((MR_DDF_HEADER_GUID)this.value).getheaderGuid();
            if (m_sasAdapter != null && (m_sasAdapter.getAdapterType() == 2 || m_sasAdapter.getAdapterType() == 3 || m_sasAdapter.getAdapterType() == 4)) {
                return Resource.getString("TEXT_CONFIGURATION", "Configuration") + " " + this.flag;
            }
            return Resource.getString("TEXT_CONFIGURATION", "Configuration") + " " + this.flag + "(" + new String(byArray, 0, 8).trim() + ")";
        }
        if (this.value instanceof MR_LD_CONFIG) {
            MR_LD_CONFIG mR_LD_CONFIG = (MR_LD_CONFIG)this.value;
            String string = new String(mR_LD_CONFIG.getproperties().getname()).trim();
            if (string.length() > 0 && Resource.isLocaleSupportedForOEM()) {
                if (mR_LD_CONFIG.getparams().getisSSCD() != 0) {
                    if (m_adapterHelper.isCSA()) {
                        return Resource.getString("CSA_CACHECADE_VIRTUAL_DRIVE_TEXT", "Nytro\u2122 Cache Drive") + ": " + mR_LD_CONFIG.getproperties().getldRef().gettargetId() + ", " + string + ", " + KernelConstants.getConvertedSize(this.getLDsizeinBlocks(mR_LD_CONFIG)) + ", " + this.getState(mR_LD_CONFIG);
                    }
                    return Resource.getString("SSCD_TEXT", "CacheCade\u2122 Virtual Drive") + ": " + mR_LD_CONFIG.getproperties().getldRef().gettargetId() + ", " + string + ", " + KernelConstants.getConvertedSize(this.getLDsizeinBlocks(mR_LD_CONFIG)) + ", " + this.getState(mR_LD_CONFIG);
                }
                char c = mR_LD_CONFIG.getproperties().getldRef().gettargetId();
                this.getBlockSize(c);
                return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + mR_LD_CONFIG.getproperties().getldRef().gettargetId() + ", " + string + ", " + KernelConstants.getConvertedSize(this.getLDsizeinBlocks(mR_LD_CONFIG), this.getBlockSize(c)) + ", " + this.getState(mR_LD_CONFIG);
            }
            if (mR_LD_CONFIG.getparams().getisSSCD() != 0) {
                if (m_adapterHelper.isCSA()) {
                    return Resource.getString("CSA_CACHECADE_VIRTUAL_DRIVE_TEXT", "Nytro\u2122 Cache Drive") + ": " + mR_LD_CONFIG.getproperties().getldRef().gettargetId() + ", " + KernelConstants.getConvertedSize(this.getLDsizeinBlocks(mR_LD_CONFIG)) + ", " + this.getState(mR_LD_CONFIG);
                }
                return Resource.getString("SSCD_TEXT", "CacheCade\u2122 Virtual Drive") + ": " + mR_LD_CONFIG.getproperties().getldRef().gettargetId() + ", " + KernelConstants.getConvertedSize(this.getLDsizeinBlocks(mR_LD_CONFIG)) + ", " + this.getState(mR_LD_CONFIG);
            }
            return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + mR_LD_CONFIG.getproperties().getldRef().gettargetId() + ", " + KernelConstants.getConvertedSize(this.getLDsizeinBlocks(mR_LD_CONFIG)) + ", " + this.getState(mR_LD_CONFIG);
        }
        if (this.value instanceof MR_ARRAY) {
            MR_ARRAY mR_ARRAY = (MR_ARRAY)this.value;
            if (this.getSpanDepth(mR_ARRAY, m_CFGdata) > 1) {
                return Resource.getString("SPAN_TEXT", "Span") + ": " + mR_ARRAY.getarrayRef();
            }
            MR_LD_CONFIG[] mR_LD_CONFIGArray = this.getLDForThisArray(mR_ARRAY, m_CFGdata);
            if (mR_LD_CONFIGArray[0].getparams().getisSSCD() != 0) {
                if (m_adapterHelper.isCSA()) {
                    return Resource.getString("CSA_CACHECADE_DRIVE_GROUP_TEXT", "Nytro Drive Group") + ": " + mR_ARRAY.getarrayRef() + ", " + this.getRAIDLevelString(mR_LD_CONFIGArray[0]);
                }
                return Resource.getString("SSCD_DRIVE_GROUP_TEXT", "Super Sized Cache Drive Group") + ": " + mR_ARRAY.getarrayRef();
            }
            return Resource.getString("DRIVE_GROUP_TEXT", "Drive Group") + ": " + mR_ARRAY.getarrayRef() + ", " + this.getRAIDLevelString(mR_LD_CONFIGArray[0]);
        }
        if (this.value instanceof pd_MR_ARRAY) {
            return this.getText((pd_MR_ARRAY)this.value);
        }
        if (this.value instanceof MR_PD_REF) {
            MR_PD_REF mR_PD_REF = (MR_PD_REF)this.value;
            PhysicalDriveHelper physicalDriveHelper = this.getPhysicalDriveHelper(mR_PD_REF);
            if (physicalDriveHelper != null) {
                StringBuffer stringBuffer = new StringBuffer(physicalDriveHelper.getTextForeign());
                if (this.flag == 4) {
                    stringBuffer.append(Resource.getString("PD_STATE_HOTSPARE_DEDICATED", "Dedicated"));
                } else {
                    stringBuffer.append(Resource.getString("PD_STATE_HOTSPARE_GLOBAL", "Global"));
                }
                stringBuffer.append(" ");
                stringBuffer.append(Resource.getString("PD_STATE_HOTSPARE", "Hot Spare"));
                return stringBuffer.toString();
            }
            return "";
        }
        return this.value.toString();
    }

    public String getState(MR_LD_CONFIG mR_LD_CONFIG) {
        char c = mR_LD_CONFIG.getparams().getstate();
        if (c == '\u0002') {
            return Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
        }
        if (c == '\u0000') {
            return Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
        }
        if (c == '\u0001') {
            return Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
        }
        if (c == '\u0003') {
            return Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        return null;
    }

    public MR_LD_CONFIG[] getLDForThisArray(MR_ARRAY mR_ARRAY, MR_CONFIG_DATA mR_CONFIG_DATA) {
        ArrayList<MR_LD_CONFIG> arrayList = new ArrayList<MR_LD_CONFIG>();
        for (int i = 0; i < mR_CONFIG_DATA.getlogDrvCount(); ++i) {
            MR_LD_CONFIG mR_LD_CONFIG = mR_CONFIG_DATA.getld()[i];
            int n = mR_LD_CONFIG.getparams().getspanDepth();
            for (int j = 0; j < n; ++j) {
                short s = mR_LD_CONFIG.getspan()[j].getarrayRef();
                if (mR_ARRAY.getarrayRef() != s) continue;
                arrayList.add(mR_LD_CONFIG);
            }
        }
        MR_LD_CONFIG[] mR_LD_CONFIGArray = new MR_LD_CONFIG[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            mR_LD_CONFIGArray[i] = (MR_LD_CONFIG)arrayList.get(i);
        }
        return mR_LD_CONFIGArray;
    }

    public int getSpanDepth(MR_ARRAY mR_ARRAY, MR_CONFIG_DATA mR_CONFIG_DATA) {
        MR_LD_CONFIG[] mR_LD_CONFIGArray = this.getLDForThisArray(mR_ARRAY, mR_CONFIG_DATA);
        if (mR_LD_CONFIGArray != null && mR_LD_CONFIGArray.length > 0) {
            return mR_LD_CONFIGArray[0].getparams().getspanDepth();
        }
        return 0;
    }

    public static void setAdapterHelper(AdapterHelper adapterHelper) {
        m_adapterHelper = adapterHelper;
        m_sasAdapter = (SASAdapter)m_adapterHelper.getDeviceObject();
    }

    public static void setCFGdata(MR_CONFIG_DATA mR_CONFIG_DATA) {
        m_CFGdata = mR_CONFIG_DATA;
    }

    private PhysicalDriveHelper getPhysicalDriveHelper(pd_MR_ARRAY pd_MR_ARRAY2) {
        PhysicalDriveHelper[] physicalDriveHelperArray = m_adapterHelper.getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getDeviceId() != pd_MR_ARRAY2.getref().getdeviceId()) continue;
            return physicalDriveHelperArray[i];
        }
        return null;
    }

    private PhysicalDriveHelper getPhysicalDriveHelper(MR_PD_REF mR_PD_REF) {
        PhysicalDriveHelper[] physicalDriveHelperArray = m_adapterHelper.getPhysicalDrives();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
            if (((SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject()).getDeviceId() != mR_PD_REF.getdeviceId()) continue;
            return physicalDriveHelperArray[i];
        }
        return null;
    }

    public short getBlockSize(int n) {
        PhysicalDriveHelper[] physicalDriveHelperArray = m_adapterHelper.getPhysicalDrives();
        if (m_CFGdata != null) {
            MR_ARRAY[] mR_ARRAYArray = m_CFGdata.getarray();
            short s = 0;
            for (int i = 0; i < mR_ARRAYArray.length; ++i) {
                MR_LD_CONFIG[] mR_LD_CONFIGArray = this.getLDForThisArray(mR_ARRAYArray[i], m_CFGdata);
                pd_MR_ARRAY[] pd_MR_ARRAYArray = mR_ARRAYArray[i].getpd_MR_ARRAY1();
                for (int j = 0; j < physicalDriveHelperArray.length; ++j) {
                    if (physicalDriveHelperArray[j].getDeviceID() != pd_MR_ARRAYArray[0].getref().getdeviceId()) continue;
                    for (int k = 0; k < mR_LD_CONFIGArray.length; ++k) {
                        s = physicalDriveHelperArray[j].getUserDataBlockSize();
                        if (n != mR_LD_CONFIGArray[k].getproperties().getldRef().gettargetId()) continue;
                        return s;
                    }
                }
            }
        }
        return 512;
    }

    private long getLDsizeinBlocks(MR_LD_CONFIG mR_LD_CONFIG) {
        int n;
        long l = 0L;
        for (n = 0; n < mR_LD_CONFIG.getparams().getspanDepth(); ++n) {
            l += mR_LD_CONFIG.getspan()[n].getnumBlocks();
        }
        n = mR_LD_CONFIG.getparams().getPRL();
        char c = mR_LD_CONFIG.getparams().getnumDrives();
        if (n == 0) {
            l *= (long)c;
        } else if (n == 1) {
            l += 0L;
        } else if (n == 17) {
            l = l * (long)c / 2L;
        } else if (n == 5) {
            l *= (long)(c - '\u0001');
        } else if (n == 6) {
            l *= (long)(c - 2);
        }
        return l;
    }

    private String getText(pd_MR_ARRAY pd_MR_ARRAY2) {
        if (pd_MR_ARRAY2.getref().getdeviceId() == -1) {
            return Resource.getString("PHDRIVE_TEXT", "Physical Drive") + " " + "Missing";
        }
        PhysicalDriveHelper physicalDriveHelper = this.getPhysicalDriveHelper(pd_MR_ARRAY2);
        if (physicalDriveHelper != null) {
            StringBuffer stringBuffer = new StringBuffer(physicalDriveHelper.getTextForeign());
            if (pd_MR_ARRAY2.getfwState() == 20) {
                stringBuffer.append(Resource.getString("FOREIGN_MSG_REBUILD_PENDING", "Rebuild Pending"));
            } else if (pd_MR_ARRAY2.getfwState() == 16) {
                stringBuffer.append(Resource.getString("PD_STATE_OFFLINE", "Offline"));
            } else if (pd_MR_ARRAY2.getfwState() == 24) {
                stringBuffer.append(Resource.getString("PD_STATE_ONLINE", "Online"));
            }
            return stringBuffer.toString();
        }
        return "";
    }
}

