/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_CONFIG_DATA;
import SASKernel.LibraryAPI.StoreLib.MR_FOREIGN_CFG_GUIDS;
import SASKernel.LibraryAPI.StoreLib.MR_LD_CONFIG;
import SASKernel.Operations.OperationDetails;
import Utils.CustomMsgBox;
import Utils.HelpContextResourse;
import Utils.Resource;
import Wizard.BaseWizardDialog;
import Wizard.ForeignConfigWizard.BaseForeignConfigDialog;
import Wizard.ForeignConfigWizard.ForeignConfigDetectedDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ImportForeignConfigDialog
extends BaseForeignConfigDialog {
    private String[] mnemonics;
    private JTree tree = new JTree();
    private DefaultTreeModel treeModel;
    private JButton acceptButton;
    private JButton cancelButton;
    JPanel PImsgPanel = new JPanel();
    private int guidIndex;
    private MR_CONFIG_DATA cfgData;
    private AdapterHelper adapterhelp;

    public ImportForeignConfigDialog(AdapterHelper adapterHelper, int n) {
        super(adapterHelper);
        Serializable serializable;
        this.adapterhelp = adapterHelper;
        this.guidIndex = n;
        if (!this.refreshTree()) {
            return;
        }
        ArrayList<MR_LD_CONFIG> arrayList = this.getPIEnabledForeignVds();
        if (!(this.adapterhelp.isPISupported() && adapterHelper.isPIEnabledOnController() || arrayList.size() <= 0)) {
            serializable = new StringBuffer();
            for (int n2 = 0; n2 < arrayList.size(); n2 = (int)((short)(n2 + 1))) {
                ((StringBuffer)serializable).append((int)arrayList.get(n2).getproperties().getldRef().gettargetId());
                ((StringBuffer)serializable).append(",");
            }
            ((StringBuffer)serializable).deleteCharAt(((StringBuffer)serializable).length() - 1);
            this.PImsgPanel.setBackground(new Color(255, 255, 160));
            JLabel jLabel = new JLabel();
            String string = Resource.getString("DATA_PROTECTION_ENABLE_DESC", "<html>This configuration contains virtual drive(s) that are data protection enabled. If you import data protection enabled virtual drives <br> on this controller, you will lose the data protection information because the controller is not capable of data protection.<br></html>");
            jLabel.setText(string);
            jLabel.setHorizontalAlignment(0);
            this.PImsgPanel.add(jLabel);
            this.PImsgPanel.setVisible(true);
            this.contentPane.add((Component)this.PImsgPanel, "North");
        }
        this.tree.setCellRenderer(this.renderer);
        this.contentPane.add((Component)new JScrollPane(this.tree), "Center");
        serializable = new JPanel(new FlowLayout(2));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_ACCEPT_TEXT", "Accept"));
        this.acceptButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.acceptButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.acceptButton.setToolTipText(Resource.getString("BUTTON_ACCEPT_DSC", "Accept"));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        this.cancelButton = new JButton(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            this.cancelButton.setMnemonic(this.mnemonics[1].charAt(0));
        }
        this.cancelButton.setToolTipText(Resource.getString("BUTTON_CANCEL_DSC", "Cancel"));
        ((Container)serializable).add(this.acceptButton);
        ((Container)serializable).add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImportForeignConfigDialog.this.dispose();
            }
        });
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_IMPORT_FOREIGN_CONFIG", "<html>This operation cannot be reversed after it is started.<br>Are you sure you want to import the configuration?</html>"), Resource.getString("FOREIGN_CONFIG_IMPORT_TITLE", "Foreign Config - Import"), 0, 3) != 0) {
                    return;
                }
                ImportForeignConfigDialog.this.acceptImportedConfiguration();
                ImportForeignConfigDialog.this.dispose();
            }
        });
        this.contentPane.add((Component)serializable, "South");
        this.show();
    }

    private boolean refreshTree() {
        try {
            this.cfgData = this.readConfigAfterImport(this.guidIndex);
            if (!this.validMergedData(this.cfgData)) {
                return false;
            }
            if (this.cfgData == null) {
                return false;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.createTreeStructure(this.cfgData);
            this.treeModel = new DefaultTreeModel(defaultMutableTreeNode);
            this.tree.setModel(this.treeModel);
            BaseWizardDialog.expandTree(this.tree);
            this.tree.repaint();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            CustomMsgBox.errorMsg(vKOperationFailedException);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new CustomMsgBox(this, Resource.getString("MSG_FAILED_FOREIGNCFG", "Can not read Foreign Config !"));
            return false;
        }
        return true;
    }

    ArrayList<MR_LD_CONFIG> getPIEnabledForeignVds() {
        ArrayList<MR_LD_CONFIG> arrayList = new ArrayList<MR_LD_CONFIG>();
        MR_LD_CONFIG[] mR_LD_CONFIGArray = this.cfgData.getld();
        for (int n = 0; n < mR_LD_CONFIGArray.length; n = (int)((short)(n + 1))) {
            if (mR_LD_CONFIGArray[n].getparams().getPIEnabled() != 1) continue;
            arrayList.add(mR_LD_CONFIGArray[n]);
        }
        return arrayList;
    }

    private void acceptImportedConfiguration() {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.cfgData);
        arrayList.add(new Short((short)this.guidIndex));
        OperationDetails operationDetails = new OperationDetails(6, arrayList);
        OperationDetails operationDetails2 = new OperationDetails(3, null);
        try {
            this.adapter.fireConfigOperation(operationDetails2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        MR_FOREIGN_CFG_GUIDS mR_FOREIGN_CFG_GUIDS = (MR_FOREIGN_CFG_GUIDS)operationDetails2.getParam();
        int n2 = mR_FOREIGN_CFG_GUIDS.getcount();
        int n3 = this.adapter.readLDCount();
        short s = this.cfgData.getlogDrvCount();
        if (this.guidIndex == 255) {
            n3 = 0;
        }
        if ((n = n3 + s) > 64) {
            new CustomMsgBox(this, Resource.getString("MSG_IMPORT_FOREIGNCFG_FAILED_MAXVD", "Cannot import the remaining foreign configuration. \n Because, the number of Logical Drives supported by \nController has been exceeded!"));
            return;
        }
        try {
            this.adapter.fireConfigOperation(operationDetails);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new CustomMsgBox(this, Resource.getString("MSG_IMPORT_FOREIGNCFG_FAILED", "Import foreign configuration failed !"));
            return;
        }
        try {
            this.dispose();
            operationDetails2 = new OperationDetails(3, null);
            this.adapter.fireConfigOperation(operationDetails2);
            mR_FOREIGN_CFG_GUIDS = (MR_FOREIGN_CFG_GUIDS)operationDetails2.getParam();
            if (mR_FOREIGN_CFG_GUIDS != null && mR_FOREIGN_CFG_GUIDS.getcount() > 0) {
                n2 += mR_FOREIGN_CFG_GUIDS.getcount();
                if (this.guidIndex == 255) {
                    int n4 = mR_FOREIGN_CFG_GUIDS.getcount();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(n4);
                    stringBuffer.append(Resource.getString("OUT_OF", " out of "));
                    stringBuffer.append(n2);
                    stringBuffer.append(Resource.getString("FAILED_TO_IMPORT", " configurations failed to import."));
                    new CustomMsgBox((Component)this, (Object)stringBuffer, 0);
                } else if (CustomMsgBox.confirm(Resource.getString("MSG_IMPORT_FOREIGNCFG_SUCCESS_RESCAN", "<html>Foreign Configuration was imported successfully. <br>More foreign configurations were detected.<br>Would you like to re-scan for foreign configurations?<br><br></html>"), 1)) {
                    new ForeignConfigDetectedDialog(this.adapterhelp, mR_FOREIGN_CFG_GUIDS);
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        new CustomMsgBox((Component)this, (Object)Resource.getString("MSG_IMPORT_FOREIGNCFG_SUCCESS", "Foreign Configuration was imported successfully."), 1);
    }

    @Override
    public String getHelpPage() {
        return HelpContextResourse.getHelpPageName("HELP_PAGE_IMPORT_FOREIGN_CONFIG_DIALOG");
    }
}

