/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUI.DeviceTreeRenderer;
import GUI.MainFrame;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKOperationFailedException;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import Wizard.ConfigWizard.GUIData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class RemoveFDEFromUnconfiguredDrives
extends VivaldiBaseOptionDialog {
    AdapterHelper adapter;
    DeviceTreeRenderer deviceRenderer;
    JCheckBox confirmCheckBox;
    JButton btnYes;
    private DefaultTreeModel pdTreeModel;
    private static final int ENCLOSURE_NODE = 7;
    private static final int ADAPTER_NODE = 5;
    private JTree pdTree = new JTree();

    public RemoveFDEFromUnconfiguredDrives(AdapterHelper adapterHelper) {
        super((Window)null);
        this.adapter = adapterHelper;
        this.createTree();
        this.buildUI();
    }

    @Override
    public void buildUI() {
        String[] stringArray = null;
        JPanel jPanel = new JPanel(new BorderLayout());
        Image image = Toolkit.getDefaultToolkit().getImage(Resource.getString("LSI_PROGRAM_ICON_16", "16_prg_icon.png"));
        this.setIconImage(image);
        this.setModal(false);
        this.setResizable(false);
        this.setSize(MainFrame.SCREEN_SIZE.width * 640 / 1250, MainFrame.SCREEN_SIZE.height * 480 / 600);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getPhysicalDrives();
        this.m_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String string = Resource.getString("REMOVE_FDE_FROM_UNCONFIGURED_DRIVES_DESC1", "<html>One or more of the drives that you unlocked does not have <br> any detectable configuration to import. In order to use these <br> drives in a new configuration, their existing full disk encryption <br> must be removed.</html>");
        System.out.println("strPassPhraseDesc  :" + string);
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        jLabel.setOpaque(false);
        String string2 = Resource.getString("REMOVE_FDE_FROM_UNCONFIGURED_DRIVES_DESC2", "<html>If there is any undetected data on the drives below, removing <br> full disk encryption will permanently delete that data. If you do <br> not want to clear the data on these drives, click No to leave <br> them encrypted and import only drives that have <br> configurations.</html>");
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(string2);
        stringArray = Resource.getResourceMnemonic(Resource.getString("DRIVES_TO_CLEAR_LABEL", "(D)rives to clear:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel3.setLabelFor(this.pdTree);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 0);
        this.m_panel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 15, 5, 0);
        this.m_panel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.m_panel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.pdTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
                if (object2 == null) {
                    return this;
                }
                if (!(object2 instanceof GUIData)) {
                    return this;
                }
                System.out.println("((GUIData) val).flag  :" + ((GUIData)object2).flag);
                switch (((GUIData)object2).flag) {
                    case 17: {
                        this.setIcon(Resource.getImage("FAILED_IMAGE", "failed.png"));
                        break;
                    }
                    case 1: {
                        this.setIcon(Resource.getImage("PHDRIVE_IMAGE", "phdrive.jpg"));
                        break;
                    }
                    case 0: {
                        this.setIcon(Resource.getImage("PHDRIVE_IMAGE", "phdrive.jpg"));
                        break;
                    }
                    case 24: {
                        this.setIcon(Resource.getImage("PHDRIVE_IMAGE", "phdrive.jpg"));
                        break;
                    }
                    case 7: {
                        this.setIcon(Resource.getImage("ENCLOSURE_IMAGE", "enclosure.png"));
                        break;
                    }
                    case 5: {
                        this.setIcon(RemoveFDEFromUnconfiguredDrives.this.adapter.getIcon());
                        break;
                    }
                }
                return this;
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.pdTree, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        this.m_panel.add((Component)new JScrollPane(jScrollPane), gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 15, 5, 0);
        String string3 = Resource.getString("REMOVE_FDE_FROM_UNCONFIGURED_DRIVES_DESC3", "<html>There is no way to undo this destructive operation. Are you <br> sure you want to clear these drives?</html>");
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(string3);
        this.m_panel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        stringArray = Resource.getResourceMnemonic(Resource.getString("CONFIRM_TEXT", "(C)onfirm"));
        this.confirmCheckBox = new JCheckBox(stringArray[0]);
        this.confirmCheckBox.setOpaque(false);
        if (stringArray.length == 2) {
            this.confirmCheckBox.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_panel.add((Component)this.confirmCheckBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.initUI(Resource.getString("REMOVE_FDE_FROM_UNCONFIGURED_DRIVES_TITLE", "Remove FDE from Unconfigured Drives"), 0, 1);
        this.add((Component)this.m_panel, "Center");
        super.buildUI();
        this.setYesEnabled(false);
        System.out.println("the location is :" + this.getLocation());
        this.confirmCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RemoveFDEFromUnconfiguredDrives.this.confirmCheckBox.isSelected()) {
                    RemoveFDEFromUnconfiguredDrives.this.setYesEnabled(true);
                } else {
                    RemoveFDEFromUnconfiguredDrives.this.setYesEnabled(false);
                }
            }
        });
    }

    @Override
    public void onYesOption() {
        super.onYesOption();
        TreeModel treeModel = this.pdTree.getModel();
        Object object = treeModel.getRoot();
        int n = -1000;
        System.out.println("rootTree child count :" + treeModel.getChildCount(object));
        System.out.println("pdTree.getRowCount()  :" + this.pdTree.getRowCount());
        int n2 = treeModel.getChildCount(object);
        for (int i = 0; i < n2; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeModel.getChild(object, i);
            if (defaultMutableTreeNode == null) continue;
            GUIData gUIData = (GUIData)defaultMutableTreeNode.getUserObject();
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)gUIData.value;
            System.out.println("the selected item DeviceId is  :" + sASPhysicalDrive.getDeviceId());
            System.out.println("the selected item SeqNum is  :" + sASPhysicalDrive.getSeqNum());
            OperationDetails operationDetails = new OperationDetails(0x20D0000, null);
            try {
                n = sASPhysicalDrive.fireOperation(operationDetails);
                continue;
            }
            catch (VKOperationFailedException vKOperationFailedException) {
                vKOperationFailedException.printStackTrace();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void createTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new GUIData(this.adapter, 5));
        System.out.println("((AdapterHelper)adapter).getEnclosures().length :" + this.adapter.getEnclosures().length);
        PhysicalDriveHelper[] physicalDriveHelperArray = this.adapter.getLockedPhysicalDrives();
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode();
        for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
            PhysicalDriveHelper physicalDriveHelper = physicalDriveHelperArray[i];
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)physicalDriveHelper.getDeviceObject();
            short s = sASPhysicalDrive.getState();
            if (s == 0) {
                System.out.println("in createTree  PD_STATE_UNCONFIGURED_GOOD  :");
                defaultMutableTreeNode4 = new DefaultMutableTreeNode(new GUIData(sASPhysicalDrive, 0));
            }
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        this.pdTreeModel = new DefaultTreeModel(defaultMutableTreeNode3);
        this.pdTree.setModel(this.pdTreeModel);
    }
}

