/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ForeignConfigWizard;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import KernelExceptions.VKInvalidOperationException;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.LibraryAPI.StoreLib.MR_FOREIGN_CFG_GUIDS;
import SASKernel.Operations.OperationDetails;
import SASKernel.SASAdapter.SASAdapter;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Utils.CustomMsgBox;
import Utils.GUIUtils;
import Utils.Resource;
import Wizard.ForeignConfigWizard.ForeignConfigDetectedDialog;
import Wizard.ForeignConfigWizard.GUIData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class UnlockForeignDrives
extends VivaldiBaseDialog {
    private AdapterHelper m_adapter = null;
    private JPasswordField m_tfSecurityKey;
    private JTable m_pdTable = null;
    private PDTableModel m_tableModel = null;
    private MR_FOREIGN_CFG_GUIDS m_guidList = null;
    private PhysicalDriveHelper[] m_lockedPdHelpers = null;

    public UnlockForeignDrives(AdapterHelper adapterHelper, PhysicalDriveHelper[] physicalDriveHelperArray) {
        super(VivaldiStartupDialog.mainScreen);
        this.m_adapter = adapterHelper;
        this.m_lockedPdHelpers = physicalDriveHelperArray;
        this.updateTableModel();
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(Resource.getString("UNLOCK_FOREIGN_DRIVES_TITLE", "Unlock Foreign Drives"));
        this.setModal(true);
        this.setResizable(false);
        this.m_pdTable = new JTable(this.m_tableModel);
        this.m_pdTable.getColumnModel().getColumn(0).setCellRenderer(new PDTableCellRenderer());
        this.m_pdTable.setShowGrid(false);
        this.m_pdTable.setCellSelectionEnabled(false);
        this.m_pdTable.setRowSelectionAllowed(false);
        this.m_pdTable.setAutoResizeMode(4);
        this.m_pdTable.setAutoscrolls(true);
        this.m_pdTable.setColumnSelectionAllowed(false);
        this.m_pdTable.getTableHeader().setReorderingAllowed(false);
        String[] stringArray = null;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(Resource.getString("UNLOCK_FOREIGN_DRIVES_DESC", "<html>One or more foreign drives are locked.<br><br>In order to import these drives, you will need to provide the security key used to secure them. If you<br>want want to import only unlocked drives, leave the security key field blank and select Continue.<br><br>If the locked drives use different security keys, enter one security key and repeat the import<br>process for the remaining locked drives.<br><br></html>"));
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_LOCKED_DRIVES", "(L)ocked Drives:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel2.setLabelFor(this.m_pdTable);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        JScrollPane jScrollPane = new JScrollPane(this.m_pdTable, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(500, 100));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        stringArray = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapter.isOnlyFDESupported() ? Resource.getResourceMnemonic(Resource.getString("LABEL_PASS_PHRASE", "(P)ass phrase:")) : Resource.getResourceMnemonic(Resource.getString("UNLOCK_FOREIGN_DRIVES_SECURITY_KEY_LABEL", "(S)ecurity Key:"));
        JLabel jLabel3 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel3.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.m_tfSecurityKey = new JPasswordField(32);
        jLabel3.setLabelFor(this.m_tfSecurityKey);
        jPanel.add((Component)this.m_tfSecurityKey, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CONTINUE_TEXT", "(C)ontinue"));
        JButton jButton = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            jButton.setMnemonic(stringArray[1].charAt(0));
        }
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = new String(UnlockForeignDrives.this.m_tfSecurityKey.getPassword());
                if (string.length() > 0) {
                    int n = 0;
                    try {
                        OperationDetails operationDetails = new OperationDetails(18155520, string);
                        ((SASAdapter)UnlockForeignDrives.this.m_adapter.getDeviceObject()).fireOperation(operationDetails);
                        for (int i = 0; i < UnlockForeignDrives.this.m_lockedPdHelpers.length; ++i) {
                            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)UnlockForeignDrives.this.m_lockedPdHelpers[i].getDeviceObject();
                            sASPhysicalDrive.refresh();
                        }
                    }
                    catch (VKOperationFailedException vKOperationFailedException) {
                        vKOperationFailedException.printStackTrace();
                        n = vKOperationFailedException.GetErrorCode();
                    }
                    catch (VKInvalidOperationException vKInvalidOperationException) {
                        n = vKInvalidOperationException.GetErrorCode();
                    }
                    catch (VKNotRespondingException vKNotRespondingException) {
                        n = vKNotRespondingException.GetErrorCode();
                    }
                    if (n == 73 || n == 72) {
                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getMfiStatString("MFI_STAT_LOCK_KEY_ESCROW_INVALID", "Incorrect security key."), Resource.getMfiStatString("MFI_STAT_LOCK_KEY_ESCROW_INVALID", "The backup security key from escrow cannot be used."), 1);
                        return;
                    }
                    UnlockForeignDrives.this.dispose();
                    UnlockForeignDrives.this.scanForForeignConfig();
                    if (UnlockForeignDrives.this.m_guidList == null || UnlockForeignDrives.this.m_guidList.getcount() <= 0) {
                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_NO_FOREIGN_CONFIG", "NO Foreign Configuration is found!"), Resource.getString("MSG_FOREIGN_CONFIG_TITLE"), 1);
                        return;
                    }
                    if (UnlockForeignDrives.this.m_guidList.getcount() > 8) {
                        new CustomMsgBox(Resource.getString("FOREIGN_CONFIG_MAX_LIMIT_EXIT_MSG", "<html>The number of foreign configurations detected exceeds the number that can be displayed.<br> Import or clear the configurations that are displayed <br>and then scan for foreign configurations again.</html>"));
                        return;
                    }
                    GUIData.setAdapterHelper(UnlockForeignDrives.this.m_adapter);
                    new ForeignConfigDetectedDialog(UnlockForeignDrives.this.m_adapter, UnlockForeignDrives.this.m_guidList);
                } else {
                    UnlockForeignDrives.this.dispose();
                    UnlockForeignDrives.this.scanForForeignConfig();
                    if (UnlockForeignDrives.this.m_guidList == null || UnlockForeignDrives.this.m_guidList.getcount() <= 0) {
                        new CustomMsgBox(VivaldiStartupDialog.mainScreen, Resource.getString("MSG_NO_FOREIGN_CONFIG", "NO Foreign Configuration is found!"), Resource.getString("MSG_FOREIGN_CONFIG_TITLE"), 1);
                        return;
                    }
                    if (UnlockForeignDrives.this.m_guidList.getcount() > 8) {
                        new CustomMsgBox(Resource.getString("FOREIGN_CONFIG_MAX_LIMIT_EXIT_MSG", "<html>The number of foreign configurations detected exceeds the number that can be displayed.<br> Import or clear the configurations that are displayed <br>and then scan for foreign configurations again.</html>"));
                    }
                    GUIData.setAdapterHelper(UnlockForeignDrives.this.m_adapter);
                    new ForeignConfigDetectedDialog(UnlockForeignDrives.this.m_adapter, UnlockForeignDrives.this.m_guidList);
                }
            }
        });
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CANCEL_TEXT", "Cancel"));
        JButton jButton2 = new JButton(stringArray[0]);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnlockForeignDrives.this.setVisible(false);
                UnlockForeignDrives.this.dispose();
            }
        });
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        this.contentPane.add((Component)jPanel, "Center");
        this.contentPane.add((Component)jPanel2, "South");
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private void scanForForeignConfig() {
        try {
            OperationDetails operationDetails = new OperationDetails(3, null);
            ((SASAdapter)this.m_adapter.getDeviceObject()).fireConfigOperation(operationDetails);
            this.m_guidList = (MR_FOREIGN_CFG_GUIDS)operationDetails.getParam();
        }
        catch (VKOperationFailedException vKOperationFailedException) {
            vKOperationFailedException.printStackTrace();
            CustomMsgBox.errorMsg(vKOperationFailedException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateTableModel() {
        if (this.m_tableModel == null) {
            String[] stringArray = new String[this.m_lockedPdHelpers.length];
            for (int i = 0; i < this.m_lockedPdHelpers.length; ++i) {
                short s = ((SASPhysicalDrive)this.m_lockedPdHelpers[i].getDeviceObject()).getDeviceId();
                System.out.println("deviceId for i: " + i + " is " + s);
                stringArray[i] = ((SASAdapter)this.m_adapter.getDeviceObject()).getKeyIDForDevice(false, s);
            }
            this.m_tableModel = new PDTableModel(this.m_lockedPdHelpers, stringArray);
        } else {
            try {
                for (int i = 0; i < this.m_lockedPdHelpers.length; ++i) {
                    this.m_lockedPdHelpers[i].getDeviceObject().refresh();
                }
                this.m_lockedPdHelpers = this.m_adapter.getLockedPhysicalDrives();
                if (this.m_lockedPdHelpers != null && this.m_lockedPdHelpers.length > 0) {
                    String[] stringArray = new String[this.m_lockedPdHelpers.length];
                    for (int i = 0; i < this.m_lockedPdHelpers.length; ++i) {
                        short s = ((SASPhysicalDrive)this.m_lockedPdHelpers[i].getDeviceObject()).getDeviceId();
                        stringArray[i] = ((SASAdapter)this.m_adapter.getDeviceObject()).getKeyIDForDevice(false, s);
                    }
                    this.m_tableModel.initModel(this.m_lockedPdHelpers, stringArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PDTableModel
    extends AbstractTableModel {
        private PhysicalDriveHelper[] lockedpdHelpers = null;
        private String[] lockedPdKeyIDs = null;

        public PDTableModel(PhysicalDriveHelper[] physicalDriveHelperArray, String[] stringArray) {
            this.lockedpdHelpers = physicalDriveHelperArray;
            this.lockedPdKeyIDs = stringArray;
        }

        public void initModel(PhysicalDriveHelper[] physicalDriveHelperArray, String[] stringArray) {
            this.lockedpdHelpers = physicalDriveHelperArray;
            this.lockedPdKeyIDs = stringArray;
            this.fireTableDataChanged();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.lockedpdHelpers[n];
            }
            if (n2 == 1) {
                return this.lockedPdKeyIDs[n];
            }
            return null;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return Resource.getString("LABEL_TABLE_COLUMN_DRIVE", "Drive");
            }
            return Resource.getString("LABEL_TABLE_COLUMN_KEYID", "Security Key Identifier");
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return PhysicalDriveHelper.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.lockedpdHelpers.length;
        }
    }

    class PDTableCellRenderer
    extends DefaultTableCellRenderer {
        PDTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            PhysicalDriveHelper physicalDriveHelper = (PhysicalDriveHelper)object;
            jLabel.setIcon(physicalDriveHelper.getIcon());
            return jLabel;
        }
    }
}

