/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ReconWizard;

import GUIHelper.AdapterHelper;
import GUIHelper.PhysicalDriveHelper;
import SASKernel.SASLogical.SASLogicalDrive;
import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.Resource;

public class GUIData {
    private static AdapterHelper m_adapterHelper = null;
    public Object value;
    public int flag;
    public boolean isNew;

    public GUIData(Object object, int n, boolean bl) {
        this.value = object;
        this.flag = n;
        this.isNew = bl;
    }

    public String toString() {
        if (this.value instanceof SASPhysicalDrive) {
            SASPhysicalDrive sASPhysicalDrive = (SASPhysicalDrive)this.value;
            char c = sASPhysicalDrive.getInformation().getslotNumber();
            PhysicalDriveHelper physicalDriveHelper = null;
            PhysicalDriveHelper[] physicalDriveHelperArray = m_adapterHelper.getPhysicalDrives();
            for (int i = 0; i < physicalDriveHelperArray.length; ++i) {
                SASPhysicalDrive sASPhysicalDrive2 = (SASPhysicalDrive)physicalDriveHelperArray[i].getDeviceObject();
                if (sASPhysicalDrive2.getDeviceId() != sASPhysicalDrive.getDeviceId()) continue;
                physicalDriveHelper = physicalDriveHelperArray[i];
                break;
            }
            return physicalDriveHelper.getText(true);
        }
        if (this.value instanceof SASLogicalDrive) {
            SASLogicalDrive sASLogicalDrive = (SASLogicalDrive)this.value;
            String string = sASLogicalDrive.getName();
            if (string.length() > 0 && Resource.isLocaleSupportedForOEM()) {
                return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive.getID() + ", " + string + ", " + KernelConstants.getConvertedSize(sASLogicalDrive.getSize()) + ", " + this.getState(sASLogicalDrive);
            }
            return Resource.getString("VIRTUAL_DRIVE_TEXT", "Virtual Drive") + ": " + sASLogicalDrive.getID() + ", " + KernelConstants.getConvertedSize(sASLogicalDrive.getSize()) + ", " + this.getState(sASLogicalDrive);
        }
        return this.value.toString();
    }

    public String getState(SASLogicalDrive sASLogicalDrive) {
        char c = sASLogicalDrive.getInformation().getldConfig().getparams().getstate();
        if (c == '\u0002') {
            return Resource.getString("LDRIVE_STATE_DEGRADED", "Degraded");
        }
        if (c == '\u0000') {
            return Resource.getString("LDRIVE_STATE_OFFLINE", "Offline");
        }
        if (c == '\u0001') {
            return Resource.getString("LDRIVE_STATE_PARTDERGRADED", "Partially Degraded");
        }
        if (c == '\u0003') {
            return Resource.getString("LDRIVE_STATE_OPTIMAL", "Optimal");
        }
        return null;
    }

    public static void setAdapterHelper(AdapterHelper adapterHelper) {
        m_adapterHelper = adapterHelper;
    }

    public static AdapterHelper getAdapterHelper() {
        return m_adapterHelper;
    }
}

