/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ReconWizard;

import SASKernel.SASPhysical.SASPhysicalDrive;
import Services.KernelConstants;
import Utils.Resource;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PhysicalDrivesJTable
extends JTable {
    public static final byte PHYSICAL_DRIVE_TABLE = 0;
    public static final byte VOLUME_GROUP_TABLE = 1;
    private PhysicalDrivesTableModel physicalDrivesModel = new PhysicalDrivesTableModel();
    private Object parent = null;
    private byte origin = 0;

    public PhysicalDrivesJTable(Object object, byte by) {
        super.setModel(this.physicalDrivesModel);
        this.setBounds(10, 0, 510, 185);
        this.setAutoResizeMode(4);
        this.setAutoCreateColumnsFromModel(true);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(2);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setEnabled(true);
        this.getColumnModel().getColumn(2).setCellRenderer(new PhysicalDriveTableRenderer());
    }

    @Override
    public void setSelectionMode(int n) {
        super.setSelectionMode(n);
    }

    public void setDataList(ArrayList arrayList) {
        this.physicalDrivesModel.setDataList(arrayList);
    }

    public ArrayList addDataList(ArrayList arrayList) {
        return this.physicalDrivesModel.addDataList(arrayList);
    }

    public ArrayList getPhysicalDriveListFromIndex(int[] nArray) {
        return this.physicalDrivesModel.getPhysicalDriveListFromIndex(nArray);
    }

    public ArrayList removePhysicalDrives(int[] nArray) {
        return this.physicalDrivesModel.removePhysicalDrives(nArray);
    }

    public void fireTableDataChanged() {
        this.physicalDrivesModel.fireTableDataChanged();
    }

    class PhysicalDriveTableRenderer
    extends DefaultTableCellRenderer {
        PhysicalDriveTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 2) {
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                Long l = (Long)object;
                String string = KernelConstants.getConvertedSize(KernelConstants.getSizeInBlocks(l.doubleValue(), 2));
                jLabel.setText(string);
                jLabel.setHorizontalAlignment(4);
                return jLabel;
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    public class PhysicalDrivesTableModel
    extends AbstractTableModel {
        private final int FIRST_COL = 0;
        private final int SECOND_COL = 1;
        private final int THIRD_COL = 2;
        private final int NUM_COLS = 3;
        private int numberColumns = 3;
        private ArrayList dataList = null;
        private SASPhysicalDrive[] driveList = null;
        private String[] columnNames = new String[]{Resource.getString("PROPERTY_VENDORINFO_TEXT", "Vendor ID"), Resource.getString("MANUAL_DRIVE_SELECTION_JTABLE__DEVID_COLUMN", "Device ID"), Resource.getString("MANUAL_DRIVE_SELECTION_JTABLE_CAPACITY_COLUMN", "Drive Capacity")};

        public void setDataList(ArrayList arrayList) {
            this.dataList = arrayList;
            this.populateList();
        }

        public void populateList() {
            this.driveList = null;
            this.driveList = new SASPhysicalDrive[this.dataList.size()];
            for (int i = 0; i < this.dataList.size(); ++i) {
                SASPhysicalDrive sASPhysicalDrive;
                this.driveList[i] = sASPhysicalDrive = (SASPhysicalDrive)this.dataList.get(i);
            }
        }

        public ArrayList addDataList(ArrayList arrayList) {
            int n;
            if (this.driveList == null) {
                this.setDataList(arrayList);
                return arrayList;
            }
            SASPhysicalDrive[] sASPhysicalDriveArray = new SASPhysicalDrive[this.driveList.length + arrayList.size()];
            for (n = 0; n < this.driveList.length; ++n) {
                sASPhysicalDriveArray[n] = this.driveList[n];
            }
            for (n = 0; n < arrayList.size(); ++n) {
                this.dataList.add(arrayList.get(n));
                sASPhysicalDriveArray[this.driveList.length + n] = (SASPhysicalDrive)arrayList.get(n);
            }
            this.driveList = new SASPhysicalDrive[sASPhysicalDriveArray.length];
            for (n = 0; n < sASPhysicalDriveArray.length; ++n) {
                this.driveList[n] = sASPhysicalDriveArray[n];
            }
            return this.dataList;
        }

        public ArrayList getPhysicalDriveListFromIndex(int[] nArray) {
            int n = nArray.length;
            if (n <= 0) {
                return null;
            }
            ArrayList<SASPhysicalDrive> arrayList = new ArrayList<SASPhysicalDrive>(n);
            for (int i = 0; i < n; ++i) {
                SASPhysicalDrive sASPhysicalDrive = this.driveList[nArray[i]];
                arrayList.add(sASPhysicalDrive);
            }
            return arrayList;
        }

        public ArrayList removePhysicalDrives(int[] nArray) {
            int n;
            int n2 = this.driveList.length;
            int n3 = nArray.length;
            ArrayList<SASPhysicalDrive> arrayList = null;
            if (n2 <= n3) {
                this.dataList = null;
                this.driveList = null;
                return null;
            }
            SASPhysicalDrive[] sASPhysicalDriveArray = new SASPhysicalDrive[n2 - n3];
            int n4 = 0;
            for (n = 0; n < n2; ++n) {
                boolean bl = false;
                for (int i = 0; i < n3; ++i) {
                    if (n != nArray[i]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                SASPhysicalDrive sASPhysicalDrive = this.driveList[n];
                sASPhysicalDriveArray[n4++] = sASPhysicalDrive;
            }
            if (n4 > 0) {
                this.driveList = sASPhysicalDriveArray;
                arrayList = new ArrayList<SASPhysicalDrive>(this.driveList.length);
                for (n = 0; n < this.driveList.length; ++n) {
                    SASPhysicalDrive sASPhysicalDrive = this.driveList[n];
                    arrayList.add(sASPhysicalDrive);
                }
            } else {
                this.driveList = null;
            }
            this.dataList = arrayList;
            return this.dataList;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.driveList != null) {
                return this.driveList.length;
            }
            return 0;
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.driveList == null) {
                return null;
            }
            SASPhysicalDrive sASPhysicalDrive = this.driveList[n];
            if (n2 == 0) {
                return sASPhysicalDrive.getVendorInfo();
            }
            if (n2 == 1) {
                return new Short(sASPhysicalDrive.getDeviceId());
            }
            if (n2 == 2) {
                System.out.println("PhysicalDrivesTableModel.getValueAt()");
                System.out.println("implemented as part of CR LSID100071008");
            }
            return null;
        }

        public Class getColumnClass(int n) {
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

