/*
 * Decompiled with CFR 0.152.
 */
package Wizard.ReconWizard;

import SASKernel.ConfigurationHelpers.ReconstructionEngine;
import Utils.CustomComboBox;
import Utils.Resource;
import Wizard.ReconWizard.BaseReconWizardDialog;
import Wizard.ReconWizard.ReconFinishWizardDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectReconstParametersPanel
extends JPanel
implements ItemListener {
    private String[] mnemonics;
    private ReconFinishWizardDialog parent;
    private JComboBox raidLevelComboBox = null;
    private byte[] supportedRAIDLevelValues;
    private String[] supportedRAIDLevels;
    private short selRaidLevel;
    private short[] raidLevelList = null;
    private boolean modifyingModel = false;
    private Vector selectionListeners = new Vector(1);
    private short volumeRAIDLevel;
    private boolean reconstParametersChanged = false;

    public SelectReconstParametersPanel(ReconFinishWizardDialog reconFinishWizardDialog, byte by, boolean bl, short s) {
        this.parent = reconFinishWizardDialog;
        this.volumeRAIDLevel = by;
        this.CreateGUI(reconFinishWizardDialog, by, bl, s);
        this.raidLevelComboBox.setToolTipText(Resource.getString("RAID_LEVEL_DSC", "RAID Level"));
        this.raidLevelComboBox.setEditable(false);
        this.raidLevelComboBox.setEnabled(bl);
    }

    private void CreateGUI(ReconFinishWizardDialog reconFinishWizardDialog, short s, boolean bl, short s2) {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new BoxLayout(this, 1));
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 15, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.setBorder(BorderFactory.createEmptyBorder(10, 15, 15, 15));
        this.mnemonics = Resource.getResourceMnemonic(Resource.getString("SELECT_RAID_LEVEL_TEXT", "New RAID Level"));
        jLabel.setText(this.mnemonics[0]);
        if (this.mnemonics.length == 2) {
            jLabel.setDisplayedMnemonic(this.mnemonics[1].charAt(0));
        }
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        int n = 0;
        if (bl) {
            ArrayList arrayList = null;
            arrayList = ReconFinishWizardDialog.reconDriveSelWizardDialog == null ? new ArrayList() : ReconFinishWizardDialog.reconDriveSelWizardDialog.getSelectedPhysicalDrives();
            this.supportedRAIDLevelValues = ReconstructionEngine.getAllowedRaidLevels((byte)s, (short)BaseReconWizardDialog.currentPDCount, s2, arrayList, (byte)BaseReconWizardDialog.currentMode, reconFinishWizardDialog.ld);
        } else {
            this.supportedRAIDLevels = new String[1];
            this.supportedRAIDLevelValues = new byte[1];
            this.supportedRAIDLevels[0] = Resource.getString("RAID_LEVEL_0_DISPLAY_STRING", "RAID 0");
            this.supportedRAIDLevelValues[0] = 0;
        }
        if (this.supportedRAIDLevelValues != null) {
            this.supportedRAIDLevels = new String[this.supportedRAIDLevelValues.length];
            for (int i = 0; i < this.supportedRAIDLevelValues.length; ++i) {
                this.supportedRAIDLevels[i] = this.getRaidLevelAsString(this.supportedRAIDLevelValues[i]);
            }
        }
        this.raidLevelComboBox = new CustomComboBox(this.supportedRAIDLevels);
        jLabel.setLabelFor(this.raidLevelComboBox);
        this.raidLevelComboBox.addItemListener(this);
        this.raidLevelComboBox.setSelectedIndex(n);
        jPanel.add((Component)this.raidLevelComboBox, gridBagConstraints);
        this.add(jPanel);
    }

    private void fillRaidLevelCombo() {
        if (this.raidLevelList == null || this.raidLevelList.length <= 0) {
            return;
        }
        this.raidLevelComboBox.removeAllItems();
        for (int i = 0; i < this.raidLevelList.length; ++i) {
            short s = this.raidLevelList[i];
            if (s == 0) continue;
            this.raidLevelComboBox.addItem(this.supportedRAIDLevels[s]);
        }
        this.raidLevelComboBox.setSelectedIndex(this.raidLevelComboBox.getItemCount() - 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.selRaidLevel = this.getRAIDLevelFromString((String)this.raidLevelComboBox.getSelectedItem());
        this.reconstParametersChanged = (short)this.getSelectedRAIDLevel() != this.volumeRAIDLevel;
        this.fireListSelectionEvent();
        if (!this.reconstParametersChanged && BaseReconWizardDialog.currentMode == 3) {
            this.parent.setNextButtonEnable(false);
        } else {
            this.parent.setNextButtonEnable(true);
        }
    }

    private short getRAIDLevelFromString(String string) {
        for (short s = 0; s < this.supportedRAIDLevels.length; s = (short)(s + 1)) {
            if (!this.supportedRAIDLevels[s].equals(string)) continue;
            return s;
        }
        return -1;
    }

    public byte getSelectedRAIDLevel() {
        return this.supportedRAIDLevelValues[this.raidLevelComboBox.getSelectedIndex()];
    }

    public void setRAIDLevelList(short[] sArray) {
        this.fillRaidLevelCombo();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        if (!this.selectionListeners.contains(listSelectionListener)) {
            this.selectionListeners.addElement(listSelectionListener);
        }
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.selectionListeners.removeElement(listSelectionListener);
    }

    private void fireListSelectionEvent() {
        if (this.modifyingModel) {
            return;
        }
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, 0, 0, false);
        for (int i = 0; i < this.selectionListeners.size(); ++i) {
            ((ListSelectionListener)this.selectionListeners.elementAt(i)).valueChanged(listSelectionEvent);
        }
    }

    public boolean isReconstParametersChanged() {
        return this.reconstParametersChanged;
    }

    public String getRaidLevelAsString(byte by) {
        switch (by) {
            case 0: {
                return Resource.getString("RAID_LEVEL_0_DISPLAY_STRING", "RAID 0");
            }
            case 1: {
                return Resource.getString("RAID_LEVEL_1_DISPLAY_STRING", "RAID 1");
            }
            case 3: {
                return Resource.getString("RAID_LEVEL_3_DISPLAY_STRING", "RAID 3");
            }
            case 4: {
                return Resource.getString("RAID_LEVEL_4_DISPLAY_STRING", "RAID 4");
            }
            case 5: {
                return Resource.getString("RAID_LEVEL_5_DISPLAY_STRING", "RAID 5");
            }
            case 6: {
                return Resource.getString("RAID_LEVEL_6_DISPLAY_STRING", "RAID 6");
            }
        }
        return Resource.getString("RAID_LEVEL_0_DISPLAY_STRING", "RAID 0");
    }
}

