/*
 * Decompiled with CFR 0.152.
 */
package Wizard.controllerSecurityWizard;

import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AuthenticationDialog
extends VivaldiBaseOptionDialog
implements DocumentListener {
    private JPasswordField m_tfCurrentSecurityKey = null;
    private AdapterHelper m_adapterHelper = null;
    private HashMap m_wizardData = null;
    private Window m_parent = null;
    private JTextField m_tfSecureKeyID = null;
    private boolean m_switchToEKM = false;
    public String m_StrCurrentSecurityKey = null;

    public AuthenticationDialog(Window window, AdapterHelper adapterHelper, HashMap hashMap, boolean bl) {
        super(window);
        this.m_parent = window;
        this.m_adapterHelper = adapterHelper;
        this.m_wizardData = hashMap;
        this.m_switchToEKM = bl;
        this.buildUI();
    }

    @Override
    public void buildUI() {
        this.initUI(Resource.getString("TITLE_AUTHENTICATE_DRIVE_SECURITY_SETTINGS"), 2, 2);
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CURRENT_SECURITY_KEY", "(C)urrent security key:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_tfCurrentSecurityKey = new JPasswordField(32){

            @Override
            public void paste() {
            }
        };
        this.m_tfCurrentSecurityKey.getDocument().addDocumentListener(this);
        jLabel.setLabelFor(this.m_tfCurrentSecurityKey);
        this.m_panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        if (VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_switchToEKM) {
            gridBagConstraints.gridy = 1;
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CURRENT_SECURITY_KEY_IDENTIFIER1", "(C)urrent pass phrase identifier:"));
            JLabel jLabel2 = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            this.m_tfSecureKeyID = new JTextField(32);
            if (stringArray.length == 2) {
                jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            jLabel2.setLabelFor(this.m_tfSecureKeyID);
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            gridBagConstraints.gridy = 1;
            this.m_panel.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridy = 2;
            this.m_panel.add((Component)this.m_tfSecureKeyID, gridBagConstraints);
            String string = this.m_adapterHelper.getKeyIDForController(!this.m_adapterHelper.isLockKeyAssigned());
            if (string != null && string.length() > 0) {
                this.m_tfSecureKeyID.setText(string);
            }
            this.m_tfSecureKeyID.setEditable(false);
        }
        gridBagConstraints.gridy = 2;
        if (!this.m_switchToEKM) {
            this.m_panel.add((Component)new JLabel(Resource.getString("AUTHENTICATE_DRIVE_SECURITY_SETTINGS_DESC", "<html>Authentication is required for the changes that you requested to the drive<br>security settings. Please enter the current security key to authenticate these<br>changes.<br><br></html>")), gridBagConstraints);
        } else {
            this.m_panel.add(new JLabel(Resource.getString("AUTHENTICATE_DESC", "Please provide the current drive security key for authentication")));
        }
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.m_panel.add((Component)this.m_tfCurrentSecurityKey, gridBagConstraints);
        this.setModalProperty(true);
        this.setOKEnabled(false);
        super.buildUI();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableDisableOKButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableDisableOKButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableDisableOKButton();
    }

    private void enableDisableOKButton() {
        boolean bl = false;
        String string = new String(this.m_tfCurrentSecurityKey.getPassword());
        if (string.length() >= 8) {
            bl = true;
        }
        this.setOKEnabled(bl);
    }

    @Override
    public void onOkAction() {
        if (this.authenticate()) {
            super.onOkAction();
        }
    }

    public String getCurrentSecurityKey() {
        return this.m_StrCurrentSecurityKey;
    }

    public HashMap getWizardData() {
        return this.m_wizardData;
    }

    private boolean authenticate() {
        System.out.println("pwd=" + this.m_tfCurrentSecurityKey.getPassword());
        String string = new String(this.m_tfCurrentSecurityKey.getPassword());
        System.out.println("pwd=" + string);
        if (this.m_switchToEKM) {
            if (!((SASAdapter)this.m_adapterHelper.getDeviceObject()).authenticate(string)) {
                JOptionPane.showMessageDialog(this, Resource.getString("ERROR_INCORRECT_SECURITY_KEY"), Resource.getString("TITLE_INCORRECT_SECURITY_KEY"), 0);
                return false;
            }
            this.m_wizardData.put("CurrentSecurityKey", string);
        } else {
            String string2 = this.m_wizardData.get("SecurityKeyID").toString();
            String string3 = null;
            String string4 = null;
            if (((Boolean)this.m_wizardData.get("EnterNewSecurityKey")).booleanValue()) {
                string3 = this.m_wizardData.get("SecurityKey").toString();
            } else if (((Boolean)this.m_wizardData.get("UsePassPhrase")).booleanValue()) {
                string4 = this.m_wizardData.get("PassPhrase").toString();
            }
            this.m_wizardData.put("CurrentSecurityKey", string);
            if (!((SASAdapter)this.m_adapterHelper.getDeviceObject()).authenticate(string)) {
                JOptionPane.showMessageDialog(this, Resource.getString("ERROR_INCORRECT_SECURITY_KEY"), Resource.getString("TITLE_INCORRECT_SECURITY_KEY"), 0);
                return false;
            }
        }
        return true;
    }
}

