/*
 * Decompiled with CFR 0.152.
 */
package Wizard.controllerSecurityWizard.EKMS;

import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import KernelExceptions.VKOperationFailedException;
import Utils.GUIUtils;
import Utils.Resource;
import Wizard.controllerSecurityWizard.AuthenticationDialog;
import Wizard.controllerSecurityWizard.SecurityBasedOperations;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ChangeSecuritySettingsPage
extends VivaldiBaseDialog {
    private AdapterHelper m_adapterHelper = null;
    private JRadioButton m_changeSecurityRadioButton = null;
    private JRadioButton m_switchModeRadioButton = null;
    private JButton m_okButton = new JButton();
    private boolean okButtonFlag = false;

    public ChangeSecuritySettingsPage(AdapterHelper adapterHelper) {
        this.m_adapterHelper = adapterHelper;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = null;
        this.setTitle(Resource.getString("TITLE_CHANGE_SECURITY_SETTINGS", "Change Security Settings"));
        String string = Resource.getString("LABEL_CONTROLLER", "Controller:");
        JLabel jLabel = new JLabel(string + " " + this.m_adapterHelper.getText());
        StringBuffer stringBuffer = new StringBuffer(Resource.getString("EKM_SUPPORTED_CHANGE_DRIVE_SECURITY_INTRO_DESC", "<html>Security is currently enabled. Change the security settings on this controller or switch<br>between the key management modes."));
        stringBuffer.append("<br><br>");
        stringBuffer.append(Resource.getString("CURRENT_DRIVE_SECURITY_MODE", "Current key management mode:"));
        if (this.m_adapterHelper.getAdapterInfo().getLockKeyBinding() == 4) {
            stringBuffer.append(Resource.getString("EKM", " EKM"));
        } else {
            stringBuffer.append(Resource.getString("LKM", " LKM"));
        }
        stringBuffer.append("<br><br></html>");
        stringArray = Resource.getResourceMnemonic(Resource.getString("CHANGE_CURRENT_SECURITY_SETTINGS", "(C)hange current security settings"));
        this.m_changeSecurityRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_changeSecurityRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_changeSecurityRadioButton.setToolTipText(Resource.getString("TOOLTIP_CURRENT_SECURITY_SETTINGS", "Change current security settings"));
        String string2 = null;
        if (this.m_adapterHelper.getAdapterInfo().getLockKeyBinding() == 4) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("SWITCH_TO_LKM", "(S)witch to Simple Key Management(SKM) mode"));
            string2 = Resource.getString("TOOLTIP_SWITCH_TO_LKM", "Switch to Simple Key Management(SKM) mode");
        } else {
            stringArray = Resource.getResourceMnemonic(Resource.getString("SWITCH_TO_EKM", "(S)witch to Enhanced Key Management(EKM) mode"));
            string2 = Resource.getString("TOOLTIP_SWITCH_TO_EKM", "Switch to Enhanced Key Management(EKM) mode");
        }
        this.m_switchModeRadioButton = new JRadioButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_switchModeRadioButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_switchModeRadioButton.setToolTipText(string2);
        if (!this.m_adapterHelper.isEKMSPossible()) {
            this.m_switchModeRadioButton.setEnabled(false);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)new JLabel(stringBuffer.toString()), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)this.m_changeSecurityRadioButton, gridBagConstraints);
        buttonGroup.add(this.m_changeSecurityRadioButton);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        jPanel.add((Component)this.m_switchModeRadioButton, gridBagConstraints);
        buttonGroup.add(this.m_switchModeRadioButton);
        this.m_changeSecurityRadioButton.setSelected(true);
        if (this.m_adapterHelper.getAdapterInfo().getLockKeyBinding() == 4 && !this.m_adapterHelper.isEKMSPossible()) {
            this.m_changeSecurityRadioButton.setEnabled(false);
        }
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2, 10, 10));
        stringArray = Resource.getResourceMnemonic(Resource.getString("ABOUT_OKBUTTON_TEXT", "OK"));
        this.m_okButton = new JButton(stringArray[0]);
        this.getRootPane().setDefaultButton(this.m_okButton);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_CLOSE", "Cancel"));
        JButton jButton = new JButton(stringArray[0]);
        jPanel2.add(this.m_okButton);
        jPanel2.add(jButton);
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChangeSecuritySettingsPage.this.dispose();
            }
        });
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChangeSecuritySettingsPage.this.m_changeSecurityRadioButton.isSelected()) {
                    if (ChangeSecuritySettingsPage.this.m_adapterHelper.getAdapterInfo().getLockKeyBinding() == 4) {
                        System.out.println("Re-key in EKM mode");
                        try {
                            ChangeSecuritySettingsPage.this.m_adapterHelper.fireRekeyOperation(null, null, null, null, true);
                            ChangeSecuritySettingsPage.this.m_adapterHelper.ctrlDataRefresh();
                            if (ChangeSecuritySettingsPage.this.m_adapterHelper.isRebootRequiredToEnableEKM()) {
                                JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("REBOOT_REQUIRED_DESC", "<html>Please restart the system for the changes to take effect. Make sure to <br>stop all the I/Os and other operations before you reboot your system.<br><br></html>"), Resource.getString("TITLE_REBOOT", "System Restart Required"), -1, 2);
                            } else {
                                JOptionPane.showConfirmDialog(null, Resource.getString("CHANGE_SECURITY_MSG", "<html>Your current security setting for external key management(EKM) is changed. <br><br></html>"), Resource.getString("TITLE_CHANGE_SECURITY", "Confirm Change Security Settings"), -1, 1);
                            }
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            vKOperationFailedException.printStackTrace();
                            if (vKOperationFailedException.GetErrorCode() == 71) {
                                JOptionPane.showMessageDialog(null, Resource.getString("LOCK_KEY_MUST", "Change current security settings operation is not allowed. Please restart the system and try it Again"), Resource.getString("REKEY_NOT_ALLOWED", "Change current security settings not allowed"), 0);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ChangeSecuritySettingsPage.this.dispose();
                    } else {
                        ChangeSecuritySettingsPage.this.dispose();
                        System.out.println("Re-key in LKM mode");
                        new SecurityBasedOperations(ChangeSecuritySettingsPage.this.m_adapterHelper, false);
                    }
                }
                if (ChangeSecuritySettingsPage.this.m_switchModeRadioButton.isSelected()) {
                    ChangeSecuritySettingsPage.this.dispose();
                    if (ChangeSecuritySettingsPage.this.m_adapterHelper.getAdapterInfo().getLockKeyBinding() == 4) {
                        System.out.println("Switching from EKM to LKM ");
                        if (VivaldiStartupDialog.OEM_TYPE == 2561 && ChangeSecuritySettingsPage.this.m_adapterHelper.getEKMSecuredLockedDrives() != null) {
                            if (JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("CLEAR_CONFIG_TO_SWITCH_DESC", "<html>Secured configuration along with pass phrase per drive is present.<br>Please clear the secured configuration to switch the mode.<br><br></html>"), Resource.getString("TITLE_SWITCH", "Unable to Switch Mode"), -1, 2) == 0) {
                                return;
                            }
                        } else {
                            new SecurityBasedOperations(ChangeSecuritySettingsPage.this.m_adapterHelper, true);
                        }
                    } else {
                        ChangeSecuritySettingsPage.this.dispose();
                        System.out.println("Switching from LKM to EKM ");
                        HashMap hashMap = new HashMap();
                        AuthenticationDialog authenticationDialog = new AuthenticationDialog((Window)VivaldiStartupDialog.mainScreen, ChangeSecuritySettingsPage.this.m_adapterHelper, hashMap, true);
                        String string = authenticationDialog.getWizardData().get("CurrentSecurityKey").toString();
                        System.out.println("strOldSecurityKey=" + string);
                        try {
                            ChangeSecuritySettingsPage.this.m_adapterHelper.fireRekeyOperation(string, null, null, null, true);
                        }
                        catch (VKOperationFailedException vKOperationFailedException) {
                            vKOperationFailedException.printStackTrace();
                        }
                        ChangeSecuritySettingsPage.this.m_adapterHelper.ctrlDataRefresh();
                        if (ChangeSecuritySettingsPage.this.m_adapterHelper.isRebootRequiredToEnableEKM() && JOptionPane.showConfirmDialog(VivaldiStartupDialog.mainScreen, Resource.getString("REBOOT_REQUIRED_DESC", "<html>Please restart the system for the changes to take effect. Make sure to <br>stop all the I/Os and other operations before you reboot your system.<br><br></html>"), Resource.getString("TITLE_REBOOT", "System Restart Required"), -1, 2) == 0) {
                            return;
                        }
                    }
                }
            }
        });
        this.add(jPanel);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }
}

