/*
 * Decompiled with CFR 0.152.
 */
package Wizard.controllerSecurityWizard;

import GUIHelper.AdapterHelper;
import SASKernel.SASAdapter.SASAdapter;
import Utils.GUIUtils;
import Utils.PassPhraseVerifier;
import Utils.Resource;
import Utils.VivaldiBaseOptionDialog;
import Wizard.controllerSecurityWizard.AuthenticationDialog;
import Wizard.controllerSecurityWizard.EnableAndChangeSecurityWizard;
import Wizard.controllerSecurityWizard.SecurityWizardConfirmationDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PassPhrasePage
extends EnableAndChangeSecurityWizard
implements ActionListener,
DocumentListener {
    private JCheckBox m_chkBxUsePassPhrase = null;
    private JPasswordField m_tfPassphrase = null;
    private JPasswordField m_tfConfirmPassPhrase = null;

    public PassPhrasePage(AdapterHelper adapterHelper, HashMap hashMap) {
        super(adapterHelper, hashMap);
    }

    public void showWizardPage() {
        if (this.m_adapterHelper.isLockKeyAssigned()) {
            this.setTitle(Resource.getString("CHANGE_DRIVE_SECURITY_ENTER_PASSPHRASE_WIZARD_PAGE_TITLE", "Change Security Settings - Pass Phrase"));
        } else {
            this.setTitle(Resource.getString("ENABLE_DRIVE_SECURITY_ENTER_PASSPHRASE_WIZARD_PAGE_TITLE", "Enable Drive Security - Enter Pass Phrase"));
        }
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_PASS_PHRASE", "(P)ass phrase:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CONFIRM", "(C)onfirm:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_tfPassphrase = new JPasswordField(32){

            @Override
            public void paste() {
            }
        };
        this.m_tfPassphrase.getDocument().addDocumentListener(this);
        this.m_tfConfirmPassPhrase = new JPasswordField(32){

            @Override
            public void paste() {
            }
        };
        this.m_tfConfirmPassPhrase.getDocument().addDocumentListener(this);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_PASS_PHRASE", "(U)se a pass phrase in addition to the security key"));
        this.m_chkBxUsePassPhrase = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_chkBxUsePassPhrase.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_chkBxUsePassPhrase.addActionListener(this);
        jLabel.setLabelFor(this.m_tfPassphrase);
        jLabel2.setLabelFor(this.m_tfConfirmPassPhrase);
        this.centerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        if (this.m_adapterHelper.isLockKeyAssigned()) {
            if (this.m_adapterHelper.isPassPhraseUsed()) {
                this.centerPanel.add((Component)new JLabel(Resource.getString("CHANGE_PASS_PHRASE_PAGE_DESC1")), gridBagConstraints);
            } else {
                this.centerPanel.add((Component)new JLabel(Resource.getString("CHANGE_PASS_PHRASE_PAGE_DESC2")), gridBagConstraints);
            }
            this.m_chkBxUsePassPhrase.setSelected(this.m_adapterHelper.isPassPhraseUsed());
        } else {
            this.centerPanel.add((Component)new JLabel(Resource.getString("ENTER_PASSPHRASE_PAGE_DESC")), gridBagConstraints);
            this.m_chkBxUsePassPhrase.setSelected(true);
        }
        this.m_tfPassphrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        this.m_tfConfirmPassPhrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        gridBagConstraints.gridy = 1;
        this.centerPanel.add((Component)this.m_chkBxUsePassPhrase, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.centerPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.centerPanel.add((Component)this.m_tfPassphrase, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.centerPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.centerPanel.add((Component)this.m_tfConfirmPassPhrase, gridBagConstraints);
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_FINISH_TEXT", "Finish"));
        this.nextButton.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.nextButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.nextButton.setEnabled(!this.m_chkBxUsePassPhrase.isSelected());
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.m_tfPassphrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        this.m_tfConfirmPassPhrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        if (this.m_chkBxUsePassPhrase.isSelected()) {
            this.enableDisableFinishButton();
        } else {
            this.nextButton.setEnabled(true);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableDisableFinishButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableDisableFinishButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableDisableFinishButton();
    }

    private void enableDisableFinishButton() {
        boolean bl = false;
        String string = new String(this.m_tfPassphrase.getPassword());
        String string2 = new String(this.m_tfConfirmPassPhrase.getPassword());
        if (string.length() >= 8 && string2.length() >= 8) {
            bl = true;
        }
        this.nextButton.setEnabled(bl);
    }

    @Override
    public void next() {
        if (this.isReady()) {
            boolean bl = true;
            boolean bl2 = true;
            this.m_wizardData.put("UsePassPhrase", new Boolean(this.m_chkBxUsePassPhrase.isSelected()));
            this.m_wizardData.put("PassPhrase", new String(this.m_tfConfirmPassPhrase.getPassword()));
            if (this.m_adapterHelper.isLockKeyAssigned()) {
                VivaldiBaseOptionDialog vivaldiBaseOptionDialog;
                if (((Boolean)this.m_wizardData.get("EnterNewSecurityKey")).booleanValue()) {
                    bl = false;
                } else if (((Boolean)this.m_wizardData.get("UseCurrentSecurityKeyID")).booleanValue()) {
                    if (this.m_adapterHelper.isPassPhraseUsed() && this.m_chkBxUsePassPhrase.isSelected()) {
                        bl = true;
                    } else if (!this.m_adapterHelper.isPassPhraseUsed() && !this.m_chkBxUsePassPhrase.isSelected()) {
                        this.dispose();
                        return;
                    }
                } else {
                    bl = false;
                    bl2 = false;
                }
                if (bl) {
                    vivaldiBaseOptionDialog = new AuthenticationDialog((Window)this, this.m_adapterHelper, this.m_wizardData, false);
                    if (vivaldiBaseOptionDialog.getSelectedOption() == 0) {
                        this.dispose();
                    } else {
                        bl2 = false;
                        return;
                    }
                }
                if ((vivaldiBaseOptionDialog = new SecurityWizardConfirmationDialog((Window)this, this.m_adapterHelper, this.m_wizardData)).getSelectedOption() != 0) {
                    return;
                }
                this.dispose();
                if (bl2) {
                    String string;
                    String string2 = this.m_wizardData.get("SecurityKeyID").toString();
                    String string3 = this.m_wizardData.get("CurrentSecurityKey").toString();
                    String string4 = null;
                    String string5 = string = this.m_chkBxUsePassPhrase.isSelected() ? new String(this.m_tfConfirmPassPhrase.getPassword()) : null;
                    if (((Boolean)this.m_wizardData.get("EnterNewSecurityKey")).booleanValue()) {
                        string4 = this.m_wizardData.get("SecurityKey").toString();
                    }
                    try {
                        this.m_adapterHelper.fireRekeyOperation(string3, string4, string, string2, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(null, Resource.getString("REKEY", "Rekey operation failed."));
                    }
                } else {
                    String string = this.m_wizardData.get("SecurityKeyID").toString();
                    ((SASAdapter)this.m_adapterHelper.getDeviceObject()).setKeyIdForDevice(string);
                }
            } else {
                SecurityWizardConfirmationDialog securityWizardConfirmationDialog = new SecurityWizardConfirmationDialog((Window)this, this.m_adapterHelper, this.m_wizardData);
                if (securityWizardConfirmationDialog.getSelectedOption() == 0) {
                    this.dispose();
                    String string = this.m_wizardData.get("SecurityKeyID").toString();
                    String string6 = this.m_wizardData.get("SecurityKey").toString();
                    String string7 = null;
                    if (this.m_chkBxUsePassPhrase.isSelected()) {
                        string7 = this.m_wizardData.get("PassPhrase").toString();
                    }
                    this.m_adapterHelper.fireCreateKeyOperation(string, string6, string7, false);
                }
            }
        }
    }

    private boolean isReady() {
        if (this.m_chkBxUsePassPhrase.isSelected()) {
            String string;
            String string2 = new String(this.m_tfPassphrase.getPassword());
            if (!string2.equals(string = new String(this.m_tfConfirmPassPhrase.getPassword()))) {
                JOptionPane.showMessageDialog(this, Resource.getString("ERROR_PASSWORD_MISMATCH"), Resource.getString("TITLE_PASSPHRASE_MISMATCH"), 0);
                return false;
            }
            if (!PassPhraseVerifier.isValidPassPhrase(string2)) {
                JOptionPane.showMessageDialog(this, Resource.getString("ERROR_INVALID_PASSPHRASE"), Resource.getString("TITLE_INVALID_PASSPHRASE"), 0);
                return false;
            }
        }
        return true;
    }
}

