/*
 * Decompiled with CFR 0.152.
 */
package Wizard.controllerSecurityWizard;

import GUI.MainFrame;
import GUI.VivaldiBaseDialog;
import GUI.VivaldiStartupDialog;
import GUIHelper.AdapterHelper;
import KernelExceptions.VKNotRespondingException;
import KernelExceptions.VKOperationFailedException;
import SASKernel.SASAdapter.SASAdapter;
import Utils.GUIUtils;
import Utils.PassPhraseVerifier;
import Utils.Resource;
import Utils.SecurityTextBox;
import Wizard.controllerSecurityWizard.AuthenticationDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SecurityBasedOperations
extends VivaldiBaseDialog
implements ActionListener,
DocumentListener {
    private SecurityTextBox m_tfSecureKeyID = null;
    private ButtonGroup m_buttonGroupKeyID = null;
    private JRadioButton m_radioUseOldKeyID = null;
    private JRadioButton m_radioEnterNewKeyID = null;
    private JTextField m_tfNewSecureKeyID = null;
    private JButton m_btnSuggestSecurityKey = null;
    private JTextField m_tfSecurityKey = null;
    private JTextField m_tfConfirmSecurityKey = null;
    private String m_strSuggestedSecurityKey = null;
    private ButtonGroup m_buttonGroupSecurityKey = null;
    private JRadioButton m_radioUseOldSecurityKey = null;
    private JRadioButton m_radioEnterNewSecurityKey = null;
    private JCheckBox m_chkBxUsePassPhrase = null;
    private JCheckBox m_chkBxStrongPWD = null;
    private JPasswordField m_tfPassphrase = null;
    private JPasswordField m_tfConfirmPassPhrase = null;
    private JCheckBox m_chkBxRecord = null;
    private JButton m_yesButton = null;
    private JButton m_noButton = null;
    protected AdapterHelper m_adapterHelper = null;
    protected HashMap m_wizardData = null;
    private JLabel secLabel = null;
    private boolean m_switchToLKM = false;

    public SecurityBasedOperations(AdapterHelper adapterHelper, boolean bl) {
        this.m_adapterHelper = adapterHelper;
        this.m_switchToLKM = bl;
        this.buildUI();
    }

    public void buildUI() {
        this.m_wizardData = new HashMap();
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.getTitlePanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.getSecurityKeyIDPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.getSecurityKeyPanel(), gridBagConstraints);
        if (!this.m_adapterHelper.getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().isBiosNotDetected() || VivaldiStartupDialog.OEM_TYPE != 2561 && !this.m_adapterHelper.isOnlyFDESupported()) {
            gridBagConstraints.gridy = 3;
            jPanel.add((Component)this.getPassPharsePanel(), gridBagConstraints);
        }
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.getConfirmationPanel(), gridBagConstraints);
        int n = (int)jPanel.getPreferredSize().getWidth();
        int n2 = (int)jPanel.getPreferredSize().getHeight();
        if (n > MainFrame.SCREEN_SIZE.width) {
            n = MainFrame.SCREEN_SIZE.width - 100;
        }
        if (n2 + 300 > MainFrame.SCREEN_SIZE.height) {
            n2 = MainFrame.SCREEN_SIZE.height - 300;
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        jScrollPane.setPreferredSize(new Dimension(n, n2));
        this.contentPane.add((Component)jScrollPane, "Center");
        this.contentPane.add((Component)this.getBottomPanel(), "South");
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM) {
            this.setTitle(Resource.getString("TITLE_SECURITY_BASED_OPERATION_ENABLE", "Security Based Operations - Enable"));
        } else {
            this.setTitle(Resource.getString("TITLE_SECURITY_BASED_OPERATION_CHANGE", "Security Based Operations - Change"));
        }
        this.setModal(true);
        this.setResizable(false);
        this.setLocation((MainFrame.SCREEN_SIZE.width - this.getWidth()) / 2, (MainFrame.SCREEN_SIZE.height - this.getHeight()) / 2);
        this.pack();
        GUIUtils.centerDialogOnScreen(this);
        this.setVisible(true);
    }

    private JPanel getTitlePanel() {
        String string;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String string2 = Resource.getString("LABEL_CONTROLLER", "Controller:");
        JLabel jLabel = new JLabel(string2 + " " + this.m_adapterHelper.getText(), 2);
        Object[] objectArray = new Object[1];
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM) {
            objectArray[0] = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? Resource.getString("MESSAGE_PASSPHRASE", "Password") : Resource.getString("MESSAGE_SECURITY_KEY", "security key");
            string = MessageFormat.format(Resource.getString("ENABLE_DRIVESECURITY_DESC", "Enabling Security - {0}"), objectArray);
        } else {
            objectArray[0] = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? Resource.getString("MESSAGE_PASSPHRASE", "Password") : Resource.getString("MESSAGE_SECURITY_KEY", "security key");
            string = MessageFormat.format(Resource.getString("CHANGE_DRIVESECURITY_DESC", "changing Security - {0}"), objectArray);
        }
        JLabel jLabel2 = new JLabel(string, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 0, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        return jPanel;
    }

    private JPanel getSecurityKeyIDPanel() {
        JComponent jComponent;
        String[] stringArray = null;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.m_radioUseOldKeyID = new JRadioButton();
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_CURRENT_SECURE_KEY_ID", "(U)se old"));
        this.m_radioUseOldKeyID.setText(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_radioUseOldKeyID.setMnemonic(stringArray[1].charAt(0));
        }
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
            this.m_radioUseOldKeyID.setSelected(true);
            jPanel.add((Component)this.m_radioUseOldKeyID, gridBagConstraints);
        }
        this.m_radioUseOldKeyID.addActionListener(this);
        stringArray = !this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM ? Resource.getResourceMnemonic(Resource.getString("LABEL_SECURE_KEY_ID", "Security key (i)dentifier:")) : Resource.getResourceMnemonic(Resource.getString("LABEL_CURRENT_SECURITY_KEY_IDENTIFIER", "Current security key (i)dentifier:"));
        JLabel jLabel = new JLabel(stringArray[0]);
        this.m_tfSecureKeyID = new SecurityTextBox(32);
        this.m_tfSecureKeyID.setHighlighter(null);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        jLabel.setLabelFor(this.m_tfSecureKeyID);
        gridBagConstraints.insets = this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM ? new Insets(0, 20, 0, 5) : new Insets(0, 5, 0, 0);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.m_tfSecureKeyID, gridBagConstraints);
        String string = this.m_adapterHelper.getKeyIDForController(!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM);
        if (string != null && string.length() > 0) {
            this.m_tfSecureKeyID.setText(string);
        }
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM) {
            this.m_tfSecureKeyID.requestFocus();
            if (VivaldiStartupDialog.OEM_TYPE == 2561) {
                this.m_tfSecureKeyID.setText("");
            }
        } else {
            this.m_tfSecureKeyID.setEditable(false);
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_ENTER_NEW_SECURITY_KEY_IDENTIFIER", "(E)nter a new security key identifier"));
            this.m_radioEnterNewKeyID = new JRadioButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_radioEnterNewKeyID.setMnemonic(stringArray[1].charAt(0));
            }
            this.m_buttonGroupKeyID = new ButtonGroup();
            this.m_buttonGroupKeyID.add(this.m_radioUseOldKeyID);
            this.m_buttonGroupKeyID.add(this.m_radioEnterNewKeyID);
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_NEW_SECURITY_KEY_IDENTIFIER", "Ne(w) security key identifier:"));
            jComponent = new JLabel(stringArray[0]);
            if (stringArray.length == 2) {
                ((JLabel)jComponent).setDisplayedMnemonic(stringArray[1].charAt(0));
            }
            this.m_tfNewSecureKeyID = new SecurityTextBox(32);
            this.m_tfNewSecureKeyID.setEnabled(false);
            this.m_tfNewSecureKeyID.setHighlighter(null);
            this.m_radioEnterNewKeyID.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SecurityBasedOperations.this.m_tfNewSecureKeyID.setEnabled(SecurityBasedOperations.this.m_radioEnterNewKeyID.isSelected());
                }
            });
            ((JLabel)jComponent).setLabelFor(this.m_tfNewSecureKeyID);
            gridBagConstraints.insets = new Insets(5, 0, 5, 0);
            gridBagConstraints.gridy = 3;
            jPanel.add((Component)this.m_radioEnterNewKeyID, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 20, 0, 5);
            gridBagConstraints.gridy = 4;
            jPanel.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.gridy = 5;
            jPanel.add((Component)this.m_tfNewSecureKeyID, gridBagConstraints);
        }
        jComponent = new JPanel(new FlowLayout(0));
        jComponent.add(jPanel);
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM) {
            this.secLabel = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? this.getTitleBorder(Resource.getString("TITLE_SECURITY_KEY_ID", "Security key Identifier"), Resource.getString("ENTER_SECURITY_KEY_ID_PAGE_DESC_FDE", "Security Key Identifier desc")) : this.getTitleBorder(Resource.getString("TITLE_SECURITY_KEY_ID", "Security key Identifier"), Resource.getString("ENTER_SECURITY_KEY_ID_PAGE_DESC", "Security Key Identifier desc"));
            jComponent.add(this.secLabel);
        } else {
            this.secLabel = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? this.getTitleBorder(Resource.getString("TITLE_SECURITY_KEY_ID", "Security key Identifier"), Resource.getString("CHANGE_SECURITY_KEY_ID_PAGE_DESC_FDE", "Security Key Identifier desc")) : this.getTitleBorder(Resource.getString("TITLE_SECURITY_KEY_ID", "Security key Identifier"), Resource.getString("CHANGE_SECURITY_KEY_ID_PAGE_DESC", "Change Security Key Identifier desc"));
            jComponent.add(this.secLabel);
        }
        return jComponent;
    }

    private JPanel getSecurityKeyPanel() {
        String[] stringArray = null;
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported()) {
            stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_PASS_PHRASE", "Pass p(h)rase:"));
            if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
                stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_NEW_PASS_PHRASE", "Ne(w) Pass phrase:"));
            }
        } else {
            stringArray = this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM ? Resource.getResourceMnemonic(Resource.getString("LABEL_NEW_SECURITY_KEY", "Ne(w) Security Key:")) : Resource.getResourceMnemonic(Resource.getString("LABEL_SECURITY_KEY", "Security (k)ey:"));
        }
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CONFIRM_SECURITYKEY", "Confirm Security (K)ey:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_tfSecurityKey = new SecurityTextBox(32);
        this.m_tfSecurityKey.setHighlighter(null);
        jLabel.setLabelFor(this.m_tfSecurityKey);
        this.m_tfSecurityKey.getDocument().addDocumentListener(this);
        this.m_tfConfirmSecurityKey = new SecurityTextBox(32);
        this.m_tfConfirmSecurityKey.setHighlighter(null);
        jLabel2.setLabelFor(this.m_tfConfirmSecurityKey);
        stringArray = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? Resource.getResourceMnemonic(Resource.getString("LABEL_SUGGEST_PASS_PHRASE", "Su(g)gest Password")) : Resource.getResourceMnemonic(Resource.getString("LABEL_SUGGEST_SECURITY_KEY", "Su(g)gest Security Key"));
        this.m_btnSuggestSecurityKey = new JButton(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_btnSuggestSecurityKey.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_btnSuggestSecurityKey.addActionListener(this);
        stringArray = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? Resource.getResourceMnemonic(Resource.getString("LABEL_ENTER_NEW_PASS_PHRASE")) : Resource.getResourceMnemonic(Resource.getString("LABEL_ENTER_NEW_SECURITY_KEY", "Enter a new drive securi(t)y key"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 10);
        gridBagConstraints.anchor = 17;
        if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
            stringArray = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? Resource.getResourceMnemonic(Resource.getString("LABEL_USE_CURRENT_PASS_PHRASE")) : Resource.getResourceMnemonic(Resource.getString("LABEL_USE_CURRENT_SECURITY_KEY", "Use the e(x)isting drive security key"));
            this.m_radioUseOldSecurityKey = new JRadioButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_radioUseOldSecurityKey.setMnemonic(stringArray[1].charAt(0));
            }
            stringArray = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? Resource.getResourceMnemonic(Resource.getString("LABEL_ENTER_NEW_PASS_PHRASE")) : Resource.getResourceMnemonic(Resource.getString("LABEL_ENTER_NEW_SECURITY_KEY", "Enter a new drive securi(t)y key"));
            this.m_radioEnterNewSecurityKey = new JRadioButton(stringArray[0]);
            if (stringArray.length == 2) {
                this.m_radioEnterNewSecurityKey.setMnemonic(stringArray[1].charAt(0));
            }
            this.m_buttonGroupSecurityKey = new ButtonGroup();
            this.m_buttonGroupSecurityKey.add(this.m_radioUseOldSecurityKey);
            this.m_buttonGroupSecurityKey.add(this.m_radioEnterNewSecurityKey);
            this.m_radioEnterNewSecurityKey.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SecurityBasedOperations.this.m_btnSuggestSecurityKey.setEnabled(SecurityBasedOperations.this.m_radioEnterNewSecurityKey.isSelected());
                    SecurityBasedOperations.this.m_tfSecurityKey.setEnabled(SecurityBasedOperations.this.m_radioEnterNewSecurityKey.isSelected());
                    SecurityBasedOperations.this.m_tfConfirmSecurityKey.setEnabled(SecurityBasedOperations.this.m_radioEnterNewSecurityKey.isSelected());
                }
            });
            this.m_radioUseOldSecurityKey.setSelected(true);
            this.m_btnSuggestSecurityKey.setEnabled(this.m_radioEnterNewSecurityKey.isSelected());
            this.m_tfSecurityKey.setEnabled(this.m_radioEnterNewSecurityKey.isSelected());
            this.m_tfConfirmSecurityKey.setEnabled(this.m_radioEnterNewSecurityKey.isSelected());
        }
        if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
            jPanel.add((Component)this.m_radioUseOldSecurityKey, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(0, 5, 0, 25);
            jPanel.add((Component)this.m_radioEnterNewSecurityKey, gridBagConstraints);
        }
        gridBagConstraints.insets = this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM ? new Insets(0, 20, 0, 5) : new Insets(0, 5, 0, 0);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.m_btnSuggestSecurityKey, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.m_tfSecurityKey, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)this.m_tfConfirmSecurityKey, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel);
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM) {
            this.secLabel = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? this.getTitleBorder(Resource.getString("TITLE_PASS_PHRASE", "Pass phrase"), Resource.getString("ENTER_PASS_PHRASE_PAGE_DESC", "Pass phrase desc")) : this.getTitleBorder(Resource.getString("TITLE_SECURITY_KEY", "Security key"), Resource.getString("ENTER_SECURITY_KEY_PAGE_DESC", "Security Key desc"));
            jPanel2.add(this.secLabel);
        } else {
            this.secLabel = VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported() ? this.getTitleBorder(Resource.getString("TITLE_PASS_PHRASE", "Pass phrase"), Resource.getString("CHANGE_PASS_PHRASE_PAGE_DESC", "Change Pass phrase desc")) : this.getTitleBorder(Resource.getString("TITLE_SECURITY_KEY", "Security key"), Resource.getString("CHANGE_SECURITY_KEY_PAGE_DESC", "Change Security Key desc"));
            jPanel2.add(this.secLabel);
        }
        return jPanel2;
    }

    private JPanel getPassPharsePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_PASSWORD", "Pass(w)ord"));
        JLabel jLabel = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_CONFIRM_PASSWORD", "C(o)nfirm:"));
        JLabel jLabel2 = new JLabel(stringArray[0]);
        if (stringArray.length == 2) {
            jLabel2.setDisplayedMnemonic(stringArray[1].charAt(0));
        }
        this.m_tfPassphrase = new JPasswordField(32){

            @Override
            public void paste() {
            }
        };
        this.m_tfConfirmPassPhrase = new JPasswordField(32){

            @Override
            public void paste() {
            }
        };
        jLabel.setLabelFor(this.m_tfPassphrase);
        jLabel2.setLabelFor(this.m_tfConfirmPassPhrase);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_PASS_BOOT", "(P)ause for Password at Boot Time ?"));
        this.m_chkBxUsePassPhrase = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_chkBxUsePassPhrase.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_chkBxUsePassPhrase.setSelected(true);
        stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_USE_STRONG_PWD", "En(f)orce Strong Password"));
        this.m_chkBxStrongPWD = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_chkBxStrongPWD.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_chkBxStrongPWD.setSelected(false);
        if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
            if (this.m_adapterHelper.isPassPhraseUsed()) {
                this.m_chkBxUsePassPhrase.setSelected(true);
            } else {
                this.m_chkBxUsePassPhrase.setSelected(false);
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM ? new Insets(0, 20, 0, 5) : new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.m_chkBxUsePassPhrase, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.m_chkBxStrongPWD, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.m_tfPassphrase, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)this.m_tfConfirmPassPhrase, gridBagConstraints);
        this.m_tfPassphrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        this.m_tfConfirmPassPhrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        this.m_chkBxStrongPWD.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        this.m_chkBxUsePassPhrase.addActionListener(this);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jPanel);
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM) {
            this.secLabel = this.getTitleBorder(Resource.getString("TITLE_PASSWORD", "Password"), Resource.getString("ENTER_PASSWORD_PAGE_DESC", "Password desc"));
            jPanel2.add(this.secLabel);
        } else if (this.m_adapterHelper.isPassPhraseUsed()) {
            this.secLabel = this.getTitleBorder(Resource.getString("TITLE_PASSWORD", "Password"), Resource.getString("CHANGE_PASSWORD_PAGE_DESC1", "Password desc1"));
            jPanel2.add(this.secLabel);
        } else {
            this.secLabel = this.getTitleBorder(Resource.getString("TITLE_PASSWORD", "Password"), Resource.getString("CHANGE_PASSWORD_PAGE_DESC2", "Password desc2"));
            jPanel2.add(this.secLabel);
        }
        return jPanel2;
    }

    public JPanel getConfirmationPanel() {
        String string;
        Object[] objectArray = new Object[1];
        if (VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported()) {
            objectArray[0] = Resource.getString("MESSAGE_PASSPHRASE", "Password");
            string = MessageFormat.format(Resource.getString("DRIVESECURITY_BE_SURE_TEXT", "<html>Be sure to record this information. You may be prompted to enter the {0} if you <br>perform certain operations. If you forgot the {0}, you could lose access to your data.</html>"), objectArray);
        } else {
            objectArray[0] = Resource.getString("MESSAGE_SECURITY_KEY", "security key");
            string = MessageFormat.format(Resource.getString("DRIVESECURITY_BE_SURE_TEXT", "<html>Be sure to record this information. You may be prompted to enter the {0} if you <br>perform certain operations. If you forgot the {0}, you could lose access to your data.</html>"), objectArray);
        }
        JLabel jLabel = new JLabel(string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("LABEL_RECORD_SECURITY_SETTINGS", "I (r)ecorded the security settings for future reference."));
        this.m_chkBxRecord = new JCheckBox(stringArray[0]);
        if (stringArray.length == 2) {
            this.m_chkBxRecord.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_chkBxRecord.setSelected(false);
        this.m_chkBxRecord.addActionListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 10;
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM) {
            gridBagConstraints.weighty = 2.0;
            jPanel.add((Component)jLabel, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.m_chkBxRecord, gridBagConstraints);
        return jPanel;
    }

    public JPanel getBottomPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.anchor = 10;
        String string = !this.m_adapterHelper.isLockKeyAssigned() || this.m_switchToLKM ? Resource.getString("MESSAGE_ARE_YOU_SURE_TO_ENABLE", "Enable?") : Resource.getString("MESSAGE_ARE_YOU_SURE_TO_CHANGE", "Change?");
        JLabel jLabel = new JLabel(string);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        String[] stringArray = Resource.getResourceMnemonic(Resource.getString("BUTTON_LABEL_YES", "(Y)es"));
        this.m_yesButton = new JButton(stringArray[0]);
        this.m_yesButton.setToolTipText(Resource.getString("PROPERTY_YES_TEXT", "Yes"));
        this.m_yesButton.setEnabled(false);
        if (stringArray.length == 2) {
            this.m_yesButton.setMnemonic(stringArray[1].charAt(0));
        }
        stringArray = Resource.getResourceMnemonic(Resource.getString("BUTON_LABEL_NO", "(N)o"));
        this.m_noButton = new JButton(stringArray[0]);
        this.m_noButton.setToolTipText(Resource.getString("PROPERTY_NO_TEXT", "No"));
        if (stringArray.length == 2) {
            this.m_noButton.setMnemonic(stringArray[1].charAt(0));
        }
        this.m_yesButton.addActionListener(this);
        this.m_noButton.addActionListener(this);
        jPanel2.add(this.m_yesButton);
        jPanel2.add(this.m_noButton);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
        jPanel3.add((Component)jPanel, gridBagConstraints2);
        gridBagConstraints2.gridy = 1;
        jPanel3.add((Component)jPanel2, gridBagConstraints2);
        return jPanel3;
    }

    public void putIntoWizardData() {
        if (this.isReady()) {
            if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
                this.m_wizardData.put("UseCurrentSecurityKeyID", new Boolean(this.m_radioUseOldKeyID.isSelected()));
                if (this.m_radioUseOldKeyID.isSelected()) {
                    this.m_wizardData.put("SecurityKeyID", this.m_tfSecureKeyID.getText());
                } else {
                    this.m_wizardData.put("SecurityKeyID", this.m_tfNewSecureKeyID.getText());
                }
            }
            if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
                this.m_wizardData.put("EnterNewSecurityKey", new Boolean(this.m_radioEnterNewSecurityKey.isSelected()));
                if (this.m_radioEnterNewSecurityKey.isSelected()) {
                    this.m_wizardData.put("SecurityKey", this.m_tfSecurityKey.getText());
                    AuthenticationDialog authenticationDialog = new AuthenticationDialog((Window)this, this.m_adapterHelper, this.m_wizardData, false);
                }
            }
            boolean bl = true;
            this.m_wizardData.put("UsePassPhrase", new Boolean(this.m_chkBxUsePassPhrase.isSelected()));
            this.m_wizardData.put("PassPhrase", new String(this.m_tfConfirmPassPhrase.getPassword()));
            if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
                Object object;
                if (((Boolean)this.m_wizardData.get("EnterNewSecurityKey")).booleanValue()) {
                    bl = false;
                } else if (((Boolean)this.m_wizardData.get("UseCurrentSecurityKeyID")).booleanValue()) {
                    if (this.m_chkBxUsePassPhrase.isSelected()) {
                        System.out.println("Inside isselect");
                        bl = true;
                    } else {
                        if (!this.m_adapterHelper.isPassPhraseUsed() && !this.m_chkBxUsePassPhrase.isSelected()) {
                            this.dispose();
                            return;
                        }
                        if (this.m_adapterHelper.isPassPhraseUsed() && !this.m_chkBxUsePassPhrase.isSelected()) {
                            bl = true;
                        }
                    }
                    System.out.println("outside isselect");
                } else {
                    object = this.m_wizardData.get("SecurityKeyID").toString();
                    ((SASAdapter)this.m_adapterHelper.getDeviceObject()).setKeyIdForDevice((String)object);
                    this.dispose();
                    bl = false;
                }
                if (bl) {
                    object = new AuthenticationDialog((Window)this, this.m_adapterHelper, this.m_wizardData, false);
                }
            }
            this.enableorChangeSecurity();
        }
    }

    public void enableorChangeSecurity() {
        JFrame jFrame = new JFrame();
        boolean bl = false;
        if (this.m_adapterHelper.isLockKeyAssigned() && !this.m_switchToLKM) {
            if (this.m_radioEnterNewSecurityKey.isSelected() || this.m_chkBxUsePassPhrase.isSelected() || !this.m_chkBxUsePassPhrase.isSelected()) {
                String string = this.m_wizardData.get("SecurityKeyID").toString();
                String string2 = this.m_wizardData.get("CurrentSecurityKey").toString();
                String string3 = null;
                String string4 = null;
                if (!this.m_adapterHelper.getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().isBiosNotDetected() || VivaldiStartupDialog.OEM_TYPE != 2561 && !this.m_adapterHelper.isOnlyFDESupported()) {
                    String string5 = string4 = this.m_chkBxUsePassPhrase.isSelected() ? new String(this.m_tfConfirmPassPhrase.getPassword()) : null;
                }
                if (((Boolean)this.m_wizardData.get("EnterNewSecurityKey")).booleanValue()) {
                    string3 = this.m_wizardData.get("SecurityKey").toString();
                }
                try {
                    this.m_adapterHelper.fireRekeyOperation(string2, string3, string4, string, bl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, Resource.getString("REKEY", "Rekey operation failed."));
                }
            } else if (!this.m_radioEnterNewSecurityKey.isSelected()) {
                this.dispose();
                return;
            }
        } else {
            String string = this.m_tfSecureKeyID.getText();
            this.m_wizardData.put("SecurityKeyID", this.m_tfSecureKeyID.getText());
            String string6 = this.m_tfSecurityKey.getText();
            this.m_wizardData.put("SecurityKey", this.m_tfSecurityKey.getText());
            String string7 = null;
            if ((!this.m_adapterHelper.getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().isBiosNotDetected() || VivaldiStartupDialog.OEM_TYPE != 2561 && !this.m_adapterHelper.isOnlyFDESupported()) && this.m_chkBxUsePassPhrase.isSelected()) {
                char[] cArray = this.m_tfPassphrase.getPassword();
                string7 = new String(cArray);
            }
            this.m_wizardData.put("PassPhrase", string7);
            if (this.m_switchToLKM) {
                try {
                    this.m_adapterHelper.fireRekeyOperation(null, string6, string7, string, bl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, Resource.getString("REKEY", "Rekey operation failed."));
                }
            } else {
                this.m_adapterHelper.fireCreateKeyOperation(string, string6, string7, bl);
                try {
                    this.m_adapterHelper.getDeviceObject().refresh();
                }
                catch (VKNotRespondingException vKNotRespondingException) {
                    vKNotRespondingException.printStackTrace();
                }
                catch (VKOperationFailedException vKOperationFailedException) {
                    vKOperationFailedException.printStackTrace();
                }
            }
        }
        this.dispose();
    }

    public boolean isReady() {
        if (!this.m_switchToLKM) {
            if (this.m_adapterHelper.isLockKeyAssigned() && this.m_radioEnterNewKeyID.isSelected()) {
                if (this.m_tfNewSecureKeyID.getText().length() == 0) {
                    JOptionPane.showMessageDialog(this, Resource.getString("MSG_INVALID_INPUT", "Invalid Input Specified !"), Resource.getString("MSG_INVALID_CMD", "Invalid Operation"), 0);
                    return false;
                }
            } else if (this.m_tfSecureKeyID.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, Resource.getString("MSG_INVALID_INPUT", "Invalid Input Specified !"), Resource.getString("MSG_INVALID_CMD", "Invalid Operation"), 0);
                return false;
            }
        }
        if (!this.m_adapterHelper.isLockKeyAssigned() || this.m_radioEnterNewSecurityKey != null && this.m_radioEnterNewSecurityKey.isSelected() || this.m_switchToLKM) {
            if (!this.m_tfSecurityKey.getText().equals(this.m_tfConfirmSecurityKey.getText())) {
                if (VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported()) {
                    JOptionPane.showMessageDialog(this, Resource.getString("ERROR_PASSWORD_MISMATCH", "The characters entered in the Password field and the confirm\nfield do not match.\n\nPlease re-enter and confirm your Password."), Resource.getString("TITLE_PASSPHRASE_MISMATCH", "Password Mismatch"), 0);
                } else {
                    JOptionPane.showMessageDialog(this, Resource.getString("ERROR_SECURITY_KEY_MISMATCH", "The characters entered in the security key field and the confirm\nfield do not match.\n\nPlease re-enter and confirm your security key."), Resource.getString("TITLE_SECURITY_KEY_MISMATCH", "Security Key Mismatch"), 0);
                }
                return false;
            }
            if (this.m_strSuggestedSecurityKey != null) {
                if (!this.m_strSuggestedSecurityKey.equals(this.m_tfSecurityKey.getText()) && !PassPhraseVerifier.isValidPassPhrase(this.m_tfSecurityKey.getText())) {
                    String string = null;
                    String string2 = null;
                    if (VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported()) {
                        string = Resource.getString("ERROR_INVALID_PASSPHRASE", "The Password entered either uses an invalid character or does\nnot meet the minimum security requirements.\n\nThe Password is case-sensitive. It must be between eight and\nthirty-two characters and contain at least one number, one\nlowercase letter, one uppercase letter, and one non-alphanumeric\ncharacter (e.g. < > @ +).\n\nThe space character is not permitted in the Password.\n\nPlease specify a Password that meets the above requirements.\n\n");
                        string2 = Resource.getString("TITLE_INVALID_PASSPHRASE", "Invalid Password");
                    } else {
                        string = Resource.getString("ERROR_INVALID_SECURITY_KEY", "The security key entered either uses an invalid character or does\nnot meet the minimum security requirements.\n\nThe security key is case-sensitive. It must be between eight and\nthirty-two characters and contain at least one number, one\nlowercase letter, one uppercase letter, and one non-alphanumeric\ncharacter (e.g. < > @ +).\n\nThe space character is not permitted in the Password.\n\nPlease specify a security key that meets the above requirements.\n\n");
                        string2 = Resource.getString("TITLE_INVALID_SECURITY_KEY", "Invalid Security Key");
                    }
                    JOptionPane.showMessageDialog(this, string, string2, 0);
                    return false;
                }
            } else if (!PassPhraseVerifier.isValidPassPhrase(this.m_tfSecurityKey.getText())) {
                String string = null;
                String string3 = null;
                if (VivaldiStartupDialog.OEM_TYPE == 2561 && this.m_adapterHelper.isOnlyFDESupported()) {
                    string = Resource.getString("ERROR_INVALID_PASSPHRASE", "The Password entered either uses an invalid character or does\nnot meet the minimum security requirements.\n\nThe Password is case-sensitive. It must be between eight and\nthirty-two characters and contain at least one number, one\nlowercase letter, one uppercase letter, and one non-alphanumeric\ncharacter (e.g. < > @ +).\n\nThe space character is not permitted in the Password.\n\nPlease specify a Password that meets the above requirements.\n\n");
                    string3 = Resource.getString("TITLE_INVALID_PASSPHRASE", "Invalid Password");
                } else {
                    string = Resource.getString("ERROR_INVALID_SECURITY_KEY", "The security key entered either uses an invalid character or does\nnot meet the minimum security requirements.\n\nThe security key is case-sensitive. It must be between eight and\nthirty-two characters and contain at least one number, one\nlowercase letter, one uppercase letter, and one non-alphanumeric\ncharacter (e.g. < > @ +).\n\nThe space character is not permitted in the Password.\n\nPlease specify a security key that meets the above requirements.\n\n");
                    string3 = Resource.getString("TITLE_INVALID_SECURITY_KEY", "Invalid Security Key");
                }
                JOptionPane.showMessageDialog(this, string, string3, 0);
                return false;
            }
        }
        if ((!this.m_adapterHelper.getAdapterInfo().getAdapterStatus_MR_CTRL_INFO().isBiosNotDetected() || VivaldiStartupDialog.OEM_TYPE != 2561 && !this.m_adapterHelper.isOnlyFDESupported()) && this.m_chkBxUsePassPhrase.isSelected()) {
            String string = new String(this.m_tfPassphrase.getPassword());
            String string4 = new String(this.m_tfConfirmPassPhrase.getPassword());
            if (string.length() == 0 || string.length() < 8 || string.length() > 32 || string4.length() == 0 || string4.length() < 8 || string.length() > 32) {
                JOptionPane.showMessageDialog(this, Resource.getString("ERROR_INVALID_PASSPHRASE_UNSTRONG", "The pass phrase entered either uses an invalid character or does\nnot meet the minimum security requirements.\n\n The pass phrase is case-sensitive. It must be between eight and\nthirty-two characters.\t\n\n Please specify a pass phrase that meets the above requirements.\n\n"), Resource.getString("TITLE_INVALID_PASSPHRASE", "Invalid Password"), 0);
                return false;
            }
            if (!string.equals(string4)) {
                JOptionPane.showMessageDialog(this, Resource.getString("ERROR_PASSWORD_MISMATCH", "The characters entered in the Password field and the confirm\nfield do not match.\n\nPlease re-enter and confirm your Password."), Resource.getString("TITLE_PASSPHRASE_MISMATCH", "Password Mismatch"), 0);
                return false;
            }
            if (this.m_chkBxStrongPWD.isSelected() && !PassPhraseVerifier.isValidPassPhrase(string)) {
                JOptionPane.showMessageDialog(this, Resource.getString("ERROR_INVALID_PASSPHRASE", "The Password entered either uses an invalid character or does\nnot meet the minimum security requirements.\n\nThe Password is case-sensitive. It must be between eight and\nthirty-two characters and contain at least one number, one\nlowercase letter, one uppercase letter, and one non-alphanumeric\ncharacter (e.g. < > @ +).\n\nThe space character is not permitted in the Password.\n\nPlease specify a Password that meets the above requirements.\n\n"), Resource.getString("TITLE_INVALID_PASSPHRASE", "Invalid Password"), 0);
                return false;
            }
        }
        if (!this.m_chkBxRecord.isSelected()) {
            JOptionPane.showMessageDialog(this, Resource.getString("ERROR_NOT_RECORDED", "Be Sure record this Information"), Resource.getString("CHECK_THE_CHECKBOX"), 0);
            return false;
        }
        return true;
    }

    public void disableSuggestButton() {
        String string = this.m_tfSecurityKey.getText();
        if (string != null && string.length() > 0) {
            this.m_btnSuggestSecurityKey.setEnabled(false);
        } else {
            this.m_btnSuggestSecurityKey.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_btnSuggestSecurityKey)) {
            this.m_strSuggestedSecurityKey = ((SASAdapter)this.m_adapterHelper.getDeviceObject()).suggestPassPhrase();
            this.m_tfSecurityKey.setText(this.m_strSuggestedSecurityKey);
        }
        if (actionEvent.getSource().equals(this.m_chkBxUsePassPhrase)) {
            this.m_tfPassphrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
            this.m_tfConfirmPassPhrase.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
            this.m_chkBxStrongPWD.setEnabled(this.m_chkBxUsePassPhrase.isSelected());
        }
        if (actionEvent.getSource().equals(this.m_chkBxRecord)) {
            this.m_yesButton.setEnabled(this.m_chkBxRecord.isSelected());
        }
        if (actionEvent.getSource().equals(this.m_noButton)) {
            this.dispose();
        }
        if (actionEvent.getSource().equals(this.m_yesButton)) {
            this.putIntoWizardData();
        }
    }

    JLabel getTitleBorder(String string, String string2) {
        JLabel jLabel = new JLabel(string2);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.DARK_GRAY), string);
        jLabel.setBorder(titledBorder);
        return jLabel;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.disableSuggestButton();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.disableSuggestButton();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.disableSuggestButton();
    }
}

