/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Array;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.OrderedSet;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.xHashComparator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

final class Tree
implements Serializable {
    public static final int RED = 1;
    public static final int BLACK = 2;
    TreeNode NIL = new TreeNode();
    int size;
    boolean myInsertAlways;
    boolean myIsMap;
    BinaryPredicate myComparator;
    Container myContainer;
    TreeNode myHeader = new TreeNode();
    static final long serialVersionUID = -7780623882639425521L;

    Tree(boolean bl, boolean bl2, Container container) {
        this(bl, bl2, (BinaryPredicate)new xHashComparator(), container);
    }

    Tree(boolean bl, boolean bl2, BinaryPredicate binaryPredicate, Container container) {
        this.myContainer = container;
        this.myIsMap = bl;
        this.myInsertAlways = bl2;
        this.myComparator = binaryPredicate;
        this.myHeader.color = 1;
        this.clear();
    }

    Tree(Tree tree, Container container) {
        this.myContainer = container;
        this.myIsMap = tree.myIsMap;
        this.myInsertAlways = tree.myInsertAlways;
        this.myComparator = tree.myComparator;
        this.myHeader.color = 1;
        this.copyTree(tree);
    }

    boolean compare(Object object, Object object2) {
        return this.myComparator.execute(object, object2);
    }

    Object key(Object object) {
        return this.myIsMap ? ((Pair)object).first : object;
    }

    Object value(Object object) {
        if (this.myIsMap) {
            if (object == null) {
                return null;
            }
            return ((Pair)object).second;
        }
        return object;
    }

    void copy(Tree tree) {
        if (this != tree) {
            this.clear();
            this.copyTree(tree);
        }
    }

    OrderedSetIterator beginSet() {
        return new OrderedSetIterator(this, this.myHeader.left, (OrderedSet)this.myContainer);
    }

    OrderedSetIterator endSet() {
        return new OrderedSetIterator(this, this.myHeader, (OrderedSet)this.myContainer);
    }

    OrderedMapIterator beginMap(int n) {
        return new OrderedMapIterator(this, this.myHeader.left, (OrderedMap)this.myContainer, n);
    }

    OrderedMapIterator endMap(int n) {
        return new OrderedMapIterator(this, this.myHeader, (OrderedMap)this.myContainer, n);
    }

    int maxSize() {
        return Integer.MAX_VALUE;
    }

    TreeNode insert(TreeNode treeNode, Object object) {
        if (treeNode == this.myHeader.left) {
            if (this.size > 0 && this.compare(this.key(object), this.key(treeNode.object))) {
                return this.insert(treeNode, treeNode, object);
            }
            return this.insert((Object)object).node;
        }
        if (treeNode == this.myHeader) {
            if (this.compare(this.key(this.myHeader.right.object), this.key(object))) {
                return this.insert(this.NIL, this.myHeader.right, object);
            }
            return this.insert((Object)object).node;
        }
        TreeNode treeNode2 = Tree.decrement(treeNode, this.NIL);
        if (this.compare(this.key(treeNode2.object), this.key(object)) && this.compare(this.key(object), this.key(treeNode.object))) {
            if (treeNode2.right == this.NIL) {
                return this.insert(this.NIL, treeNode2, object);
            }
            return this.insert(treeNode, treeNode, object);
        }
        return this.insert((Object)object).node;
    }

    void clear() {
        this.myHeader.parent = this.NIL;
        this.myHeader.right = this.myHeader;
        this.myHeader.left = this.myHeader;
        this.size = 0;
    }

    Pair remove(Object object) {
        Pair pair = this.equalRange(object);
        return this.remove((TreeNode)pair.first, (TreeNode)pair.second, this.size);
    }

    Pair remove(Object object, int n) {
        Pair pair = this.equalRange(object);
        return this.remove((TreeNode)pair.first, (TreeNode)pair.second, n);
    }

    Pair remove(TreeNode treeNode, TreeNode treeNode2) {
        return this.remove(treeNode, treeNode2, this.size);
    }

    /*
     * Unable to fully structure code
     */
    Pair remove(TreeNode var1_1, TreeNode var2_2, int var3_3) {
        block3: {
            if (var3_3 <= 0) {
                return new Pair(null, new Integer(0));
            }
            var4_4 = 0;
            var5_5 = null;
            if (var1_1 != this.myHeader.left || var2_2 != this.myHeader || this.size > var3_3) ** GOTO lbl18
            var4_4 = this.size;
            var5_5 = this.value(var1_1.object);
            this.clear();
            break block3;
lbl-1000:
            // 1 sources

            {
                if (var4_4 == 0) {
                    var5_5 = this.value(var1_1.object);
                }
                --var3_3;
                ++var4_4;
                var6_6 = Tree.increment(var1_1, this.NIL);
                this.remove(var1_1);
                var1_1 = var6_6;
lbl18:
                // 2 sources

                ** while (var3_3 > 0 && var1_1 != var2_2)
            }
        }
        return new Pair(var5_5, new Integer(var4_4));
    }

    TreeNode find(Object object) {
        TreeNode treeNode = this.lowerBound(object);
        return treeNode == this.myHeader || this.compare(object, this.key(treeNode.object)) ? this.myHeader : treeNode;
    }

    int count(Object object) {
        Pair pair = this.equalRange(object);
        return Tree.distance((TreeNode)pair.first, (TreeNode)pair.second, this.NIL);
    }

    TreeNode lowerBound(Object object) {
        return (TreeNode)this.equalRange((Object)object).first;
    }

    TreeNode upperBound(Object object) {
        return (TreeNode)this.equalRange((Object)object).second;
    }

    Pair equalRange(Object object) {
        TreeNode treeNode = this.lowerBoundAux(object);
        TreeNode treeNode2 = this.upperBoundAux(object);
        if (treeNode2 == this.myHeader) {
            return new Pair(treeNode, treeNode2);
        }
        if (treeNode == this.myHeader) {
            return new Pair(treeNode2, treeNode);
        }
        TreeNode treeNode3 = treeNode;
        TreeNode treeNode4 = treeNode2;
        do {
            treeNode3 = Tree.increment(treeNode3, this.NIL);
            if ((treeNode4 = Tree.increment(treeNode4, this.NIL)) != this.myHeader && treeNode3 != treeNode2) continue;
            return new Pair(treeNode, treeNode2);
        } while (treeNode3 != this.myHeader && treeNode != treeNode4);
        return new Pair(treeNode2, treeNode);
    }

    TreeNode lowerBoundAux(Object object) {
        TreeNode treeNode = this.myHeader;
        TreeNode treeNode2 = this.myHeader.parent;
        boolean bl = false;
        while (treeNode2 != this.NIL) {
            treeNode = treeNode2;
            bl = this.compare(this.key(treeNode2.object), object);
            TreeNode treeNode3 = treeNode2 = bl ? treeNode2.right : treeNode2.left;
        }
        return bl ? Tree.increment(treeNode, this.NIL) : treeNode;
    }

    TreeNode upperBoundAux(Object object) {
        TreeNode treeNode = this.myHeader;
        TreeNode treeNode2 = this.myHeader.parent;
        boolean bl = true;
        while (treeNode2 != this.NIL) {
            treeNode = treeNode2;
            bl = this.compare(object, this.key(treeNode2.object));
            TreeNode treeNode3 = treeNode2 = bl ? treeNode2.left : treeNode2.right;
        }
        return bl ? treeNode : Tree.increment(treeNode, this.NIL);
    }

    void insert(InputIterator inputIterator, InputIterator inputIterator2) {
        InputIterator inputIterator3 = (InputIterator)inputIterator.clone();
        while (!inputIterator3.equals(inputIterator2)) {
            this.insert(inputIterator3.nextElement());
        }
    }

    InsertResult insertAux(Object object, boolean bl) {
        TreeNode treeNode = this.myHeader;
        TreeNode treeNode2 = this.myHeader.parent;
        boolean bl2 = true;
        while (treeNode2 != this.NIL) {
            treeNode = treeNode2;
            bl2 = this.compare(this.key(object), this.key(treeNode2.object));
            TreeNode treeNode3 = treeNode2 = bl2 ? treeNode2.left : treeNode2.right;
        }
        if (this.myInsertAlways && bl) {
            return new InsertResult(this.insert(treeNode2, treeNode, object), true);
        }
        TreeNode treeNode4 = treeNode;
        if (bl2) {
            if (treeNode4 == this.myHeader.left) {
                return new InsertResult(this.insert(treeNode2, treeNode, object), true);
            }
            treeNode4 = Tree.decrement(treeNode4, this.NIL);
        }
        if (this.compare(this.key(treeNode4.object), this.key(object))) {
            return new InsertResult(this.insert(treeNode2, treeNode, object), true);
        }
        return new InsertResult(treeNode4, false);
    }

    InsertResult insert(Object object) {
        return this.insertAux(object, true);
    }

    InsertResult put(Object object) {
        return this.insertAux(object, false);
    }

    Object get(Object object) {
        TreeNode treeNode = this.myHeader;
        TreeNode treeNode2 = this.myHeader.parent;
        boolean bl = true;
        while (treeNode2 != this.NIL) {
            treeNode = treeNode2;
            bl = this.compare(object, this.key(treeNode2.object));
            TreeNode treeNode3 = treeNode2 = bl ? treeNode2.left : treeNode2.right;
        }
        TreeNode treeNode4 = treeNode;
        if (bl) {
            if (treeNode4 == this.myHeader.left) {
                return null;
            }
            treeNode4 = Tree.decrement(treeNode4, this.NIL);
        }
        if (this.compare(this.key(treeNode4.object), object)) {
            return null;
        }
        return ((Pair)treeNode4.object).second;
    }

    TreeNode insert(TreeNode treeNode, TreeNode treeNode2, Object object) {
        ++this.size;
        TreeNode treeNode3 = new TreeNode(object);
        boolean bl = treeNode2 == this.myHeader || treeNode != this.NIL || this.compare(this.key(object), this.key(treeNode2.object));
        this.insert(bl, treeNode, treeNode2, treeNode3);
        return treeNode3;
    }

    static int distance(TreeNode treeNode, TreeNode treeNode2, TreeNode treeNode3) {
        int n = 0;
        while (treeNode != treeNode2) {
            treeNode = Tree.increment(treeNode, treeNode3);
            ++n;
        }
        return n;
    }

    TreeNode copyTree(TreeNode treeNode, TreeNode treeNode2, TreeNode treeNode3) {
        if (treeNode == treeNode3) {
            return this.NIL;
        }
        TreeNode treeNode4 = new TreeNode(treeNode.object);
        treeNode4.color = treeNode.color;
        treeNode4.left = this.copyTree(treeNode.left, treeNode4, treeNode3);
        treeNode4.right = this.copyTree(treeNode.right, treeNode4, treeNode3);
        treeNode4.parent = treeNode2;
        return treeNode4;
    }

    void copyTree(Tree tree) {
        this.myHeader.parent = this.copyTree(tree.myHeader.parent, this.myHeader, tree.NIL);
        this.myHeader.left = this.minimum(this.myHeader.parent);
        this.myHeader.right = this.maximum(this.myHeader.parent);
        this.size = tree.size;
    }

    Array keys() {
        Array array = new Array();
        boolean bl = false;
        TreeNode treeNode = this.myHeader.left;
        while (treeNode != this.myHeader) {
            array.add(((Pair)treeNode.object).first);
            treeNode = Tree.increment(treeNode, this.NIL);
        }
        return array;
    }

    Array keys(Object object) {
        Array array = new Array();
        boolean bl = false;
        TreeNode treeNode = this.myHeader.left;
        while (treeNode != this.myHeader) {
            if (((Pair)treeNode.object).second.equals(object)) {
                array.add(((Pair)treeNode.object).first);
            }
            treeNode = Tree.increment(treeNode, this.NIL);
        }
        return array;
    }

    Array values(Object object) {
        Array array = new Array();
        Pair pair = this.equalRange(object);
        TreeNode treeNode = (TreeNode)pair.first;
        TreeNode treeNode2 = (TreeNode)pair.second;
        while (treeNode != treeNode2) {
            array.add(((Pair)treeNode.object).second);
            treeNode = Tree.increment(treeNode, this.NIL);
        }
        return array;
    }

    /*
     * Unable to fully structure code
     */
    static TreeNode increment(TreeNode var0, TreeNode var1_1) {
        if (var0.right == var1_1) ** GOTO lbl8
        var0 = var0.right;
        while (var0.left != var1_1) {
            var0 = var0.left;
        }
        return var0;
lbl-1000:
        // 1 sources

        {
            var0 = var0.parent;
lbl8:
            // 2 sources

            ** while (var0 == var0.parent.right)
        }
lbl9:
        // 1 sources

        return var0.right == var0.parent ? var0 : var0.parent;
    }

    /*
     * Unable to fully structure code
     */
    static TreeNode decrement(TreeNode var0, TreeNode var1_1) {
        if (var0.color == 1 && var0.parent.parent == var0) {
            return var0.right;
        }
        if (var0.left == var1_1) ** GOTO lbl10
        var0 = var0.left;
        while (var0.right != var1_1) {
            var0 = var0.right;
        }
        return var0;
lbl-1000:
        // 1 sources

        {
            var0 = var0.parent;
lbl10:
            // 2 sources

            ** while (var0 == var0.parent.left)
        }
lbl11:
        // 1 sources

        return var0.parent;
    }

    /*
     * Unable to fully structure code
     */
    TreeNode minimum(TreeNode var1_1) {
        if (var1_1 != this.NIL) ** GOTO lbl4
        return this.myHeader;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.left;
lbl4:
            // 2 sources

            ** while (var1_1.left != this.NIL)
        }
lbl5:
        // 1 sources

        return var1_1;
    }

    /*
     * Unable to fully structure code
     */
    TreeNode maximum(TreeNode var1_1) {
        if (var1_1 != this.NIL) ** GOTO lbl4
        return this.myHeader;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.right;
lbl4:
            // 2 sources

            ** while (var1_1.right != this.NIL)
        }
lbl5:
        // 1 sources

        return var1_1;
    }

    void rotateLeft(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode.right;
        treeNode.right = treeNode2.left;
        if (treeNode2.left != this.NIL) {
            treeNode2.left.parent = treeNode;
        }
        treeNode2.parent = treeNode.parent;
        if (treeNode == this.myHeader.parent) {
            this.myHeader.parent = treeNode2;
        } else if (treeNode == treeNode.parent.left) {
            treeNode.parent.left = treeNode2;
        } else {
            treeNode.parent.right = treeNode2;
        }
        treeNode2.left = treeNode;
        treeNode.parent = treeNode2;
    }

    void rotateRight(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode.left;
        treeNode.left = treeNode2.right;
        if (treeNode2.right != this.NIL) {
            treeNode2.right.parent = treeNode;
        }
        treeNode2.parent = treeNode.parent;
        if (treeNode == this.myHeader.parent) {
            this.myHeader.parent = treeNode2;
        } else if (treeNode == treeNode.parent.right) {
            treeNode.parent.right = treeNode2;
        } else {
            treeNode.parent.left = treeNode2;
        }
        treeNode2.right = treeNode;
        treeNode.parent = treeNode2;
    }

    void insert(boolean bl, TreeNode treeNode, TreeNode treeNode2, TreeNode treeNode3) {
        if (bl) {
            treeNode2.left = treeNode3;
            if (treeNode2 == this.myHeader) {
                this.myHeader.parent = treeNode3;
                this.myHeader.right = treeNode3;
            } else if (treeNode2 == this.myHeader.left) {
                this.myHeader.left = treeNode3;
            }
        } else {
            treeNode2.right = treeNode3;
            if (treeNode2 == this.myHeader.right) {
                this.myHeader.right = treeNode3;
            }
        }
        treeNode3.parent = treeNode2;
        treeNode3.left = this.NIL;
        treeNode3.right = this.NIL;
        treeNode = treeNode3;
        treeNode.color = 1;
        while (treeNode != this.myHeader.parent && treeNode.parent.color == 1) {
            if (treeNode.parent == treeNode.parent.parent.left) {
                treeNode2 = treeNode.parent.parent.right;
                if (treeNode2.color == 1) {
                    treeNode.parent.color = 2;
                    treeNode2.color = 2;
                    treeNode.parent.parent.color = 1;
                    treeNode = treeNode.parent.parent;
                    continue;
                }
                if (treeNode == treeNode.parent.right) {
                    treeNode = treeNode.parent;
                    this.rotateLeft(treeNode);
                }
                treeNode.parent.color = 2;
                treeNode.parent.parent.color = 1;
                this.rotateRight(treeNode.parent.parent);
                continue;
            }
            treeNode2 = treeNode.parent.parent.left;
            if (treeNode2.color == 1) {
                treeNode.parent.color = 2;
                treeNode2.color = 2;
                treeNode.parent.parent.color = 1;
                treeNode = treeNode.parent.parent;
                continue;
            }
            if (treeNode == treeNode.parent.left) {
                treeNode = treeNode.parent;
                this.rotateRight(treeNode);
            }
            treeNode.parent.color = 2;
            treeNode.parent.parent.color = 1;
            this.rotateLeft(treeNode.parent.parent);
        }
        this.myHeader.parent.color = 2;
    }

    TreeNode remove(TreeNode treeNode) {
        TreeNode treeNode2;
        TreeNode treeNode3 = treeNode;
        if (treeNode3.left == this.NIL) {
            treeNode2 = treeNode3.right;
        } else if (treeNode3.right == this.NIL) {
            treeNode2 = treeNode3.left;
        } else {
            treeNode3 = treeNode3.right;
            while (treeNode3.left != this.NIL) {
                treeNode3 = treeNode3.left;
            }
            treeNode2 = treeNode3.right;
        }
        if (treeNode3 != treeNode) {
            treeNode.left.parent = treeNode3;
            treeNode3.left = treeNode.left;
            if (treeNode3 != treeNode.right) {
                treeNode2.parent = treeNode3.parent;
                treeNode3.parent.left = treeNode2;
                treeNode3.right = treeNode.right;
                treeNode.right.parent = treeNode3;
            } else {
                treeNode2.parent = treeNode3;
            }
            if (this.myHeader.parent == treeNode) {
                this.myHeader.parent = treeNode3;
            } else if (treeNode.parent.left == treeNode) {
                treeNode.parent.left = treeNode3;
            } else {
                treeNode.parent.right = treeNode3;
            }
            treeNode3.parent = treeNode.parent;
            int n = treeNode3.color;
            treeNode3.color = treeNode.color;
            treeNode.color = n;
            treeNode3 = treeNode;
        } else {
            treeNode2.parent = treeNode3.parent;
            if (this.myHeader.parent == treeNode) {
                this.myHeader.parent = treeNode2;
            } else if (treeNode.parent.left == treeNode) {
                treeNode.parent.left = treeNode2;
            } else {
                treeNode.parent.right = treeNode2;
            }
            if (this.myHeader.left == treeNode) {
                this.myHeader.left = treeNode.right == this.NIL ? treeNode.parent : this.minimum(treeNode2);
            }
            if (this.myHeader.right == treeNode) {
                this.myHeader.right = treeNode.left == this.NIL ? treeNode.parent : this.maximum(treeNode2);
            }
        }
        if (treeNode3.color != 1) {
            while (treeNode2 != this.myHeader.parent && treeNode2.color == 2) {
                if (treeNode2 == treeNode2.parent.left) {
                    TreeNode treeNode4 = treeNode2.parent.right;
                    if (treeNode4.color == 1) {
                        treeNode4.color = 2;
                        treeNode2.parent.color = 1;
                        this.rotateLeft(treeNode2.parent);
                        treeNode4 = treeNode2.parent.right;
                    }
                    if (treeNode4.left.color == 2 && treeNode4.right.color == 2) {
                        treeNode4.color = 1;
                        treeNode2 = treeNode2.parent;
                        continue;
                    }
                    if (treeNode4.right.color == 2) {
                        treeNode4.left.color = 2;
                        treeNode4.color = 1;
                        this.rotateRight(treeNode4);
                        treeNode4 = treeNode2.parent.right;
                    }
                    treeNode4.color = treeNode2.parent.color;
                    treeNode2.parent.color = 2;
                    treeNode4.right.color = 2;
                    this.rotateLeft(treeNode2.parent);
                    break;
                }
                TreeNode treeNode5 = treeNode2.parent.left;
                if (treeNode5.color == 1) {
                    treeNode5.color = 2;
                    treeNode2.parent.color = 1;
                    this.rotateRight(treeNode2.parent);
                    treeNode5 = treeNode2.parent.left;
                }
                if (treeNode5.right.color == 2 && treeNode5.left.color == 2) {
                    treeNode5.color = 1;
                    treeNode2 = treeNode2.parent;
                    continue;
                }
                if (treeNode5.left.color == 2) {
                    treeNode5.right.color = 2;
                    treeNode5.color = 1;
                    this.rotateLeft(treeNode5);
                    treeNode5 = treeNode2.parent.left;
                }
                treeNode5.color = treeNode2.parent.color;
                treeNode2.parent.color = 2;
                treeNode5.left.color = 2;
                this.rotateRight(treeNode2.parent);
                break;
            }
            treeNode2.color = 2;
        }
        --this.size;
        return treeNode3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.size < 2) {
            return;
        }
        boolean bl = true;
        TreeNode treeNode = this.myHeader.left;
        int n = 1;
        while (bl && n < this.size) {
            TreeNode treeNode2 = Tree.increment(treeNode, this.NIL);
            bl = this.compare(this.key(treeNode.object), this.key(treeNode2.object));
            treeNode = treeNode2;
            ++n;
        }
        if (bl) {
            return;
        }
        treeNode = this.myHeader.left;
        int n2 = this.size;
        this.clear();
        while (n2-- > 0) {
            this.insert(treeNode.object);
            treeNode = Tree.increment(treeNode, this.NIL);
        }
    }

    final class TreeNode
    implements Serializable {
        public int color = 2;
        public TreeNode parent;
        public TreeNode left;
        public TreeNode right;
        public Object object;

        public TreeNode() {
        }

        public TreeNode(Object object) {
            this.object = object;
        }
    }

    final class InsertResult {
        public boolean ok;
        public TreeNode node;

        public InsertResult(TreeNode treeNode, boolean bl) {
            this.ok = bl;
            this.node = treeNode;
        }
    }
}

