/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.help3;

import com.webworks.help3.ColorUtils;
import com.webworks.help3.DirectionButton;
import com.webworks.help3.GeneralUtils;
import com.webworks.help3.PropertyChangeSupport;
import com.webworks.help3.VetoableChangeSupport;
import com.webworks.help3.WWHelp;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Vector;

public abstract class BaseTabbedPanel
extends Panel
implements MouseListener,
ActionListener {
    public Color backgroundColor;
    public Color tabFgColor1;
    public Color tabBgColor1;
    public Color tabFgColor2;
    public Color tabBgColor2;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int ROUNDED = 0;
    public static final int SQUARE = 1;
    protected int curIndex = -1;
    protected transient boolean suppressRepaints = false;
    protected Vector vPolys;
    protected int firstVisibleTab = 0;
    protected DirectionButton dbLeft;
    protected DirectionButton dbRight;
    protected Polygon nullPoly;
    protected Vector vLabels;
    protected Color borderDarkerColor = null;
    protected Color borderLightColor = null;
    protected Color borderDarkColor = null;
    protected Color disabledTextColor = null;
    protected Color cachedForeground = null;
    protected Color cachedBackground = null;
    protected int TF_LEFT = 4;
    protected int TF_RIGHT = -4;
    protected int TF_TOP = 34;
    protected int TF_BOTTOM = -4;
    protected int TF_BTN_HEIGHT = 0;
    private Vector vEnabled;
    protected Font fReg;
    protected Font fSel;
    private Component userPanel = null;
    private int iTabsPosition = 0;
    private int iTabsStyle = 0;
    private transient int osAdjustment;
    private int lastWidth = -1;
    private Insets btpInsets;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public BaseTabbedPanel() {
        this(0, 0);
    }

    public BaseTabbedPanel(boolean bl) {
        this(bl ? 0 : 1, bl ? 0 : 1);
    }

    public BaseTabbedPanel(int n, int n2) {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.btpInsets = new Insets(0, 0, 0, 0);
        this.setTabsInfo(n, n2);
        if (WWHelp.getSecurityType().equals("ms_ie")) {
            this.fReg = WWHelp.getFontX(WWHelp.fontName, 0, WWHelp.fontSize);
            this.fSel = WWHelp.getFontX(WWHelp.fontName, 1, WWHelp.fontSize);
        } else {
            this.fReg = new Font(WWHelp.fontName, 0, WWHelp.fontSize);
            this.fSel = new Font(WWHelp.fontName, 1, WWHelp.fontSize);
        }
        this.osAdjustment = System.getProperty("os.name").startsWith("S") ? -1 : 0;
        super.setLayout(null);
        this.dbLeft = new DirectionButton(0);
        this.dbRight = new DirectionButton(1);
        try {
            this.dbLeft.setShowFocus(false);
            this.dbRight.setShowFocus(false);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.dbLeft.shrinkTriangle(1, 1, 0, 1);
        this.dbRight.shrinkTriangle(1, 1, 0, 1);
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.nullPoly = new Polygon();
        this.nullPoly.addPoint(0, 0);
        this.nullPoly.addPoint(1, 1);
        this.nullPoly.addPoint(0, 0);
        this.cachedForeground = this.getForeground();
        this.cachedBackground = this.getBackground();
    }

    public void setTabsPosition(int n) throws PropertyVetoException {
        if (this.iTabsPosition != n) {
            Integer n2 = new Integer(this.iTabsPosition);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("TabsPosition", n2, n3);
            this.setTabsInfo(n, this.iTabsStyle);
            this.changes.firePropertyChange("TabsPosition", n2, n3);
        }
    }

    public int getTabsPosition() {
        return this.iTabsPosition;
    }

    public void setTabsStyle(int n) throws PropertyVetoException {
        if (this.iTabsStyle != n) {
            Integer n2 = new Integer(this.iTabsStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("TabsStyle", n2, n3);
            this.setTabsInfo(this.iTabsPosition, n);
            this.changes.firePropertyChange("TabsStyle", n2, n3);
        }
    }

    public int getTabsStyle() {
        return this.iTabsStyle;
    }

    public void setTabsInfo(int n, int n2) {
        this.iTabsPosition = n;
        this.iTabsStyle = this.iTabsPosition == 0 ? 0 : n2;
        this.TF_BTN_HEIGHT = this.iTabsStyle == 0 ? 24 : 21;
        this.triggerRepaint();
    }

    public boolean setSuppressRepaints(boolean bl) {
        boolean bl2 = this.suppressRepaints;
        this.suppressRepaints = bl;
        return bl2;
    }

    protected void triggerRepaint() {
        if (!this.suppressRepaints) {
            this.repaint();
        }
    }

    public void setPanel(Component component) throws PropertyVetoException {
        Component component2 = this.userPanel;
        this.vetos.fireVetoableChange("Panel", component2, component);
        this.removeAll();
        this.userPanel = component;
        if (this.userPanel != null) {
            super.add(this.userPanel, -1);
            this.userPanel.requestFocus();
        }
        this.changes.firePropertyChange("Panel", component2, component);
    }

    public synchronized void setTab(String string, boolean bl, int n) throws PropertyVetoException {
        boolean bl2 = this.setSuppressRepaints(true);
        try {
            this.setLabel(string, n);
            this.setEnabled(bl, n);
        }
        finally {
            Object var6_5 = null;
            this.setSuppressRepaints(bl2);
        }
        this.triggerRepaint();
    }

    public synchronized void setLabel(String string, int n) throws PropertyVetoException {
        if (n < 0 || n >= this.vLabels.size()) {
            return;
        }
        try {
            String string2 = (String)this.vLabels.elementAt(n);
            this.vetos.fireVetoableChange("Label", string2, string);
            this.vLabels.setElementAt(string, n);
            this.triggerRepaint();
            this.changes.firePropertyChange("Label", string2, string);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public synchronized String getLabel(int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return "";
        }
        try {
            return (String)this.vLabels.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "";
        }
    }

    public synchronized void setEnabled(boolean bl, int n) throws PropertyVetoException {
        if (n < 0 || n >= this.vLabels.size()) {
            return;
        }
        if (n == this.curIndex && !bl) {
            return;
        }
        try {
            Boolean bl2 = (Boolean)this.vEnabled.elementAt(n);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("Enabled", bl2, bl3);
            this.vEnabled.setElementAt(bl3, n);
            this.triggerRepaint();
            this.changes.firePropertyChange("Enabled", bl2, bl3);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public boolean isEnabled(int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return false;
        }
        try {
            Boolean bl = (Boolean)this.vEnabled.elementAt(n);
            if (bl.booleanValue()) {
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return false;
    }

    public void setCurrentTab(int n) throws PropertyVetoException {
        if (n < 0 || n >= this.vLabels.size() || n == this.curIndex) {
            return;
        }
        if (this.isEnabled(n)) {
            boolean bl = this.setSuppressRepaints(true);
            try {
                Integer n2 = new Integer(this.curIndex);
                Integer n3 = new Integer(n);
                this.vetos.fireVetoableChange("CurrentTab", n2, n3);
                this.curIndex = n;
                this.firstVisibleTab = this.calculateMakeTabVisible(n);
                this.changes.firePropertyChange("CurrentTab", n2, n3);
            }
            finally {
                Object var4_5 = null;
                this.setSuppressRepaints(bl);
            }
            this.triggerRepaint();
        }
    }

    public int getCurrentTab() {
        return this.curIndex;
    }

    public void enableTab(boolean bl, int n) throws PropertyVetoException {
        this.setEnabled(bl, n);
    }

    public boolean tabIsEnabled(int n) {
        return this.isEnabled(n);
    }

    public void showPanel(Component component) {
        if (this.userPanel != null) {
            this.userPanel.hide();
        }
        this.userPanel = component;
        if (this.userPanel != null) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (componentArray[n2] == this.userPanel) break;
                ++n2;
            }
            if (n2 == n) {
                super.add(this.userPanel, -1);
            }
            this.userPanel.show();
            this.userPanel.requestFocus();
            this.validate();
            this.triggerRepaint();
        }
    }

    public int addTab(String string, boolean bl) {
        return this.addTab(string, bl, -1);
    }

    public int addTab(String string, boolean bl, int n) {
        int n2;
        block4: {
            if (n == -1) {
                this.vLabels.addElement(string);
                this.vEnabled.addElement(new Boolean(bl));
                n2 = this.vLabels.size() - 1;
            } else {
                this.vLabels.insertElementAt(string, n);
                this.vEnabled.insertElementAt(new Boolean(bl), n);
                n2 = n;
            }
            if (this.curIndex != -1 || !bl) break block4;
            try {
                this.setCurrentTab(n2);
            }
            catch (PropertyVetoException propertyVetoException) {
                n2 = -1;
            }
        }
        return n2;
    }

    public void showTab(int n) throws PropertyVetoException {
        this.setCurrentTab(n);
    }

    public int currentTabIndex() {
        return this.getCurrentTab();
    }

    public synchronized void insertTab(String string, boolean bl, int n) {
        if (n < 0 || n >= this.vLabels.size()) {
            return;
        }
        if (n == this.curIndex && !bl) {
            return;
        }
        try {
            this.vLabels.insertElementAt(string, n);
            this.vEnabled.insertElementAt(new Boolean(bl), n);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void removeTab(int n) {
        if (n < 0 || n >= this.vEnabled.size() || n == this.curIndex) {
            return;
        }
        try {
            this.vLabels.removeElementAt(n);
            this.vEnabled.removeElementAt(n);
            this.triggerRepaint();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void removeAllTabs() {
        this.vLabels = new Vector();
        this.vEnabled = new Vector();
        this.vPolys = new Vector();
        this.curIndex = -1;
        this.firstVisibleTab = 0;
        this.lastWidth = -1;
        this.removeAll();
        this.triggerRepaint();
    }

    public void layout() {
        Rectangle rectangle = this.bounds();
        int n = rectangle.width - this.TF_LEFT + this.TF_RIGHT;
        if (n < 0) {
            return;
        }
        int n2 = rectangle.height - this.TF_TOP + this.TF_BOTTOM;
        if (n2 < 0) {
            return;
        }
        int n3 = this.TF_LEFT;
        int n4 = 0;
        n4 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        if (this.userPanel != null) {
            this.userPanel.reshape(n3 + 3, n4 + 3, n - 6, n2 - 5);
            this.userPanel.invalidate();
            this.userPanel.validate();
            if (this.userPanel instanceof Canvas || this.userPanel instanceof Panel) {
                this.userPanel.repaint();
            } else {
                this.triggerRepaint();
            }
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        Rectangle rectangle = this.bounds();
        Color color = this.getForeground();
        Color color2 = this.backgroundColor;
        if (color2 == null) {
            color2 = this.getBackground();
        }
        if (!GeneralUtils.objectsEqual(color, this.cachedForeground)) {
            this.cachedForeground = color;
            this.calculateDisabledTextColor(color);
        }
        if (!GeneralUtils.objectsEqual(color2, this.cachedBackground)) {
            this.cachedBackground = color2;
            this.calculateBorderColors(color2);
        }
        if ((n = rectangle.width - this.TF_LEFT + this.TF_RIGHT) < 0) {
            return;
        }
        int n2 = rectangle.height - this.TF_TOP + this.TF_BOTTOM;
        if (n2 < 0) {
            return;
        }
        if (rectangle.width > this.lastWidth) {
            this.firstVisibleTab = 0;
        }
        this.lastWidth = rectangle.width;
        int n3 = this.TF_LEFT;
        Color color3 = graphics.getColor();
        graphics.setColor(color2);
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
        int n4 = this.iTabsPosition == 0 ? this.TF_TOP : this.TF_TOP - this.TF_BTN_HEIGHT;
        graphics.setColor(this.getBackground());
        graphics.fillRect(n3, n4, n, n2);
        graphics.setColor(this.borderLightColor);
        graphics.drawLine(n3, n4, n3 + n - 1, n4);
        graphics.drawLine(n3, n4, n3, n4 + n2 - 1);
        graphics.setColor(this.borderDarkColor);
        graphics.drawLine(n3 + 2, n4 + n2 - 2, n3 + n - 2, n4 + n2 - 2);
        graphics.drawLine(n3 + n - 2, n4 + 2, n3 + n - 2, n4 + n2 - 2);
        graphics.setColor(this.borderDarkerColor);
        graphics.drawLine(n3 + 1, n4 + n2 - 1, n3 + n - 1, n4 + n2 - 1);
        graphics.drawLine(n3 + n - 1, n4 + 1, n3 + n - 1, n4 + n2 - 1);
        int n5 = this.TF_LEFT + 8;
        int n6 = 0;
        int n7 = this.TF_LEFT;
        int n8 = this.vLabels.size();
        this.vPolys.removeAllElements();
        Font font = graphics.getFont();
        if (font != null) {
            int n9 = font.getSize();
            if (n9 != this.fReg.getSize()) {
                this.fReg = new Font(this.fReg.getName(), this.fReg.getStyle(), n9);
            }
            if (n9 != this.fSel.getSize()) {
                this.fSel = new Font(this.fSel.getName(), this.fSel.getStyle(), n9);
            }
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.fReg);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.fSel);
        int n10 = 0;
        int n11 = 0;
        while (n11 < this.firstVisibleTab) {
            this.vPolys.addElement(this.nullPoly);
            ++n11;
        }
        if (n11 > 0) {
            n7 += 2;
        }
        while (n11 < n8) {
            Polygon polygon = new Polygon();
            try {
                int n12;
                int n13;
                int n14;
                String string = (String)this.vLabels.elementAt(n11);
                n10 = n11 == this.curIndex ? fontMetrics2.stringWidth(string) : fontMetrics.stringWidth(string);
                if (this.iTabsPosition == 0) {
                    n14 = this.TF_TOP - this.TF_BTN_HEIGHT;
                    n13 = this.TF_TOP - 1;
                } else {
                    n14 = rectangle.height + this.TF_BOTTOM + 1;
                    n13 = rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT;
                }
                if (this.iTabsStyle == 0) {
                    n12 = n7 + 2;
                    n5 = n12 + n10 + 13;
                } else {
                    n12 = n5 - 7;
                    n5 = n12 + n10 + 28;
                }
                if (n5 + 36 - this.TF_RIGHT > rectangle.width) break;
                if (this.iTabsPosition == 0) {
                    if (n11 == this.curIndex) {
                        graphics.setColor(this.tabBgColor1);
                        graphics.fillRect((n12 -= 2) + 1, (n14 -= 3) + 1, n5 - n12, n13 - n14);
                    } else {
                        graphics.setColor(this.tabBgColor2);
                        graphics.fillRect(n12 + 1, n14 + 1, n5 - n12, n13 - n14);
                    }
                    graphics.setColor(this.borderLightColor);
                    if (this.curIndex == n11 + 1) {
                        graphics.drawLine(n12 + 2, n14, n5 - 2, n14);
                    } else {
                        graphics.drawLine(n12 + 2, n14, n5, n14);
                    }
                    if (this.curIndex != n11 - 1) {
                        graphics.drawLine(n12, n14 + 2, n12, n13);
                        n6 = n12;
                    } else {
                        n6 = n12 + 1;
                    }
                    graphics.drawLine(n12 + 1, n14 + 1, n12 + 1, n14 + 1);
                    if (this.curIndex != n11 + 1) {
                        graphics.setColor(this.borderDarkColor);
                        graphics.drawLine(n5, n14, n5, n13);
                        graphics.setColor(this.borderDarkerColor);
                        graphics.drawLine(n5 + 1, n14 + 2, n5 + 1, n13);
                        n7 = n5;
                    } else {
                        n7 = n5 - 1;
                    }
                } else if (this.iTabsStyle == 1) {
                    graphics.setColor(this.borderDarkColor);
                    graphics.drawLine(n12 + 9, n14, n5 - 9, n14);
                    graphics.setColor(this.borderDarkerColor);
                    if (n11 == 0 || n11 == this.curIndex) {
                        graphics.drawLine(n12, n13, n12 + 9, n14);
                        polygon.addPoint(n12, n13);
                    } else {
                        graphics.drawLine(n12 + 4, n14 - 9, n12 + 9, n14);
                        polygon.addPoint(n12 + 9, n13);
                        polygon.addPoint(n12 + 4, n14 - 9);
                    }
                    polygon.addPoint(n12 + 9, n14);
                    polygon.addPoint(n5 - 9, n14);
                    if (n11 + 1 == this.curIndex) {
                        graphics.drawLine(n5 - 5, n14 - 9, n5 - 9, n14);
                        polygon.addPoint(n5 - 5, n14);
                        polygon.addPoint(n5 - 9, n13);
                    } else {
                        graphics.drawLine(n5, n13, n5 - 9, n14);
                        polygon.addPoint(n5, n13);
                    }
                    if (n11 == 1 || n11 == this.curIndex) {
                        polygon.addPoint(n12, n13);
                    } else {
                        polygon.addPoint(n12 + 9, n13);
                    }
                } else {
                    if (n11 == this.curIndex) {
                        n14 += 3;
                        n12 -= 2;
                    }
                    graphics.setColor(this.borderLightColor);
                    if (this.curIndex == n11 + 1) {
                        graphics.drawLine(n12 + 2, n14, n5 - 2, n14);
                    } else {
                        graphics.drawLine(n12 + 2, n14, n5, n14);
                    }
                    if (this.curIndex != n11 - 1) {
                        graphics.drawLine(n12, n14 - 2, n12, n13);
                        n6 = n12;
                    } else {
                        n6 = n12 + 1;
                    }
                    graphics.drawLine(n12 + 1, n14 - 1, n12 + 1, n14 - 1);
                    if (this.curIndex != n11 + 1) {
                        graphics.setColor(this.borderDarkColor);
                        graphics.drawLine(n5, n14, n5, n13);
                        graphics.setColor(this.borderDarkerColor);
                        graphics.drawLine(n5 + 1, n14 - 2, n5 + 1, n13);
                        n7 = n5;
                    } else {
                        n7 = n5 - 1;
                    }
                }
                if (n11 == this.curIndex) {
                    n13 = this.iTabsPosition == 0 ? ++n13 : --n13;
                    graphics.setColor(this.getBackground());
                    graphics.drawLine(n12 + 1, n13, n5, n13);
                    if (this.iTabsPosition == 1) {
                        graphics.drawLine(n12 + 1, n13 - 1, n5, n13 - 1);
                    }
                    graphics.setFont(this.fSel);
                } else {
                    graphics.setFont(this.fReg);
                }
                if (this.iTabsStyle == 0) {
                    polygon.addPoint(n6, n13);
                    polygon.addPoint(n7, n13);
                    polygon.addPoint(n7, n14);
                    polygon.addPoint(n6, n14);
                    polygon.addPoint(n6, n13);
                }
                this.vPolys.addElement(polygon);
                Boolean bl = (Boolean)this.vEnabled.elementAt(n11);
                if (bl.booleanValue()) {
                    if (n11 == this.curIndex) {
                        graphics.setColor(this.tabFgColor1);
                    } else {
                        graphics.setColor(this.tabFgColor2);
                    }
                } else {
                    graphics.setColor(this.disabledTextColor);
                }
                if (this.iTabsPosition == 0) {
                    graphics.drawString(string, n12 + 8, n14 + 17 + this.osAdjustment);
                } else if (this.iTabsStyle == 0) {
                    graphics.drawString(string, n12 + 8, n14 - 6 + this.osAdjustment);
                } else {
                    graphics.drawString(string, n12 + 14, n14 - 4 + this.osAdjustment);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n11;
        }
        if (this.firstVisibleTab > 0 || n11 < n8) {
            this.dbLeft.show();
            this.dbRight.show();
            if (this.firstVisibleTab > 0) {
                this.dbLeft.setEnabled(true);
            } else {
                this.dbLeft.setEnabled(false);
            }
            if (n11 < n8) {
                this.dbRight.setEnabled(true);
            } else {
                this.dbRight.setEnabled(false);
            }
            if (this.iTabsPosition == 0) {
                this.dbLeft.reshape(rectangle.width - 33 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
                this.dbRight.reshape(rectangle.width - 16 + this.TF_RIGHT, this.TF_TOP - 16, 16, 15);
            } else {
                this.dbLeft.reshape(rectangle.width - 33 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
                this.dbRight.reshape(rectangle.width - 16 + this.TF_RIGHT, rectangle.height + this.TF_BOTTOM - this.TF_BTN_HEIGHT, 16, 15);
            }
        } else {
            this.dbLeft.hide();
            this.dbRight.hide();
        }
        while (n11 < n8) {
            this.vPolys.addElement(this.nullPoly);
            ++n11;
        }
        graphics.setFont(font);
        graphics.setColor(color3);
    }

    public Component add(Component component) {
        return component;
    }

    public synchronized Component add(Component component, int n) {
        return component;
    }

    public synchronized Component add(String string, Component component) {
        return component;
    }

    public synchronized void remove(Component component) {
        if (component == this.dbLeft || component == this.dbRight) {
            return;
        }
        super.remove(component);
        if (component == this.userPanel) {
            this.userPanel = null;
        }
    }

    public synchronized void removeAll() {
        super.removeAll();
        super.add((Component)this.dbLeft, -1);
        super.add((Component)this.dbRight, -1);
        this.userPanel = null;
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public Insets insets() {
        this.btpInsets = super.insets();
        this.btpInsets.left += this.TF_LEFT + 3;
        this.btpInsets.right += 6 - this.TF_RIGHT;
        if (this.iTabsPosition == 0) {
            this.btpInsets.top += this.TF_TOP + 3;
            this.btpInsets.bottom += 5 - this.TF_BOTTOM;
        } else {
            this.btpInsets.top += this.TF_TOP - this.TF_BTN_HEIGHT + 3;
            this.btpInsets.bottom += this.TF_BTN_HEIGHT + 5 - this.TF_BOTTOM;
        }
        return this.btpInsets;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.size();
        Dimension dimension2 = this.minimumSize();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.userPanel != null) {
            Dimension dimension = this.userPanel.minimumSize();
            return new Dimension(dimension.width + this.btpInsets.left + this.btpInsets.right, dimension.height + this.btpInsets.top + this.btpInsets.bottom);
        }
        return new Dimension(100, 100);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.addMouseListener(this);
        this.dbLeft.addActionListener(this);
        this.dbRight.addActionListener(this);
    }

    public synchronized void removeNotify() {
        this.removeMouseListener(this);
        this.dbLeft.removeActionListener(this);
        this.dbRight.removeActionListener(this);
        super.removeNotify();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void addCurrentTabListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener("CurrentTab", propertyChangeListener);
    }

    public synchronized void removeCurrentTabListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener("CurrentTab", propertyChangeListener);
    }

    public synchronized void addCurrentTabListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener("CurrentTab", vetoableChangeListener);
    }

    public synchronized void removeCurrentTabListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener("CurrentTab", vetoableChangeListener);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.vPolys.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                Polygon polygon = (Polygon)this.vPolys.elementAt(n2);
                if (polygon != this.nullPoly && polygon.inside(mouseEvent.getX(), mouseEvent.getY())) {
                    try {
                        this.setCurrentTab(n2);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            ++n2;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.dbLeft) {
            if (--this.firstVisibleTab < 0) {
                this.firstVisibleTab = 0;
            } else {
                this.triggerRepaint();
            }
        } else if (actionEvent.getSource() == this.dbRight) {
            int n = this.vLabels.size();
            if (++this.firstVisibleTab == n) {
                --this.firstVisibleTab;
            } else {
                this.triggerRepaint();
            }
        }
    }

    protected void calculateBorderColors(Color color) {
        this.borderLightColor = Color.white;
        this.borderDarkColor = ColorUtils.calculateShadowColor(color);
        this.borderDarkerColor = ColorUtils.darken(this.borderDarkColor, 0.2);
    }

    protected void calculateDisabledTextColor(Color color) {
        try {
            this.disabledTextColor = ColorUtils.fade(color, Color.lightGray, 0.5);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    protected int calculateMakeTabVisible(int n) {
        int n2;
        int n3;
        int n4;
        if (n == 0) {
            return 0;
        }
        if (!this.dbLeft.isVisible() && !this.dbRight.isVisible()) {
            return 0;
        }
        Rectangle rectangle = this.getBounds();
        int n5 = rectangle.width - this.btpInsets.left - this.btpInsets.right - this.dbLeft.getBounds().width - this.dbRight.getBounds().width - this.TF_LEFT + this.TF_RIGHT;
        if (n5 < 0) {
            return 0;
        }
        Font font = this.getFont();
        if (font != null) {
            int n6 = font.getSize();
            if (n6 != this.fReg.getSize()) {
                this.fReg = new Font(this.fReg.getName(), this.fReg.getStyle(), n6);
            }
            if (n6 != this.fSel.getSize()) {
                this.fSel = new Font(this.fSel.getName(), this.fSel.getStyle(), n6);
            }
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.fReg);
        FontMetrics fontMetrics2 = this.getFontMetrics(this.fSel);
        Vector<Integer> vector = new Vector<Integer>();
        int n7 = 0;
        while (n7 < this.vLabels.size()) {
            String string = (String)this.vLabels.elementAt(n7);
            n4 = n7 != n ? fontMetrics.stringWidth(string) : fontMetrics2.stringWidth(string);
            if (this.iTabsStyle == 0) {
                n3 = this.TF_LEFT + 2;
                n2 = n3 + n4 + 13;
            } else {
                n3 = this.TF_LEFT - 7;
                n2 = n3 + n4 + 28;
            }
            if (n7 == n) {
                n3 -= 2;
            }
            vector.addElement(new Integer(n2 - n3));
            ++n7;
        }
        int n8 = 0;
        n4 = 0;
        while (n4 <= n) {
            n8 += ((Integer)vector.elementAt(n4)).intValue();
            ++n4;
        }
        if (n8 < n5) {
            return 0;
        }
        n3 = n;
        while (n3 >= 0) {
            n2 = (Integer)vector.elementAt(n3);
            if (n5 - n2 > 0) {
                n5 -= n2;
            } else {
                return n3 + 1;
            }
            --n3;
        }
        return 0;
    }
}

