/*
 * Decompiled with CFR 0.152.
 */
package Framework.AccessControllers;

import Framework.FrameworkManager;
import Framework.Network.VivaldiFrameworkProtocolErrorException;
import Framework.PluginManagers.PluginDataInfo;
import Services.CommonConstants;
import Services.NetworkPacket;
import Services.NetworkToJavaConverter;
import Services.RoutingManager;
import java.util.Hashtable;

public class AccessControlManager
implements CommonConstants {
    private static String currentFullAccessWWN = null;
    private static int fullAccessClientID;
    private static Hashtable loggedInClients;

    public static void handleClientCall(NetworkPacket networkPacket) throws VivaldiFrameworkProtocolErrorException {
        if (networkPacket.getRequestType() == 261) {
            byte[] sendBuff;
            byte[] wwnBuff;
            int successInFullAccess = 1;
            int id = NetworkToJavaConverter.byteArrayToInt(networkPacket.getDatabuffer());
            if (currentFullAccessWWN == null) {
                currentFullAccessWWN = networkPacket.getSenderWWN();
                fullAccessClientID = id;
                successInFullAccess = 0;
            } else {
                wwnBuff = NetworkPacket.convertWWNStringToByteArray(networkPacket.getSenderWWN());
                sendBuff = new byte[wwnBuff.length + 4];
                NetworkToJavaConverter.intToByteArray(fullAccessClientID, sendBuff);
                System.arraycopy(wwnBuff, 0, sendBuff, 4, wwnBuff.length);
                PluginDataInfo plugInData = new PluginDataInfo(FrameworkManager.getFrameworkWWN(), currentFullAccessWWN, sendBuff);
                NetworkPacket netPacket = new NetworkPacket(4097, plugInData);
                try {
                    RoutingManager.routeCall(netPacket);
                }
                catch (VivaldiFrameworkProtocolErrorException e) {
                    netPacket.setFrameworkError(1);
                }
                if (netPacket.getFrameworkError() != 0 || NetworkToJavaConverter.byteArrayToInt(netPacket.getDatabuffer()) == 0) {
                    currentFullAccessWWN = networkPacket.getSenderWWN();
                    fullAccessClientID = id;
                    successInFullAccess = 0;
                }
            }
            if (successInFullAccess == 0) {
                AccessControlManager.registerClient(networkPacket.getSenderWWN(), 261);
            }
            wwnBuff = NetworkPacket.convertWWNStringToByteArray(currentFullAccessWWN);
            sendBuff = new byte[wwnBuff.length + 4];
            NetworkToJavaConverter.intToByteArray(successInFullAccess, sendBuff);
            System.arraycopy(wwnBuff, 0, sendBuff, 4, wwnBuff.length);
            networkPacket.setDatabuffer(sendBuff);
        } else if (networkPacket.getRequestType() == 266) {
            AccessControlManager.registerClient(networkPacket.getSenderWWN(), 266);
            byte[] sendBuff = new byte[4];
            NetworkToJavaConverter.intToByteArray(0, sendBuff);
            networkPacket.setDatabuffer(sendBuff);
        } else if (networkPacket.getRequestType() == 267) {
            int pollResult = 1;
            if (AccessControlManager.isClientRegistered(networkPacket.getSenderWWN())) {
                pollResult = 0;
            }
            byte[] sendBuff = new byte[4];
            NetworkToJavaConverter.intToByteArray(pollResult, sendBuff);
            networkPacket.setDatabuffer(sendBuff);
        } else {
            throw new VivaldiFrameworkProtocolErrorException();
        }
    }

    private static void registerClient(String clientWWN, int accessMode) {
        loggedInClients.put(clientWWN, new Integer(accessMode));
    }

    public static boolean isClientRegistered(String clientWWN) {
        return loggedInClients.get(clientWWN) != null;
    }

    static {
        loggedInClients = new Hashtable();
    }
}

